/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.theme;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.hizlab.kagetaka.awt.ImageButton;
import net.hizlab.kagetaka.theme.InvalidThemeException;
import net.hizlab.kagetaka.token.AttributeConverter;

public class Theme {
    private static final int BUFFER_SIZE = 16384;
    private static final int RESOURCE = 0;
    private static final int DIRECTORY = 1;
    private static final int ARCHIVE = 2;
    static final int LOAD_RESOURCE = 0;
    static final int LOAD_USER = 1;
    static final int LOAD_SYSTEM = 2;
    static final int LOAD_CUSTOM = 3;
    private static final String[] THEME_INI = new String[]{"theme", ".properties"};
    public static final String THEME_ID = "theme.id";
    public static final String THEME_NAME = "theme.name";
    public static final String THEME_AUTHOR = "theme.author";
    public static final String THEME_VERSION = "theme.version";
    public static final String THEME_DATE = "theme.date";
    public static final String THEME_MEMO = "theme.memo";
    public static final String THEME_SAMPLE = "theme.sample";
    public static final String EXT_SEPARATE = ".separate";
    public static final String EXT_HOTSPOT = ".hs";
    public static final String EXT_BASE = ".base";
    public static final String EXT_OVER = ".over";
    public static final String EXT_DOWN = ".down";
    public static final String EXT_DISABLE = ".disable";
    public static final String EXT_AREA = ".area";
    public static final String EXT_LABEL = ".label";
    public static final String BROWSER_TOOLBAR_FONT = "browser.toolbar.font";
    public static final String BROWSER_TOOLBAR_FOREGROUND = "browser.toolbar.foreground";
    public static final String BROWSER_TOOLBAR_BACKGROUND = "browser.toolbar.background";
    public static final String BROWSER_TOOLBAR_BACKGROUND_IMAGE = "browser.toolbar.background.image";
    public static final String BROWSER_TOOLBAR_BACK = "browser.toolbar.back";
    public static final String BROWSER_TOOLBAR_FORWARD = "browser.toolbar.forward";
    public static final String BROWSER_TOOLBAR_RELOAD = "browser.toolbar.reload";
    public static final String BROWSER_TOOLBAR_STOP = "browser.toolbar.stop";
    public static final String BROWSER_TOOLBAR_GO = "browser.toolbar.go";
    public static final String BROWSER_TOOLBAR_HOME = "browser.toolbar.home";
    public static final String BROWSER_TOOLBAR_BOOKMARK = "browser.toolbar.bookmark";
    public static final String BROWSER_TOOLBAR_ADDRESSBAR_FONT = "browser.toolbar.addressbar.font";
    public static final String BROWSER_TOOLBAR_ADDRESSBAR_FOREGROUND = "browser.toolbar.addressbar.foreground";
    public static final String BROWSER_TOOLBAR_ADDRESSBAR_BACKGROUND = "browser.toolbar.addressbar.background";
    public static final String BROWSER_TAB_ICON_NORMAL = "browser.tab.icon.normal";
    public static final String BROWSER_TAB_ICON_LOADING = "browser.tab.icon.loading";
    public static final String BROWSER_TAB_FOREGROUND = "browser.tab.foreground";
    public static final String BROWSER_TAB_BACKGROUND = "browser.tab.background";
    public static final String BROWSER_TAB_FOCUS = "browser.tab.focus";
    public static final String BROWSER_TAB_ACTIVE_FONT = "browser.tab.active.font";
    public static final String BROWSER_TAB_ACTIVE_FOREGROUND = "browser.tab.active.foreground";
    public static final String BROWSER_TAB_ACTIVE_BACKGROUND = "browser.tab.active.background";
    public static final String BROWSER_TAB_UNACTIVE_FONT = "browser.tab.unactive.font";
    public static final String BROWSER_TAB_UNACTIVE_FOREGROUND = "browser.tab.unactive.foreground";
    public static final String BROWSER_TAB_UNACTIVE_BACKGROUND = "browser.tab.unactive.background";
    public static final String BROWSER_TAB_SCROLLBAR_LEFT = "browser.tab.scrollbar.left";
    public static final String BROWSER_TAB_SCROLLBAR_RIGHT = "browser.tab.scrollbar.right";
    public static final String BOOKMARK_FILE = "bookmark.file";
    public static final String BOOKMARK_OPENFOLDER = "bookmark.openfolder";
    public static final String BOOKMARK_CLOSEFOLDER = "bookmark.closefolder";
    private String path;
    private int type;
    private Properties p;
    private ClassLoader cl;
    private String name;
    private String key;
    private Hashtable cache = new Hashtable();

    public Theme(String path) throws InvalidThemeException {
        this(new File(path));
    }

    public Theme(File path) throws InvalidThemeException {
        this(path, 3);
    }

    Theme(String path, int load) throws InvalidThemeException {
        this.path = path;
        this.type = 0;
        this.cl = this.getClass().getClassLoader();
        this.loadProperties();
        this.key = this.name = this.p.getProperty(THEME_ID);
    }

    Theme(File path, int load) throws InvalidThemeException {
        this.path = path.getPath();
        this.type = path.isDirectory() ? 1 : 2;
        this.loadProperties();
        this.name = this.p.getProperty(THEME_ID);
        if (this.name == null) {
            new InvalidThemeException("Theme `" + path + "' has no name");
        }
        switch (load) {
            case 1: {
                this.key = "user";
                break;
            }
            case 2: {
                this.key = "system";
                break;
            }
            case 3: {
                this.key = path.getPath();
            }
        }
        this.key = this.key + "/" + this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadProperties() throws InvalidThemeException {
        is = null;
        pops = null;
        locale = Locale.getDefault();
        lists = new Vector<String>(4);
        sb = new StringBuffer();
        lists.addElement("");
        sb.append('_');
        sb.append(locale.getLanguage());
        lists.addElement(sb.toString());
        s = locale.getCountry();
        if (s.length() > 0) {
            sb.append('_');
            sb.append(s);
            lists.addElement(sb.toString());
        }
        if ((s = locale.getVariant()).length() > 0) {
            sb.append('_');
            sb.append(s);
            lists.addElement(sb.toString());
        }
        i = 0;
        while (true) {
            block16: {
                block18: {
                    block17: {
                        if (i >= lists.size()) {
                            if (this.p != null) return;
                            throw new InvalidThemeException("`" + this.path + "' is invalid");
                        }
                        try {
                            try {
                                is = this.getInputStream(Theme.THEME_INI[0] + (String)lists.elementAt(i) + Theme.THEME_INI[1]);
                                if (is == null) {
                                    var10_9 = null;
                                    if (is == null) break block16;
                                    break block17;
                                }
                                this.p = new Properties(this.p);
                                this.p.load(is);
                                break block18;
                            }
                            catch (IOException e) {
                                new InvalidThemeException(e.toString());
                                var10_9 = null;
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException e) {}
                                }
                                break block16;
                            }
                        }
                        catch (Throwable var9_11) {
                            var10_9 = null;
                            if (is == null) throw var9_11;
                            ** try [egrp 2[TRYBLOCK] [6 : 271->278)] { 
lbl57:
                            // 1 sources

                            is.close();
                            throw var9_11;
lbl59:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                            throw var9_11;
                        }
                    }
                    try {}
                    catch (IOException e) {}
                    is.close();
                    break block16;
                }
                var10_9 = null;
                if (is != null) {
                    try {}
                    catch (IOException e) {}
                    is.close();
                }
            }
            ++i;
        }
    }

    private InputStream getInputStream(String file) throws IOException {
        switch (this.type) {
            case 0: {
                if (this.cl != null) {
                    return this.cl.getResourceAsStream(this.path + "/" + file);
                }
                return ClassLoader.getSystemResourceAsStream(this.path + "/" + file);
            }
            case 1: {
                return new FileInputStream(new File(this.path, file));
            }
            case 2: {
                return new ZipInputStream(this.path, file);
            }
        }
        return null;
    }

    private byte[] getBytes(String file) {
        if (file == null) {
            return null;
        }
        try {
            InputStream is = this.getInputStream(file);
            if (is == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
            byte[] buffer = new byte[16384];
            int length = 0;
            while ((length = is.read(buffer, 0, 16384)) != -1) {
                baos.write(buffer, 0, length);
            }
            baos.flush();
            byte[] data = baos.toByteArray();
            is.close();
            ((OutputStream)baos).close();
            return data;
        }
        catch (IOException e) {
            System.out.println(e);
            return null;
        }
    }

    void load() throws InvalidThemeException {
    }

    public String getKey() {
        return this.key;
    }

    public String getString(String key) {
        return this.p.getProperty(key);
    }

    public boolean getBoolean(String key) {
        String value = this.p.getProperty(key);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public Color getColor(String key) {
        String value = this.p.getProperty(key);
        if (value == null) {
            return null;
        }
        return AttributeConverter.convertToColorSilent(value);
    }

    public Font getFont(String key) {
        String value = this.p.getProperty(key);
        if (value == null) {
            return null;
        }
        return Font.decode(value);
    }

    public Polygon getPolygon(String key) {
        String value = this.p.getProperty(key);
        if (value == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken().trim());
        }
        int npoints = v.size() / 2;
        int[] xpoints = new int[npoints];
        int[] ypoints = new int[npoints];
        try {
            for (int i = 0; i < npoints; ++i) {
                xpoints[i] = Integer.parseInt((String)v.elementAt(i * 2));
                ypoints[i] = Integer.parseInt((String)v.elementAt(i * 2 + 1));
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new Polygon(xpoints, ypoints, npoints);
    }

    public Image getImage(String key, Toolkit tk) {
        Image image = null;
        try {
            image = (Image)this.cache.get(key);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (image == null) {
            byte[] data = this.getBytes(this.p.getProperty(key));
            if (data == null) {
                return null;
            }
            image = tk.createImage(data);
            if (image != null) {
                this.cache.put(key, image);
            }
        }
        return image;
    }

    public ImageButton getImageButton(String key, Toolkit tk) {
        ImageButton ib = null;
        Image image = this.getImage(key, tk);
        if (image != null) {
            ib = new ImageButton(image, this.getImage(key + EXT_HOTSPOT, tk));
        } else {
            image = this.getImage(key + EXT_BASE, tk);
            if (image != null) {
                boolean separate = this.getBoolean(key + EXT_SEPARATE);
                Image over = this.getImage(key + EXT_OVER, tk);
                Image down = this.getImage(key + EXT_DOWN, tk);
                Image disable = this.getImage(key + EXT_DISABLE, tk);
                Image sover = this.getImage(key + EXT_HOTSPOT + EXT_OVER, tk);
                Image sdown = this.getImage(key + EXT_HOTSPOT + EXT_DOWN, tk);
                Image sdisable = this.getImage(key + EXT_HOTSPOT + EXT_DISABLE, tk);
                Polygon sarea = this.getPolygon(key + EXT_HOTSPOT + EXT_AREA);
                ib = new ImageButton(separate, image, over, down, disable, sover, sdown, sdisable, sarea);
            } else {
                return null;
            }
        }
        ib.setName(key);
        return ib;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.key + "]";
    }

    private class ZipInputStream
    extends FilterInputStream {
        private ZipFile zipFile;

        private ZipInputStream(String zip, String path) throws IOException {
            super(null);
            this.zipFile = new ZipFile(zip);
            ZipEntry zipEntry = this.zipFile.getEntry(path);
            if (zipEntry == null) {
                throw new FileNotFoundException("`" + path + "' in `" + zip + "'");
            }
            this.in = this.zipFile.getInputStream(zipEntry);
        }

        public void close() throws IOException {
            super.close();
            this.zipFile.close();
        }
    }
}

