/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.style;

import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.style.Selector;
import net.hizlab.kagetaka.style.Value;

public class Style
implements net.hizlab.kagetaka.token.Style {
    private static final int TOP = 0;
    private static final int RIGHT = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;
    private static final int TARGET_TOP = 1;
    private static final int TARGET_RIGHT = 2;
    private static final int TARGET_BOTTOM = 4;
    private static final int TARGET_LEFT = 8;
    private static final int TARGET_ALL = 15;
    protected Reporter reporter = null;
    protected int lineNumber = 0;
    protected int columnNumber = 0;
    Style next = null;
    private int media = 0;
    private Selector selector = null;
    private boolean page = false;
    private Hashtable properties = null;
    private Value propertyTextIndent = null;
    private Value propertyTextAlign = null;
    private Value propertyWhiteSpace = null;
    private Value[] propertyMargin = new Value[4];
    private Value[] propertyBorderStyle = new Value[4];
    private Value[] propertyBorderColor = new Value[4];
    private Value[] propertyBorderWidth = new Value[4];
    private Value[] propertyPadding = new Value[4];
    private Value propertyWidth = null;
    private Value propertyHeight = null;
    private Value propertyLineHeight = null;
    private Value propertyVerticalAlign = null;
    private Value propertyLetterSpacing = null;
    private Value propertyListStyleType = null;
    private Value propertyListStylePosition = null;
    private Value propertyListStyleImage = null;
    private Value propertyFloat = null;
    private Value propertyClear = null;
    private Value propertyColor = null;
    private Value propertyBackgroundColor = null;
    private Value[] propertyFontFamily = null;
    private Value propertyFontStyle = null;
    private Value propertyFontWeight = null;
    private Value propertyFontSize = null;
    private Value[] propertyTextDecoration = null;
    private static final int[] TYPES_LEN_PER = new int[]{1, -2, -3};
    private static final int[] TYPES_SIZE = new int[]{1, -2, -3};
    private static final int[] TYPES_COLOR = new int[]{1, -5};
    private static final int[] TYPES_COLOR_TRANS = new int[]{1, -5, 901};
    private static final int[] TYPES_ALIGN = new int[]{1, 31, 32, 33};
    private static final int[] TYPES_WHITE_SPACE = new int[]{1, 2, 51, 52};
    private static final int[] TYPES_BORDER_WIDTH = new int[]{1, 21, 22, 23, -2};
    private static final int[] TYPES_BORDER_STYLE = new int[]{1, 3, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    private static final int[] TYPES_LINE_HEIGHT = new int[]{1, 2, -1, -2, -3};
    private static final int[] TYPES_VERTICAL_ALIGN = new int[]{1, 41, 42, 43, 44, 45, 46, 47, 48, -1, -2, -3};
    private static final int[] TYPES_LETTER_SPACING = new int[]{1, 2, -2};
    private static final int[] TYPES_LIST_STYLE_TYPE = new int[]{1, 3, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100};
    private static final int[] TYPES_LIST_STYLE_POSITION = new int[]{1, 101, 102};
    private static final int[] TYPES_LIST_STYLE_IMAGE = new int[]{1, 3, -6};
    private static final int[] TYPES_FLOAT = new int[]{1, 31, 32, 3};
    private static final int[] TYPES_CLEAR = new int[]{1, 3, 31, 32, 35};
    private static final int[] TYPES_FONT_FAMILY = new int[]{1, -4};
    private static final int[] TYPES_FONT_STYLE = new int[]{1, 2, 72, 71};
    private static final int[] TYPES_FONT_WEIGHT = new int[]{1, 2, 75, 76, 77, -1};
    private static final int[] TYPES_FONT_SIZE = new int[]{1, 61, 62, 63, 22, 65, 66, 67, 69, 68, -2, -3};
    private static final int[] TYPES_TEXT_DECORATION = new int[]{1, 3, 4096, 8192, 16384, 32768};

    public Style(Reporter reporter, int line, int column, int media, Selector selector, boolean page) {
        this.reporter = reporter;
        this.lineNumber = line;
        this.columnNumber = column;
        this.media = media;
        this.selector = selector;
        this.page = page;
    }

    public void initProperties(String name, String[] values) {
        name = name.toLowerCase();
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(name, values);
        if (values.length == 0) {
            return;
        }
        try {
            if (name.compareTo("text-indent") == 0) {
                this.propertyTextIndent = new Value(values, TYPES_LEN_PER);
                return;
            }
            if (name.compareTo("text-align") == 0) {
                this.propertyTextAlign = new Value(values, TYPES_ALIGN);
                return;
            }
            if (name.compareTo("white-space") == 0) {
                this.propertyWhiteSpace = new Value(values, TYPES_WHITE_SPACE);
                return;
            }
            if (name.compareTo("clear") == 0) {
                this.propertyClear = new Value(values, TYPES_CLEAR);
                return;
            }
            if (name.compareTo("margin-top") == 0) {
                this.propertyMargin[0] = new Value(values, TYPES_SIZE);
                return;
            }
            if (name.compareTo("margin-right") == 0) {
                this.propertyMargin[1] = new Value(values, TYPES_SIZE);
                return;
            }
            if (name.compareTo("margin-bottom") == 0) {
                this.propertyMargin[2] = new Value(values, TYPES_SIZE);
                return;
            }
            if (name.compareTo("margin-left") == 0) {
                this.propertyMargin[3] = new Value(values, TYPES_SIZE);
                return;
            }
            if (name.compareTo("margin") == 0) {
                this.distribute(values, this.propertyMargin, TYPES_SIZE);
                return;
            }
            if (name.compareTo("border-top-width") == 0) {
                this.propertyBorderWidth[0] = new Value(values, TYPES_BORDER_WIDTH);
                return;
            }
            if (name.compareTo("border-right-width") == 0) {
                this.propertyBorderWidth[1] = new Value(values, TYPES_BORDER_WIDTH);
                return;
            }
            if (name.compareTo("border-bottom-width") == 0) {
                this.propertyBorderWidth[2] = new Value(values, TYPES_BORDER_WIDTH);
                return;
            }
            if (name.compareTo("border-left-width") == 0) {
                this.propertyBorderWidth[3] = new Value(values, TYPES_BORDER_WIDTH);
                return;
            }
            if (name.compareTo("border-width") == 0) {
                this.distribute(values, this.propertyBorderWidth, TYPES_BORDER_WIDTH);
                return;
            }
            if (name.compareTo("border-top-color") == 0) {
                this.propertyBorderColor[0] = new Value(values, TYPES_COLOR_TRANS);
                return;
            }
            if (name.compareTo("border-right-color") == 0) {
                this.propertyBorderColor[1] = new Value(values, TYPES_COLOR_TRANS);
                return;
            }
            if (name.compareTo("border-bottom-color") == 0) {
                this.propertyBorderColor[2] = new Value(values, TYPES_COLOR_TRANS);
                return;
            }
            if (name.compareTo("border-left-color") == 0) {
                this.propertyBorderColor[3] = new Value(values, TYPES_COLOR_TRANS);
                return;
            }
            if (name.compareTo("border-color") == 0) {
                this.distribute(values, this.propertyBorderColor, TYPES_COLOR_TRANS);
                return;
            }
            if (name.compareTo("border-top-style") == 0) {
                this.propertyBorderStyle[0] = new Value(values, TYPES_BORDER_STYLE);
                return;
            }
            if (name.compareTo("border-right-style") == 0) {
                this.propertyBorderStyle[1] = new Value(values, TYPES_BORDER_STYLE);
                return;
            }
            if (name.compareTo("border-bottom-style") == 0) {
                this.propertyBorderStyle[2] = new Value(values, TYPES_BORDER_STYLE);
                return;
            }
            if (name.compareTo("border-left-style") == 0) {
                this.propertyBorderStyle[3] = new Value(values, TYPES_BORDER_STYLE);
                return;
            }
            if (name.compareTo("border-style") == 0) {
                this.distribute(values, this.propertyBorderStyle, TYPES_BORDER_STYLE);
                return;
            }
            if (name.compareTo("border-top") == 0) {
                this.normalizeBorder(values, 1);
                return;
            }
            if (name.compareTo("border-right") == 0) {
                this.normalizeBorder(values, 2);
                return;
            }
            if (name.compareTo("border-bottom") == 0) {
                this.normalizeBorder(values, 4);
                return;
            }
            if (name.compareTo("border-left") == 0) {
                this.normalizeBorder(values, 8);
                return;
            }
            if (name.compareTo("border") == 0) {
                this.normalizeBorder(values, 15);
                return;
            }
            if (name.compareTo("padding-top") == 0) {
                this.propertyPadding[0] = new Value(values, TYPES_LEN_PER);
                return;
            }
            if (name.compareTo("padding-right") == 0) {
                this.propertyPadding[1] = new Value(values, TYPES_LEN_PER);
                return;
            }
            if (name.compareTo("padding-bottom") == 0) {
                this.propertyPadding[2] = new Value(values, TYPES_LEN_PER);
                return;
            }
            if (name.compareTo("padding-left") == 0) {
                this.propertyPadding[3] = new Value(values, TYPES_LEN_PER);
                return;
            }
            if (name.compareTo("padding") == 0) {
                this.distribute(values, this.propertyPadding, TYPES_LEN_PER);
                return;
            }
            if (name.compareTo("width") == 0) {
                this.propertyWidth = new Value(values, TYPES_SIZE);
                return;
            }
            if (name.compareTo("height") == 0) {
                this.propertyHeight = new Value(values, TYPES_SIZE);
                return;
            }
            if (name.compareTo("line-height") == 0) {
                this.propertyLineHeight = new Value(values, TYPES_LINE_HEIGHT);
                return;
            }
            if (name.compareTo("vertical-align") == 0) {
                this.propertyVerticalAlign = new Value(values, TYPES_VERTICAL_ALIGN);
                return;
            }
            if (name.compareTo("letter-spacing") == 0) {
                this.propertyLetterSpacing = new Value(values, TYPES_LETTER_SPACING);
                return;
            }
            if (name.compareTo("list-style-type") == 0) {
                this.propertyListStyleType = new Value(values, TYPES_LIST_STYLE_TYPE);
                return;
            }
            if (name.compareTo("list-style-position") == 0) {
                this.propertyListStylePosition = new Value(values, TYPES_LIST_STYLE_POSITION);
                return;
            }
            if (name.compareTo("list-style-image") == 0) {
                this.propertyListStyleImage = new Value(values, TYPES_LIST_STYLE_IMAGE);
                return;
            }
            if (name.compareTo("list-style") == 0) {
                this.normalizeListStyle(values);
                return;
            }
            if (name.compareTo("float") == 0) {
                this.propertyFloat = new Value(values, TYPES_FLOAT);
                return;
            }
            if (name.compareTo("color") == 0) {
                this.propertyColor = new Value(values, TYPES_COLOR);
                return;
            }
            if (name.compareTo("background-color") == 0) {
                this.propertyBackgroundColor = new Value(values, TYPES_COLOR_TRANS);
                return;
            }
            if (name.compareTo("background") == 0) {
                for (int i = 0; i < values.length; ++i) {
                    try {
                        this.propertyBackgroundColor = new Value(values[i], TYPES_COLOR_TRANS);
                        continue;
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
                return;
            }
            if (name.compareTo("font-style") == 0) {
                this.propertyFontStyle = new Value(values, TYPES_FONT_STYLE);
                return;
            }
            if (name.compareTo("font-weight") == 0) {
                this.propertyFontWeight = new Value(values, TYPES_FONT_WEIGHT);
                return;
            }
            if (name.compareTo("font-size") == 0) {
                this.propertyFontSize = new Value(values, TYPES_FONT_SIZE);
                return;
            }
            if (name.compareTo("text-decoration") == 0) {
                this.propertyTextDecoration = this.createValues(values, TYPES_TEXT_DECORATION, this.propertyTextDecoration);
                return;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.reportMessage(7, "style.warning.notsupported", new String[]{name});
    }

    public void changeStatus(Document document, boolean block, Status status) {
        if (block) {
            if (this.propertyTextIndent != null) {
                status.textIndent = this.propertyTextIndent;
            }
            if (this.propertyTextAlign != null) {
                status.align = this.propertyTextAlign.getType();
            }
            if (this.propertyWhiteSpace != null) {
                status.whiteSpace = this.propertyWhiteSpace.getType();
            }
            if (this.propertyClear != null) {
                status.clearType = this.propertyClear.getType();
            }
        }
        if (this.propertyMargin[0] != null) {
            status.setMargin(2, this.propertyMargin[0]);
        }
        if (this.propertyMargin[1] != null) {
            status.setMargin(4, this.propertyMargin[1]);
        }
        if (this.propertyMargin[2] != null) {
            status.setMargin(8, this.propertyMargin[2]);
        }
        if (this.propertyMargin[3] != null) {
            status.setMargin(1, this.propertyMargin[3]);
        }
        if (this.propertyBorderStyle[0] != null) {
            status.setBorderStyle(2, this.propertyBorderStyle[0]);
        }
        if (this.propertyBorderStyle[1] != null) {
            status.setBorderStyle(4, this.propertyBorderStyle[1]);
        }
        if (this.propertyBorderStyle[2] != null) {
            status.setBorderStyle(8, this.propertyBorderStyle[2]);
        }
        if (this.propertyBorderStyle[3] != null) {
            status.setBorderStyle(1, this.propertyBorderStyle[3]);
        }
        if (this.propertyBorderColor[0] != null) {
            status.setBorderColor(2, this.propertyBorderColor[0].getColor());
        }
        if (this.propertyBorderColor[1] != null) {
            status.setBorderColor(4, this.propertyBorderColor[1].getColor());
        }
        if (this.propertyBorderColor[2] != null) {
            status.setBorderColor(8, this.propertyBorderColor[2].getColor());
        }
        if (this.propertyBorderColor[3] != null) {
            status.setBorderColor(1, this.propertyBorderColor[3].getColor());
        }
        if (this.propertyBorderWidth[0] != null) {
            status.setBorderWidth(2, this.propertyBorderWidth[0]);
        }
        if (this.propertyBorderWidth[1] != null) {
            status.setBorderWidth(4, this.propertyBorderWidth[1]);
        }
        if (this.propertyBorderWidth[2] != null) {
            status.setBorderWidth(8, this.propertyBorderWidth[2]);
        }
        if (this.propertyBorderWidth[3] != null) {
            status.setBorderWidth(1, this.propertyBorderWidth[3]);
        }
        if (this.propertyPadding[0] != null) {
            status.setPadding(2, this.propertyPadding[0]);
        }
        if (this.propertyPadding[1] != null) {
            status.setPadding(4, this.propertyPadding[1]);
        }
        if (this.propertyPadding[2] != null) {
            status.setPadding(8, this.propertyPadding[2]);
        }
        if (this.propertyPadding[3] != null) {
            status.setPadding(1, this.propertyPadding[3]);
        }
        if (this.propertyWidth != null) {
            status.height = this.propertyWidth;
        }
        if (this.propertyHeight != null) {
            status.width = this.propertyHeight;
        }
        if (this.propertyLineHeight != null) {
            status.lineHeight = this.propertyLineHeight;
        }
        if (this.propertyVerticalAlign != null) {
            status.valign = this.propertyVerticalAlign.getType();
        }
        if (this.propertyLetterSpacing != null) {
            status.letterSpacing = this.propertyLetterSpacing;
        }
        if (this.propertyListStyleType != null) {
            status.setList(this.propertyListStyleType.getType());
        }
        if (this.propertyFloat != null) {
            status.floatType = this.propertyFloat.getType();
        }
        if (this.propertyColor != null) {
            status.foreColor = this.propertyColor.getColor();
        }
        if (this.propertyBackgroundColor != null) {
            status.backColor = this.propertyBackgroundColor.getColor();
        }
        if (this.propertyFontFamily != null) {
            status.setFontFamily(this.propertyFontFamily);
        }
        if (this.propertyFontStyle != null) {
            status.setFontStyle(this.propertyFontStyle);
        }
        if (this.propertyFontWeight != null) {
            status.setFontWeight(this.propertyFontWeight);
        }
        if (this.propertyFontSize != null) {
            status.setFontSize(this.propertyFontSize, 2);
        }
        if (this.propertyTextDecoration != null) {
            status.decoration = this.getOr(this.propertyTextDecoration);
        }
    }

    private void distribute(String[] values, Value[] props, int[] types) throws ParseException {
        switch (values.length) {
            case 1: {
                props[2] = props[3] = new Value(values[0], types);
                props[1] = props[3];
                props[0] = props[3];
                return;
            }
            case 2: {
                props[0] = props[2] = new Value(values[0], types);
                props[1] = props[3] = new Value(values[1], types);
                return;
            }
            case 3: {
                props[0] = new Value(values[0], types);
                props[1] = props[3] = new Value(values[1], types);
                props[2] = new Value(values[2], types);
                return;
            }
            case 4: {
                props[0] = new Value(values[0], types);
                props[1] = new Value(values[1], types);
                props[2] = new Value(values[2], types);
                props[3] = new Value(values[3], types);
                return;
            }
        }
        throw new ParseException(values[4], 0);
    }

    private Value[] createValues(String[] values, int[] types, Value[] props) throws ParseException {
        int i;
        Vector<Value> vector = new Vector<Value>();
        if (props != null && props.length > 0 && props[0].getType() != 1) {
            for (i = 0; i < props.length; ++i) {
                vector.addElement(props[i]);
            }
        }
        for (i = 0; i < values.length; ++i) {
            Value v = new Value(values[i], types);
            if (v.getType() == 1) {
                if (values.length != 1) {
                    throw new ParseException(values[i], 0);
                }
                return new Value[]{v};
            }
            vector.addElement(v);
        }
        props = new Value[vector.size()];
        vector.copyInto(props);
        return props;
    }

    private void normalizeBorder(String[] values, int target) throws ParseException {
        block0: for (int i = values.length - 1; i >= 0; --i) {
            int j;
            Value v = new Value(values[i], null);
            int type = v.getType();
            if (type == 1) {
                if (values.length != 1) break;
                this.distributeBorder(this.propertyBorderWidth, v, target);
                this.distributeBorder(this.propertyBorderStyle, v, target);
                this.distributeBorder(this.propertyBorderColor, v, target);
                return;
            }
            for (j = 0; j < TYPES_BORDER_WIDTH.length; ++j) {
                if (TYPES_BORDER_WIDTH[j] != type) continue;
                this.distributeBorder(this.propertyBorderWidth, v, target);
                continue block0;
            }
            for (j = 0; j < TYPES_BORDER_STYLE.length; ++j) {
                if (TYPES_BORDER_STYLE[j] != type) continue;
                this.distributeBorder(this.propertyBorderStyle, v, target);
                continue block0;
            }
            for (j = 0; j < TYPES_COLOR_TRANS.length; ++j) {
                if (TYPES_COLOR_TRANS[j] != type) continue;
                this.distributeBorder(this.propertyBorderColor, v, target);
                continue block0;
            }
            throw new ParseException(values[i], 0);
        }
    }

    private void distributeBorder(Value[] props, Value v, int target) {
        if ((target & 1) != 0) {
            props[0] = v;
        }
        if ((target & 2) != 0) {
            props[1] = v;
        }
        if ((target & 4) != 0) {
            props[2] = v;
        }
        if ((target & 8) != 0) {
            props[3] = v;
        }
    }

    private void normalizeListStyle(String[] values) throws ParseException {
        block0: for (int i = values.length - 1; i >= 0; --i) {
            int j;
            Value v = new Value(values[i], null);
            int type = v.getType();
            if (type == 1) {
                if (values.length != 1) break;
                this.propertyListStyleType = v;
                this.propertyListStylePosition = v;
                this.propertyListStyleImage = v;
                return;
            }
            for (j = 0; j < TYPES_LIST_STYLE_TYPE.length; ++j) {
                if (TYPES_LIST_STYLE_TYPE[j] != type) continue;
                this.propertyListStyleType = v;
                continue block0;
            }
            for (j = 0; j < TYPES_LIST_STYLE_POSITION.length; ++j) {
                if (TYPES_LIST_STYLE_POSITION[j] != type) continue;
                this.propertyListStylePosition = v;
                continue block0;
            }
            for (j = 0; j < TYPES_LIST_STYLE_IMAGE.length; ++j) {
                if (TYPES_LIST_STYLE_IMAGE[j] != type) continue;
                this.propertyListStyleImage = v;
                continue block0;
            }
            throw new ParseException(values[i], 0);
        }
    }

    private int getOr(Value[] props) {
        int typeOr = 0;
        int type = 0;
        for (int i = 0; i < props.length; ++i) {
            type = props[i].getType();
            if (type == 1) {
                return type;
            }
            typeOr |= type;
        }
        return typeOr;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public int getMedia() {
        return this.media;
    }

    public static int convertMedia(String[] list) {
        if (list == null) {
            return 0;
        }
        int type = 0;
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            if (s.compareTo("aural") == 0) {
                type |= 2;
                continue;
            }
            if (s.compareTo("braille") == 0) {
                type |= 4;
                continue;
            }
            if (s.compareTo("embossed") == 0) {
                type |= 8;
                continue;
            }
            if (s.compareTo("handheld") == 0) {
                type |= 0x10;
                continue;
            }
            if (s.compareTo("print") == 0) {
                type |= 0x20;
                continue;
            }
            if (s.compareTo("projection") == 0) {
                type |= 0x40;
                continue;
            }
            if (s.compareTo("screen") == 0) {
                type |= 0x80;
                continue;
            }
            if (s.compareTo("tty") == 0) {
                type |= 0x100;
                continue;
            }
            if (s.compareTo("tv") == 0) {
                type |= 0x200;
                continue;
            }
            if (s.compareTo("all") == 0) {
                type |= 0xFFFFFF;
                continue;
            }
            type |= 1;
        }
        return type;
    }

    public boolean isPage() {
        return this.page;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.media != 0 && this.media != 1) {
            sb.append('<');
            if ((this.media & 2) != 0) {
                sb.append("aural, ");
            }
            if ((this.media & 4) != 0) {
                sb.append("braille, ");
            }
            if ((this.media & 8) != 0) {
                sb.append("embossed, ");
            }
            if ((this.media & 0x10) != 0) {
                sb.append("handheld, ");
            }
            if ((this.media & 0x20) != 0) {
                sb.append("print, ");
            }
            if ((this.media & 0x40) != 0) {
                sb.append("projection, ");
            }
            if ((this.media & 0x80) != 0) {
                sb.append("screen, ");
            }
            if ((this.media & 0x100) != 0) {
                sb.append("tty, ");
            }
            if ((this.media & 0x200) != 0) {
                sb.append("tv, ");
            }
            sb.setLength(sb.length() - 2);
            sb.append('>');
        }
        if (this.selector != null) {
            sb.append(this.selector.toString());
        }
        sb.append('{');
        if (this.properties != null) {
            Enumeration e = this.properties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String[] values = (String[])this.properties.get(key);
                sb.append(key);
                sb.append(':');
                for (int i = 0; i < values.length; ++i) {
                    sb.append(' ');
                    sb.append(values[i]);
                }
                sb.append("; ");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append('}');
        return sb.toString();
    }

    private void reportMessage(int type, String key, String[] args) {
        if (this.reporter == null) {
            return;
        }
        this.reporter.report(type, Resource.getMessage(key, args), this.lineNumber, this.columnNumber);
    }
}

