/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.style;

import java.text.ParseException;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TokenTypes;

public class Selector {
    private Operator operator = null;
    private Operator lastOperator = null;

    public Selector(String value) throws ParseException {
        if (value == null) {
            return;
        }
        int length = value.length();
        if (length == 0) {
            return;
        }
        int p = 0;
        char c = value.charAt(0);
        while (c == ' ') {
            if (++p >= length) {
                return;
            }
            c = value.charAt(p);
        }
        Operator o = new Operator(null);
        char type = '\u0000';
        int start = 0;
        block22: for (p = 0; p <= length; ++p) {
            c = p < length ? (char)value.charAt(p) : (char)' ';
            switch (c) {
                case ' ': 
                case '#': 
                case '+': 
                case ',': 
                case '.': 
                case ':': 
                case '>': 
                case '[': {
                    switch (type) {
                        case '\u0000': {
                            if (start == p) {
                                o.targetType = -20;
                                break;
                            }
                            String s = value.substring(start, p);
                            if (s.compareTo("*") == 0) {
                                o.targetType = -20;
                                break;
                            }
                            if ((o.targetType = TokenTypes.getType(s + "_START")) != -1) break;
                            throw new ParseException(Resource.getMessage("selector.error.unknowntarget", new String[]{s}), p);
                        }
                        case '[': {
                            o.addAttribute(null, null, 0);
                            break;
                        }
                        case '.': {
                            o.addClass(value.substring(start, p));
                            break;
                        }
                        case '#': {
                            o.addId(value.substring(start, p));
                            break;
                        }
                        case ':': {
                            String s = value.substring(start, p);
                            if (s.compareTo("first-child") == 0) {
                                o.pseudoClasses |= 1;
                                break;
                            }
                            if (s.compareTo("link") == 0) {
                                o.pseudoClasses |= 2;
                                break;
                            }
                            if (s.compareTo("visited") == 0) {
                                o.pseudoClasses |= 4;
                                break;
                            }
                            if (s.compareTo("hover") == 0) {
                                o.pseudoClasses |= 8;
                                break;
                            }
                            if (s.compareTo("active") == 0) {
                                o.pseudoClasses |= 16;
                                break;
                            }
                            if (s.compareTo("focus") == 0) {
                                o.pseudoClasses |= 32;
                                break;
                            }
                            if (s.startsWith("lang(") && s.endsWith(")")) {
                                o.pseudoClasses |= 64;
                                o.pseudoLang = s.substring(5, s.length() - 1);
                                break;
                            }
                            if (s.compareTo("first-line") == 0) {
                                o.pseudoElements |= 1;
                                break;
                            }
                            if (s.compareTo("first-letter") == 0) {
                                o.pseudoElements |= 2;
                                break;
                            }
                            if (s.compareTo("before") == 0) {
                                o.pseudoElements |= 4;
                                break;
                            }
                            if (s.compareTo("after") == 0) {
                                o.pseudoElements |= 8;
                                break;
                            }
                            throw new ParseException(Resource.getMessage("selector.error.invalidpseudo", new String[]{value, s}), p);
                        }
                    }
                    type = c;
                    start = p + 1;
                    block10 : switch (c) {
                        case '#': 
                        case '.': 
                        case ':': 
                        case '[': {
                            break;
                        }
                        default: {
                            while (c == ' ') {
                                if (++p >= length) break block22;
                                c = value.charAt(p);
                            }
                            type = c;
                            switch (type) {
                                case '+': 
                                case ',': 
                                case '>': {
                                    do {
                                        if (++p < length) continue;
                                        throw new ParseException(Resource.getMessage("selector.error.nosimpleselector", new String[]{value, String.valueOf(type)}), p);
                                    } while ((c = (char)value.charAt(p)) == 32);
                                }
                            }
                            switch (type) {
                                case ',': {
                                    this.lastOperator = this.operator == null ? (this.operator = o) : (this.lastOperator.nextOperator = o);
                                    o = new Operator(null);
                                    type = '\u0000';
                                    break block10;
                                }
                                case '>': {
                                    o.combinator = 2;
                                    break;
                                }
                                case '+': {
                                    o.combinator = 3;
                                    break;
                                }
                                default: {
                                    o.combinator = 1;
                                }
                            }
                            o = new Operator(o);
                            type = '\u0000';
                        }
                    }
                }
                default: {
                    continue block22;
                }
            }
        }
        this.lastOperator = this.operator == null ? (this.operator = o) : (this.lastOperator.nextOperator = o);
    }

    public boolean isMatch(StartToken token) {
        if (this.operator == null) {
            return true;
        }
        Operator o = this.operator;
        do {
            if (!o.isMatch(token)) continue;
            return true;
        } while ((o = o.nextOperator) != null);
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        if (this.operator != null) {
            Operator o = this.operator;
            sb.append(o.toString());
            while ((o = o.nextOperator) != null) {
                sb.append(", ");
                sb.append(o.toString());
            }
        }
        sb.append(')');
        return sb.toString();
    }

    private class StringChain {
        private String value;
        private StringChain next;
        private StringChain last;

        private StringChain(String value) {
            this.value = value;
        }

        private void add(String value) {
            StringChain sc = new StringChain(value);
            if (this.last == null) {
                this.next = sc;
            } else {
                this.last.next = sc;
            }
            this.last = sc;
        }

        private boolean isMatch(String v) {
            if (v.compareTo(this.value) != 0) {
                return false;
            }
            return this.next == null;
        }

        private boolean isMatch(String[] v) {
            StringChain sc = this;
            block0: do {
                for (int i = 0; i < v.length; ++i) {
                    if (v[i].compareTo(sc.value) == 0) continue block0;
                }
                return false;
            } while ((sc = sc.next) != null);
            return true;
        }
    }

    private class AttributeChain {
        private AttributeChain next;

        private AttributeChain(String key, String value, int match) {
        }

        private void add(String key, String value, int match) {
        }

        private boolean isMatch(Attribute attribute) {
            return false;
        }

        public String toString() {
            return "[]";
        }
    }

    private class Operator {
        private static final int ALL = -20;
        private static final int OWN = 0;
        private static final int ANCESTOR = 1;
        private static final int PARENT = 2;
        private static final int PREDECESSOR = 3;
        private static final int FIRST_CHILD = 1;
        private static final int LINK = 2;
        private static final int VISITED = 4;
        private static final int HOVER = 8;
        private static final int ACTIVE = 16;
        private static final int FOCUS = 32;
        private static final int LANG = 64;
        private static final int FIRST_LINE = 1;
        private static final int FIRST_LETTER = 2;
        private static final int BEFORE = 4;
        private static final int AFTER = 8;
        private Operator nextOperator;
        private Operator nestedOperator;
        private int combinator;
        private int targetType;
        private AttributeChain targetAttribute;
        private StringChain targetClass;
        private StringChain targetId;
        private int pseudoClasses;
        private int pseudoElements;
        private String pseudoLang;
        private String[] tokenClass;
        private String tokenId;
        private Attribute tokenAttribute;

        private Operator(Operator nested) {
            this.nestedOperator = nested;
        }

        private void addAttribute(String key, String value, int match) {
            if (this.targetAttribute == null) {
                this.targetAttribute = new AttributeChain(key, value, match);
            } else {
                this.targetAttribute.add(key, value, match);
            }
        }

        private void addClass(String value) {
            if (this.targetClass == null) {
                this.targetClass = new StringChain(value);
            } else {
                this.targetClass.add(value);
            }
        }

        private void addId(String value) {
            if (this.targetId == null) {
                this.targetId = new StringChain(value);
            } else {
                this.targetId.add(value);
            }
        }

        private boolean isMatch(StartToken token) {
            switch (this.combinator) {
                case 0: 
                case 2: 
                case 3: {
                    return this.isInnerMatch(token);
                }
                case 1: {
                    while (!this.isInnerMatch(token)) {
                        do {
                            if ((token = token.getParent()) != null) continue;
                            return false;
                        } while (token.getCompleteToken());
                    }
                    return true;
                }
            }
            return false;
        }

        private boolean isInnerMatch(StartToken token) {
            this.tokenAttribute = token.getAttribute();
            if (this.tokenAttribute != null) {
                this.tokenClass = this.tokenAttribute.getBaseClass();
                this.tokenId = this.tokenAttribute.getBaseId();
            } else {
                this.tokenClass = null;
                this.tokenId = null;
            }
            if (this.targetType != -20 && this.targetType != token.getType()) {
                return false;
            }
            if (!(this.targetAttribute == null || this.tokenAttribute != null && this.targetAttribute.isMatch(this.tokenAttribute))) {
                return false;
            }
            if (!(this.targetClass == null || this.tokenClass != null && this.targetClass.isMatch(this.tokenClass))) {
                return false;
            }
            if (!(this.targetId == null || this.tokenId != null && this.targetId.isMatch(this.tokenId))) {
                return false;
            }
            if (this.pseudoClasses != 0) {
                return false;
            }
            if (this.pseudoElements != 0) {
                return false;
            }
            if (this.nestedOperator != null) {
                if (this.nestedOperator.combinator == 3) {
                    while ((token = token.getBeforeStartToken()) != null && token.getCompleteToken()) {
                    }
                } else {
                    while ((token = token.getParent()) != null && token.getCompleteToken()) {
                    }
                }
                if (token == null) {
                    return false;
                }
                return this.nestedOperator.isMatch(token);
            }
            return true;
        }

        public String toString() {
            StringChain sc;
            StringBuffer sb = new StringBuffer();
            if (this.nestedOperator != null) {
                sb.append(this.nestedOperator.toString());
                sb.append(' ');
            }
            if (this.targetType == -20) {
                sb.append('*');
            } else {
                sb.append(TokenTypes.getName(this.targetType));
            }
            if (this.targetAttribute != null) {
                AttributeChain ac = this.targetAttribute;
                do {
                    sb.append(ac.toString());
                } while ((ac = ac.next) != null);
            }
            if (this.targetClass != null) {
                sc = this.targetClass;
                do {
                    sb.append('.');
                    sb.append(sc.value);
                } while ((sc = sc.next) != null);
            }
            if (this.targetId != null) {
                sc = this.targetId;
                do {
                    sb.append('#');
                    sb.append(sc.value);
                } while ((sc = sc.next) != null);
            }
            if (this.pseudoClasses != 0) {
                if ((this.pseudoClasses & 1) != 0) {
                    sb.append(":first-child");
                }
                if ((this.pseudoClasses & 2) != 0) {
                    sb.append(":link");
                }
                if ((this.pseudoClasses & 4) != 0) {
                    sb.append(":visited");
                }
                if ((this.pseudoClasses & 8) != 0) {
                    sb.append(":hover");
                }
                if ((this.pseudoClasses & 0x10) != 0) {
                    sb.append(":active");
                }
                if ((this.pseudoClasses & 0x20) != 0) {
                    sb.append(":focus");
                }
                if ((this.pseudoClasses & 0x40) != 0) {
                    sb.append(":lang(");
                    sb.append(this.pseudoLang);
                    sb.append(')');
                }
            }
            if (this.pseudoClasses != 0) {
                if ((this.pseudoElements & 1) != 0) {
                    sb.append(":first-line");
                }
                if ((this.pseudoElements & 2) != 0) {
                    sb.append(":first-letter");
                }
                if ((this.pseudoElements & 4) != 0) {
                    sb.append(":before");
                }
                if ((this.pseudoElements & 8) != 0) {
                    sb.append(":after");
                }
            }
            switch (this.combinator) {
                case 2: {
                    sb.append(" >");
                    break;
                }
                case 3: {
                    sb.append(" +");
                }
            }
            return sb.toString();
        }
    }
}

