/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.net.URL;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.java2.AWTWrapper;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.token.Value;

public class Status
implements Cloneable {
    private static final char FONT_CHECK_CHAR = '\u4e9c';
    public static final int TARGET_TOP = 1;
    public static final int TARGET_RIGHT = 2;
    public static final int TARGET_BOTTOM = 4;
    public static final int TARGET_LEFT = 8;
    public static final int TARGET_ALL = 15;
    public static final int TOKEN = 1;
    public static final int STYLE = 2;
    private static AWTWrapper awtWrapper = AWTWrapper.getInstance();
    private HawkContext context;
    private Drawkit drawkit;
    private double baseFontSize = 12.0;
    Status firstChild = null;
    Status link = null;
    Status visited = null;
    Status hover = null;
    Status active = null;
    Status focus = null;
    Status firstLine = null;
    Status firstLetter = null;
    Status before = null;
    Status after = null;
    Box margin = null;
    Border border = null;
    Box padding = null;
    Image backImage = null;
    Dimension backImageSize = null;
    FontData fd = null;
    Font font = null;
    FontMetrics fm = null;
    Dimension fdFontSize = null;
    int fontHeightMax = 0;
    int fontHeightHalf = 0;
    int fontBaseFull = 0;
    int fontBaseHalf = 0;
    URL href = null;
    String tip = null;
    int listLevel = 0;
    int listType = 3;
    Status counterStatus = this;
    boolean reference = true;
    public boolean isBlackHole = false;
    public boolean isHorizontalRule = false;
    public Value hrHeight = null;
    public boolean isTable = false;
    public boolean isVertical = false;
    public int colSpan = 1;
    public int rowSpan = 1;
    public Value borderVerticalSpacing = null;
    public Value borderHorizontalSpacing = null;
    public int type = -1;
    public Status parent = null;
    private double fontPerPixel = 0.0;
    private boolean fontChanged = false;
    private Value[] fontFamilies = null;
    private String fontFamily = null;
    private boolean fontStyle = false;
    private int fontWeight = 0;
    private double fontSize = 0.0;
    private boolean fontSizeStyle = false;
    public Value width = null;
    public Value height = null;
    public Value textIndent = null;
    public Value lineHeight = null;
    public Value letterSpacing = null;
    public int align = 3;
    public int valign = 41;
    public Color foreColor = null;
    public Color backColor = null;
    public Color linkColor = null;
    public Color vlinkColor = null;
    public Color alinkColor = null;
    public int decoration = 1;
    public int whiteSpace = 3;
    public int counterNo = 1;
    public int offsetX = 0;
    public int floatType = 3;
    public int clearType = 3;

    Status(Drawkit drawkit) {
        this.context = drawkit.context;
        this.drawkit = drawkit;
        this.parent = this;
        Font font = this.context.getOption().getDefaultFont();
        FontMetrics fm = this.context.getToolkit().getFontMetrics(font);
        this.fontPerPixel = this.context.getOption().getFontPerPixel();
        this.fontChanged = true;
        this.fontFamily = font.getName();
        this.fontStyle = (font.getStyle() & 2) != 0;
        this.fontWeight = (font.getStyle() & 1) != 0 ? 700 : 400;
        this.fontSize = (double)font.getSize() / this.fontPerPixel;
        this.setupFont();
    }

    public Object clone() {
        try {
            Status s = (Status)super.clone();
            s.backImage = null;
            s.backImageSize = null;
            s.margin = null;
            s.border = null;
            s.padding = null;
            s.type = -1;
            s.width = null;
            s.height = null;
            s.valign = 41;
            s.backColor = null;
            s.counterNo = 1;
            s.floatType = 3;
            s.clearType = 3;
            s.isHorizontalRule = false;
            s.hrHeight = null;
            s.isTable = false;
            s.isVertical = false;
            s.colSpan = 1;
            s.rowSpan = 1;
            s.fontSizeStyle = false;
            s.parent = this;
            return s;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Status getParent() {
        return this.parent;
    }

    void checkStatus() {
        this.setupFont();
        if (this.align == 1) {
            this.align = this.parent.align;
        }
        if (this.valign == 1) {
            this.valign = this.parent.valign;
        }
        if (this.foreColor == null) {
            this.foreColor = this.parent.foreColor;
        }
        if (this.linkColor == null) {
            this.linkColor = this.parent.linkColor;
        }
        if (this.vlinkColor == null) {
            this.vlinkColor = this.parent.vlinkColor;
        }
        if (this.alinkColor == null) {
            this.alinkColor = this.parent.alinkColor;
        }
        if (this.decoration == 1) {
            this.decoration = this.parent.decoration;
        }
        if (this.whiteSpace == 1) {
            this.whiteSpace = this.parent.whiteSpace;
        }
    }

    public void setMargin(int target, Value value) {
        if (this.margin == null) {
            this.margin = new Box();
        }
        if ((target & 1) != 0) {
            this.margin.top = value;
        }
        if ((target & 2) != 0) {
            this.margin.right = value;
        }
        if ((target & 4) != 0) {
            this.margin.bottom = value;
        }
        if ((target & 8) != 0) {
            this.margin.left = value;
        }
    }

    public void setBorderStyle(int target, Value value) {
        if (this.border == null) {
            this.border = new Border();
        }
        this.border.setStyle(target, value);
    }

    public void setBorderWidth(int target, Value value) {
        if (this.border == null) {
            this.border = new Border();
        }
        this.border.setWidth(target, value);
    }

    public void setBorderColor(int target, Color value) {
        if (this.border == null) {
            this.border = new Border();
        }
        this.border.setColor(target, value);
    }

    public void setPadding(int target, Value value) {
        if (this.padding == null) {
            this.padding = new Box();
        }
        if ((target & 1) != 0) {
            this.padding.top = value;
        }
        if ((target & 2) != 0) {
            this.padding.right = value;
        }
        if ((target & 4) != 0) {
            this.padding.bottom = value;
        }
        if ((target & 8) != 0) {
            this.padding.left = value;
        }
    }

    public void setBackImage(String src) {
        if (src == null) {
            return;
        }
        Image image = this.drawkit.getImage(this.drawkit.createURL(src), src);
        if (image == null) {
            return;
        }
        if (this.drawkit.loadImage(image, "wait to load a background image") != 8) {
            image.flush();
            return;
        }
        this.backImage = image;
        this.backImageSize = new Dimension(image.getWidth(this.drawkit.imageDrawer), image.getHeight(this.drawkit.imageDrawer));
    }

    public void setFontFamily(Value[] v) {
        this.fontFamilies = v.length == 1 && v[0].getType() == 1 ? this.parent.fontFamilies : v;
        this.fontChanged = true;
    }

    public void setFontStyle(Value v) {
        switch (v.getType()) {
            case 1: {
                this.fontStyle = this.parent.fontStyle;
                break;
            }
            case 2: {
                this.fontStyle = false;
                break;
            }
            case 71: 
            case 72: {
                this.fontStyle = true;
            }
        }
        this.fontChanged = true;
    }

    public int getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(Value v) {
        switch (v.getType()) {
            case 1: {
                this.fontWeight = this.parent.fontWeight;
                break;
            }
            case 2: {
                this.fontWeight = 400;
                break;
            }
            case 75: {
                this.fontWeight = 700;
                break;
            }
            case 76: {
                this.fontWeight += 100;
                break;
            }
            case 77: {
                this.fontWeight -= 100;
                break;
            }
            case -1: {
                this.fontWeight = v.intValue();
                break;
            }
            case 3: {
                this.fontWeight = -1;
            }
        }
        this.fontChanged = true;
    }

    public void setFontSize(Value v, int owner) {
        if (owner == 2 && !this.fontSizeStyle) {
            this.fontSize = this.parent.fontSize;
            this.fontSizeStyle = true;
        }
        switch (v.getType()) {
            case 1: {
                this.fontSize = this.parent.fontSize;
                break;
            }
            case 61: {
                this.fontSize = this.baseFontSize / 1.2 / 1.2 / 1.2;
                break;
            }
            case 62: {
                this.fontSize = this.baseFontSize / 1.2 / 1.2;
                break;
            }
            case 63: {
                this.fontSize = this.baseFontSize / 1.2;
                break;
            }
            case 22: {
                this.fontSize = this.baseFontSize;
                break;
            }
            case 65: {
                this.fontSize = this.baseFontSize * 1.2;
                break;
            }
            case 66: {
                this.fontSize = this.baseFontSize * 1.2 * 1.2;
                break;
            }
            case 67: {
                this.fontSize = this.baseFontSize * 1.2 * 1.2 * 1.2;
                break;
            }
            case 69: {
                this.fontSize *= 1.2;
                break;
            }
            case 68: {
                this.fontSize /= 1.2;
                break;
            }
            case -3: 
            case -2: {
                this.fontSize = v.getValue(this.fd, (int)this.fontSize, 1);
            }
        }
        this.fontChanged = true;
    }

    public void setFixedFont() {
        Font font = this.context.getOption().getDefaultFixedFont();
        if (font != null) {
            this.fontFamily = font.getName();
        }
        this.fontChanged = true;
    }

    private void setupFont() {
        if (!this.fontChanged) {
            return;
        }
        String name = this.fontFamily;
        int style = (this.fontWeight >= 700 ? 1 : 0) | (this.fontStyle ? 2 : 0);
        int size = (int)(this.fontSize * this.fontPerPixel);
        Font font = null;
        if (this.fontFamilies != null) {
            for (int i = 0; i < this.fontFamilies.length; ++i) {
                name = this.fontFamilies[i].getString();
                font = new Font(name, style, size);
                if (awtWrapper != null && !awtWrapper.canFontDisplay(font, '\u4e9c')) continue;
                this.fontFamily = name;
                break;
            }
            this.fontFamilies = null;
        }
        if (font == null) {
            font = new Font(name, style, size);
        }
        if (font.equals(this.font)) {
            return;
        }
        this.font = font;
        this.fd = FontData.getInstance(this.context, font);
        this.fm = this.fd.getFontMetrics();
        this.fdFontSize = this.fd.getFullSize();
        this.fontHeightMax = this.fd.getMaxHeight();
        this.fontHeightHalf = this.fd.getHalfHeight();
        this.fontBaseFull = this.fd.getFullBase();
        this.fontBaseHalf = this.fd.getHalfBase();
        this.fontChanged = false;
    }

    public FontData getFontData() {
        return this.fd;
    }

    public void setTextDecoration(int td) {
        this.decoration |= td;
    }

    public boolean getTextDecoration(int td) {
        return (this.decoration & td) != 0;
    }

    public void setList(int type) {
        ++this.listLevel;
        if (type == 912) {
            switch (this.listLevel) {
                case 1: {
                    this.listType = 81;
                    break;
                }
                case 2: {
                    this.listType = 82;
                    break;
                }
                default: {
                    this.listType = 83;
                    break;
                }
            }
        } else {
            this.listType = type;
        }
        this.counterStatus = this;
    }

    class Box {
        Value top;
        Value right;
        Value bottom;
        Value left;

        private Box() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName());
            sb.append('[');
            if (this.top != null) {
                sb.append(this.top.toString());
            }
            sb.append(", ");
            if (this.right != null) {
                sb.append(this.right.toString());
            }
            sb.append(", ");
            if (this.bottom != null) {
                sb.append(this.bottom.toString());
            }
            sb.append(", ");
            if (this.left != null) {
                sb.append(this.left.toString());
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

