/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Point;
import java.net.URL;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.PostData;

public class Request {
    public static final int CACHE_MUST = 3;
    public static final int CACHE_NORMAL = 2;
    public static final int CACHE_CHECK = 1;
    public static final int CACHE_NONE = 0;
    public final URL url;
    public final PostData postData;
    public final URL referer;
    public final String target;
    public final boolean isNewWindow;
    public final boolean isExtension;
    public final int useCache;
    Request next;
    Request prev;
    private Document document;
    private boolean isMoved;
    private Point position;

    public Request(URL url, PostData pd, URL referer, String target, boolean newWindow, boolean extension, int cache) {
        this.url = url;
        this.postData = pd;
        this.referer = referer;
        this.target = target;
        this.isNewWindow = newWindow;
        this.isExtension = extension;
        this.useCache = cache;
    }

    public Document getDocument() {
        return this.document;
    }

    void setDocument(Document document) {
        this.document = document;
    }

    public void copyFrom(Request src) {
        this.document = new Document(this.url, src.getDocument());
    }

    public String getDisplayURL() {
        String ref = this.url.getRef();
        if (ref == null) {
            return this.document.url.toString();
        }
        String urlString = this.document.url.toString();
        int p = urlString.indexOf(35);
        if (p != -1) {
            return urlString.substring(0, p + 1) + ref;
        }
        return urlString + "#" + ref;
    }

    public boolean isMoved() {
        return this.isMoved;
    }

    public void setMoved(boolean moved) {
        this.isMoved = moved;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public Request getNext() {
        return this.next;
    }

    public Request getPrevious() {
        return this.prev;
    }

    public boolean isMember() {
        return this.prev != null || this.next != null;
    }
}

