/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Color;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import net.hizlab.kagetaka.rendering.Box;
import net.hizlab.kagetaka.rendering.ConnectWrapper;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.rendering.StopException;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.FormManager;
import net.hizlab.kagetaka.token.StyleManager;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.Charset;
import net.hizlab.kagetaka.util.ContentType;

public class Render {
    private static final int DEFAULT_ALIGN = 31;
    private static final Color DEFAULT_FORE_COLOR = Color.black;
    private static final Color DEFAULT_BACK_COLOR = Color.white;
    private static final Color DEFAULT_LINK_COLOR = Color.blue;
    private static final Color DEFAULT_VLINK_COLOR = new Color(85, 26, 139);
    private static final Color DEFAULT_ALINK_COLOR = Color.red;
    private static final int DEFAULT_TD = 0;
    private HawkContext context;
    private Drawkit drawkit;
    private boolean smCreate = false;
    private StyleManager sm = null;
    private boolean fmCreate = false;
    private FormManager fm = null;
    private int refreshTime = -1;
    private URL refreshUrl = null;
    private Box topBox;
    private Box bottomBox;

    Render(HawkContext context, Request request) {
        this.context = context;
        this.drawkit = new Drawkit(context, request);
    }

    public void drawText(String text) {
        if (this.drawkit.status.isBlackHole) {
            return;
        }
        this.bottomBox.appendString(text);
    }

    public void doBr() {
        if (this.drawkit.status.isBlackHole) {
            return;
        }
        this.bottomBox.appendNewLine();
    }

    public void createNewRow() {
        this.bottomBox.createNewRow();
    }

    public void drawImage(String src, String alt, Value width, Value height, Integer border, int floatType) {
        if (this.drawkit.status.isBlackHole) {
            return;
        }
        if (src == null) {
            return;
        }
        int b = 0;
        b = border != null ? border : (this.drawkit.status.href != null ? 2 : 0);
        this.bottomBox.appendImage(src, alt, width, height, b, floatType);
    }

    public void drawForm(FormItem item) {
        this.bottomBox.appendForm(item);
    }

    public void setTitle(String title) {
        this.drawkit.document.setTitle(title);
    }

    public Status getStatus() {
        return this.drawkit.status;
    }

    public void setBaseHref(String href) {
        if (href == null) {
            return;
        }
        URL url = this.drawkit.createURL(href);
        if (url != null) {
            this.drawkit.document.setBaseURL(url);
        }
    }

    public void setMark(String name) {
        if (name != null) {
            this.drawkit.idQueue.put(name);
        }
    }

    public void setLink(String href) {
        if (href != null) {
            URL url = this.drawkit.createURL(href);
            if (url == null) {
                return;
            }
            this.drawkit.status.href = url;
            this.drawkit.status.foreColor = this.context.haveEverVisited(url) ? this.drawkit.status.vlinkColor : this.drawkit.status.linkColor;
        }
    }

    public void setPopup(String tip) {
        if (tip != null) {
            this.drawkit.status.tip = tip;
        }
    }

    public void startRuby() {
        this.bottomBox.setRuby(1);
    }

    public void startRubyRb() {
        this.bottomBox.setRuby(2);
    }

    public void startRubyRp() {
        this.bottomBox.setRuby(3);
    }

    public void startRubyRt() {
        this.bottomBox.setRuby(4);
    }

    public void endRuby() {
        this.bottomBox.setRuby(7);
    }

    public void setListItem() {
        this.bottomBox.setListItem();
    }

    public void setRefresh(int time, String href) {
        this.refreshTime = time;
        if (href == null) {
            this.refreshUrl = this.drawkit.document.getBaseURL();
        } else {
            this.refreshUrl = this.drawkit.createURL(href);
            if (this.refreshUrl == null) {
                this.refreshTime = -1;
            }
        }
    }

    public void setCookie(String value) {
        this.context.setCookie(value, this.drawkit.document.url);
    }

    public void setStyleSheet(String href, String contentType) {
        if (href == null) {
            return;
        }
        URL url = this.drawkit.createURL(href);
        if (url == null) {
            return;
        }
        if (this.sm == null && !this.smCreate) {
            this.sm = StyleManager.createStyleManager(this.context.getReporter());
            this.smCreate = true;
        }
        if (this.sm == null) {
            return;
        }
        try {
            URLConnection connection = ConnectWrapper.getURLConnection(this.context, new Request(url, null, this.drawkit.document.url, null, false, false, 2));
            if (connection == null) {
                return;
            }
            String encoding = null;
            if (contentType == null) {
                contentType = connection.getContentType();
            }
            if ((contentType = ContentType.normalize(contentType, url)) != null) {
                try {
                    ContentType ct = new ContentType(contentType);
                    contentType = (ct.getType() != null ? ct.getType() : "") + "/" + (ct.getSubType() != null ? ct.getSubType() : "");
                    String charset = ct.getParameter("charset");
                    if (charset != null && (encoding = Charset.toEncoding(charset)) == null) {
                        this.drawkit.reportMessage(7, "charset.warning.invalid", new String[]{charset});
                    }
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
            if (contentType == null || contentType.compareTo("text/css") != 0) {
                return;
            }
            this.sm.addStyle(connection.getInputStream(), encoding);
        }
        catch (SecurityException e) {
            this.drawkit.reportMessage(7, "engine.status.load.error.security", new String[]{href});
        }
        catch (FileNotFoundException e) {
            this.drawkit.reportMessage(7, "engine.status.load.error.nofile", new String[]{href});
        }
        catch (IOException e) {
            String s = e.getMessage();
            this.drawkit.reportMessage(7, "engine.status.load.error", new Object[]{href, new Integer(s != null ? 1 : 0), s, e.getClass().getName()});
        }
        catch (InterruptedException e) {
            throw new StopException("wait to load style");
        }
    }

    public StyleManager getStyleManager(boolean create) {
        if (this.sm == null && !this.smCreate && create) {
            this.sm = StyleManager.createStyleManager(this.context.getReporter());
            this.smCreate = true;
        }
        return this.sm;
    }

    public FormManager getFormManager() {
        if (this.fm == null && !this.fmCreate) {
            this.fm = FormManager.createFormManager(this.context, this.drawkit.document);
            this.fmCreate = true;
        }
        return this.fm;
    }

    void startBlock() {
        this.bottomBox = this.bottomBox.createBox();
    }

    void endBlock() {
        this.bottomBox = this.bottomBox.commitBox();
    }

    void startBody() {
        Status status = this.drawkit.baseStatus;
        if (status.backColor == null) {
            status.backColor = DEFAULT_BACK_COLOR;
        }
        if (status.align == 1) {
            status.align = 31;
        }
        if (status.foreColor == null) {
            status.foreColor = DEFAULT_FORE_COLOR;
        }
        if (status.linkColor == null) {
            status.linkColor = DEFAULT_LINK_COLOR;
        }
        if (status.vlinkColor == null) {
            status.vlinkColor = DEFAULT_VLINK_COLOR;
        }
        if (status.alinkColor == null) {
            status.alinkColor = DEFAULT_ALINK_COLOR;
        }
        if (status.decoration == 1) {
            status.decoration = 0;
        }
        int scaleWidth = status.fdFontSize.width;
        int scaleHeight = status.fdFontSize.height;
        if (status.lineHeight != null) {
            scaleWidth = status.lineHeight.getValue(status.fd, status.fdFontSize.width, 1);
        }
        if (status.letterSpacing != null) {
            scaleHeight += status.letterSpacing.getValue(status.fd, status.fdFontSize.height, 2);
        }
        this.drawkit.document.setCharScale(new Dimension(scaleWidth, scaleHeight));
        if (status.backColor != null) {
            this.drawkit.document.setBackColor(status.backColor);
        }
        if (status.backImage != null) {
            this.drawkit.document.setBackImage(status.backImage);
        }
        this.bottomBox = this.topBox = new Box(this.drawkit);
    }

    void endBody() {
        Status status = this.drawkit.baseStatus;
        this.topBox.dispose();
    }

    void save(int type) {
        this.drawkit.saveStatus(type);
    }

    void reset() {
        this.drawkit.resetStatus();
    }

    void statusChanged() {
        this.drawkit.status.checkStatus();
        this.bottomBox.statusChanged();
    }

    void waitImageLoad() {
        this.drawkit.waitImageLoad();
    }

    void stopImageLoad() {
        this.drawkit.stopImageLoad();
    }

    URL getRefreshURL() {
        if (this.refreshTime < 0) {
            return null;
        }
        if (this.refreshTime > 0) {
            try {
                Thread.sleep(this.refreshTime * 1000);
            }
            catch (InterruptedException e) {
                throw new StopException("wait for refresh");
            }
        }
        return this.refreshUrl;
    }

    void dispose() {
        this.drawkit.dispose();
    }
}

