/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Point;
import java.util.Vector;
import net.fclabs.util.Queue;
import net.hizlab.kagetaka.rendering.Box;
import net.hizlab.kagetaka.rendering.Caddy;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.Position;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.TextFormat;

class Paragraph {
    private static final String BR = String.valueOf('\n');
    private static final String SPACE = String.valueOf(' ');
    private static final int LS_BEGIN = 0;
    private static final int LS_TRUE = 1;
    private static final int LS_FALSE = 2;
    Box box;
    private Drawkit drawkit;
    int preferredHeight;
    private boolean rearrange = false;
    private boolean hasFloat = false;
    private int whiteSpace = 3;
    private int indent = 0;
    private boolean reference = true;
    private Caddy caddy = null;
    private Caddy topCaddy = null;
    private Caddy lastCaddy = null;
    private Vector widthList = new Vector();
    private Vector heightList = new Vector();
    private Vector offsetList = new Vector();
    private Vector topList = new Vector();
    private Vector bottomList = new Vector();
    private int lineno = 0;
    int width = 0;
    int height = 0;
    int maxHeight = 0;
    int drawOffsetX = 0;
    int lineWidth = 0;
    int lineHeight = 0;
    int lineOffset = 0;
    int linePitch = 0;
    int lineMaxHeight = 0;
    int floatTop = 0;
    int floatBottom = 0;
    int floatHeight = 0;
    private boolean statusChanged = false;
    private Status listStatus = null;
    private int lastSpace = 0;
    private Queue floatQueue = null;

    Paragraph(Box box, Status listStatus, int height) {
        this.box = box;
        this.drawkit = box.drawkit;
        this.preferredHeight = height;
        Status status = this.drawkit.status;
        if (status.textIndent != null) {
            this.indent = status.textIndent.getValue(status.fd, status.fdFontSize.height, 2);
            this.lineHeight += this.indent;
        }
        this.whiteSpace = status.whiteSpace;
        this.reference = status.reference;
        if (listStatus != null) {
            if (listStatus.listLevel == 0) {
                this.drawkit.status = listStatus;
                this.statusChanged();
                this.appendString("\u30fb");
                this.drawkit.status = status;
                this.statusChanged();
            } else {
                this.listStatus = listStatus;
            }
        }
    }

    void appendString(String text) {
        int ls = this.lastSpace;
        int end = 0;
        text = this.whiteSpace != 51 ? TextFormat.convertXhtml(text, ls != 2, false, true, this.reference) : TextFormat.convertXhtml(text, false, false, false, this.reference);
        end = text.length();
        if (end == 0) {
            return;
        }
        this.checkCaddy(false, true, true);
        if (this.whiteSpace != 51 && !this.lastCaddy.ruby && text.charAt(end - 1) == ' ') {
            --end;
            this.lastSpace = 1;
        }
        this.caddy.append(text, 0, end);
    }

    void appendImage(String src, String alt, Value width, Value height, int border, int floatType) {
        boolean notFloat = floatType == 3;
        this.checkCaddy(false, notFloat, notFloat);
        this.caddy.append(src, alt, width, height, border, floatType);
        if (!notFloat) {
            this.caddy.statusChanged();
        }
    }

    void appendFloat(Box box) {
        this.checkCaddy(false, false, false);
        this.caddy.append(box);
        this.caddy.statusChanged();
    }

    void appendForm(FormItem item) {
        this.checkCaddy(false, true, true);
        this.caddy.append(item);
    }

    void setRuby(int mode) {
        switch (mode) {
            case 1: {
                this.commitCaddy();
                this.checkCaddy(true, true, true);
                break;
            }
            case 7: {
                this.caddy.setRuby(7);
                this.commitCaddy();
                break;
            }
            default: {
                this.caddy.setRuby(mode);
            }
        }
    }

    void newLine() {
        this.checkCaddy(false, false, false);
        if (!this.caddy.ruby) {
            this.caddy.append(BR, 0, 1);
        }
        this.lastSpace = 0;
    }

    void appendLastLine(boolean br, int nextHeight) {
        int o2;
        int o1;
        this.lineMaxHeight += this.lineHeight;
        if (br) {
            this.maxHeight = Math.max(this.maxHeight, this.lineMaxHeight);
            this.lineMaxHeight = 0;
        }
        if (this.lineno > 0) {
            this.lineWidth += this.linePitch;
        }
        this.width += this.lineWidth;
        this.width += this.lineOffset;
        this.height = Math.max(this.height, this.lineHeight);
        ++this.lineno;
        this.widthList.addElement(new Integer(this.lineWidth));
        this.heightList.addElement(new Integer(this.lineHeight));
        this.offsetList.addElement(new Integer(this.lineOffset));
        this.topList.addElement(new Integer(this.floatTop));
        this.bottomList.addElement(new Integer(this.floatBottom));
        this.lineWidth = 0;
        this.lineHeight = 0;
        this.lineOffset = 0;
        this.linePitch = 0;
        if (this.floatQueue != null) {
            FloatBlock fb;
            while ((fb = (FloatBlock)this.floatQueue.get()) != null) {
                this.allocateFloatBlock(fb);
            }
        }
        this.floatTop = this.getFloatHeight(31);
        this.floatBottom = this.getFloatHeight(32);
        this.floatHeight = this.floatTop + this.floatBottom;
        if (nextHeight > 0 && this.floatHeight > 0 && (o1 = this.drawOffsetX + this.width) != (o2 = this.box.getFloatGap(o1, nextHeight, this.preferredHeight))) {
            this.linePitch = o2 - o1;
            this.floatTop = this.box.getFloatHeight(o2, 31);
            this.floatBottom = this.box.getFloatHeight(o2, 32);
            this.floatHeight = this.floatTop + this.floatBottom;
        }
    }

    void appendFloatBlock(int width, int height, int type, Point offset, int current) {
        if (!this.rearrange) {
            this.height = Math.max(this.height, height);
            this.hasFloat = true;
            return;
        }
        FloatBlock fb = new FloatBlock(width, height, type, offset);
        if (this.lineHeight + current == 0) {
            this.allocateFloatBlock(fb);
            this.floatTop = this.getFloatHeight(31);
            this.floatBottom = this.getFloatHeight(32);
            this.floatHeight = this.floatTop + this.floatBottom;
            return;
        }
        if (this.floatQueue == null) {
            this.floatQueue = new Queue();
        }
        this.floatQueue.put(fb);
    }

    private void allocateFloatBlock(FloatBlock fb) {
        int offset = this.drawOffsetX;
        Point pos = this.box.addFloat(offset + this.width, fb.width, fb.height, fb.type, this.preferredHeight);
        ((FloatBlock)fb).offset.x = pos.x - offset;
        ((FloatBlock)fb).offset.y = pos.y;
    }

    int getFloatHeight(int type) {
        return this.box.getFloatHeight(this.drawOffsetX + this.width, type);
    }

    void commit() {
        if (this.caddy != null) {
            this.caddy.commit();
            this.caddy = null;
        }
        if (this.lineHeight > 0) {
            this.appendLastLine(true, 0);
        }
    }

    void statusChanged() {
        if (this.caddy == null) {
            return;
        }
        this.statusChanged = true;
    }

    void rearrange(int newHeight, boolean force) {
        if (!force && !this.hasFloat && this.preferredHeight == newHeight) {
            return;
        }
        this.rearrange = true;
        this.preferredHeight = newHeight;
        this.widthList.removeAllElements();
        this.heightList.removeAllElements();
        this.offsetList.removeAllElements();
        this.topList.removeAllElements();
        this.bottomList.removeAllElements();
        this.lineno = 0;
        this.width = 0;
        this.height = 0;
        this.lineWidth = 0;
        this.lineHeight = this.indent;
        this.lineOffset = 0;
        this.linePitch = 0;
        this.floatTop = this.getFloatHeight(31);
        this.floatBottom = this.getFloatHeight(32);
        this.floatHeight = this.floatTop + this.floatBottom;
        this.floatQueue = null;
        Caddy caddy = this.topCaddy;
        while (caddy != null) {
            caddy.rearrange(newHeight);
            caddy = caddy.next;
        }
        this.commit();
    }

    void draw(int x, int y) {
        if (this.lineno == 0 && !this.hasFloat) {
            return;
        }
        x -= this.drawOffsetX;
        int[] ws = new int[this.lineno];
        int[] hs = new int[this.lineno];
        int[] os = new int[this.lineno];
        int[] ts = new int[this.lineno];
        int[] bs = new int[this.lineno];
        for (int i = 0; i < this.lineno; ++i) {
            ws[i] = (Integer)this.widthList.elementAt(i);
            hs[i] = (Integer)this.heightList.elementAt(i);
            os[i] = (Integer)this.offsetList.elementAt(i);
            ts[i] = (Integer)this.topList.elementAt(i);
            bs[i] = (Integer)this.bottomList.elementAt(i);
        }
        Position p = new Position(x, y, this.box.status.align, this.preferredHeight, ws, hs, os, ts, bs);
        if (this.listStatus != null) {
            this.drawkit.drawListItem(p.x, p.y, this.listStatus);
        }
        p.y += this.indent;
        Caddy caddy = this.topCaddy;
        while (caddy != null) {
            caddy.draw(p);
            caddy = caddy.next;
        }
    }

    private void checkCaddy(boolean ruby, boolean space, boolean changeSpace) {
        if (this.caddy == null) {
            this.caddy = new Caddy(this, ruby);
            if (this.topCaddy == null) {
                this.topCaddy = this.lastCaddy = this.caddy;
            } else {
                this.lastCaddy = this.lastCaddy.next = this.caddy;
            }
        } else {
            if (space && this.lastSpace == 1) {
                this.caddy.append(SPACE, 0, 1);
            }
            if (this.statusChanged) {
                this.caddy.statusChanged();
                this.whiteSpace = this.drawkit.status.whiteSpace;
                this.reference = this.drawkit.status.reference;
            }
        }
        if (changeSpace && this.lastSpace != 2) {
            this.lastSpace = 2;
        }
    }

    private void commitCaddy() {
        if (this.caddy == null) {
            return;
        }
        this.caddy.commit();
        this.caddy = null;
    }

    private class FloatBlock {
        private int width;
        private int height;
        private int type;
        private Point offset;

        private FloatBlock(int width, int height, int type, Point offset) {
            this.width = width;
            this.height = height;
            this.type = type;
            this.offset = offset;
        }
    }
}

