/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Point;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;

public class ItemMap {
    private Reporter reporter = null;
    private Vector hrefMap = new Vector();
    private Vector imageMap = new Vector();
    private Vector tipMap = new Vector();
    private Vector infoMap = new Vector();
    private Hashtable idMap = new Hashtable();

    ItemMap(Reporter reporter) {
        this.reporter = reporter;
    }

    synchronized void addHref(int x1, int y1, int x2, int y2, URL url) {
        this.hrefMap.addElement(new InfoRectangle(x1, y1, x2, y2, url));
    }

    synchronized void addImage(int x1, int y1, int x2, int y2, URL url) {
        this.imageMap.addElement(new InfoRectangle(x1, y1, x2, y2, url));
    }

    public synchronized URL getLinkURL(int x, int y) {
        InfoRectangle ir = null;
        for (int i = 0; i < this.hrefMap.size(); ++i) {
            ir = (InfoRectangle)this.hrefMap.elementAt(i);
            if (!ir.isInner(x, y)) continue;
            return (URL)ir.info;
        }
        return null;
    }

    public synchronized URL getImageURL(int x, int y) {
        InfoRectangle ir = null;
        for (int i = 0; i < this.imageMap.size(); ++i) {
            ir = (InfoRectangle)this.imageMap.elementAt(i);
            if (!ir.isInner(x, y)) continue;
            return (URL)ir.info;
        }
        return null;
    }

    synchronized void addTip(int x1, int y1, int x2, int y2, String tip) {
        this.tipMap.addElement(new InfoRectangle(x1, y1, x2, y2, tip));
    }

    public synchronized String getTip(int x, int y) {
        InfoRectangle ir = null;
        for (int i = 0; i < this.tipMap.size(); ++i) {
            ir = (InfoRectangle)this.tipMap.elementAt(i);
            if (!ir.isInner(x, y)) continue;
            return (String)ir.info;
        }
        return null;
    }

    synchronized void addInfo(int x1, int y1, int x2, int y2, String tip) {
        this.infoMap.addElement(new InfoRectangle(x1, y1, x2, y2, tip));
    }

    public synchronized String getInfo(int x, int y) {
        InfoRectangle ir = null;
        for (int i = 0; i < this.infoMap.size(); ++i) {
            ir = (InfoRectangle)this.infoMap.elementAt(i);
            if (!ir.isInner(x, y)) continue;
            return (String)ir.info;
        }
        return null;
    }

    synchronized void addId(String id, int x, int y) {
        if (this.idMap.containsKey(id)) {
            this.reporter.report(7, Resource.getMessage("render.warning.id.duplicate", new String[]{id}), 0, 0);
            return;
        }
        this.idMap.put(id, new Point(x, y));
    }

    public synchronized Point getIdPoint(String id) {
        Point p = (Point)this.idMap.get(id);
        if (p == null) {
            return null;
        }
        return new Point(p.x, p.y);
    }

    private class InfoRectangle {
        private int x1 = 0;
        private int y1 = 0;
        private int x2 = 0;
        private int y2 = 0;
        private Object info = null;

        private InfoRectangle(int x1, int y1, int x2, int y2, Object info) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.info = info;
        }

        private boolean isInner(int x, int y) {
            return this.x1 <= x && x <= this.x2 && this.y1 <= y && y <= this.y2;
        }
    }
}

