/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.ParseException;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.build.FilterParser;
import net.hizlab.kagetaka.build.Parser;
import net.hizlab.kagetaka.build.ParserManager;
import net.hizlab.kagetaka.build.TokenCoordinator;
import net.hizlab.kagetaka.io.CounterInputStream;
import net.hizlab.kagetaka.io.CounterListener;
import net.hizlab.kagetaka.java2.NETWrapper;
import net.hizlab.kagetaka.rendering.ConnectWrapper;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.EngineListener;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.ImageCache;
import net.hizlab.kagetaka.rendering.ItemMap;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.Render;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.rendering.StopException;
import net.hizlab.kagetaka.token.EndToken;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TextToken;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenTypes;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.Charset;
import net.hizlab.kagetaka.util.ContentType;
import net.hizlab.kagetaka.util.StringUtils;

public class HawkEngine {
    private static final ContentType DEFAULT_CONTENT_TYPE = new ContentType("text", "html");
    private static final int LT_TEXT = 0;
    private static final int LT_HTML = 1;
    private static final int LT_IMAGE = 2;
    private static final int LT_BINARY = 3;
    private static NETWrapper netWrapper = NETWrapper.getInstance();
    private final HawkContext context;
    private final Reporter reporter;
    private final Option option;
    private ImageCache imageCache;
    private Object threadLock = new Object();
    private LoadThread oldThread = null;
    private LoadThread loadThread = null;
    private EngineListener listener = null;
    private Object renderLock = new Object();
    private Render render = null;

    public HawkEngine(HawkContext context) {
        this.context = context;
        this.reporter = context.getReporter();
        this.option = context.getOption();
        this.imageCache = ImageCache.getInstance();
    }

    public void setEngineListener(EngineListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(Request request) {
        if (this.isLoading()) {
            this.stop();
        }
        Object object = this.threadLock;
        synchronized (object) {
            if (this.loadThread != null) {
                this.loadThread.dispose();
                if (this.oldThread == null) {
                    this.oldThread = this.loadThread;
                }
            }
        }
        this.loadThread = new LoadThread(request);
        this.loadThread.start();
    }

    public synchronized void stop() {
        if (this.isLoading()) {
            this.loadThread.interrupt();
        }
    }

    public synchronized boolean isLoading() {
        return this.loadThread != null && this.loadThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        if (this.isLoading()) {
            this.loadThread.interrupt();
        }
        Object object = this.renderLock;
        synchronized (object) {
            if (this.render != null) {
                this.render.dispose();
            }
        }
    }

    static /* synthetic */ Object access$100(HawkEngine x0) {
        return x0.threadLock;
    }

    static /* synthetic */ LoadThread access$200(HawkEngine x0) {
        return x0.oldThread;
    }

    static /* synthetic */ LoadThread access$202(HawkEngine x0, LoadThread x1) {
        x0.oldThread = x1;
        return x0.oldThread;
    }

    static /* synthetic */ ContentType access$300() {
        return DEFAULT_CONTENT_TYPE;
    }

    static /* synthetic */ ImageCache access$500(HawkEngine x0) {
        return x0.imageCache;
    }

    static /* synthetic */ Object access$700(HawkEngine x0) {
        return x0.renderLock;
    }

    static /* synthetic */ Render access$802(HawkEngine x0, Render x1) {
        x0.render = x1;
        return x0.render;
    }

    private class Chatty
    implements CounterListener {
        private LoadThread thread;
        private String name;
        private int max;
        private int percent = 0;
        private int p;

        private Chatty(LoadThread thread, String name, int max) {
            this.thread = thread;
            this.name = name;
            this.max = max;
        }

        public void changeLength(long length) {
            this.p = (int)(length * 100L / (long)this.max);
            if (this.p >= 100) {
                this.p = 99;
            }
            if (this.p != this.percent) {
                if (this.percent > 0) {
                    this.thread.setStatus("engine.status.load.percent", new Object[]{this.name, new Integer(this.percent)}, 3);
                }
                this.percent = this.p;
            }
        }
    }

    private class LoadThread
    extends Thread
    implements EngineListener {
        private Request request;
        private URL url;
        private String urlString;
        private boolean active = true;

        private LoadThread(Request request) {
            this.request = request;
            this.url = request.url;
            this.urlString = this.url.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block226: {
                block196: {
                    block189: {
                        block190: {
                            block183: {
                                block229: {
                                    loadType = 1;
                                    noerror = false;
                                    connection = null;
                                    is = null;
                                    document = null;
                                    try {
                                        var6_6 = HawkEngine.access$100(HawkEngine.this);
                                        synchronized (var6_6) {
                                            if (HawkEngine.access$200(HawkEngine.this) != null) {
                                                HawkEngine.access$200(HawkEngine.this).join();
                                                HawkEngine.access$202(HawkEngine.this, null);
                                            }
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        this.setStatus("engine.warning.stop", new String[]{"old thread stop"}, 7);
                                        var21_21 = null;
                                        try {
                                            if (noerror && loadType == 1) {
                                                HawkEngine.access$500(HawkEngine.this).clear();
                                                try {
                                                    refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                                    if (refreshUrl != null) {
                                                        this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                                                    }
                                                }
                                                catch (StopException e) {
                                                    // empty catch block
                                                }
                                            }
                                            v0 = null;
                                        }
                                        catch (Throwable var23_72) {
                                            v0 = null;
                                        }
                                        var24_89 = v0;
                                        var25_106 = this;
                                        synchronized (var25_106) {
                                            this.active = false;
                                        }
                                        return;
                                    }
                                    contentType = HawkEngine.access$300();
                                    encoding = null;
                                    contentLength = -1;
                                    this.connecting(this.request);
                                    this.setStatus("engine.status.load.open", new String[]{this.urlString}, 3);
                                    noerror = false;
                                    if (HawkEngine.access$500(HawkEngine.this).getImage(HawkEngine.access$400(HawkEngine.this), this.url, this.urlString, this.request, false) == null) break block229;
                                    loadType = 2;
                                    try {
                                        contentType = new ContentType(HawkEngine.access$500(HawkEngine.this).getContentType(this.url));
                                    }
                                    catch (ParseException e) {}
                                    ** GOTO lbl216
                                }
                                connection = ConnectWrapper.getURLConnection(HawkEngine.access$400(HawkEngine.this), this.request);
                                if (connection != null) break block182;
                                this.setStatus(null, null, 0);
                                var14_143 = null;
                                this.connected(this.request, noerror);
                                if (noerror && !this.isInterrupted()) break block183;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    noerror = true;
                                }
                                var21_22 = null;
                                try {
                                    if (noerror && loadType == 1) {
                                        HawkEngine.access$500(HawkEngine.this).clear();
                                        try {
                                            refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                            if (refreshUrl != null) {
                                                this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                                            }
                                        }
                                        catch (StopException e) {
                                            // empty catch block
                                        }
                                    }
                                    v1 = null;
                                }
                                catch (Throwable var23_73) {
                                    v1 = null;
                                }
                                var24_90 = v1;
                                var25_107 = this;
                                synchronized (var25_107) {
                                    this.active = false;
                                }
                                return;
                            }
                            var21_23 = null;
                            try {
                                if (noerror && loadType == 1) {
                                    HawkEngine.access$500(HawkEngine.this).clear();
                                    try {
                                        refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                        if (refreshUrl != null) {
                                            this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                                        }
                                    }
                                    catch (StopException e) {
                                        // empty catch block
                                    }
                                }
                                v2 = null;
                            }
                            catch (Throwable var23_74) {
                                v2 = null;
                            }
                            var24_91 = v2;
                            var25_108 = this;
                            synchronized (var25_108) {
                                this.active = false;
                            }
                            {
                                block182: {
                                    return;
                                }
                                if (!this.isInterrupted()) break block188;
                                var14_144 = null;
                                this.connected(this.request, noerror);
                                if (noerror && !this.isInterrupted()) break block189;
                                this.renderingSkipped(this.request);
                                if (!this.isInterrupted()) break block190;
                                noerror = true;
                            }
                        }
                        var21_24 = null;
                        try {
                            if (noerror && loadType == 1) {
                                HawkEngine.access$500(HawkEngine.this).clear();
                                try {
                                    refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                    if (refreshUrl != null) {
                                        this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                                    }
                                }
                                catch (StopException e) {
                                    // empty catch block
                                }
                            }
                            v3 = null;
                        }
                        catch (Throwable var23_75) {
                            v3 = null;
                        }
                        var24_92 = v3;
                        var25_109 = this;
                        synchronized (var25_109) {
                            this.active = false;
                        }
                        return;
                    }
                    var21_25 = null;
                    try {
                        if (noerror && loadType == 1) {
                            HawkEngine.access$500(HawkEngine.this).clear();
                            try {
                                refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                if (refreshUrl != null) {
                                    this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                                }
                            }
                            catch (StopException e) {
                                // empty catch block
                            }
                        }
                        v4 = null;
                    }
                    catch (Throwable var23_76) {
                        v4 = null;
                    }
                    var24_93 = v4;
                    var25_110 = this;
                    synchronized (var25_110) {
                        this.active = false;
                    }
                    {
                        block188: {
                            return;
                        }
                        this.url = connection.getURL();
                        this.urlString = this.url.toString();
                        ct = connection.getContentType();
                        if (ct != null) {
                            try {
                                contentType = new ContentType(ct);
                            }
                            catch (ParseException e) {
                                // empty catch block
                            }
                        }
                        media = contentType.getType();
                        subtype = contentType.getSubType();
                        if (media.compareTo("text") == 0) {
                            loadType = subtype != null && subtype.compareTo("html") == 0 ? 1 : 0;
                            is = this.getConnectionInputStream(connection);
                            charset = contentType.getParameter("charset");
                            if (charset != null && (encoding = Charset.toEncoding(charset)) == null) {
                                this.setStatus("charset.warning.invalid", new String[]{charset}, 7);
                            }
                        } else {
                            loadType = media.compareTo("image") == 0 ? 2 : 3;
                        }
                        contentLength = connection.getContentLength();
lbl216:
                        // 3 sources

                        document = new Document(this.url, contentType, contentLength, 128, new ItemMap(HawkEngine.access$600(HawkEngine.this)));
                        document.setEncoding(encoding);
                        this.request.setDocument(document);
                        noerror = true;
                        var14_145 = null;
                        this.connected(this.request, noerror);
                        if (noerror && !this.isInterrupted()) break block195;
                        this.renderingSkipped(this.request);
                        if (!this.isInterrupted()) break block196;
                        noerror = true;
                    }
                }
                var21_26 = null;
                try {
                    if (noerror && loadType == 1) {
                        HawkEngine.access$500(HawkEngine.this).clear();
                        try {
                            refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                            if (refreshUrl != null) {
                                this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                            }
                        }
                        catch (StopException e) {
                            // empty catch block
                        }
                    }
                    v5 = null;
                }
                catch (Throwable var23_77) {
                    v5 = null;
                }
                var24_94 = v5;
                var25_111 = this;
                synchronized (var25_111) {
                    this.active = false;
                }
                {
                    block195: {
                        return;
                        {
                            catch (InterruptedException e) {
                                var14_146 = null;
                                this.connected(this.request, noerror);
                                if (noerror && !this.isInterrupted()) break block195;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    noerror = true;
                                }
                                var21_27 = null;
                                try {
                                    if (noerror && loadType == 1) {
                                        HawkEngine.access$500(HawkEngine.this).clear();
                                        try {
                                            refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                            if (refreshUrl != null) {
                                                this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                                            }
                                        }
                                        catch (StopException e) {
                                            // empty catch block
                                        }
                                    }
                                    v6 = null;
                                }
                                catch (Throwable var23_78) {
                                    v6 = null;
                                }
                                var24_95 = v6;
                                var25_112 = this;
                                synchronized (var25_112) {
                                    this.active = false;
                                }
                                return;
                            }
                            catch (SecurityException e) {
                                this.setStatus("engine.status.load.error.security", new String[]{this.urlString}, 7);
                                var14_147 = null;
                                this.connected(this.request, noerror);
                                if (noerror && !this.isInterrupted()) break block195;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    noerror = true;
                                }
                                var21_28 = null;
                                try {
                                    if (noerror && loadType == 1) {
                                        HawkEngine.access$500(HawkEngine.this).clear();
                                        try {
                                            refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                            if (refreshUrl != null) {
                                                this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                                            }
                                        }
                                        catch (StopException e) {
                                            // empty catch block
                                        }
                                    }
                                    v7 = null;
                                }
                                catch (Throwable var23_79) {
                                    v7 = null;
                                }
                                var24_96 = v7;
                                var25_113 = this;
                                synchronized (var25_113) {
                                    this.active = false;
                                }
                                return;
                            }
                            catch (FileNotFoundException e) {
                                this.setStatus("engine.status.load.error.nofile", new String[]{this.urlString}, 7);
                                var14_148 = null;
                                this.connected(this.request, noerror);
                                if (noerror && !this.isInterrupted()) break block195;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    noerror = true;
                                }
                                var21_29 = null;
                                try {
                                    if (noerror && loadType == 1) {
                                        HawkEngine.access$500(HawkEngine.this).clear();
                                        try {
                                            refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                            if (refreshUrl != null) {
                                                this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                                            }
                                        }
                                        catch (StopException e) {
                                            // empty catch block
                                        }
                                    }
                                    v8 = null;
                                }
                                catch (Throwable var23_80) {
                                    v8 = null;
                                }
                                var24_97 = v8;
                                var25_114 = this;
                                synchronized (var25_114) {
                                    this.active = false;
                                }
                                return;
                            }
                            catch (UnknownHostException e) {
                                this.setStatus("engine.status.load.error.hostname", new String[]{this.url.getHost()}, 7);
                                var14_149 = null;
                                this.connected(this.request, noerror);
                                if (noerror && !this.isInterrupted()) break block195;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    noerror = true;
                                }
                                var21_30 = null;
                                try {
                                    if (noerror && loadType == 1) {
                                        HawkEngine.access$500(HawkEngine.this).clear();
                                        try {
                                            refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                            if (refreshUrl != null) {
                                                this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                                            }
                                        }
                                        catch (StopException e) {
                                            // empty catch block
                                        }
                                    }
                                    v9 = null;
                                }
                                catch (Throwable var23_81) {
                                    v9 = null;
                                }
                                var24_98 = v9;
                                var25_115 = this;
                                synchronized (var25_115) {
                                    this.active = false;
                                }
                                return;
                            }
                            catch (ConnectException e) {
                                this.setStatus("engine.status.load.error.connect", new String[]{this.url.getHost()}, 7);
                                var14_150 = null;
                                this.connected(this.request, noerror);
                                if (noerror && !this.isInterrupted()) break block195;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    noerror = true;
                                }
                                var21_31 = null;
                                try {
                                    if (noerror && loadType == 1) {
                                        HawkEngine.access$500(HawkEngine.this).clear();
                                        try {
                                            refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                            if (refreshUrl != null) {
                                                this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                                            }
                                        }
                                        catch (StopException e) {
                                            // empty catch block
                                        }
                                    }
                                    v10 = null;
                                }
                                catch (Throwable var23_82) {
                                    v10 = null;
                                }
                                var24_99 = v10;
                                var25_116 = this;
                                synchronized (var25_116) {
                                    this.active = false;
                                }
                                return;
                            }
                            catch (IOException e) {
                                s = e.getMessage();
                                this.setStatus("engine.status.load.error", new Object[]{this.urlString, new Integer(s != null ? 1 : 0), s, e.getClass().getName()}, 7);
                                if (HawkEngine.access$600(HawkEngine.this) != null && HawkEngine.access$600(HawkEngine.this).getLevel() <= -1) {
                                    e.printStackTrace(System.out);
                                }
                                var14_151 = null;
                                this.connected(this.request, noerror);
                                if (noerror && !this.isInterrupted()) break block195;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    noerror = true;
                                }
                                var21_32 = null;
                                try {
                                    if (noerror && loadType == 1) {
                                        HawkEngine.access$500(HawkEngine.this).clear();
                                        try {
                                            refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                            if (refreshUrl != null) {
                                                this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                                            }
                                        }
                                        catch (StopException e) {
                                            // empty catch block
                                        }
                                    }
                                    v11 = null;
                                }
                                catch (Throwable var23_83) {
                                    v11 = null;
                                }
                                var24_100 = v11;
                                var25_117 = this;
                                synchronized (var25_117) {
                                    this.active = false;
                                }
                                return;
                            }
                            catch (RuntimeException e) {
                                s = e.getMessage();
                                this.setStatus("engine.status.load.error", new Object[]{this.urlString, new Integer(s != null ? 1 : 0), s, e.getClass().getName()}, 7);
                                e.printStackTrace(System.out);
                                var14_152 = null;
                                this.connected(this.request, noerror);
                                if (noerror && !this.isInterrupted()) break block195;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    noerror = true;
                                }
                                var21_33 = null;
                                try {
                                    if (noerror && loadType == 1) {
                                        HawkEngine.access$500(HawkEngine.this).clear();
                                        try {
                                            refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                            if (refreshUrl != null) {
                                                this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                                            }
                                        }
                                        catch (StopException e) {
                                            // empty catch block
                                        }
                                    }
                                    v12 = null;
                                }
                                catch (Throwable var23_84) {
                                    v12 = null;
                                }
                                var24_101 = v12;
                                var25_118 = this;
                                synchronized (var25_118) {
                                    this.active = false;
                                }
                                return;
                            }
                        }
                        catch (Throwable var13_158) {
                            var14_153 = null;
                            this.connected(this.request, noerror);
                            if (!noerror || this.isInterrupted()) {
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    noerror = true;
                                }
                                var21_34 = null;
                                try {
                                    if (noerror && loadType == 1) {
                                        HawkEngine.access$500(HawkEngine.this).clear();
                                        try {
                                            refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                            if (refreshUrl != null) {
                                                this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                                            }
                                        }
                                        catch (StopException e) {
                                            // empty catch block
                                        }
                                    }
                                    v13 = null;
                                }
                                catch (Throwable var23_85) {
                                    v13 = null;
                                }
                                var24_102 = v13;
                                var25_119 = this;
                                synchronized (var25_119) {
                                    this.active = false;
                                }
                                return;
                            }
                            throw var13_158;
                        }
                    }
                    if (loadType != 3) break block230;
                    try {
                        noerror = false;
                        this.doBinary(document, connection);
                        this.setStatus(null, null, 0);
                        noerror = true;
                    }
                    finally {
                        this.renderingSkipped(this.request);
                    }
                }
                var21_35 = null;
                try {
                    if (noerror && loadType == 1) {
                        HawkEngine.access$500(HawkEngine.this).clear();
                        try {
                            refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                            if (refreshUrl != null) {
                                this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                            }
                        }
                        catch (StopException e) {
                            // empty catch block
                        }
                    }
                    v14 = null;
                }
                catch (Throwable var23_86) {
                    v14 = null;
                }
                var24_103 = v14;
                var25_120 = this;
                synchronized (var25_120) {
                    this.active = false;
                }
                {
                    block230: {
                        return;
                    }
                    try {
                        this.renderingStarted(this.request);
                        this.setStatus("engine.status.load.start", new String[]{this.urlString}, 3);
                        noerror = false;
                        e = HawkEngine.access$700(HawkEngine.this);
                        synchronized (e) {
                            if (HawkEngine.access$800(HawkEngine.this) != null) {
                                HawkEngine.access$800(HawkEngine.this).dispose();
                            }
                            HawkEngine.access$802(HawkEngine.this, new Render(HawkEngine.access$400(HawkEngine.this), this.request));
                        }
                        switch (loadType) {
                            case 0: {
                                is = this.getConnectionInputStream(connection);
                                this.doText(document, is);
                                break;
                            }
                            case 1: {
                                is = this.getConnectionInputStream(connection);
                                this.doHtml(document, is);
                                break;
                            }
                            case 2: {
                                this.doImage(document);
                            }
                        }
                        this.setStatus("engine.status.load.complete", null, 3);
                        noerror = true;
                        var18_161 = null;
                        this.renderingStopped(this.request, noerror);
                        ** if (is == null) goto lbl-1000
                    }
                    catch (Throwable var17_173) {
                        var18_166 = null;
                        this.renderingStopped(this.request, noerror);
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw var17_173;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block226;
                        catch (StopException e) {
                            if (HawkEngine.access$600(HawkEngine.this) != null) {
                                HawkEngine.access$600(HawkEngine.this).report(3, Resource.getMessage("engine.warning.stop", new String[]{e.toString()}), 0, 0);
                            }
                            HawkEngine.access$800(HawkEngine.this).stopImageLoad();
                            noerror = true;
                            var18_162 = null;
                            this.renderingStopped(this.request, noerror);
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {}
                            }
                            break block226;
                        }
                        catch (OutOfMemoryError e) {
                            this.setStatus("engine.status.load.error.oom", new String[]{this.urlString}, 7);
                            if (HawkEngine.access$600(HawkEngine.this) != null && HawkEngine.access$600(HawkEngine.this).getLevel() <= -1) {
                                e.printStackTrace(System.out);
                            }
                            var18_163 = null;
                            this.renderingStopped(this.request, noerror);
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {}
                            }
                            break block226;
                        }
                        catch (IOException e) {
                            s = e.getMessage();
                            this.setStatus("engine.status.load.error", new Object[]{this.urlString, new Integer(s != null ? 1 : 0), s, e.getClass().getName()}, 7);
                            e.printStackTrace(System.out);
                            var18_164 = null;
                            this.renderingStopped(this.request, noerror);
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {}
                            }
                            break block226;
                        }
                        catch (RuntimeException e) {
                            s = e.getMessage();
                            this.setStatus("engine.status.load.error", new Object[]{this.urlString, new Integer(s != null ? 1 : 0), s, e.getClass().getName()}, 7);
                            e.printStackTrace(System.out);
                            var18_165 = null;
                            this.renderingStopped(this.request, noerror);
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                }
            }
            var21_36 = null;
            try {
                if (noerror && loadType == 1) {
                    HawkEngine.access$500(HawkEngine.this).clear();
                    try {
                        refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                        if (refreshUrl != null) {
                            this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                        }
                    }
                    catch (StopException e) {
                        // empty catch block
                    }
                }
                v15 = null;
            }
            catch (Throwable var23_87) {
                v15 = null;
            }
            var24_104 = v15;
            var25_121 = this;
            synchronized (var25_121) {
                this.active = false;
            }
            catch (Throwable var20_174) {
                var21_37 = null;
                try {
                    if (noerror && loadType == 1) {
                        HawkEngine.access$500(HawkEngine.this).clear();
                        try {
                            refreshUrl = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                            if (refreshUrl != null) {
                                this.refresh(this.request, new Request(refreshUrl, null, this.request.getDocument().url, null, false, false, 1));
                            }
                        }
                        catch (StopException e) {
                            // empty catch block
                        }
                    }
                    v16 = null;
                }
                catch (Throwable var23_88) {
                    v16 = null;
                }
                var24_105 = v16;
                var25_122 = this;
                synchronized (var25_122) {
                    this.active = false;
                }
                throw var20_174;
            }
        }

        public void interrupt() {
            super.interrupt();
            this.setStatus("engine.status.load.stop", null, 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                this.active = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setStatus(String key, Object[] args, int type) {
            String message;
            String string = message = key != null ? Resource.getMessage(key, args) : null;
            if (message != null && HawkEngine.this.reporter != null) {
                HawkEngine.this.reporter.report(type, message, 0, 0);
            }
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active) {
                    HawkEngine.this.context.setStatus(message);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connecting(Request request) {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active && HawkEngine.this.listener != null) {
                    HawkEngine.this.listener.connecting(request);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connected(Request request, boolean noerror) {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active && HawkEngine.this.listener != null) {
                    HawkEngine.this.listener.connected(request, noerror);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renderingSkipped(Request request) {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active && HawkEngine.this.listener != null) {
                    HawkEngine.this.listener.renderingSkipped(request);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renderingStarted(Request request) {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active && HawkEngine.this.listener != null) {
                    HawkEngine.this.listener.renderingStarted(request);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renderingStopped(Request request, boolean noerror) {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active && HawkEngine.this.listener != null) {
                    HawkEngine.this.listener.renderingStopped(request, noerror);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh(Request baseRequest, Request newRequest) {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active && HawkEngine.this.listener != null) {
                    HawkEngine.this.listener.refresh(baseRequest, newRequest);
                }
            }
        }

        private void doText(Document document, InputStream is) {
            String line;
            BufferedReader br = null;
            String encoding = document.getEncoding();
            if (encoding != null) {
                try {
                    br = new BufferedReader(new InputStreamReader(is, encoding));
                    document.setEncoding(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
            if (br == null) {
                br = new BufferedReader(new InputStreamReader(is));
            }
            Status status = HawkEngine.this.render.getStatus();
            status.setMargin(15, new Value(5L, 3));
            status.lineHeight = new Value(1.2, 1);
            status.whiteSpace = 51;
            status.reference = false;
            status.setFixedFont();
            HawkEngine.this.render.setTitle(StringUtils.getFile(document.url));
            HawkEngine.this.render.startBody();
            do {
                int num = 0;
                HawkEngine.this.render.save(3191);
                HawkEngine.this.render.statusChanged();
                HawkEngine.this.render.startBlock();
                try {
                    while ((line = br.readLine()) != null) {
                        HawkEngine.this.render.drawText(line);
                        HawkEngine.this.render.drawText("\n");
                        if (++num < 100) continue;
                        break;
                    }
                }
                catch (IOException e) {
                    line = null;
                    String s = e.getMessage();
                    this.setStatus("engine.status.load.error", new Object[]{this.urlString, new Integer(s != null ? 1 : 0), s, e.getClass().getName()}, 7);
                }
                HawkEngine.this.render.endBlock();
                HawkEngine.this.render.reset();
                HawkEngine.this.render.statusChanged();
            } while (line != null);
            HawkEngine.this.render.endBody();
            try {
                br.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }

        private void doHtml(Document document, InputStream is) {
            boolean debug;
            String inputParser;
            if (is != null && document.contentLength != -1) {
                is = new CounterInputStream(is, new Chatty(this, this.urlString, document.contentLength));
            }
            if ((inputParser = HawkEngine.this.option.getInputStreamParser()) == null) {
                inputParser = Resource.getMessage("parser.default", null);
            }
            Parser parser = ParserManager.createInstance(inputParser, document, is, HawkEngine.this.reporter);
            String[] filters = HawkEngine.this.option.getFilterParsers();
            if (filters != null && filters.length > 0) {
                for (int i = 0; i < filters.length; ++i) {
                    FilterParser p = ParserManager.createInstance(filters[i], document, parser, HawkEngine.this.reporter);
                    if (p != null) {
                        parser = p;
                        continue;
                    }
                    ParserManager.ParserInfo pi = ParserManager.getParser(filters[i]);
                    String name = pi != null ? pi.getName() : "?";
                    this.setStatus("engine.status.load.error.filter", new String[]{name, filters[i]}, 7);
                }
            }
            TokenCoordinator tc = new TokenCoordinator(document, parser, HawkEngine.this.reporter);
            Token token = null;
            int type = -1;
            boolean isBlock = false;
            int frameSet = 0;
            boolean inHead = false;
            boolean inBody = false;
            boolean bl = debug = HawkEngine.this.reporter != null && HawkEngine.this.reporter.getLevel() <= -1;
            block8: while ((token = tc.next()) != null) {
                if (debug) {
                    HawkEngine.this.reporter.report(-1, "[" + token + "]", token.getLineNumber(), token.getColumnNumber());
                }
                if (Thread.interrupted()) break;
                type = token.getType();
                isBlock = type == 3501 || type == 3502 ? TokenTypes.canHaveBlock(token.getParent().getType()) : TokenTypes.isBlockEx(type) || type == 3401 || type == 3402;
                switch (type) {
                    case -1: 
                    case 0: 
                    case 3: 
                    case 4: 
                    case 5: {
                        token.render(HawkEngine.this.render);
                        continue block8;
                    }
                }
                if (!inBody) {
                    if (type == 2) continue;
                    if (type == 2041) {
                        if (++frameSet == 1) {
                            token.render(HawkEngine.this.render);
                            HawkEngine.this.render.startBody();
                            Status status = HawkEngine.this.render.getStatus();
                            status.setMargin(15, new Value(5L, 3));
                            status.lineHeight = new Value(1.2, 1);
                            status.letterSpacing = new Value(1L, 3);
                        }
                        HawkEngine.this.render.save(type);
                        token.render(HawkEngine.this.render);
                        HawkEngine.this.render.statusChanged();
                        HawkEngine.this.render.startBlock();
                        if (frameSet != 1) continue;
                        HawkEngine.this.render.save(type);
                        HawkEngine.this.render.getStatus().setMargin(10, new Value(1L, 1));
                        HawkEngine.this.render.statusChanged();
                        HawkEngine.this.render.startBlock();
                        HawkEngine.this.render.drawText(Resource.getMessage("engine.message.useframe", null));
                        HawkEngine.this.render.endBlock();
                        HawkEngine.this.render.reset();
                        HawkEngine.this.render.statusChanged();
                        continue;
                    }
                    if (frameSet > 0) {
                        switch (type) {
                            case 2043: {
                                HawkEngine.this.render.save(type);
                                token.render(HawkEngine.this.render);
                                HawkEngine.this.render.statusChanged();
                                HawkEngine.this.render.startBlock();
                                HawkEngine.this.render.endBlock();
                                HawkEngine.this.render.reset();
                                HawkEngine.this.render.statusChanged();
                                break;
                            }
                            case 2042: {
                                token.render(HawkEngine.this.render);
                                HawkEngine.this.render.endBlock();
                                HawkEngine.this.render.reset();
                                HawkEngine.this.render.statusChanged();
                                if (--frameSet != 0) break;
                                token.render(HawkEngine.this.render);
                                HawkEngine.this.render.endBody();
                            }
                        }
                        continue;
                    }
                    if (type == 3001) {
                        inBody = true;
                        token.render(HawkEngine.this.render);
                        HawkEngine.this.render.startBody();
                        continue;
                    }
                    if (!inHead) {
                        if (type == 2001) {
                            inHead = true;
                        }
                    } else if (type == 2002) {
                        inHead = false;
                    }
                    token.render(HawkEngine.this.render);
                    continue;
                }
                if (inBody && type == 3002) {
                    inBody = false;
                    token.render(HawkEngine.this.render);
                    HawkEngine.this.render.endBody();
                    continue;
                }
                if (token instanceof StartToken) {
                    HawkEngine.this.render.save(type);
                    token.render(HawkEngine.this.render);
                    HawkEngine.this.render.statusChanged();
                    if (isBlock) {
                        HawkEngine.this.render.startBlock();
                    }
                    if (!TokenTypes.isEmpty(token.getType())) continue;
                    if (isBlock) {
                        HawkEngine.this.render.endBlock();
                    }
                    HawkEngine.this.render.reset();
                    HawkEngine.this.render.statusChanged();
                    continue;
                }
                if (token instanceof EndToken) {
                    token.render(HawkEngine.this.render);
                    if (isBlock) {
                        HawkEngine.this.render.endBlock();
                    }
                    HawkEngine.this.render.reset();
                    HawkEngine.this.render.statusChanged();
                    continue;
                }
                if (!(token instanceof TextToken)) continue;
                token.render(HawkEngine.this.render);
            }
            HawkEngine.this.render.waitImageLoad();
        }

        private void doImage(Document document) {
            Status status = HawkEngine.this.render.getStatus();
            status.setMargin(15, new Value(5L, 3));
            HawkEngine.this.render.setTitle(StringUtils.getFile(document.url));
            HawkEngine.this.render.startBody();
            HawkEngine.this.render.save(3191);
            HawkEngine.this.render.statusChanged();
            HawkEngine.this.render.startBlock();
            HawkEngine.this.render.drawImage(this.urlString, null, null, null, new Integer(0), 3);
            HawkEngine.this.render.endBlock();
            HawkEngine.this.render.reset();
            HawkEngine.this.render.statusChanged();
            HawkEngine.this.render.endBody();
        }

        private void doBinary(Document document, URLConnection connection) {
            HawkEngine.this.context.download(document, connection);
        }

        private InputStream getConnectionInputStream(URLConnection connection) throws IOException {
            try {
                return connection.getInputStream();
            }
            catch (IOException e) {
                if (connection instanceof HttpURLConnection && netWrapper != null) {
                    HttpURLConnection httpConnection = (HttpURLConnection)connection;
                    InputStream is = netWrapper.getConnectionErrorStream(httpConnection);
                    if (is != null) {
                        return is;
                    }
                }
                throw e;
            }
        }
    }
}

