/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import net.hizlab.kagetaka.rendering.ItemMap;
import net.hizlab.kagetaka.util.ContentType;

public class Document {
    public static final int ZONE_INTERNET = 0;
    public static final int ZONE_LOCAL = 1;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.white;
    public final URL url;
    public final ContentType contentType;
    public final int contentLength;
    public final int media;
    public final ItemMap itemMap;
    public final int zone;
    private URL baseUrl;
    private String encoding;
    private String title;
    private Color backColor;
    private Image backImage;
    private Dimension charScale;

    Document(URL url, ContentType contentType, int contentLength, int media, ItemMap itemMap) {
        this.url = url;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.media = media;
        this.itemMap = itemMap;
        this.baseUrl = url;
        this.zone = url.getProtocol().compareTo("file") == 0 ? 1 : 0;
    }

    Document(URL url, Document src) {
        this.url = url;
        this.contentType = src.contentType;
        this.contentLength = src.contentLength;
        this.media = src.media;
        this.itemMap = src.itemMap;
        this.zone = src.zone;
        this.baseUrl = src.baseUrl;
        this.encoding = src.encoding;
        this.title = src.title;
        this.backColor = src.backColor;
        this.backImage = src.backImage;
        this.charScale = src.charScale;
    }

    public URL getBaseURL() {
        return this.baseUrl;
    }

    public void setBaseURL(URL url) {
        this.baseUrl = url;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Color getBackColor() {
        return this.backColor != null ? this.backColor : DEFAULT_BACKGROUND_COLOR;
    }

    public void setBackColor(Color color) {
        this.backColor = color;
    }

    public Image getBackImage() {
        return this.backImage;
    }

    public void setBackImage(Image image) {
        this.backImage = image;
    }

    public Dimension getCharScale() {
        return this.charScale;
    }

    public void setCharScale(Dimension scale) {
        this.charScale = scale;
    }

    public URL createURL(String href) throws MalformedURLException, SecurityException {
        URL url = new URL(this.baseUrl, href);
        if (this.zone != 1 && url.getProtocol().compareTo("file") == 0) {
            throw new SecurityException("Can not access to local file");
        }
        return url;
    }
}

