/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.io.IOException;
import java.net.URLConnection;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Request;

class ConnectWrapper
extends Thread {
    private HawkContext context;
    private Request request;
    private URLConnection connection;
    private IOException ioException;
    private InterruptedException interruptedException;
    private RuntimeException runtimeException;
    private Error error;

    static URLConnection getURLConnection(HawkContext context, Request request) throws IOException, InterruptedException {
        ConnectWrapper cw = new ConnectWrapper(context, request);
        cw.start();
        try {
            cw.join();
        }
        catch (InterruptedException e) {
            cw.interrupt();
            throw e;
        }
        if (cw.connection != null) {
            return cw.connection;
        }
        if (cw.ioException != null) {
            throw cw.ioException;
        }
        if (cw.interruptedException != null) {
            throw cw.interruptedException;
        }
        if (cw.runtimeException != null) {
            throw cw.runtimeException;
        }
        if (cw.error != null) {
            throw cw.error;
        }
        return null;
    }

    private ConnectWrapper(HawkContext context, Request request) {
        this.context = context;
        this.request = request;
    }

    public void run() {
        try {
            this.connection = this.context.getURLConnection(this.request);
        }
        catch (IOException e) {
            this.ioException = e;
        }
        catch (InterruptedException e) {
            this.interruptedException = e;
        }
        catch (RuntimeException e) {
            this.runtimeException = e;
        }
        catch (Error e) {
            this.error = e;
        }
    }
}

