/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.rendering.Box;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.Paragraph;
import net.hizlab.kagetaka.rendering.Position;
import net.hizlab.kagetaka.rendering.Wadge;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.Value;

class Caddy {
    Paragraph paragraph;
    boolean ruby;
    private Drawkit drawkit;
    private Wadge wadge = null;
    private Wadge baseWadge;
    private int rubyMode = 0;
    private Wadge rubyWadge = null;
    int width = 0;
    int height = 0;
    int offset = 0;
    int pitch = 0;
    Caddy next = null;

    Caddy(Paragraph paragraph, boolean ruby) {
        this.paragraph = paragraph;
        this.ruby = ruby;
        this.drawkit = paragraph.box.drawkit;
        this.wadge = this.baseWadge = new Wadge(this, ruby ? 1 : 0, null);
    }

    void append(String text, int begin, int end) {
        if (this.wadge != null) {
            this.wadge.append(text, begin, end);
        }
    }

    void append(String src, String alt, Value width, Value height, int border, int floatType) {
        if (this.wadge != null) {
            this.wadge.append(src, alt, width, height, border, floatType);
        }
    }

    void append(Box box) {
        if (this.wadge != null) {
            this.wadge.append(box);
        }
    }

    void append(FormItem item) {
        if (this.wadge != null) {
            this.wadge.append(item);
        }
    }

    void setRuby(int mode) {
        if (this.rubyMode == mode) {
            return;
        }
        switch (mode) {
            case 2: {
                this.wadge = this.baseWadge;
                break;
            }
            case 3: {
                this.wadge = null;
                break;
            }
            case 4: {
                if (this.rubyWadge == null) {
                    this.rubyWadge = new Wadge(this, 2, this.baseWadge);
                }
                this.wadge = this.rubyWadge;
                break;
            }
        }
        this.rubyMode = mode;
    }

    void statusChanged() {
        if (this.wadge == null) {
            return;
        }
        this.wadge.statusChanged();
    }

    void commit() {
        if (this.ruby) {
            if (this.rubyMode < 7) {
                return;
            }
            this.baseWadge.commit();
            if (this.rubyWadge != null) {
                this.rubyWadge.commit();
            }
            this.rubyMode = 8;
        } else {
            this.baseWadge.commit();
        }
        this.paragraph.lineWidth = Math.max(this.paragraph.lineWidth, this.width);
        this.paragraph.lineHeight += this.height;
        this.paragraph.lineOffset = Math.max(this.paragraph.lineOffset, this.offset);
        this.paragraph.linePitch = Math.max(this.paragraph.linePitch, this.pitch);
    }

    void rearrange(int newHeight) {
        if (this.baseWadge != null) {
            this.baseWadge.rearrange(newHeight);
        }
        if (this.rubyWadge != null) {
            this.rubyWadge.rearrange(newHeight);
        }
        this.paragraph.lineWidth = Math.max(this.paragraph.lineWidth, this.width);
        this.paragraph.lineHeight += this.height;
        this.paragraph.lineOffset = Math.max(this.paragraph.lineOffset, this.offset);
        this.paragraph.linePitch = Math.max(this.paragraph.linePitch, this.pitch);
    }

    void draw(Position p) {
        if (this.ruby) {
            if (this.rubyMode != 8) {
                return;
            }
            this.baseWadge.draw(p, this.height);
            if (this.rubyWadge != null) {
                this.rubyWadge.draw(p, this.height);
            }
            this.rubyMode = 9;
        } else {
            this.baseWadge.draw(p, 0);
        }
    }

    public String toString() {
        return this.baseWadge.toString();
    }
}

