/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.protocol.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import net.hizlab.kagetaka.Resource;

public class ResourceURLConnection
extends URLConnection {
    private static final String RESOURCE = "net.hizlab.kagetaka.protocol.resource.Resource";
    private String type;
    private byte[] data;
    private IOException exception;

    ResourceURLConnection(URL url) {
        super(url);
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        String jarPath = this.url.getHost();
        if (jarPath == null || jarPath.length() == 0) {
            String key = this.url.getFile().substring(1).replace('/', '.');
            this.type = Resource.getMessage(RESOURCE, key + ".type", null);
            this.data = Resource.getBinaryResource(RESOURCE, key + ".path");
        }
        this.connected = true;
    }

    public String getContentType() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException e) {
                this.exception = e;
            }
        }
        return this.type;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        } else if (this.exception != null) {
            throw this.exception;
        }
        if (this.data == null) {
            throw new IOException("resource not found");
        }
        return new ByteArrayInputStream(this.data);
    }
}

