/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;

public class URLConnectionCache {
    private static URLConnectionCache urlCache = new URLConnectionCache();
    private Hashtable cache = new Hashtable();

    public static Entry getEntry(URL url) {
        return urlCache.findEntry(url);
    }

    private URLConnectionCache() {
    }

    private synchronized Entry findEntry(URL url) {
        String urlString = url.toExternalForm();
        Set set = (Set)this.cache.get(urlString);
        Entry entry = null;
        if (set == null) {
            set = new Set(urlString);
            this.cache.put(urlString, set);
        } else {
            entry = set.find(url);
        }
        if (entry == null) {
            entry = new Entry(url);
            set.add(entry);
        }
        return entry;
    }

    private static class Map {
        private String key;
        private String value;
        private Map next;

        private Map(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class Entry {
        private URL url;
        private String proxyHost;
        private int proxyPort;
        private Map requestPropertyTop;
        private Map requestPropertyLast;
        private Entry prev;

        private Entry(URL url) {
            this.url = url;
        }

        public synchronized void setProxy(String host, int port) {
            this.proxyHost = host;
            this.proxyPort = port;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public synchronized URL setupProxy(URL url) {
            if (this.proxyHost == null) {
                return url;
            }
            try {
                return new URL(url.getProtocol(), this.proxyHost, this.proxyPort, url.toExternalForm());
            }
            catch (MalformedURLException e) {
                return url;
            }
        }

        public synchronized void addRequestProperty(String key, String value) {
            if (this.requestPropertyTop == null) {
                this.requestPropertyTop = this.requestPropertyLast = new Map(key, value);
            } else {
                this.requestPropertyLast = this.requestPropertyLast.next = new Map(key, value);
            }
        }

        public synchronized void setupURLConnection(URLConnection connection) {
            Map map = this.requestPropertyTop;
            while (map != null) {
                connection.setRequestProperty(map.key, map.value);
                map = map.next;
            }
        }
    }

    private static class Set {
        private String urlString;
        private Entry top;
        private Entry last;

        private Set(String urlString) {
            this.urlString = urlString;
        }

        private void add(Entry entry) {
            if (this.top == null) {
                this.top = this.last = entry;
            } else {
                entry.prev = this.last;
                this.last = entry;
            }
        }

        private Entry find(URL url) {
            Entry entry = this.last;
            while (entry != null) {
                if (entry.url == url) {
                    return entry;
                }
                entry = entry.prev;
            }
            return null;
        }
    }
}

