/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.java2.bridge;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import net.hizlab.kagetaka.java2.DnDListener;
import net.hizlab.kagetaka.java2.DnDWrapper;
import net.hizlab.kagetaka.java2.bridge.FileFlavorMap;

public class DnDCaller
extends DnDWrapper {
    private static final int ACTION = 0x40000003;
    private static FlavorMap flavorMap = new FileFlavorMap();

    public void addDnDListener(Component c, DnDListener l) {
        new DropTarget(c, 0x40000003, new DropListener(l), true, flavorMap);
    }

    private class DropListener
    implements DropTargetListener {
        private DnDListener listener;

        private DropListener(DnDListener l) {
            this.listener = l;
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (!this.listener.isActive()) {
                dtde.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (!this.listener.isActive()) {
                dtde.rejectDrag();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void dragExit(DropTargetEvent dte) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dtde) {
            String value;
            block26: {
                if (!this.listener.isActive()) {
                    dtde.rejectDrop();
                    return;
                }
                dtde.acceptDrop(1);
                value = null;
                try {
                    List list;
                    Transferable t = dtde.getTransferable();
                    DataFlavor[] fs = t.getTransferDataFlavors();
                    DataFlavor f = null;
                    for (int i = 0; i < fs.length; ++i) {
                        if (fs[i].getHumanPresentableName().compareTo("File Name Wide") != 0) continue;
                        f = fs[i];
                        break;
                    }
                    if (f == null) {
                        f = DataFlavor.selectBestTextFlavor(fs);
                    }
                    if (f == null) {
                        f = t.getTransferDataFlavors()[0];
                    }
                    Object data = null;
                    try {
                        data = t.getTransferData(f);
                    }
                    catch (UnsupportedFlavorException e) {
                        dtde.dropComplete(true);
                        return;
                    }
                    catch (IOException e) {
                        dtde.dropComplete(true);
                        return;
                    }
                    if (data instanceof InputStream || data instanceof Reader) {
                        BufferedReader br = null;
                        if (data instanceof InputStream) {
                            InputStreamReader isr = null;
                            String encoding = f.getParameter("charset");
                            if (encoding != null) {
                                try {
                                    isr = new InputStreamReader((InputStream)data, encoding);
                                }
                                catch (UnsupportedEncodingException e) {
                                    // empty catch block
                                }
                            }
                            if (isr == null) {
                                isr = new InputStreamReader((InputStream)data);
                            }
                            br = new BufferedReader(isr);
                        } else {
                            br = new BufferedReader((Reader)data);
                        }
                        try {
                            int len;
                            char[] buffer = new char[8192];
                            StringBuffer sb = new StringBuffer();
                            while ((len = br.read(buffer, 0, 8192)) != -1) {
                                sb.append(buffer, 0, len);
                            }
                            br.close();
                            value = sb.toString();
                        }
                        catch (IOException e) {
                            System.out.println(e);
                            e.printStackTrace(System.out);
                        }
                        break block26;
                    }
                    if (data instanceof String) {
                        value = (String)data;
                    } else if (data instanceof List && (list = (List)data).size() > 0) {
                        value = list.get(0).toString();
                    }
                }
                finally {
                    dtde.dropComplete(true);
                }
            }
            if (value == null) {
                return;
            }
            this.listener.drop(value);
        }
    }
}

