/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EolInputStream
extends FilterInputStream {
    private static final int NO = 0;
    private static final int CR = 1;
    private int last = 0;
    private int crlf = 0;
    private int cr = 0;
    private int lf = 0;

    public EolInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        int b = this.in.read();
        if (b == 13) {
            if (this.last == 1) {
                ++this.cr;
            }
            this.last = 1;
        } else {
            if (b == 10) {
                if (this.last == 1) {
                    ++this.crlf;
                } else {
                    ++this.lf;
                }
            } else if (this.last == 1) {
                ++this.cr;
            }
            this.last = 0;
        }
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int length = this.in.read(b, off, len);
        int end = length + off;
        block4: for (int i = off; i < end; ++i) {
            switch (b[i]) {
                case 13: {
                    if (this.last == 1) {
                        ++this.cr;
                    }
                    this.last = 1;
                    continue block4;
                }
                case 10: {
                    if (this.last == 1) {
                        ++this.crlf;
                    } else {
                        ++this.lf;
                    }
                    this.last = 0;
                    continue block4;
                }
                default: {
                    if (this.last == 1) {
                        ++this.cr;
                    }
                    this.last = 0;
                }
            }
        }
        return length;
    }

    public String getEol() {
        int cr = this.cr;
        if (this.last == 1) {
            ++cr;
        }
        if (this.crlf == 0 && this.lf == 0 && cr == 0) {
            return "\n";
        }
        if (this.crlf >= cr && this.crlf >= this.lf) {
            return "\r\n";
        }
        if (this.lf >= cr && this.lf >= this.crlf) {
            return String.valueOf('\n');
        }
        return String.valueOf('\r');
    }
}

