/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.hizlab.kagetaka.io.CounterListener;

public class CounterInputStream
extends FilterInputStream {
    private CounterListener listener;
    private boolean marked = false;
    private long length = 0L;
    private long temporary = 0L;
    int i;
    long l;

    public CounterInputStream(InputStream is, CounterListener listener) {
        super(is);
        this.listener = listener;
    }

    public int read() throws IOException {
        this.i = super.read();
        if (this.i != -1) {
            this.append(1L);
        }
        return this.i;
    }

    public int read(byte[] b) throws IOException {
        this.i = super.read(b);
        if (this.i > 0) {
            this.append(this.i);
        }
        return this.i;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.i = super.read(b, off, len);
        if (this.i > 0) {
            this.append(this.i);
        }
        return this.i;
    }

    public long skip(long n) throws IOException {
        this.l = super.skip(n);
        if (this.l > 0L) {
            this.append(this.l);
        }
        return this.l;
    }

    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.marked = readlimit > 0;
        this.length += this.temporary;
        this.temporary = 0L;
    }

    public synchronized void reset() throws IOException {
        try {
            super.reset();
        }
        catch (IOException e) {
            this.marked = false;
            this.length += this.temporary;
            this.temporary = 0L;
            throw e;
        }
        if (this.listener != null && this.temporary > 0L) {
            this.listener.changeLength(this.length);
        }
        this.temporary = 0L;
    }

    private void append(long add) {
        if (this.marked) {
            this.temporary += add;
        } else {
            this.length += add;
        }
        if (this.listener != null) {
            this.listener.changeLength(this.temporary + this.length);
        }
    }
}

