/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.bookmarks.Bookmark;
import net.hizlab.kagetaka.bookmarks.BookmarkManager;
import net.hizlab.kagetaka.history.History;
import net.hizlab.kagetaka.history.HistoryManager;
import net.hizlab.kagetaka.option.InvalidValueException;
import net.hizlab.kagetaka.option.Setter;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.viewer.HawkViewer;
import net.hizlab.kagetaka.viewer.HawkWindow;
import net.hizlab.kagetaka.viewer.WindowManager;

public class HistoryEditor
extends Frame
implements HawkWindow {
    private static final String RESOURCE = "net.hizlab.kagetaka.history.Resource";
    private static final int MARGIN = 3;
    private static final int MENU_OPEN = 0;
    private static final int MENU_COPY = 1;
    private static final int MENU_BOOKMARK = 2;
    private static final int MENU_DELETE = 3;
    private static final int MENU_SIZE = 4;
    private Object lock = new Object();
    private ViewerOption option;
    private HistoryManager hm;
    private BookmarkManager bm;
    private WindowManager wm;
    private List list;
    private Label text;
    private Label url;
    private Label first;
    private Label last;
    private Label count;
    private History[] histories;
    private int size;
    private PopupMenu popupMenu;
    private MenuItem[] menuItems;

    HistoryEditor(ViewerOption option) {
        this.option = option;
        this.hm = option.getHistoryManager();
        this.bm = option.getBookmarkManager();
        this.wm = WindowManager.getInstance();
        this.setTitle(this.getMessage("title"));
        this.setResizable(true);
        this.setForeground(SystemColor.textText);
        ((Component)this).setBackground(SystemColor.text);
        ((Component)this).setFont(new Font("Dialog", 0, 12));
        Image image = Resource.getImageResource(RESOURCE, "historyeditor.icon", this.getToolkit());
        if (image != null) {
            this.setIconImage(image);
        }
        GridBagLayout gbl = new GridBagLayout();
        Insets insets = new Insets(3, 3, 3, 3);
        this.setLayout(gbl);
        this.list = new List(10);
        LayoutUtils.addGridBag(this, this.list, gbl, 0, 0, 3, 1, 1.0, 1.0, 1, 10, insets);
        LayoutUtils.addGridBag(this, new Label(this.getMessage("label.detail")), gbl, 0, 1, 1, 5, 0.0, 0.0, 0, 11, insets);
        insets.bottom = 0;
        this.text = new Label();
        LayoutUtils.addGridBag(this, this.text, gbl, 1, 1, 2, 1, 1.0, 0.0, 2, 17, insets);
        insets.top = 0;
        this.url = new Label();
        LayoutUtils.addGridBag(this, this.url, gbl, 1, 2, 2, 1, 1.0, 0.0, 2, 17, insets);
        LayoutUtils.addGridBag(this, new Label(this.getMessage("label.first")), gbl, 1, 3, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.first = new Label();
        LayoutUtils.addGridBag(this, this.first, gbl, 2, 3, 1, 1, 1.0, 0.0, 2, 17, insets);
        LayoutUtils.addGridBag(this, new Label(this.getMessage("label.last")), gbl, 1, 4, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.last = new Label();
        LayoutUtils.addGridBag(this, this.last, gbl, 2, 4, 1, 1, 1.0, 0.0, 2, 17, insets);
        insets.bottom = 3;
        LayoutUtils.addGridBag(this, new Label(this.getMessage("label.count")), gbl, 1, 5, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.count = new Label();
        LayoutUtils.addGridBag(this, this.count, gbl, 2, 5, 1, 1, 1.0, 0.0, 2, 17, insets);
        this.popupMenu = new PopupMenu(this.getMessage("menu"));
        this.menuItems = new MenuItem[4];
        this.createMenuItem(0);
        this.popupMenu.addSeparator();
        this.createMenuItem(1);
        this.createMenuItem(2);
        this.popupMenu.addSeparator();
        this.createMenuItem(3);
        this.add(this.popupMenu);
        KeyAdapter findKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean isCtrl;
                boolean bl = isCtrl = (e.getModifiers() & 2) != 0;
                if (e.getKeyCode() == 87 && isCtrl) {
                    HistoryEditor.this.closeWindow();
                    return;
                }
                if (e.getKeyCode() == 81 && isCtrl) {
                    HistoryEditor.this.wm.exit();
                    return;
                }
            }
        };
        this.addKeyListener(findKeyListener);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                HistoryEditor.this.wm.addWindow(HistoryEditor.this);
            }

            public void windowClosing(WindowEvent e) {
                HistoryEditor.this.closeWindow();
            }

            public void windowClosed(WindowEvent e) {
                HistoryEditor.this.wm.removeWindow(HistoryEditor.this);
                Point position = HistoryEditor.this.getLocation();
                if (position.x >= 0 || position.y >= 0) {
                    Setter setter = HistoryEditor.this.option.getSetter();
                    try {
                        setter.putPropertyPoint("history.window.position", position);
                        setter.putPropertyDimension("history.window.size", HistoryEditor.this.getSize());
                        setter.commit();
                    }
                    catch (InvalidValueException ex) {
                        // empty catch block
                    }
                }
            }
        });
        this.list.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                int index = HistoryEditor.this.list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                HistoryEditor.this.text.setText(HistoryEditor.this.histories[index].getTitle());
                HistoryEditor.this.url.setText(HistoryEditor.this.histories[index].getURLText());
                HistoryEditor.this.first.setText(new Date(HistoryEditor.this.histories[index].getFirstVisit()).toString());
                HistoryEditor.this.last.setText(new Date(HistoryEditor.this.histories[index].getLastVisit()).toString());
                HistoryEditor.this.count.setText(String.valueOf(HistoryEditor.this.histories[index].getVisitCount()));
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    HistoryEditor.this.openHistory();
                    e.consume();
                    return;
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() || (e.getModifiers() & 4) == 4) {
                    Font font = HistoryEditor.this.menuItems[0].getFont();
                    HistoryEditor.this.menuItems[0].setFont(new Font(font.getName(), 1, font.getSize()));
                    HistoryEditor.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    e.consume();
                    return;
                }
                if ((e.getModifiers() & 0x10) == 16 && e.getClickCount() == 2) {
                    HistoryEditor.this.openHistory();
                    e.consume();
                    return;
                }
            }
        });
        this.list.addKeyListener(findKeyListener);
        this.doLayout();
        ((Component)this).setSize(option.getPropertyDimension("history.window.size"));
        Point position = option.getPropertyPoint("history.window.position");
        if (position != null) {
            ((Component)this).setLocation(position);
        } else {
            Dimension size = this.getSize();
            Dimension desktopSize = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((desktopSize.width - size.width) / 2, (desktopSize.height - size.height) / 2);
        }
        this.setForeground(SystemColor.controlText);
        ((Component)this).setBackground(SystemColor.control);
        this.histories = this.hm.getHistories(true);
        this.size = this.histories.length;
        for (int i = 0; i < this.size; ++i) {
            this.list.add(this.histories[i].getTitle());
        }
        this.text.setFont(new Font("Dialog", 1, 12));
    }

    private void createMenuItem(int index) {
        String menuKey = null;
        switch (index) {
            case 0: {
                menuKey = "menu.open";
                break;
            }
            case 1: {
                menuKey = "menu.copy";
                break;
            }
            case 2: {
                menuKey = "menu.bookmark";
                break;
            }
            case 3: {
                menuKey = "menu.delete";
                break;
            }
            default: {
                return;
            }
        }
        MenuItem mi = new MenuItem(this.getMessage(menuKey));
        mi.setEnabled(true);
        mi.addActionListener(new MenuActionListner(index));
        this.menuItems[index] = mi;
        this.popupMenu.add(mi);
    }

    private String getMessage(String key) {
        if (key == null) {
            return "";
        }
        return Resource.getMessage(RESOURCE, "historyeditor." + key, null);
    }

    public void closeWindow() {
        this.dispose();
    }

    public void addWindowMenu(HawkWindow window) {
    }

    public void removeWindowMenu(int index) {
    }

    public void changeWindowMenu(int index, HawkWindow window) {
    }

    public void addToBookmark(Bookmark parent, Bookmark bookmark) {
    }

    public void bookmarkChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openHistory() {
        Object object = this.lock;
        synchronized (object) {
            int index = this.list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            HawkViewer viewer = this.wm.getActiveViewer();
            if (viewer == null) {
                return;
            }
            viewer.open(this.histories[index].getURL());
            if (index != 0) {
                History h = this.histories[index];
                this.list.remove(index);
                this.list.addItem(h.getTitle(), 0);
                this.list.select(index);
                System.arraycopy(this.histories, 0, this.histories, 1, index);
                this.histories[0] = h;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyHistory() {
        Object object = this.lock;
        synchronized (object) {
            int index = this.list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            this.copyClipboard(this.histories[index].getURLText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bookmarkHistory() {
        Object object = this.lock;
        synchronized (object) {
            int index = this.list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            Bookmark parent = this.bm.getRootBookmark();
            Bookmark bookmark = new Bookmark(this.histories[index].getTitle(), this.histories[index].getURLText());
            parent.addBookmark(bookmark);
            this.wm.addToBookmark(parent, bookmark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteHistory() {
        Object object = this.lock;
        synchronized (object) {
            int index = this.list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            --this.size;
            this.list.remove(index);
            this.hm.remove(this.histories[index]);
            if (index < this.size) {
                System.arraycopy(this.histories, index + 1, this.histories, index, this.size - index);
            }
            this.histories[this.size] = null;
            this.text.setText("");
            this.url.setText("");
            this.first.setText("");
            this.last.setText("");
            this.count.setText("");
        }
    }

    private void copyClipboard(String value) {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(value);
        clipboard.setContents(data, data);
    }

    private class MenuActionListner
    implements ActionListener {
        private int index = 0;

        private MenuActionListner(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            switch (this.index) {
                case 0: {
                    HistoryEditor.this.openHistory();
                    break;
                }
                case 1: {
                    HistoryEditor.this.copyHistory();
                    break;
                }
                case 2: {
                    HistoryEditor.this.bookmarkHistory();
                    break;
                }
                case 3: {
                    HistoryEditor.this.deleteHistory();
                }
            }
        }
    }
}

