/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.history;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import net.hizlab.kagetaka.util.StringUtils;

public class History {
    private String title;
    private String url;
    private long firstVisit;
    private long lastVisit;
    private int visitCount;
    History next;
    History prev;

    public History(String url) {
        this.title = "";
        this.url = url;
        this.lastVisit = this.firstVisit = System.currentTimeMillis();
        this.visitCount = 1;
    }

    History(String line, boolean load) throws InvalidObjectException {
        int p1 = 0;
        int length = line.length();
        String[] s = new String[5];
        for (int i = 0; i < 5; ++i) {
            int p2 = line.indexOf(9, p1);
            if (p2 == -1) {
                p2 = length;
            }
            s[i] = line.substring(p1, p2);
            p1 = p2 + 1;
            if (p1 >= length) break;
        }
        try {
            this.title = s[0];
            this.url = s[1];
            this.firstVisit = Long.parseLong(s[2]);
            this.lastVisit = Long.parseLong(s[3]);
            this.visitCount = Integer.parseInt(s[4]);
        }
        catch (NumberFormatException e) {
            throw new InvalidObjectException("invalid format");
        }
        if (this.title == null || this.url == null) {
            throw new InvalidObjectException("invalid format");
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.title = title;
    }

    public URL getURL() {
        URL url = null;
        try {
            url = StringUtils.toURL(this.url);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return url;
    }

    public String getURLText() {
        return this.url;
    }

    public long getFirstVisit() {
        return this.firstVisit;
    }

    public long getLastVisit() {
        return this.lastVisit;
    }

    public int getVisitCount() {
        return this.visitCount;
    }

    void visited() {
        this.lastVisit = System.currentTimeMillis();
        ++this.visitCount;
    }

    void write(Writer w) throws IOException {
        w.write(this.title);
        w.write("\t");
        w.write(this.url);
        w.write("\t");
        w.write(String.valueOf(this.firstVisit));
        w.write("\t");
        w.write(String.valueOf(this.lastVisit));
        w.write("\t");
        w.write(String.valueOf(this.visitCount));
    }

    public String toString() {
        return this.title + ", (" + this.url + "), " + new Date(this.lastVisit) + ", " + this.visitCount;
    }
}

