/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.cookie;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Writer;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.hizlab.kagetaka.Resource;

public class Cookie {
    private static final String RESOURCE = "net.hizlab.kagetaka.cookie.Resource";
    private static final String EXPIRE = "E, dd MMM yyyy HH:mm:ss z";
    private static final SimpleDateFormat[] EXPIRES = new SimpleDateFormat[]{new SimpleDateFormat("E, dd MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("E, dd MMM yy HH:mm z", Locale.US), new SimpleDateFormat("dd MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("dd MMM yy HH:mm z", Locale.US), new SimpleDateFormat("E, dd-MM-yy HH:mm:ss z", Locale.US), new SimpleDateFormat("E, dd-MMM-yy HH:mm:ss z", Locale.US), new SimpleDateFormat("E MMM dd HH:mm:ss yy", Locale.US)};
    private String name;
    private String value;
    private long expires = -1L;
    private String path;
    private String domain;
    private boolean secure;
    private String pathDirectory;
    private boolean isDomain;
    Cookie next;
    Cookie prev;

    public Cookie(String data, URL url, boolean strict) throws ParseException {
        int start = 0;
        int end = 0;
        int length = data.length();
        if (length == 0) {
            throw new ParseException(Resource.getMessage(RESOURCE, "cookie.parse.none", null), 0);
        }
        end = data.indexOf(59);
        String s = end == -1 ? data : data.substring(start, end);
        int p = s.indexOf(61);
        if (p != -1) {
            this.name = s.substring(0, p).trim();
            this.value = s.substring(p + 1).trim();
        } else {
            this.name = s.trim();
        }
        block2: while ((start = end) != -1) {
            while (++start != length) {
                String key;
                char c = data.charAt(start);
                if (c == ' ' || c == ';') continue;
                end = data.indexOf(59, start);
                s = end == -1 ? data.substring(start) : data.substring(start, end);
                boolean unknown = false;
                p = s.indexOf(61);
                if (p == -1) {
                    key = s;
                    if (key.trim().toLowerCase().compareTo("secure") == 0) {
                        if (!this.secure) {
                            this.secure = true;
                            continue block2;
                        }
                    } else {
                        unknown = true;
                    }
                } else {
                    key = s.substring(0, p).trim().toLowerCase();
                    String value = s.substring(p + 1).trim();
                    if (key.compareTo("expires") == 0) {
                        if (this.expires == -1L) {
                            Date date = null;
                            for (int i = 0; i < EXPIRES.length; ++i) {
                                try {
                                    date = EXPIRES[i].parse(value);
                                    break;
                                }
                                catch (ParseException e) {
                                    continue;
                                }
                            }
                            if (date == null) {
                                throw new ParseException(Resource.getMessage(RESOURCE, "cookie.parse.invalidexpires", new String[]{value}), start);
                            }
                            this.expires = date.getTime();
                            continue block2;
                        }
                    } else if (key.compareTo("path") == 0) {
                        if (this.path == null) {
                            this.path = value;
                            if (this.path.length() > 0 && this.path.charAt(this.path.length() - 1) == '/') {
                                this.pathDirectory = this.path;
                                continue block2;
                            }
                            this.pathDirectory = this.path + "/";
                            continue block2;
                        }
                    } else if (key.compareTo("domain") == 0) {
                        if (this.domain == null) {
                            p = value.lastIndexOf(46);
                            if (p != -1) {
                                int need = 2;
                                int count = 0;
                                for (int i = value.length() - 1; i >= 0; --i) {
                                    if (value.charAt(i) != '.') continue;
                                    ++count;
                                }
                                if (count >= need) {
                                    this.domain = value;
                                    this.isDomain = this.domain.charAt(0) == '.';
                                    continue block2;
                                }
                            }
                            if (!strict) continue block2;
                            throw new ParseException(Resource.getMessage(RESOURCE, "cookie.parse.invaliddomain", new String[]{value}), start);
                        }
                    } else {
                        unknown = true;
                    }
                }
                if (!strict) continue block2;
                throw new ParseException(Resource.getMessage(RESOURCE, unknown ? "cookie.parse.unknownoption" : "cookie.parse.duplicate", new String[]{key}), 0);
            }
            break block2;
        }
        if (this.domain != null && !this.isTargetHost(url.getHost())) {
            throw new ParseException(Resource.getMessage(RESOURCE, "cookie.parse.outofdomain", new String[]{url.getHost(), this.domain}), start);
        }
        if (this.path == null || this.path.length() == 0) {
            this.path = "/";
            this.pathDirectory = "/";
        }
        if (this.domain == null || this.domain.length() == 0) {
            this.domain = url.getHost();
        }
    }

    Cookie(String line) throws InvalidObjectException {
        int p1 = 0;
        int length = line.length();
        String[] s = new String[7];
        for (int i = 0; i < 7; ++i) {
            int p2 = line.indexOf(9, p1);
            if (p2 == -1) {
                p2 = length;
            }
            s[i] = line.substring(p1, p2);
            p1 = p2 + 1;
            if (p1 >= length) break;
        }
        if (s[5] == null) {
            throw new InvalidObjectException("invalid format");
        }
        try {
            this.name = s[5];
            this.value = s[6] != null && s[6].length() > 0 ? s[6] : null;
            this.expires = Long.parseLong(s[4]) * 1000L;
            this.path = s[2];
            this.domain = s[0];
            this.secure = Boolean.valueOf(s[3]);
            this.pathDirectory = this.path.length() > 0 && this.path.charAt(this.path.length() - 1) == '/' ? this.path : this.path + "/";
            this.isDomain = Boolean.valueOf(s[1]);
        }
        catch (NumberFormatException e) {
            throw new InvalidObjectException("invalid format");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getFullValue() {
        if (this.value == null) {
            return this.name;
        }
        return this.name + "=" + this.value;
    }

    public long getExpires() {
        return this.expires;
    }

    public String getPath() {
        return this.path;
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isTargetHost(String host) {
        if (this.isDomain) {
            return host.endsWith(this.domain);
        }
        return host.compareTo(this.domain) == 0;
    }

    public boolean isTargetPath(String path) {
        if (this.path.compareTo(path) == 0) {
            return true;
        }
        return path.startsWith(this.pathDirectory);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append('[');
        sb.append(this.name);
        if (this.value != null) {
            sb.append('=');
            sb.append(this.value);
        }
        if (this.expires != -1L) {
            SimpleDateFormat sdf = new SimpleDateFormat(EXPIRE, Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            sb.append("; expires=");
            sb.append(sdf.format(new Date(this.expires)));
        }
        sb.append("; path=");
        sb.append(this.path);
        sb.append("; domain=");
        sb.append(this.domain);
        if (this.secure) {
            sb.append("; secure");
        }
        sb.append(']');
        return sb.toString();
    }

    void write(Writer w) throws IOException {
        w.write(this.domain);
        w.write("\t");
        w.write(this.isDomain ? "TRUE" : "FALSE");
        w.write("\t");
        w.write(this.path);
        w.write("\t");
        w.write(this.secure ? "TRUE" : "FALSE");
        w.write("\t");
        w.write(String.valueOf(this.expires / 1000L));
        w.write("\t");
        w.write(this.name);
        w.write("\t");
        if (this.value != null) {
            w.write(this.value);
        }
    }
}

