/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.build;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import net.fclabs.util.Queue;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.build.CacheReporter;
import net.hizlab.kagetaka.build.InputStreamParser;
import net.hizlab.kagetaka.build.ParseException;
import net.hizlab.kagetaka.build.Tag;
import net.hizlab.kagetaka.build.TagReader;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.MetaAttribute;
import net.hizlab.kagetaka.token.MiscToken;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TextToken;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenManager;
import net.hizlab.kagetaka.token.TokenTypes;
import net.hizlab.kagetaka.util.Charset;
import net.hizlab.kagetaka.util.ContentType;

public class TagParser
implements InputStreamParser {
    private static final int INPUT_BUFFER = 8192;
    private Document document = null;
    private InputStream is = null;
    private BufferedInputStream bis = null;
    private TagReader tagReader = null;
    private String encoding = null;
    private Reporter reporter = null;
    private CacheReporter cacheReporter = null;
    private String lastElementName = "html";
    private boolean commitEncoding = false;
    private Queue tokenQueue = null;

    public void setInputStream(Document document, InputStream is, Reporter reporter) {
        if (this.is != null) {
            throw new RuntimeException("Already set InputStream");
        }
        this.document = document;
        this.is = is;
        this.encoding = document.getEncoding();
        this.reporter = reporter;
        BufferedReader br = null;
        if (this.encoding != null && (br = this.createBufferedReader(is, this.encoding)) != null) {
            this.commitEncoding = true;
        } else {
            this.bis = new BufferedInputStream(is, 8192);
            this.bis.mark(32768);
            br = this.createBufferedReader(this.bis, Charset.getDefaultEncoding());
            this.tokenQueue = new Queue(20);
            this.cacheReporter = new CacheReporter(reporter);
            this.reporter = this.cacheReporter;
        }
        this.tagReader = new TagReader(br, reporter);
    }

    private BufferedReader createBufferedReader(InputStream is, String encoding) {
        if (encoding != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding), 8192);
                this.document.setEncoding(encoding);
                return br;
            }
            catch (UnsupportedEncodingException e) {
                this.addWarning("charset.warning.invalid", new String[]{encoding}, null);
                return null;
            }
        }
        return new BufferedReader(new InputStreamReader(is), 8192);
    }

    public String getParserName() {
        return Resource.getMessage("tagparser.name", null);
    }

    public String getParserDescription() {
        return Resource.getMessage("tagparser.description", null);
    }

    public synchronized Token next() throws ParseException, IOException {
        if (this.is == null) {
            throw new RuntimeException("No InputStream yet");
        }
        Tag tag = null;
        Token token = null;
        if (this.commitEncoding && this.tokenQueue != null) {
            token = (Token)this.tokenQueue.get();
            if (token != null) {
                return token;
            }
            this.tokenQueue = null;
        }
        block4: while (true) {
            if ((tag = this.tagReader.readTag()) == null) {
                if (!this.commitEncoding) {
                    this.commitEncoding = true;
                }
                if (this.tokenQueue != null) {
                    return (Token)this.tokenQueue.get();
                }
                return null;
            }
            switch (tag.getType()) {
                case 1: {
                    if (tag.getElement() == null) {
                        tag.setElement(this.lastElementName);
                    } else {
                        this.lastElementName = tag.getElement();
                    }
                    if (!tag.isEndTag()) {
                        token = this.createStartToken(tag);
                        break;
                    }
                    token = this.createEndToken(tag);
                    break;
                }
                case 2: {
                    token = this.createTextToken(tag);
                    break;
                }
                default: {
                    if (!this.commitEncoding && tag.getType() == 5 && tag.getElement() != null && tag.getElement().compareTo("xml") == 0 && tag.getAttribute() != null) {
                        this.resetEncoding((String)tag.getAttribute().get("encoding"), tag);
                        continue block4;
                    }
                    token = this.createMiscToken(tag);
                }
            }
            if (token == null) continue;
            int type = token.getType();
            int mode = TokenTypes.isContent(type);
            if (mode != 0) {
                String name = token.getName();
                String content = this.tagReader.readContent(name, mode == 2);
                ((StartToken)token).setContent(content);
            }
            if (this.commitEncoding) {
                return token;
            }
            this.tokenQueue.put(token);
            if (type == 2019) {
                this.checkCharSet(token, tag);
                continue;
            }
            if (type != 2002 && !TokenTypes.isBody(type)) continue;
            this.cacheReporter.restart(false);
            this.cacheReporter = null;
            this.commitEncoding = true;
            token = (Token)this.tokenQueue.get();
            if (token != null) break;
        }
        return token;
    }

    private Token createStartToken(Tag tag) throws ParseException {
        String fieldName = tag.getElement().toUpperCase() + "_START";
        int tokenType = TokenTypes.getType(fieldName);
        if (tokenType == -1) {
            this.addWarning("tagparser.warning.tag.unknownstart", new String[]{tag.getElement()}, tag);
            return null;
        }
        StartToken token = TokenManager.createStartToken(this.document, this.reporter, tag.getLineNumber(), tag.getColumnNumber(), tokenType, false);
        if (token == null) {
            return null;
        }
        token.initAttribute(tag.getAttribute());
        if (TokenTypes.isEmpty(tokenType) && !tag.isEmpty()) {
            this.reporter.report(3, Resource.getMessage("tagparser.warning.tag.notempty", new String[]{this.lastElementName}), tag.getLineNumber(), tag.getColumnNumber());
        }
        return token;
    }

    private Token createEndToken(Tag tag) throws ParseException {
        String fieldName = tag.getElement().toUpperCase() + "_END";
        int tokenType = TokenTypes.getType(fieldName);
        if (tokenType == -1) {
            fieldName = tag.getElement().toUpperCase() + "_START";
            tokenType = TokenTypes.getType(fieldName);
            if (tokenType != -1) {
                this.addWarning("tagparser.warning.tag.notend", new String[]{tag.getElement()}, tag);
                return null;
            }
            this.addWarning("tagparser.warning.tag.unknownend", new String[]{tag.getElement()}, tag);
            return null;
        }
        return TokenManager.createEndToken(this.document, this.reporter, tag.getLineNumber(), tag.getColumnNumber(), tokenType, false);
    }

    private Token createTextToken(Tag tag) throws ParseException {
        return new TextToken(this.document, this.reporter, tag.getLineNumber(), tag.getColumnNumber(), tag.getText());
    }

    private Token createMiscToken(Tag tag) throws ParseException {
        int type = -1;
        switch (tag.getType()) {
            case 3: {
                type = 3;
                break;
            }
            case 4: {
                type = 4;
                break;
            }
            case 5: {
                type = 5;
                break;
            }
            case 0: {
                type = 0;
            }
        }
        return new MiscToken(this.document, this.reporter, tag.getLineNumber(), tag.getColumnNumber(), tag.getInnerText(), type);
    }

    private void checkCharSet(Token token, Tag tag) throws IOException {
        if (token.getType() != 2019) {
            return;
        }
        MetaAttribute meta = (MetaAttribute)((StartToken)token).getAttribute();
        if (meta == null) {
            return;
        }
        String httpEquiv = meta.getHttpEquiv();
        if (httpEquiv == null || httpEquiv.toLowerCase().compareTo("content-type") != 0) {
            return;
        }
        String content = meta.getContent();
        if (content == null) {
            return;
        }
        String charset = null;
        try {
            charset = new ContentType(content).getParameter("charset");
        }
        catch (java.text.ParseException e) {
            // empty catch block
        }
        if (charset == null) {
            return;
        }
        this.resetEncoding(charset, tag);
    }

    private void resetEncoding(String charset, Tag tag) throws IOException {
        if (charset == null) {
            return;
        }
        String encoding = Charset.toEncoding(charset);
        if (encoding == null) {
            this.addWarning("charset.warning.invalid", new String[]{charset}, null);
            return;
        }
        try {
            this.bis.reset();
            this.tagReader = new TagReader(this.createBufferedReader(this.bis, encoding), this.reporter);
        }
        catch (IOException e) {
            this.addWarning("charset.warning.reset", new String[]{charset}, tag);
        }
        this.tokenQueue.clear();
        this.tokenQueue = null;
        this.cacheReporter.restart(true);
        this.cacheReporter = null;
        this.encoding = encoding;
        this.commitEncoding = true;
        this.reporter.report(3, Resource.getMessage("charset.info.encoding", new String[]{encoding}), tag.getLineNumber(), tag.getColumnNumber());
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() {
        try {
            if (this.bis != null) {
                ((FilterInputStream)this.bis).close();
            }
        }
        catch (IOException e) {
            this.addWarning("tagparser.warning.stream.close", new String[]{e.toString()}, null);
        }
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException e) {
            this.addWarning("tagparser.warning.stream.close", new String[]{e.toString()}, null);
        }
    }

    private void addWarning(String key, String[] args, Tag tag) {
        this.reporter.report(7, Resource.getMessage(key, args), tag != null ? tag.getLineNumber() : 0, tag != null ? tag.getColumnNumber() : 0);
    }
}

