/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.bookmarks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import net.hizlab.kagetaka.bookmarks.Bookmark;
import net.hizlab.kagetaka.bookmarks.BookmarkEditor;
import net.hizlab.kagetaka.build.ParseException;
import net.hizlab.kagetaka.build.Tag;
import net.hizlab.kagetaka.build.TagReader;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.util.Charset;
import net.hizlab.kagetaka.util.ContentType;
import net.hizlab.kagetaka.util.TextFormat;

public class BookmarkManager {
    private static final String ROOT_NAME = "/";
    private static final int LF = 10;
    private ViewerOption option;
    private BookmarkEditor editor;
    private Bookmark rootFolder = new Bookmark("/");
    private boolean commitEncoding;
    private String encoding;
    private String charset;
    private Hashtable shortcuts = new Hashtable();
    private Object ptFolderLock = new Object();
    private Bookmark ptFolder;

    public BookmarkManager(ViewerOption option) {
        this.option = option;
        this.load(option.getPropertyFile("bookmarks.path"));
    }

    private synchronized void load(File file) {
        this.commitEncoding = false;
        TagReader reader = null;
        try {
            block8: while (true) {
                Tag tag;
                Bookmark parent;
                String text = null;
                String element = null;
                boolean level = false;
                Bookmark bookmark = parent = this.rootFolder;
                Vector bookmarks = this.rootFolder.getBookmarks();
                Stack<Bookmark> stack = new Stack<Bookmark>();
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                bookmarks.removeAllElements();
                reader = this.createTagReader(file);
                while ((tag = reader.readTag()) != null) {
                    if (tag.getType() != 1 || (element = tag.getElement()) == null) continue;
                    if (element.compareTo("META") == 0 && !this.commitEncoding && this.checkCharset(tag)) {
                        reader.close();
                        continue block8;
                    }
                    if (element.compareTo("DL") == 0) {
                        if (!tag.isEndTag()) {
                            if (bookmark == null || bookmark.getType() != 1) break block8;
                            stack.push(parent);
                            parent = bookmark;
                        } else {
                            parent = (Bookmark)stack.pop();
                        }
                        bookmarks = parent.getBookmarks();
                        bookmark = null;
                        continue;
                    }
                    if (element.compareTo("HR") == 0) {
                        if (bookmarks == null) continue;
                        bookmark = new Bookmark();
                        bookmark.parent = parent;
                        bookmarks.addElement(bookmark);
                        continue;
                    }
                    if (element.compareTo("DT") != 0) continue;
                    Tag target = reader.readTag();
                    if (target == null || (tag = reader.readTag()) == null) break block8;
                    text = TextFormat.convertXhtml(tag.getText(), true, true, true, true);
                    tag = reader.readTag();
                    if (tag == null || !tag.isEndTag()) break block8;
                    bookmark = new Bookmark(text, target);
                    bookmark.parent = parent;
                    bookmarks.addElement(bookmark);
                    if (bookmark.getShortcutURL() != null) {
                        this.shortcuts.put(bookmark.getShortcutURL(), bookmark);
                    }
                    if (!bookmark.getPersonalToolbarFolder() || this.ptFolder != null) continue;
                    this.ptFolder = bookmark;
                }
                break;
            }
            this.commitEncoding = true;
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (ParseException e) {
            System.out.println(e);
            e.printStackTrace(System.out);
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace(System.out);
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void save() {
        File file = this.option.getPropertyFile("bookmarks.path");
        BufferedWriter bw = null;
        try {
            if (!this.commitEncoding) {
                this.charset = "UTF-8";
                this.encoding = Charset.toEncoding("UTF-8");
            }
            while (true) {
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    OutputStreamWriter osw = this.encoding != null ? new OutputStreamWriter((OutputStream)fos, this.encoding) : new OutputStreamWriter(fos);
                    bw = new BufferedWriter(osw);
                    String charset = this.charset != null ? "; charset=" + this.charset : "";
                    bw.write("<!DOCTYPE NETSCAPE-Bookmark-file-1>");
                    bw.write(10);
                    bw.write("<!-- This is an automatically generated file.");
                    bw.write(10);
                    bw.write("It will be read and overwritten.");
                    bw.write(10);
                    bw.write("Do Not Edit! -->");
                    bw.write(10);
                    bw.write("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html" + charset + "\">");
                    bw.write(10);
                    bw.write("<TITLE>Bookmarks</TITLE>");
                    bw.write(10);
                    bw.write("<H1>Bookmarks</H1>");
                    bw.write(10);
                    bw.write(10);
                    bw.write("<DL><p>");
                    bw.write(10);
                    Vector bookmarks = this.getBookmarks();
                    if (bookmarks != null) {
                        for (int i = 0; i < bookmarks.size(); ++i) {
                            ((Bookmark)bookmarks.elementAt(i)).write(bw, 1);
                        }
                    }
                    bw.write("</DL><p>");
                    bw.write(10);
                    bw.flush();
                }
                catch (CharConversionException e) {
                    if (this.commitEncoding) {
                        throw e;
                    }
                    this.commitEncoding = true;
                    this.encoding = null;
                    this.charset = null;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace(System.out);
        }
        if (bw != null) {
            try {
                bw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Bookmark getRootBookmark() {
        return this.rootFolder;
    }

    public Vector getBookmarks() {
        if (this.rootFolder == null) {
            return null;
        }
        return this.rootFolder.getBookmarks();
    }

    public synchronized void showEditor() {
        if (this.editor == null || !this.editor.isVisible()) {
            this.editor = new BookmarkEditor(this.option);
        }
        this.editor.show();
    }

    public String resolveShortcut(String shortcut) {
        Bookmark bookmark;
        if (shortcut == null || shortcut.length() == 0) {
            return null;
        }
        if (shortcut.indexOf(58) != -1) {
            return null;
        }
        int p = shortcut.indexOf(32);
        if (p == -1) {
            p = shortcut.indexOf(12288);
        }
        String key = shortcut;
        String option = null;
        if (p != -1) {
            key = shortcut.substring(0, p).trim();
            option = shortcut.substring(p + 1).trim();
        }
        if ((bookmark = (Bookmark)this.shortcuts.get(key)) == null) {
            return null;
        }
        if (!this.checkInTree(bookmark)) {
            return null;
        }
        String url = bookmark.getURLText();
        if (option != null && option.length() > 0) {
            option = URLEncoder.encode(option);
            p = url.lastIndexOf("%s");
            url = p != 0 ? url.substring(0, p) + option + url.substring(p + 2) : url + option;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark getPersonalToolbarFolder() {
        Object object = this.ptFolderLock;
        synchronized (object) {
            if (this.ptFolder == null) {
                return null;
            }
            if (!this.checkInTree(this.ptFolder)) {
                this.ptFolder = null;
            }
            return this.ptFolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPersonalToolbarFolder(Bookmark bookmark) {
        if (bookmark.getType() != 1) {
            throw new IllegalArgumentException("not folder");
        }
        if (!this.checkInTree(bookmark)) {
            throw new IllegalArgumentException("invalid bookmark");
        }
        Object object = this.ptFolderLock;
        synchronized (object) {
            if (this.ptFolder != null) {
                this.ptFolder.setPersonalToolbarFolder(false);
            }
            this.ptFolder = bookmark;
            this.ptFolder.setPersonalToolbarFolder(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean changeShortcut(String oldShortcut, String newShortcut, Bookmark bookmark) {
        if (!(oldShortcut != null && oldShortcut.length() != 0 || newShortcut != null && newShortcut.length() != 0)) {
            return true;
        }
        if (oldShortcut != null && newShortcut != null && oldShortcut.compareTo(newShortcut) == 0) {
            return true;
        }
        if (newShortcut == null || newShortcut.length() == 0) {
            this.shortcuts.remove(oldShortcut);
            return true;
        }
        Hashtable hashtable = this.shortcuts;
        synchronized (hashtable) {
            if (this.shortcuts.containsKey(newShortcut)) {
                return false;
            }
            if (oldShortcut != null) {
                this.shortcuts.remove(oldShortcut);
            }
            this.shortcuts.put(newShortcut, bookmark);
        }
        return true;
    }

    private TagReader createTagReader(File file) throws IOException {
        for (int i = 0; i < 2; ++i) {
            try {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = this.encoding != null ? new InputStreamReader((InputStream)fis, this.encoding) : new InputStreamReader(fis);
                return new TagReader(new BufferedReader(isr), null);
            }
            catch (UnsupportedEncodingException e) {
                this.encoding = null;
                continue;
            }
        }
        throw new IOException("Can not open `" + file + "'");
    }

    private boolean checkCharset(Tag tag) {
        Hashtable param = tag.getAttribute();
        String s = (String)param.get("HTTP-EQUIV");
        if (s == null) {
            return false;
        }
        if (s.toLowerCase().compareTo("content-type") != 0) {
            return false;
        }
        s = (String)param.get("CONTENT");
        if (s == null) {
            return false;
        }
        String charset = null;
        try {
            charset = new ContentType(s).getParameter("charset");
        }
        catch (java.text.ParseException e) {
            // empty catch block
        }
        if (charset == null) {
            return false;
        }
        this.commitEncoding = true;
        if (this.charset != null && this.charset.compareTo(charset) == 0) {
            return false;
        }
        this.charset = charset;
        String encoding = Charset.toEncoding(charset);
        if (encoding == null) {
            return false;
        }
        if (this.encoding != null && this.encoding.compareTo(encoding) == 0) {
            return false;
        }
        this.encoding = encoding;
        return true;
    }

    private boolean checkInTree(Bookmark bookmark) {
        Bookmark parent = bookmark.parent;
        while (parent != this.rootFolder) {
            if (parent == null) {
                return false;
            }
            parent = parent.parent;
        }
        return true;
    }
}

