/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.bookmarks;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Stack;
import java.util.Vector;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.InputBox;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.Tree;
import net.hizlab.kagetaka.awt.TreeItem;
import net.hizlab.kagetaka.bookmarks.Bookmark;
import net.hizlab.kagetaka.bookmarks.BookmarkManager;
import net.hizlab.kagetaka.bookmarks.Detail;
import net.hizlab.kagetaka.option.InvalidValueException;
import net.hizlab.kagetaka.option.Setter;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.theme.Theme;
import net.hizlab.kagetaka.viewer.HawkViewer;
import net.hizlab.kagetaka.viewer.HawkWindow;
import net.hizlab.kagetaka.viewer.WindowManager;

public class BookmarkEditor
extends Frame
implements HawkWindow {
    private static final String RESOURCE = "net.hizlab.kagetaka.bookmarks.Resource";
    private static final int MARGIN = 3;
    private static final int MENU_OPEN = 0;
    private static final int MENU_NEWBOOKMARK = 1;
    private static final int MENU_NEWFOLDER = 2;
    private static final int MENU_NEWSEPARATOR = 3;
    private static final int MENU_CUT = 4;
    private static final int MENU_COPY = 5;
    private static final int MENU_PASTE = 6;
    private static final int MENU_DELETE = 7;
    private static final int MENU_PTF = 8;
    private static final int MENU_PROPERTY = 9;
    private static final int MENU_SIZE = 10;
    private Object lock = new Object();
    private ViewerOption option;
    private BookmarkManager bm;
    private WindowManager wm;
    private TextField search;
    private Tree tree;
    private Button up;
    private Button down;
    private Label text;
    private Label url;
    private Item root;
    private Vector entries;
    private Bookmark buffer;
    private PopupMenu popupMenu;
    private MenuItem[] menuItems;
    private boolean changed;
    private Image fileImage;
    private Image openfolderImage;
    private Image closefolderImage;

    BookmarkEditor(ViewerOption option) {
        this.option = option;
        this.bm = option.getBookmarkManager();
        this.wm = WindowManager.getInstance();
        this.setTitle(this.getMessage("title"));
        this.setResizable(true);
        this.setForeground(SystemColor.textText);
        ((Component)this).setBackground(SystemColor.text);
        ((Component)this).setFont(new Font("Dialog", 0, 12));
        Image image = Resource.getImageResource(RESOURCE, "bookmarkeditor.icon", this.getToolkit());
        if (image != null) {
            this.setIconImage(image);
        }
        GridBagLayout gbl = new GridBagLayout();
        Insets insets = new Insets(3, 3, 3, 3);
        this.setLayout(gbl);
        LayoutUtils.addGridBag(this, new Label(this.getMessage("label.search")), gbl, 0, 0, 1, 1, 0.0, 0.0, 2, 17, insets);
        this.search = new TextField();
        LayoutUtils.addGridBag(this, this.search, gbl, 1, 0, 2, 1, 1.0, 0.0, 2, 17, insets);
        this.tree = new Tree(10, 20);
        LayoutUtils.addGridBag(this, this.tree, gbl, 0, 1, 3, 1, 1.0, 1.0, 1, 10, insets);
        this.up = new Button(this.getMessage("label.up"));
        LayoutUtils.addGridBag(this, this.up, gbl, 0, 2, 1, 1, 0.0, 0.0, 2, 18, insets);
        LayoutUtils.addGridBag(this, new Label(this.getMessage("label.detail")), gbl, 1, 2, 1, 2, 0.0, 0.0, 0, 11, insets);
        this.text = new Label();
        LayoutUtils.addGridBag(this, this.text, gbl, 2, 2, 1, 1, 1.0, 0.0, 2, 17, insets);
        this.down = new Button(this.getMessage("label.down"));
        LayoutUtils.addGridBag(this, this.down, gbl, 0, 3, 1, 1, 0.0, 0.0, 2, 18, insets);
        this.url = new Label();
        LayoutUtils.addGridBag(this, this.url, gbl, 2, 3, 1, 1, 1.0, 0.0, 2, 17, insets);
        this.popupMenu = new PopupMenu(this.getMessage("menu"));
        this.menuItems = new MenuItem[10];
        this.createMenuItem(0, false);
        this.popupMenu.addSeparator();
        this.createMenuItem(1, true);
        this.createMenuItem(2, true);
        this.createMenuItem(3, true);
        this.popupMenu.addSeparator();
        this.createMenuItem(4, false);
        this.createMenuItem(5, false);
        this.createMenuItem(6, false);
        this.createMenuItem(7, false);
        this.popupMenu.addSeparator();
        this.createMenuItem(8, false);
        this.popupMenu.addSeparator();
        this.createMenuItem(9, false);
        this.add(this.popupMenu);
        KeyAdapter findKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean isCtrl;
                boolean isShift = (e.getModifiers() & 1) != 0;
                boolean bl = isCtrl = (e.getModifiers() & 2) != 0;
                if (e.getKeyCode() == 114 && !isShift) {
                    BookmarkEditor.this.searchBookmark(false);
                    e.consume();
                    return;
                }
                if (e.getKeyCode() == 114 && isShift) {
                    BookmarkEditor.this.searchBookmark(true);
                    e.consume();
                    return;
                }
                if (e.getKeyCode() == 70 && isCtrl) {
                    BookmarkEditor.this.search.requestFocus();
                    return;
                }
                if (e.getKeyCode() == 87 && isCtrl) {
                    BookmarkEditor.this.closeWindow();
                    return;
                }
                if (e.getKeyCode() == 81 && isCtrl) {
                    BookmarkEditor.this.wm.exit();
                    return;
                }
            }
        };
        this.addKeyListener(findKeyListener);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                BookmarkEditor.this.wm.addWindow(BookmarkEditor.this);
            }

            public void windowClosing(WindowEvent e) {
                BookmarkEditor.this.closeWindow();
            }

            public void windowClosed(WindowEvent e) {
                BookmarkEditor.this.wm.removeWindow(BookmarkEditor.this);
                Point position = BookmarkEditor.this.getLocation();
                if (position.x >= 0 || position.y >= 0) {
                    Setter setter = BookmarkEditor.this.option.getSetter();
                    try {
                        setter.putPropertyPoint("bookmarks.window.position", position);
                        setter.putPropertyDimension("bookmarks.window.size", BookmarkEditor.this.getSize());
                        setter.commit();
                    }
                    catch (InvalidValueException ex) {
                        // empty catch block
                    }
                }
                if (!BookmarkEditor.this.changed) {
                    return;
                }
                BookmarkEditor.this.wm.bookmarkChanged();
                BookmarkEditor.this.bm.save();
            }
        });
        this.search.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    BookmarkEditor.this.searchBookmark(false);
                    e.consume();
                    return;
                }
            }
        });
        this.tree.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                int index = BookmarkEditor.this.tree.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                BookmarkEditor.this.up.setEnabled(index != 0);
                BookmarkEditor.this.down.setEnabled(index + 1 < BookmarkEditor.this.tree.getViewItemCount());
                Item item = (Item)BookmarkEditor.this.tree.getSelectedTreeItem();
                if (item == null) {
                    return;
                }
                if (item.type == 2) {
                    BookmarkEditor.this.text.setText(item.bookmark.getText());
                    BookmarkEditor.this.url.setText(item.bookmark.getURLText());
                } else {
                    BookmarkEditor.this.text.setText("");
                    BookmarkEditor.this.url.setText("");
                }
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean isAlt;
                boolean bl = isAlt = (e.getModifiers() & 8) != 0;
                if (e.getKeyCode() == 10 && isAlt) {
                    BookmarkEditor.this.showProperty();
                    e.consume();
                    return;
                }
                if ((e.getModifiers() & 2) != 0) {
                    switch (e.getKeyCode()) {
                        case 68: {
                            BookmarkEditor.this.deleteBookmark();
                            e.consume();
                            return;
                        }
                        case 88: {
                            BookmarkEditor.this.cutBookmark();
                            e.consume();
                            return;
                        }
                        case 67: {
                            BookmarkEditor.this.copyBookmark();
                            e.consume();
                            return;
                        }
                        case 86: {
                            BookmarkEditor.this.pasteBookmark();
                            e.consume();
                            return;
                        }
                    }
                }
                switch (e.getKeyCode()) {
                    case 10: {
                        BookmarkEditor.this.openBookmark();
                        e.consume();
                        return;
                    }
                    case 127: {
                        BookmarkEditor.this.deleteBookmark();
                        e.consume();
                        return;
                    }
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() || (e.getModifiers() & 4) == 4) {
                    Item item = (Item)BookmarkEditor.this.tree.getSelectedTreeItem();
                    if (item != null) {
                        BookmarkEditor.this.menuItems[0].setEnabled(item.type == 2);
                        BookmarkEditor.this.menuItems[4].setEnabled(true);
                        BookmarkEditor.this.menuItems[5].setEnabled(true);
                        BookmarkEditor.this.menuItems[7].setEnabled(true);
                        BookmarkEditor.this.menuItems[8].setEnabled(!item.bookmark.getPersonalToolbarFolder() && item.type == 1);
                        BookmarkEditor.this.menuItems[9].setEnabled(item.type != 3);
                    }
                    BookmarkEditor.this.menuItems[6].setEnabled(BookmarkEditor.this.buffer != null);
                    Font font = BookmarkEditor.this.menuItems[0].getFont();
                    BookmarkEditor.this.menuItems[0].setFont(new Font(font.getName(), 1, font.getSize()));
                    BookmarkEditor.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    e.consume();
                    return;
                }
                if ((e.getModifiers() & 0x10) == 16 && e.getClickCount() == 2) {
                    BookmarkEditor.this.openBookmark();
                    e.consume();
                    return;
                }
            }
        });
        this.up.addMouseListener(new MouseAdapter(){
            private boolean pressed;

            public void mousePressed(MouseEvent e) {
                if (BookmarkEditor.this.checkInnerComponent(e)) {
                    this.pressed = true;
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (this.pressed && BookmarkEditor.this.checkInnerComponent(e)) {
                    BookmarkEditor.this.moveUp();
                }
                this.pressed = false;
            }
        });
        this.up.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ' ') {
                    BookmarkEditor.this.moveUp();
                }
            }
        });
        this.down.addMouseListener(new MouseAdapter(){
            private boolean pressed;

            public void mousePressed(MouseEvent e) {
                if (BookmarkEditor.this.checkInnerComponent(e)) {
                    this.pressed = true;
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (this.pressed && BookmarkEditor.this.checkInnerComponent(e)) {
                    BookmarkEditor.this.moveDown();
                }
                this.pressed = false;
            }
        });
        this.down.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ' ') {
                    BookmarkEditor.this.moveDown();
                }
            }
        });
        this.search.addKeyListener(findKeyListener);
        this.tree.addKeyListener(findKeyListener);
        this.up.addKeyListener(findKeyListener);
        this.down.addKeyListener(findKeyListener);
        this.doLayout();
        ((Component)this).setSize(option.getPropertyDimension("bookmarks.window.size"));
        Point position = option.getPropertyPoint("bookmarks.window.position");
        if (position != null) {
            ((Component)this).setLocation(position);
        } else {
            Dimension size = this.getSize();
            Dimension desktopSize = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((desktopSize.width - size.width) / 2, (desktopSize.height - size.height) / 2);
        }
        Theme theme = option.getThemeManager().getTheme();
        this.fileImage = theme.getImage("bookmark.file", this.getToolkit());
        this.openfolderImage = theme.getImage("bookmark.openfolder", this.getToolkit());
        this.closefolderImage = theme.getImage("bookmark.closefolder", this.getToolkit());
        this.setForeground(SystemColor.controlText);
        ((Component)this).setBackground(SystemColor.control);
        this.root = new Item(null, this.bm.getRootBookmark());
        this.tree.setRootTreeItem(this.root);
        this.tree.setBackground(SystemColor.window);
        this.text.setFont(new Font("Dialog", 1, 12));
        this.up.setEnabled(false);
        this.down.setEnabled(false);
    }

    private void createMenuItem(int index, boolean enable) {
        String menuKey = null;
        switch (index) {
            case 0: {
                menuKey = "menu.open";
                break;
            }
            case 1: {
                menuKey = "menu.newbookmark";
                break;
            }
            case 2: {
                menuKey = "menu.newfolder";
                break;
            }
            case 3: {
                menuKey = "menu.newseparator";
                break;
            }
            case 4: {
                menuKey = "menu.cut";
                break;
            }
            case 5: {
                menuKey = "menu.copy";
                break;
            }
            case 6: {
                menuKey = "menu.paste";
                break;
            }
            case 7: {
                menuKey = "menu.delete";
                break;
            }
            case 8: {
                menuKey = "menu.ptf";
                break;
            }
            case 9: {
                menuKey = "menu.property";
                break;
            }
            default: {
                return;
            }
        }
        MenuItem mi = new MenuItem(this.getMessage(menuKey));
        mi.setEnabled(enable);
        mi.addActionListener(new MenuActionListener(index));
        this.menuItems[index] = mi;
        this.popupMenu.add(mi);
    }

    private String getMessage(String key) {
        if (key == null) {
            return "";
        }
        return Resource.getMessage(RESOURCE, "bookmarkeditor." + key, null);
    }

    public void closeWindow() {
        this.dispose();
    }

    public void addWindowMenu(HawkWindow window) {
    }

    public void removeWindowMenu(int index) {
    }

    public void changeWindowMenu(int index, HawkWindow window) {
    }

    public void addToBookmark(Bookmark parent, Bookmark bookmark) {
    }

    public void bookmarkChanged() {
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.paintComponents(g);
    }

    private void searchBookmark(boolean reverse) {
        String search = this.search.getText();
        if (search == null || search.length() == 0) {
            return;
        }
        search = search.toLowerCase();
        Stack<Integer> stack = new Stack<Integer>();
        int pos = -2;
        Item item = (Item)this.tree.getSelectedTreeItem();
        if (item == null) {
            item = this.root;
        } else if (item.type != 1 || reverse) {
            pos = item.getNumber();
            item = item.parent;
        }
        while (true) {
            if (item.search(search, stack, reverse, pos)) {
                while (item.parent != null) {
                    stack.push(new Integer(item.getNumber()));
                    item = item.parent;
                }
                int[] indices = new int[stack.size()];
                int i = 0;
                while (!stack.empty()) {
                    indices[i++] = (Integer)stack.pop();
                }
                this.tree.selectTreeItem(indices);
                return;
            }
            if (item.parent == null) break;
            pos = item.getNumber();
            item = item.parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openBookmark() {
        Object object = this.lock;
        synchronized (object) {
            Item item = (Item)this.tree.getSelectedTreeItem();
            if (item == null || item.type != 2) {
                return;
            }
            HawkViewer viewer = this.wm.getActiveViewer();
            if (viewer == null) {
                return;
            }
            viewer.open(item.bookmark.getURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBookmark() {
        Object object = this.lock;
        synchronized (object) {
            Bookmark bookmark = Detail.show(this, this.bm, null);
            if (bookmark != null) {
                this.addBookmark(bookmark);
            }
        }
        this.tree.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFolder() {
        Object object = this.lock;
        synchronized (object) {
            String name = InputBox.show(this, this.getMessage("newfolder.message"), this.getMessage("newfolder.title"), "");
            if (name == null) {
                return;
            }
            this.addBookmark(new Bookmark(name));
        }
        this.tree.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSeparator() {
        Object object = this.lock;
        synchronized (object) {
            this.addBookmark(new Bookmark());
        }
        this.tree.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cutBookmark() {
        Object object = this.lock;
        synchronized (object) {
            Item item = (Item)this.tree.getSelectedTreeItem();
            if (item == null) {
                return;
            }
            item.removeFromParent();
            this.changed = true;
            this.buffer = item.bookmark;
            if (this.buffer.getType() == 2) {
                this.copyClipboard(this.buffer.getURLText());
            }
        }
        this.tree.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyBookmark() {
        Object object = this.lock;
        synchronized (object) {
            Item item = (Item)this.tree.getSelectedTreeItem();
            if (item == null) {
                return;
            }
            this.buffer = (Bookmark)item.bookmark.clone();
            if (this.buffer.getType() == 2) {
                this.copyClipboard(this.buffer.getURLText());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pasteBookmark() {
        Object object = this.lock;
        synchronized (object) {
            if (this.buffer == null) {
                return;
            }
            this.addBookmark((Bookmark)this.buffer.clone());
        }
        this.tree.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteBookmark() {
        Object object = this.lock;
        synchronized (object) {
            Item item = (Item)this.tree.getSelectedTreeItem();
            if (item == null) {
                return;
            }
            item.removeFromParent();
            this.changed = true;
        }
        this.tree.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changePtf() {
        Object object = this.lock;
        synchronized (object) {
            Item item = (Item)this.tree.getSelectedTreeItem();
            if (item == null) {
                return;
            }
            this.bm.setPersonalToolbarFolder(item.bookmark);
            this.changed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showProperty() {
        Object object = this.lock;
        synchronized (object) {
            Item item = (Item)this.tree.getSelectedTreeItem();
            if (item == null) {
                return;
            }
            switch (item.type) {
                case 2: {
                    Bookmark bookmark = Detail.show(this, this.bm, item.bookmark);
                    if (bookmark == null) {
                        return;
                    }
                    this.text.setText(item.bookmark.getText());
                    this.url.setText(item.bookmark.getURLText());
                    break;
                }
                case 1: {
                    String name = InputBox.show(this, this.getMessage("editfolder.message"), this.getMessage("editfolder.title"), item.bookmark.getText());
                    if (name == null) {
                        return;
                    }
                    item.bookmark.setText(name);
                    break;
                }
                default: {
                    return;
                }
            }
            this.changed = true;
        }
        this.tree.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveUp() {
        Object object = this.lock;
        synchronized (object) {
            int index = this.tree.getSelectedIndex();
            if (index < 1) {
                return;
            }
            Item item1 = (Item)this.tree.getTreeItem(index);
            Item item2 = (Item)this.tree.getTreeItem(index - 1);
            int level1 = this.tree.getTreeItemLevel(index);
            int level2 = this.tree.getTreeItemLevel(index - 1);
            int state2 = this.tree.getTreeItemState(index - 1);
            this.up.setEnabled(index > 1);
            this.down.setEnabled(true);
            item1.removeFromParent();
            if (level1 < level2) {
                item2.addAfter(item1);
            } else if (state2 == 3) {
                item2.addLastChild(item1);
                this.tree.openTreeItem(index - 1);
            } else {
                item2.addBefore(item1);
            }
            this.changed = true;
        }
        this.tree.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveDown() {
        Object object = this.lock;
        synchronized (object) {
            int index = this.tree.getSelectedIndex();
            if (index < 0 || index >= this.tree.getViewItemCount()) {
                return;
            }
            Item item1 = (Item)this.tree.getTreeItem(index);
            Item item2 = (Item)this.tree.getTreeItem(index + 1);
            int level1 = this.tree.getTreeItemLevel(index);
            int level2 = this.tree.getTreeItemLevel(index + 1);
            int state2 = this.tree.getTreeItemState(index + 1);
            this.up.setEnabled(true);
            this.down.setEnabled(item2 != null);
            if (item2 == null && level1 == 1) {
                return;
            }
            item1.removeFromParent();
            if (item2 == null) {
                this.root.addLastChild(item1);
            } else if (level1 > level2) {
                item2.addBefore(item1);
            } else if (state2 == 3) {
                item2.addTopChild(item1);
                this.tree.openTreeItem(index + 1);
            } else if (state2 == 1) {
                item2.addTopChild(item1);
            } else {
                item2.addAfter(item1);
            }
            this.changed = true;
        }
        this.tree.refresh();
    }

    private void addBookmark(Bookmark bookmark) {
        Item item1 = new Item(null, bookmark);
        int index = this.tree.getSelectedIndex();
        if (index < 0) {
            this.root.addLastChild(item1);
        } else {
            Item item2 = (Item)this.tree.getTreeItem(index);
            switch (this.tree.getTreeItemState(index)) {
                case 2: 
                case 3: 
                case 4: {
                    item2.addBefore(item1);
                    break;
                }
                case 1: {
                    item2.addLastChild(item1);
                }
            }
        }
        this.changed = true;
    }

    private Vector createItems(Item parent, Vector bookmarks) {
        Vector<Item> v = new Vector<Item>();
        for (int i = 0; i < bookmarks.size(); ++i) {
            Bookmark b = (Bookmark)bookmarks.elementAt(i);
            v.addElement(new Item(parent, b));
        }
        return v;
    }

    private void copyClipboard(String value) {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(value);
        clipboard.setContents(data, data);
    }

    private boolean checkInnerComponent(MouseEvent e) {
        Component c = (Component)e.getSource();
        if (!c.isEnabled()) {
            return false;
        }
        if ((e.getModifiers() & 0x10) == 0) {
            return false;
        }
        int x = e.getX();
        int y = e.getY();
        Dimension size = c.getSize();
        return 0 < x && x <= size.width && 0 < y && y <= size.height;
    }

    private class MenuActionListener
    implements ActionListener {
        private int index = 0;

        private MenuActionListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            switch (this.index) {
                case 0: {
                    BookmarkEditor.this.openBookmark();
                    break;
                }
                case 1: {
                    BookmarkEditor.this.createBookmark();
                    break;
                }
                case 2: {
                    BookmarkEditor.this.createFolder();
                    break;
                }
                case 3: {
                    BookmarkEditor.this.createSeparator();
                    break;
                }
                case 4: {
                    BookmarkEditor.this.cutBookmark();
                    break;
                }
                case 5: {
                    BookmarkEditor.this.copyBookmark();
                    break;
                }
                case 6: {
                    BookmarkEditor.this.pasteBookmark();
                    break;
                }
                case 7: {
                    BookmarkEditor.this.deleteBookmark();
                    break;
                }
                case 8: {
                    BookmarkEditor.this.changePtf();
                    break;
                }
                case 9: {
                    BookmarkEditor.this.showProperty();
                }
            }
        }
    }

    public class Entry {
        public Bookmark parent;
        public Bookmark bookmark;

        private Entry(Bookmark parent, Bookmark bookmark) {
            this.parent = parent;
            this.bookmark = bookmark;
        }
    }

    private class Item
    implements TreeItem {
        private int type;
        private Item parent;
        private Bookmark bookmark;
        private Vector items;

        private Item(Item parent, Bookmark bookmark) {
            this.parent = parent;
            this.type = bookmark.getType();
            this.bookmark = bookmark;
        }

        public Image getTreeIcon(boolean opened) {
            if (this.type != 1) {
                return BookmarkEditor.this.fileImage;
            }
            return opened ? BookmarkEditor.this.openfolderImage : BookmarkEditor.this.closefolderImage;
        }

        public String getTreeLabel() {
            if (this.type == 3) {
                return null;
            }
            return this.bookmark.getText();
        }

        public Vector getTreeItems() {
            if (this.type != 1) {
                return null;
            }
            if (this.items != null) {
                return this.items;
            }
            this.items = BookmarkEditor.this.createItems(this, this.bookmark.getBookmarks());
            return this.items;
        }

        private void addAfter(Item item) {
            this.parent.insertTreeItem(item, this.getNumber() + 1);
        }

        private void addBefore(Item item) {
            this.parent.insertTreeItem(item, this.getNumber());
        }

        private void addTopChild(Item item) {
            this.insertTreeItem(item, 0);
        }

        private void addLastChild(Item item) {
            this.insertTreeItem(item, -1);
        }

        private void insertTreeItem(Item item, int index) {
            Vector v = this.getTreeItems();
            if (v == null) {
                return;
            }
            if (index < 0) {
                v.addElement(item);
            } else {
                v.insertElementAt(item, index);
            }
            item.parent = this;
            this.bookmark.addBookmark(item.bookmark, index);
        }

        private void removeFromParent() {
            this.parent.bookmark.removeBookmark(this.bookmark);
            if (this.parent.items != null) {
                this.parent.items.removeElement(this);
            }
            this.parent = null;
        }

        private int getNumber() {
            return this.parent.getTreeItems().indexOf(this);
        }

        private boolean search(String search, Stack stack, boolean reverse, int pos) {
            if (reverse && this.type == 1 && this.searchSub(search, stack, reverse, pos)) {
                return true;
            }
            if (reverse || pos == -1) {
                switch (this.type) {
                    case 3: {
                        return false;
                    }
                    case 2: {
                        if (this.bookmark.getURLText() != null && this.bookmark.getURLText().toLowerCase().indexOf(search) != -1) {
                            return true;
                        }
                    }
                    case 1: {
                        if (this.bookmark.getText() == null || this.bookmark.getText().toLowerCase().indexOf(search) == -1) break;
                        return true;
                    }
                }
            }
            return !reverse && this.type == 1 && this.searchSub(search, stack, reverse, pos);
        }

        private boolean searchSub(String search, Stack stack, boolean reverse, int pos) {
            Vector v = this.getTreeItems();
            if (v == null) {
                return false;
            }
            int start = pos >= 0 ? pos + 1 : 0;
            int end = v.size();
            int step = 1;
            if (reverse) {
                start = pos >= 0 ? pos - 1 : v.size() - 1;
                end = -1;
                step = -1;
            }
            int i = start;
            while (reverse ? i > end : i < end) {
                if (((Item)v.elementAt(i)).search(search, stack, reverse, -1)) {
                    stack.push(new Integer(i));
                    return true;
                }
                i += step;
            }
            return false;
        }
    }
}

