/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.bookmarks;

import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.InputBox;
import net.hizlab.kagetaka.awt.Tree;
import net.hizlab.kagetaka.awt.TreeItem;
import net.hizlab.kagetaka.bookmarks.Bookmark;
import net.hizlab.kagetaka.bookmarks.BookmarkManager;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.theme.Theme;

public class BookmarkAs
extends DialogBox {
    private static final String RESOURCE = "net.hizlab.kagetaka.bookmarks.Resource";
    private static final int MARGIN = 3;
    private BookmarkManager bm;
    private Frame owner;
    private TextField text;
    private TextField urlText;
    private Tree tree;
    private Bookmark parent;
    private Item root;
    private Vector entries;
    private Image openfolderImage;
    private Image closefolderImage;

    public static Entry[] show(Frame owner, ViewerOption option, String text, String url) {
        BookmarkAs dialog = new BookmarkAs(owner, option);
        dialog.setText(text);
        dialog.setURL(url);
        dialog.show();
        if (dialog.getResult() != 0) {
            return null;
        }
        return dialog.getAddedEntries();
    }

    public BookmarkAs(Frame owner, ViewerOption option) {
        super(owner, 1);
        this.setTitle(this.getMessage("title"));
        this.setResizable(true);
        this.setModal(true);
        this.owner = owner;
        this.bm = option.getBookmarkManager();
        GridBagLayout gbl = new GridBagLayout();
        Insets insets = new Insets(3, 3, 3, 3);
        this.mainPanel.setLayout(gbl);
        this.addToPanel(new Label(this.getMessage("label.text")), gbl, 0, 0, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.text = new TextField();
        this.addToPanel(this.text, gbl, 1, 0, 2, 1, 1.0, 0.0, 2, 10, insets);
        this.addToPanel(new Label(this.getMessage("label.url")), gbl, 0, 1, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.urlText = new TextField();
        this.addToPanel(this.urlText, gbl, 1, 1, 2, 1, 1.0, 0.0, 2, 10, insets);
        this.addToPanel(new Label(this.getMessage("label.folder")), gbl, 0, 2, 1, 1, 0.0, 0.0, 0, 18, insets);
        this.tree = new Tree(10, 20);
        this.addToPanel(this.tree, gbl, 1, 2, 1, 1, 1.0, 1.0, 1, 10, insets);
        Button folder = new Button(this.getMessage("label.new"));
        this.addToPanel(folder, gbl, 2, 2, 1, 1, 0.0, 0.0, 0, 12, insets);
        folder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BookmarkAs.this.createNewFolder();
            }
        });
        Theme theme = option.getThemeManager().getTheme();
        this.openfolderImage = theme.getImage("bookmark.openfolder", this.getToolkit());
        this.closefolderImage = theme.getImage("bookmark.closefolder", this.getToolkit());
        this.root = new Item(null, this.bm.getRootBookmark());
        this.tree.setRootTreeItem(this.root);
        this.tree.setBackground(SystemColor.window);
        this.pack();
    }

    private String getMessage(String key) {
        if (key == null) {
            return "";
        }
        return Resource.getMessage(RESOURCE, "bookmarkas." + key, null);
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String value) {
        ((TextComponent)this.text).setText(value);
    }

    public String getURL() {
        return this.urlText.getText();
    }

    public void setURL(String value) {
        ((TextComponent)this.urlText).setText(value);
    }

    public Bookmark getParentBookmark() {
        Item item = (Item)this.tree.getSelectedTreeItem();
        if (item == null) {
            return null;
        }
        return item.bookmark;
    }

    public void setParentBookmark(Bookmark value) {
        this.parent = value;
    }

    public synchronized Entry[] getAddedEntries() {
        Entry entry = new Entry(this.getParentBookmark(), new Bookmark(this.getText(), this.getURL()));
        if (this.entries == null) {
            return new Entry[]{entry};
        }
        this.entries.addElement(entry);
        Object[] es = new Entry[this.entries.size()];
        this.entries.copyInto(es);
        return es;
    }

    public synchronized void removeAllAddedEntries() {
        this.entries = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewFolder() {
        String name = InputBox.show(this.owner, this.getMessage("newfolder.message"), this.getMessage("newfolder.title"), "");
        if (name == null) {
            return;
        }
        BookmarkAs bookmarkAs = this;
        synchronized (bookmarkAs) {
            if (this.entries == null) {
                this.entries = new Vector();
            }
            Bookmark bookmark = new Bookmark(name);
            this.entries.addElement(new Entry(this.getParentBookmark(), bookmark));
            Item item = (Item)this.tree.getSelectedTreeItem();
            if (item == null) {
                item = this.root;
            }
            item.addLastChild(new Item(item, bookmark));
        }
        this.tree.refresh();
    }

    private Vector createFolder(Item parent, Vector bookmarks) {
        Vector<Item> v = new Vector<Item>();
        for (int i = 0; i < bookmarks.size(); ++i) {
            Bookmark b = (Bookmark)bookmarks.elementAt(i);
            if (b.getType() != 1) continue;
            v.addElement(new Item(parent, b));
        }
        return v;
    }

    public class Entry {
        public Bookmark parent;
        public Bookmark bookmark;

        private Entry(Bookmark parent, Bookmark bookmark) {
            if (parent == null) {
                parent = BookmarkAs.this.bm.getRootBookmark();
            }
            this.parent = parent;
            this.bookmark = bookmark;
        }
    }

    private class Item
    implements TreeItem {
        private Item parent;
        private Bookmark bookmark;
        private Vector items;

        private Item(Item parent, Bookmark bookmark) {
            this.parent = parent;
            this.bookmark = bookmark;
        }

        public Image getTreeIcon(boolean opened) {
            return opened ? BookmarkAs.this.openfolderImage : BookmarkAs.this.closefolderImage;
        }

        public String getTreeLabel() {
            return this.bookmark.getText();
        }

        public Vector getTreeItems() {
            if (this.items != null) {
                return this.items;
            }
            this.items = BookmarkAs.this.createFolder(this, this.bookmark.getBookmarks());
            return this.items;
        }

        private void addLastChild(Item item) {
            Vector v = this.getTreeItems();
            if (v == null) {
                return;
            }
            v.addElement(item);
            item.parent = this;
        }
    }
}

