/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.event.ActionEvent;
import net.hizlab.kagetaka.awt.tate.TextComponent;
import net.hizlab.kagetaka.rendering.Option;

public class TextField
extends TextComponent {
    private static final String RESOURCE = "net.hizlab.kagetaka.awt.tate.Resource";
    private static final String BASE = "textfield";
    private static int nameCounter = 0;
    private String command;
    private char echoChar;
    private int maxlength;
    private transient ActionListener actionListener;

    public TextField(Option option, ImageCreator ic) {
        this(option, ic, null, 20);
    }

    public TextField(Option option, ImageCreator ic, String text) {
        this(option, ic, text, text != null ? text.length() : 20);
    }

    public TextField(Option option, ImageCreator ic, int columns) {
        this(option, ic, null, columns);
    }

    public TextField(Option option, ImageCreator ic, String text, int columns) {
        super(option, ic, text, 1, columns, false);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!TextField.this.isEnabled()) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 10: {
                        e.consume();
                        TextField.this.postActionEvent(e.getModifiers());
                    }
                }
            }
        });
    }

    protected String paramString() {
        String str = super.paramString();
        if (this.echoChar != '\u0000') {
            str = str + ",echo=" + this.echoChar;
        }
        return str;
    }

    String constructComponentName() {
        return BASE + nameCounter++;
    }

    void resetText() {
        this.text = null;
        if (this.value.length() > 0) {
            try {
                String v = this.value;
                if (this.echoChar != '\u0000') {
                    StringBuffer sb = new StringBuffer();
                    for (int i = v.length() - 1; i >= 0; --i) {
                        sb.append(this.echoChar);
                    }
                    v = sb.toString();
                }
                this.text = super.getText(v);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            this.setPreferredSize(0, 0);
        }
    }

    public int getColumns() {
        return super.getColumns();
    }

    public void setColumns(int columns) {
        super.setColumns(columns);
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char c) {
        this.echoChar = c;
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    public int getMaxLength() {
        return this.maxlength;
    }

    public void setMaxLength(int max) {
        this.maxlength = max;
    }

    public String getActionCommand() {
        return this.command != null ? this.command : this.getText();
    }

    public void setActionCommand(String command) {
        this.command = command;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.enableEvents(128L);
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    private void postActionEvent(int modifiers) {
        ActionEvent e = new ActionEvent(this, 3020, this.getActionCommand(), modifiers);
        try {
            this.getToolkit().getSystemEventQueue().postEvent(e);
        }
        catch (SecurityException ex) {
            this.processActionEvent(e);
        }
    }

    Window showInputBox(Frame owner, int x, int y) {
        Point point = this.getLocationOnScreen();
        Input input = new Input(owner);
        Insets insets = input.getInsets();
        ((Component)input).setLocation(point.x + x - insets.left, point.y + y - insets.top);
        input.show();
        input.text.requestFocus();
        input.toFront();
        return input;
    }

    private class Input
    extends Dialog {
        private java.awt.TextField text;
        private boolean isClosed;

        private Input(Frame parent) {
            super(parent, Resource.getMessage(TextField.RESOURCE, "input.title", null), false);
            this.text = new java.awt.TextField(TextField.this.value, TextField.this.getColumns());
            this.text.setForeground(TextField.this.getForeground());
            ((Component)this.text).setBackground(TextField.this.getBackground());
            this.text.setFont(TextField.this.getFont());
            if (TextField.this.echoChar != '\u0000') {
                this.text.setEchoChar(TextField.this.echoChar);
            }
            this.add(this.text);
            this.pack();
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ Input this$1;
                {
                    this.this$1 = this$1;
                }

                public void windowClosing(WindowEvent e) {
                    Input.access$400(this.this$1, false);
                }

                public void windowDeactivated(WindowEvent e) {
                    Input.access$400(this.this$1, true);
                }
            });
            this.text.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ Input this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    char c;
                    if (!(TextField.access$600(Input.access$500(this.this$1)) == 0 || Input.access$200(this.this$1).getText().length() < TextField.access$600(Input.access$500(this.this$1)) || Character.isISOControl(c = e.getKeyChar()) && c != '\u0016')) {
                        e.consume();
                    }
                }

                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 27: {
                            e.consume();
                            Input.access$400(this.this$1, false);
                            break;
                        }
                        case 10: {
                            e.consume();
                            Input.access$400(this.this$1, true);
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(boolean commit) {
            Input input = this;
            synchronized (input) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            if (commit) {
                String v = this.text.getText();
                if (TextField.this.maxlength != 0 && v.length() >= TextField.this.maxlength) {
                    v = v.substring(0, TextField.this.maxlength);
                }
                TextField.this.setText(v);
            }
            this.dispose();
        }

        public void update(Graphics g) {
            ((Container)this).paint(g);
        }

        static /* synthetic */ void access$400(Input x0, boolean x1) {
            x0.close(x1);
        }

        static /* synthetic */ TextField access$500(Input x0) {
            return x0.TextField.this;
        }
    }
}

