/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.InnerScrollbar;
import net.hizlab.kagetaka.awt.tate.TextComponent;
import net.hizlab.kagetaka.rendering.Option;

public class TextArea
extends TextComponent {
    private static final String RESOURCE = "net.hizlab.kagetaka.awt.tate.Resource";
    private static final String BASE = "textarea";
    private static int nameCounter = 0;
    private static final int SCROLLBAR_SIZE = 16;
    public static final int SCROLLBARS_BOTH = 0;
    public static final int SCROLLBARS_VERTICAL_ONLY = 1;
    public static final int SCROLLBARS_HORIZONTAL_ONLY = 2;
    public static final int SCROLLBARS_NONE = 3;
    private int scrollbarVisibility;
    private Scrollbar scrollbarHorizontal;
    private Scrollbar scrollbarVertical;

    public TextArea(Option option, ImageCreator ic) {
        this(option, ic, null, 0, 0, 0);
    }

    public TextArea(Option option, ImageCreator ic, String text) {
        this(option, ic, text, 0, 0, 0);
    }

    public TextArea(Option option, ImageCreator ic, int rows, int columns) {
        this(option, ic, null, rows, columns, 0);
    }

    public TextArea(Option option, ImageCreator ic, String text, int rows, int columns) {
        this(option, ic, text, rows, columns, 0);
    }

    public TextArea(Option option, ImageCreator ic, String text, int rows, int columns, int scrollbars) {
        super(option, ic, text, rows, columns, true);
        this.scrollbarVisibility = scrollbars;
        this.setFrameSize(4, 4, 4 + (scrollbars == 0 || scrollbars == 2 ? 16 : 0), 4 + (scrollbars == 0 || scrollbars == 1 ? 16 : 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            if (this.scrollbarVisibility == 0 || this.scrollbarVisibility == 2) {
                this.scrollbarHorizontal = new Scrollbar(0);
            }
            if (this.scrollbarVisibility == 0 || this.scrollbarVisibility == 1) {
                this.scrollbarVertical = new Scrollbar(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.removeNotify();
            if (this.scrollbarHorizontal != null) {
                this.scrollbarHorizontal.dispose();
                this.scrollbarHorizontal = null;
            }
            if (this.scrollbarVertical != null) {
                this.scrollbarVertical.dispose();
                this.scrollbarVertical = null;
            }
        }
    }

    protected String paramString() {
        String sbVisStr;
        String str = super.paramString();
        switch (this.scrollbarVisibility) {
            case 0: {
                sbVisStr = "both";
                break;
            }
            case 1: {
                sbVisStr = "vertical-only";
                break;
            }
            case 2: {
                sbVisStr = "horizontal-only";
                break;
            }
            case 3: {
                sbVisStr = "none";
                break;
            }
            default: {
                sbVisStr = "invalid display policy";
            }
        }
        return str + ",rows=" + this.getRows() + ",columns=" + this.getColumns() + ", scrollbarVisibility=" + sbVisStr;
    }

    String constructComponentName() {
        return BASE + nameCounter++;
    }

    protected void refresh(Graphics g, Dimension size, int state, boolean focus) {
        int page;
        super.refresh(g, size, state, focus);
        Point viewPosition = this.getViewPosition();
        Dimension textSize = this.getTextSize();
        Insets frameSize = this.getFrameSize();
        if (this.scrollbarHorizontal != null) {
            page = size.width - frameSize.left - frameSize.right;
            this.scrollbarHorizontal.setBounds(2, size.height - 16 - 2, size.width - (this.scrollbarVertical != null ? 16 : 0) - 4, 16);
            this.scrollbarHorizontal.setReverseValues(viewPosition.x, page, 0, textSize.width);
            this.scrollbarHorizontal.setBlockIncrement(Math.max(10, page - 10));
            this.scrollbarHorizontal.setUnitIncrement(10);
            this.scrollbarHorizontal.setEnabled(this.scrollbarHorizontal.canScroll());
            this.scrollbarHorizontal.paint(g, true);
        }
        if (this.scrollbarVertical != null) {
            page = size.height - frameSize.top - frameSize.bottom;
            this.scrollbarVertical.setBounds(size.width - 16 - 2, 2, 16, size.height - (this.scrollbarHorizontal != null ? 16 : 0) - 4);
            this.scrollbarVertical.setValues(viewPosition.y, page, 0, textSize.height);
            this.scrollbarVertical.setBlockIncrement(Math.max(this.getLineHeight(), page - this.getLineHeight()));
            this.scrollbarVertical.setUnitIncrement(this.getLineHeight());
            this.scrollbarVertical.setEnabled(this.scrollbarVertical.canScroll());
            this.scrollbarVertical.paint(g, true);
        }
        if (this.scrollbarHorizontal != null && this.scrollbarVertical != null) {
            g.setColor(SystemColor.control);
            g.fillRect(size.width - 16 - 2, size.height - 16 - 2, 16, 16);
        }
    }

    public int getColumns() {
        return super.getColumns();
    }

    public void setColumns(int columns) {
        super.setColumns(columns);
    }

    public int getRows() {
        return super.getRows();
    }

    public void setRows(int rows) {
        super.setRows(rows);
    }

    public boolean getWordwrap() {
        return super.getWordwrap();
    }

    public void setWordwrap(boolean b) {
        super.setWordwrap(b);
    }

    Window showInputBox(Frame owner, int x, int y) {
        Point point = this.getLocationOnScreen();
        Input input = new Input(owner);
        Insets insets = input.getInsets();
        ((Component)input).setLocation(point.x + x - insets.left, point.y + y - insets.top);
        input.show();
        input.text.requestFocus();
        input.toFront();
        return input;
    }

    private class Scrollbar
    extends InnerScrollbar {
        private int orientation;

        private Scrollbar(int orientation) {
            super(orientation, TextArea.this);
            this.orientation = orientation;
        }

        public void repaint() {
            TextArea.this.repaintForce();
        }

        public void changedValue() {
            Point viewPosition = TextArea.this.getViewPosition();
            if (this.orientation == 0) {
                int x = this.getReverseValue();
                if (x == viewPosition.x) {
                    return;
                }
                TextArea.this.setViewPosition(x, viewPosition.y);
            } else {
                int y = this.getValue();
                if (y == viewPosition.y) {
                    return;
                }
                TextArea.this.setViewPosition(viewPosition.x, y);
            }
            TextArea.this.repaintForce();
        }
    }

    private class Input
    extends Dialog
    implements ActionListener {
        private static final String COMMAND_OK = "ok";
        private static final String COMMAND_CANCEL = "cancel";
        private java.awt.TextArea text;
        private boolean isClosed;

        private Input(Frame parent) {
            super(parent, Resource.getMessage(TextArea.RESOURCE, "input.title", null), false);
            this.text = new java.awt.TextArea(TextArea.this.value, TextArea.this.getRows(), TextArea.this.getColumns(), TextArea.this.scrollbarVisibility);
            this.text.setForeground(TextArea.this.getForeground());
            ((Component)this.text).setBackground(TextArea.this.getBackground());
            this.text.setFont(TextArea.this.getFont());
            this.add(this.text);
            Panel panel = new Panel();
            this.add((Component)panel, "South");
            panel.setLayout(new GridLayout(1, 2, 10, 5));
            Button button = new Button(Resource.getMessage(TextArea.RESOURCE, "textarea.button.ok", null));
            panel.add(button);
            button.setActionCommand(COMMAND_OK);
            button.addActionListener(this);
            button = new Button(Resource.getMessage(TextArea.RESOURCE, "textarea.button.cancel", null));
            panel.add(button);
            button.setActionCommand(COMMAND_CANCEL);
            button.addActionListener(this);
            this.pack();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    this.close(false);
                }

                public void windowDeactivated(WindowEvent e) {
                    this.close(true);
                }
            });
            this.text.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ Input this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 27: {
                            e.consume();
                            Input.access$400(this.this$1, false);
                            break;
                        }
                        case 10: {
                            if ((e.getModifiers() & 2) == 0) break;
                            e.consume();
                            Input.access$400(this.this$1, true);
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(boolean commit) {
            Input input = this;
            synchronized (input) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            if (commit) {
                TextArea.this.setText(this.text.getText());
            }
            this.dispose();
        }

        public void update(Graphics g) {
            ((Container)this).paint(g);
        }

        public void actionPerformed(ActionEvent e) {
            this.close(COMMAND_OK.compareTo(e.getActionCommand()) == 0);
        }
    }
}

