/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.tate.Button;
import net.hizlab.kagetaka.awt.tate.TextField;
import net.hizlab.kagetaka.rendering.Option;

public class FileField
extends Container {
    private static final String RESOURCE = "net.hizlab.kagetaka.awt.tate.Resource";
    private static final String BASE = "filefield";
    private static int nameCounter = 0;
    private String name;
    private boolean nameExplicitlySet = false;
    private TextField text;
    private Button button;
    private String title;
    private FilenameFilter filter;

    public FileField(Option option, ImageCreator ic) {
        this(option, ic, null, 20);
    }

    public FileField(Option option, ImageCreator ic, String file) {
        this(option, ic, file, 20);
    }

    public FileField(Option option, ImageCreator ic, String file, int columns) {
        this.text = new TextField(option, ic, file, columns);
        this.button = new Button(option, ic, Resource.getMessage(RESOURCE, "filefield.button.browse", null));
        GridBagLayout gbl = new GridBagLayout();
        Insets insets = new Insets(0, 0, 0, 0);
        this.setLayout(gbl);
        LayoutUtils.addGridBag(this, this.text, gbl, 0, 0, 1, 1, 1.0, 1.0, 3, 11, insets);
        insets.top = 2;
        LayoutUtils.addGridBag(this, this.button, gbl, 0, 1, 1, 1, 1.0, 0.0, 0, 15, insets);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Container parent = FileField.this.getParent();
                if (parent == null) {
                    return;
                }
                while (!(parent instanceof Frame)) {
                    if ((parent = parent.getParent()) != null) continue;
                    return;
                }
                String title = FileField.this.title;
                if (title == null) {
                    title = Resource.getMessage(FileField.RESOURCE, "filefield.browse.title", null);
                }
                FileDialog fd = new FileDialog((Frame)parent, title);
                String fileName = FileField.this.text.getText();
                if (fileName.length() > 0 && fileName.indexOf(42) == -1 && fileName.indexOf(63) == -1) {
                    File file = new File(fileName);
                    fd.setDirectory(file.getParent());
                    fd.setFile(file.getName());
                }
                if (FileField.this.filter != null) {
                    fd.setFilenameFilter(FileField.this.filter);
                }
                fd.show();
                fileName = fd.getFile();
                if (fileName != null) {
                    FileField.this.text.setText(fd.getDirectory() + fileName);
                }
            }
        });
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    protected String paramString() {
        String str = super.paramString();
        return str + ",file=" + this.text.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            FileField fileField = this;
            synchronized (fileField) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = BASE + nameCounter++;
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        FileField fileField = this;
        synchronized (fileField) {
            super.setName(name);
            this.name = name;
            this.nameExplicitlySet = true;
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Border getBorder() {
        return this.text.getBorder();
    }

    public void setBorder(Border border) {
        this.text.setBorder(border);
        this.button.setBorder(border);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFile() {
        return this.text.getText();
    }

    public void setFile(String file) {
        this.text.setText(file);
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public void setFilenameFilter(FilenameFilter filter) {
        this.filter = filter;
    }
}

