/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.TextManager;
import net.hizlab.kagetaka.rendering.Option;

public abstract class Component
extends java.awt.Component {
    private static final Font DEFAULT_FONT = Font.decode("Dialog-plain-12");
    private static final int NONE = -1;
    public static final int NORMAL = 0;
    public static final int MOUSE_OVER = 1;
    public static final int MOUSE_DOWN = 2;
    public static final int KEY_DOWN = 3;
    public static final int DISABLE = 4;
    final Option option;
    final ImageCreator ic;
    private String name;
    private boolean nameExplicitlySet = false;
    private TextManager textManager;
    private Border border;
    private Object stateLock = new Object();
    private int stateRequest;
    private int stateEnable;
    private int statePaint = -1;
    private boolean focusRequest;
    private boolean focusPaint = false;
    private boolean repaintForce;
    private Dimension preferredSize = new Dimension(0, 0);
    private int pressX = -1;
    private int pressY = -1;
    private Image offScreenImage;
    private Dimension offScreenSize;
    private Graphics offScreenGraphics;

    public Component(Option option, ImageCreator ic) {
        this.option = option;
        this.ic = ic;
        this.textManager = new TextManager(option, ic);
        this.addFocusListener(new FocusListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void focusGained(FocusEvent e) {
                boolean repaint = false;
                Object object = Component.this.stateLock;
                synchronized (object) {
                    if (!Component.this.focusRequest) {
                        Component.this.focusRequest = true;
                        repaint = true;
                    }
                }
                if (repaint) {
                    Component.this.repaint();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void focusLost(FocusEvent e) {
                boolean repaint = false;
                Object object = Component.this.stateLock;
                synchronized (object) {
                    if (Component.this.focusRequest) {
                        Component.this.focusRequest = false;
                        repaint = true;
                    }
                }
                Component.this.setViewState(0);
                if (repaint) {
                    Component.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (Component.this.stateRequest == 3) {
                    return;
                }
                if (Component.this.isEnabled()) {
                    Component.this.requestFocus();
                    e.consume();
                }
                if ((e.getModifiers() & 0x10) == 0) {
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                Dimension size = Component.this.getSize();
                if (x < 0 || y < 0 || x >= size.width || y > size.height) {
                    return;
                }
                Component.this.setViewState(2);
                Component.this.pressX = e.getX();
                Component.this.pressY = e.getY();
            }

            public void mouseReleased(MouseEvent e) {
                if (Component.this.isEnabled()) {
                    e.consume();
                }
                if (Component.this.stateRequest == 3) {
                    return;
                }
                if ((e.getModifiers() & 0x10) == 0) {
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                Dimension size = Component.this.getSize();
                if (x < 0 || y < 0 || x >= size.width || y > size.height) {
                    Component.this.setViewState(0);
                } else {
                    Component.this.setViewState(1);
                }
                if (e.getClickCount() > 0 && x >= 0 && y >= 0 && x < size.width && y < size.height && (x != Component.this.pressX || y != Component.this.pressY)) {
                    Component.this.getToolkit().getSystemEventQueue().postEvent(new MouseEvent(e.getComponent(), 500, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger()));
                }
            }

            public void mouseEntered(MouseEvent e) {
                if (Component.this.stateRequest != 3) {
                    Component.this.setViewState(1);
                }
            }

            public void mouseExited(MouseEvent e) {
                if (Component.this.stateRequest != 3) {
                    Component.this.setViewState(0);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (Component.this.isEnabled()) {
                    e.consume();
                }
                if (Component.this.stateRequest != 1) {
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                Dimension size = Component.this.getSize();
                if (x < 0 || y < 0 || x >= size.width || y > size.height) {
                    return;
                }
                Component.this.setViewState(2);
            }

            public void mouseMoved(MouseEvent e) {
                if (Component.this.isEnabled()) {
                    e.consume();
                }
                if (Component.this.stateRequest != 3) {
                    Component.this.setViewState(1);
                }
            }
        });
        this.setFont(DEFAULT_FONT);
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferredSize(int width, int height) {
        Dimension dimension = this.preferredSize;
        synchronized (dimension) {
            if (this.preferredSize.width != width || this.preferredSize.height != height) {
                this.preferredSize.width = width;
                this.preferredSize.height = height;
                this.invalidate();
            }
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.offScreenImage == null || !size.equals(this.offScreenSize)) {
                if (this.offScreenImage != null) {
                    this.offScreenGraphics.dispose();
                    this.offScreenImage.flush();
                }
                if (size.width == 0 || size.height == 0) {
                    this.offScreenImage = null;
                    this.offScreenSize = null;
                    this.offScreenGraphics = null;
                    return;
                }
                this.offScreenImage = this.createImage(size.width, size.height);
                this.offScreenSize = size;
                this.offScreenGraphics = this.offScreenImage.getGraphics();
                this.statePaint = -1;
            }
            if (this.offScreenGraphics != null && (this.stateRequest != this.statePaint || this.focusRequest != this.focusPaint || this.repaintForce)) {
                this.refresh(this.offScreenGraphics, size, this.stateRequest, this.focusRequest);
                this.statePaint = this.stateRequest;
                this.focusPaint = this.focusRequest;
                this.repaintForce = false;
            }
        }
        if (this.offScreenImage != null) {
            g.drawImage(this.offScreenImage, 0, 0, size.width, size.height, this);
        }
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setViewState(b ? this.stateEnable : 4);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected String paramString() {
        String str = super.paramString();
        return str + ",state=" + this.statePaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            Component component = this;
            synchronized (component) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = this.constructComponentName();
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        Component component = this;
        synchronized (component) {
            super.setName(name);
            this.name = name;
            this.nameExplicitlySet = true;
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    String constructComponentName() {
        return null;
    }

    protected abstract void refresh(Graphics var1, Dimension var2, int var3, boolean var4);

    protected int getViewState() {
        return this.stateRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setViewState(int state) {
        Object object = this.stateLock;
        synchronized (object) {
            if (state != 4) {
                this.stateEnable = state;
            }
            if (!this.isEnabled()) {
                state = 4;
            }
            if (this.stateRequest != state) {
                this.stateRequest = state;
                if (this.isVisible()) {
                    Graphics g = this.getGraphics();
                    if (g != null) {
                        try {
                            this.update(g);
                        }
                        finally {
                            g.dispose();
                        }
                    } else {
                        this.repaint();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repaintForce() {
        Object object = this.stateLock;
        synchronized (object) {
            this.repaintForce = true;
        }
        this.repaint();
    }

    protected Text getText(String text) {
        return this.textManager.getText(FontData.getInstance(this.ic, this.getFont()), text);
    }
}

