/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

public class RotateFilter
extends ImageFilter {
    private static ColorModel defaultColorModel = ColorModel.getRGBdefault();
    private int[] raster;
    private int srcWidth;
    private int srcHeight;

    public void setDimensions(int width, int height) {
        this.raster = new int[width * height];
        this.srcWidth = width;
        this.srcHeight = height;
        this.consumer.setDimensions(height, width);
    }

    public void setColorModel(ColorModel model) {
        this.consumer.setColorModel(defaultColorModel);
    }

    public void setHints(int hintflags) {
        this.consumer.setHints(0xE | hintflags & 0x10);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int srcoff = off;
        int dstoff = y * this.srcWidth + x;
        for (int yc = 0; yc < h; ++yc) {
            for (int xc = 0; xc < w; ++xc) {
                this.raster[dstoff++] = model.getRGB(pixels[srcoff++] & 0xFF);
            }
            srcoff += scansize - w;
            dstoff += this.srcWidth - w;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int srcoff = off;
        int dstoff = y * this.srcWidth + x;
        if (model == defaultColorModel) {
            for (int yc = 0; yc < h; ++yc) {
                System.arraycopy(pixels, srcoff, this.raster, dstoff, w);
                srcoff += scansize;
                dstoff += this.srcWidth;
            }
        } else {
            for (int yc = 0; yc < h; ++yc) {
                for (int xc = 0; xc < w; ++xc) {
                    this.raster[dstoff++] = model.getRGB(pixels[srcoff++]);
                }
                srcoff += scansize - w;
                dstoff += this.srcWidth - w;
            }
        }
    }

    public void imageComplete(int status) {
        if (status == 1 || status == 4) {
            this.consumer.imageComplete(status);
            return;
        }
        int[] pixels = new int[this.srcWidth * this.srcHeight];
        int dp = 0;
        for (int dy = 0; dy < this.srcWidth; ++dy) {
            int sy = this.srcWidth * (this.srcHeight - 1) + dy;
            for (int dx = 0; dx < this.srcHeight; ++dx) {
                pixels[dp++] = this.raster[sy];
                sy -= this.srcWidth;
            }
        }
        this.consumer.setPixels(0, 0, this.srcHeight, this.srcWidth, defaultColorModel, pixels, 0, this.srcHeight);
        this.consumer.imageComplete(status);
    }
}

