/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.util.Vector;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.ImageUtils;
import net.hizlab.kagetaka.awt.InnerScrollbar;
import net.hizlab.kagetaka.awt.TreeItem;
import net.hizlab.kagetaka.awt.event.ItemEvent;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.java2.WheelListener;
import net.hizlab.kagetaka.java2.WheelWrapper;

public class Tree
extends Component
implements ItemSelectable {
    private static final String BASE = "tree";
    private static int nameCounter = 0;
    private static final Font DEFAULT_FONT = Font.decode("Dialog-plain-12");
    private static final int INSET = 2;
    private static final int SPACE = 2;
    private static final int BOX = 13;
    private static final int SB_W = 16;
    private static final int[] BOX_OPEN = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 2, 2, 2, 2, 2, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] BOX_CLOSE = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 2, 2, 2, 2, 2, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int NONE = -1;
    public static final int NORMAL = 0;
    public static final int MOUSE_OVER = 1;
    public static final int MOUSE_DOWN = 2;
    public static final int KEY_DOWN = 3;
    public static final int DISABLE = 4;
    public static final int ITEM_FOLDER_OPEN = 1;
    public static final int ITEM_FOLDER_CLOSE = 2;
    public static final int ITEM_FOLDER_NONE = 3;
    public static final int ITEM_NORMAL = 4;
    public static final int ITEM_INVALID = -1;
    private static final int TOGGLE = 1;
    private static final int OPEN = 2;
    private static final int CLOSE = 3;
    private String name;
    private boolean nameExplicitlySet = false;
    private int rows;
    private int columns;
    private Border border;
    private Item rootItem;
    private Vector viewItems = new Vector();
    private int selectedIndex = -1;
    private int selectedOldIndex = -1;
    private Object stateLock = new Object();
    private int stateRequest;
    private int stateEnable;
    private int statePaint = -1;
    private boolean focusRequest;
    private boolean focusPaint = false;
    private boolean repaintForce;
    private FontMetrics fm;
    private Dimension preferredSize = new Dimension(0, 0);
    private int viewStart = 0;
    private int viewEnd = 0;
    private int visibleIndex = -1;
    private int visibleReq = -1;
    private int rowHeight = -1;
    private Scrollbar scrollbar = null;
    private Image offScreenImage;
    private Dimension offScreenSize;
    private Graphics offScreenGraphics;
    private Dimension boxSize;
    private Image openImage;
    private Image closeImage;
    private Image openSelectedImage;
    private Image closeSelectedImage;
    private MouseListener treeMouseListener;
    private transient Vector listenerWrappers = new Vector();
    private transient ItemListener itemListener;

    public Tree(int rows, int columns) {
        this.setRows(rows);
        this.setColumns(columns);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!Tree.this.focusRequest) {
                    Tree.this.focusRequest = true;
                    Tree.this.repaint();
                }
            }

            public void focusLost(FocusEvent e) {
                boolean repaint = false;
                if (Tree.this.focusRequest) {
                    Tree.this.focusRequest = false;
                    repaint = true;
                }
                Tree.this.setViewState(0);
                if (repaint) {
                    Tree.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void keyPressed(KeyEvent e) {
                if (!Tree.this.isEnabled()) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 37: {
                        e.consume();
                        Tree tree = Tree.this;
                        synchronized (tree) {
                            if (Tree.this.selectedIndex >= 0) {
                                Item item = (Item)Tree.this.viewItems.elementAt(Tree.this.selectedIndex);
                                if (item.isOpen) {
                                    Tree.this.openItem(Tree.this.selectedIndex, 3);
                                } else {
                                    if (item.parent == null) return;
                                    for (int i = Tree.this.selectedIndex - 1; i >= 0; --i) {
                                        if (((Item)Tree.this.viewItems.elementAt(i)).level >= item.level) continue;
                                        if (Tree.this.moveCurrent(i, false, true)) break;
                                        return;
                                    }
                                }
                            }
                        }
                        Tree.this.repaintForce();
                        return;
                    }
                    case 39: {
                        e.consume();
                        Tree tree = Tree.this;
                        synchronized (tree) {
                            if (Tree.this.selectedIndex >= 0) {
                                Item item = (Item)Tree.this.viewItems.elementAt(Tree.this.selectedIndex);
                                if (item.isOpen) return;
                                if (!item.hasChild()) {
                                    return;
                                }
                                Tree.this.openItem(Tree.this.selectedIndex, 2);
                            }
                        }
                        Tree.this.repaintForce();
                        return;
                    }
                    case 40: {
                        e.consume();
                        Tree tree = Tree.this;
                        synchronized (tree) {
                            int index;
                            int n = index = Tree.this.selectedIndex == -1 && Tree.this.selectedOldIndex != -1 ? Math.min(Tree.this.selectedOldIndex, Tree.this.viewItems.size() - 1) : Tree.this.selectedIndex + 1;
                            if (index >= Tree.this.viewItems.size()) {
                                return;
                            }
                            if (!Tree.this.moveCurrent(index, false, true)) {
                                return;
                            }
                        }
                        Tree.this.repaintForce();
                        return;
                    }
                    case 38: {
                        e.consume();
                        Tree tree = Tree.this;
                        synchronized (tree) {
                            int index;
                            int n = index = Tree.this.selectedIndex == -1 && Tree.this.selectedOldIndex != -1 ? Math.min(Math.max(Tree.this.selectedOldIndex - 1, 0), Tree.this.viewItems.size() - 1) : Tree.this.selectedIndex - 1;
                            if (index < 0) {
                                return;
                            }
                            if (!Tree.this.moveCurrent(index, false, true)) {
                                return;
                            }
                        }
                        Tree.this.repaintForce();
                        return;
                    }
                    case 34: {
                        e.consume();
                        Tree tree = Tree.this;
                        synchronized (tree) {
                            int index;
                            int n = index = Tree.this.selectedIndex == -1 && Tree.this.selectedOldIndex != -1 ? Math.min(Tree.this.selectedOldIndex, Tree.this.viewItems.size() - 1) : Tree.this.selectedIndex;
                            if (index + 1 >= Tree.this.viewItems.size()) {
                                return;
                            }
                            int viewNum = (Tree.this.getSize().height - 4) / Tree.this.rowHeight;
                            int request = Math.min(Tree.this.viewEnd + viewNum, Tree.this.viewItems.size() - 1);
                            int n2 = index = request > Tree.this.viewEnd ? index + (request - Tree.this.viewEnd) : Tree.this.viewItems.size() - 1;
                            if (!Tree.this.moveCurrent(index, false, true)) {
                                return;
                            }
                            Tree.this.visibleReq = request;
                        }
                        Tree.this.repaintForce();
                        return;
                    }
                    case 33: {
                        e.consume();
                        Tree tree = Tree.this;
                        synchronized (tree) {
                            int index;
                            int n = index = Tree.this.selectedIndex == -1 && Tree.this.selectedOldIndex != -1 ? Math.min(Math.max(Tree.this.selectedOldIndex - 1, 0), Tree.this.viewItems.size() - 1) : Tree.this.selectedIndex;
                            if (index == 0) {
                                return;
                            }
                            int viewNum = (Tree.this.getSize().height - 4) / Tree.this.rowHeight;
                            int request = Math.max(Tree.this.viewStart - viewNum, 0);
                            int n3 = index = request < Tree.this.viewStart ? index - (Tree.this.viewStart - request) : 0;
                            if (!Tree.this.moveCurrent(index, false, true)) {
                                return;
                            }
                            Tree.this.visibleReq = request;
                        }
                        Tree.this.repaintForce();
                        return;
                    }
                }
            }
        });
        this.treeMouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (!Tree.this.isEnabled()) {
                    return;
                }
                e.consume();
                if (Tree.this.isEnabled()) {
                    Tree.this.requestFocus();
                }
                if (Tree.this.scrollbar.contains(e.getX(), e.getY(), false)) {
                    return;
                }
                Tree.this.moveCurrentFromPoint(e.getX(), e.getY());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent e) {
                if (!Tree.this.isEnabled()) {
                    return;
                }
                e.consume();
                if (e.getClickCount() == 2) {
                    int x = e.getX();
                    int y = e.getY();
                    Tree tree = Tree.this;
                    synchronized (tree) {
                        int index = Tree.this.getIndexFromPosition(x, y);
                        if (index < 0) {
                            return;
                        }
                        if (Tree.this.isBoxFromPosition(index, x, y)) {
                            return;
                        }
                        if (!Tree.this.openItem(index, 1)) {
                            return;
                        }
                    }
                    Tree.this.repaintForce();
                }
            }
        };
        this.addMouseListener(this.treeMouseListener);
        WheelWrapper wheelWrapper = WheelWrapper.getInstance();
        if (wheelWrapper != null) {
            wheelWrapper.addWheelListener(this, new WheelListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void spin(int type, int value, int modifiers) {
                    Tree tree = Tree.this;
                    synchronized (tree) {
                        int request;
                        if (type == 0) {
                            if (value > 0) {
                                request = Math.min(Tree.this.viewEnd + value, Tree.this.viewItems.size() - 1);
                                if (request <= Tree.this.viewEnd) {
                                    return;
                                }
                            } else {
                                request = Math.max(Tree.this.viewStart + value, 0);
                                if (request >= Tree.this.viewStart) {
                                    return;
                                }
                            }
                        } else {
                            int viewNum = (Tree.this.getSize().height - 4) / Tree.this.rowHeight;
                            if (value > 0) {
                                request = Math.min(Tree.this.viewEnd + value * viewNum, Tree.this.viewItems.size() - 1);
                                if (request <= Tree.this.viewEnd) {
                                    return;
                                }
                            } else {
                                request = Math.max(Tree.this.viewStart + value * viewNum, 0);
                                if (request >= Tree.this.viewStart) {
                                    return;
                                }
                            }
                        }
                        Tree.this.visibleReq = request;
                    }
                    Tree.this.repaintForce();
                }
            });
        }
        this.setFont(DEFAULT_FONT);
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            Tree tree = this;
            synchronized (tree) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = BASE + nameCounter++;
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        Tree tree = this;
        synchronized (tree) {
            super.setName(name);
            this.name = name;
            this.nameExplicitlySet = true;
        }
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.initDefaultImage();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.resetSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferredSize(int width, int height) {
        Dimension dimension = this.preferredSize;
        synchronized (dimension) {
            if (this.preferredSize.width != width || this.preferredSize.height != height) {
                this.preferredSize.width = width;
                this.preferredSize.height = height;
                this.invalidate();
            }
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.offScreenImage == null || !size.equals(this.offScreenSize)) {
                if (this.offScreenImage != null) {
                    this.offScreenGraphics.dispose();
                    this.offScreenImage.flush();
                }
                if (size.width == 0 || size.height == 0) {
                    this.offScreenImage = null;
                    this.offScreenSize = null;
                    this.offScreenGraphics = null;
                    return;
                }
                this.offScreenImage = this.createImage(size.width, size.height);
                this.offScreenSize = size;
                this.offScreenGraphics = this.offScreenImage.getGraphics();
                this.statePaint = -1;
            }
            if (this.offScreenGraphics != null && (this.stateRequest != this.statePaint || this.focusRequest != this.focusPaint || this.repaintForce)) {
                this.repaintForce = false;
                this.refresh(this.offScreenGraphics, size, this.stateRequest, this.focusRequest);
                this.statePaint = this.stateRequest;
                this.focusPaint = this.focusRequest;
            }
        }
        if (this.offScreenImage != null) {
            g.drawImage(this.offScreenImage, 0, 0, size.width, size.height, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            this.scrollbar = new Scrollbar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.removeNotify();
            if (this.scrollbar != null) {
                this.scrollbar.dispose();
                this.scrollbar = null;
            }
        }
    }

    public synchronized void addMouseListener(MouseListener l) {
        if (this.scrollbar != null && !this.scrollbar.isOwnListener(l) && this.treeMouseListener != l) {
            l = new ListenerWrapper(l);
            this.listenerWrappers.addElement(l);
        }
        super.addMouseListener(l);
    }

    public synchronized void removeMouseListener(MouseListener l) {
        for (int i = this.listenerWrappers.size() - 1; i >= 0; --i) {
            ListenerWrapper lw = (ListenerWrapper)this.listenerWrappers.elementAt(i);
            if (lw.mouseListener != l) continue;
            this.listenerWrappers.removeElementAt(i);
            this.removeMouseListener(lw.mouseListener);
        }
        super.removeMouseListener(l);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        if (this.scrollbar != null && !this.scrollbar.isOwnListener(l)) {
            l = new ListenerWrapper(l);
            this.listenerWrappers.addElement(l);
        }
        super.addMouseMotionListener(l);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        for (int i = this.listenerWrappers.size() - 1; i >= 0; --i) {
            ListenerWrapper lw = (ListenerWrapper)this.listenerWrappers.elementAt(i);
            if (lw.mouseMotionListener != l) continue;
            this.listenerWrappers.removeElementAt(i);
            this.removeMouseMotionListener(lw.mouseMotionListener);
        }
        super.removeMouseMotionListener(l);
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public synchronized void setRootTreeItem(TreeItem root) {
        this.rootItem = new Item(null, root, true);
        this.loadItems();
        this.repaintForce();
    }

    public synchronized TreeItem getTreeItem(int index) {
        if (index < 0 || index >= this.viewItems.size()) {
            return null;
        }
        return ((Item)this.viewItems.elementAt(index)).data;
    }

    public synchronized int getTreeItemLevel(int index) {
        if (index < 0 || index >= this.viewItems.size()) {
            return -1;
        }
        return ((Item)this.viewItems.elementAt(index)).level + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTreeItemState(int index) {
        Item item = null;
        Tree tree = this;
        synchronized (tree) {
            if (index < 0 || index >= this.viewItems.size()) {
                return -1;
            }
            item = (Item)this.viewItems.elementAt(index);
        }
        if (item.hasChild()) {
            return item.isOpen ? 1 : 2;
        }
        return item.child != null ? 3 : 4;
    }

    public synchronized void removeAll() {
        this.viewItems.removeAllElements();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Tree tree = this;
        synchronized (tree) {
            TreeItem selectedTreeItem = this.getSelectedTreeItem();
            this.rootItem.reset();
            this.loadItems();
            int size = this.viewItems.size();
            for (int i = 0; i < size; ++i) {
                if (((Item)this.viewItems.elementAt(i)).data != selectedTreeItem) continue;
                this.visibleReq = i;
                this.selectedIndex = i;
                selectedTreeItem = null;
                break;
            }
            if (selectedTreeItem != null) {
                this.selectedOldIndex = this.selectedIndex;
                this.moveCurrent(-1, false, false);
            }
        }
        this.repaintForce();
    }

    public synchronized TreeItem getSelectedTreeItem() {
        if (this.selectedIndex < 0 || this.selectedIndex >= this.viewItems.size()) {
            return null;
        }
        return ((Item)this.viewItems.elementAt(this.selectedIndex)).data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selecteIndex(int index) {
        Tree tree = this;
        synchronized (tree) {
            this.moveCurrent(index, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectTreeItem(int[] indices) {
        Tree tree = this;
        synchronized (tree) {
            Vector child;
            int index = -1;
            Item item = this.rootItem;
            int i = 0;
            while (item.hasChild() && (child = item.child).size() > indices[i]) {
                for (int j = 0; j < indices[i]; ++j) {
                    index += this.countOpenItem((Item)child.elementAt(j));
                }
                ++index;
                if (i + 1 >= indices.length || !item.hasChild()) break;
                item = (Item)child.elementAt(indices[i]);
                item.isOpen = true;
                ++i;
            }
            this.loadItems();
            this.moveCurrent(index, false, true);
        }
        this.repaintForce();
    }

    private int countOpenItem(Item item) {
        if (!item.hasChild() || !item.isOpen) {
            return 1;
        }
        int num = 1;
        Vector child = item.child;
        for (int i = child.size() - 1; i >= 0; --i) {
            num += this.countOpenItem((Item)child.elementAt(i));
        }
        return num;
    }

    public synchronized boolean isIndexSelected(int index) {
        return this.selectedIndex == index;
    }

    public synchronized int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex < 0 || this.selectedIndex >= this.viewItems.size()) {
            return null;
        }
        return new TreeItem[]{((Item)this.viewItems.elementAt(this.selectedIndex)).data};
    }

    public int getViewItemCount() {
        return this.viewItems.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openTreeItem(int index) {
        Tree tree = this;
        synchronized (tree) {
            if (index < 0 || index >= this.viewItems.size()) {
                return false;
            }
            if (!this.openItem(index, 2)) {
                return false;
            }
        }
        this.repaintForce();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeTreeItem(int index) {
        Tree tree = this;
        synchronized (tree) {
            if (index < 0 || index >= this.viewItems.size()) {
                return false;
            }
            if (!this.openItem(index, 3)) {
                return false;
            }
        }
        this.repaintForce();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(Graphics g, Dimension size, int state, boolean focus) {
        Color fg = this.getForeground();
        Color bg = this.getBackground();
        int selectedIndex = -1;
        int lineNum = 0;
        int viewNum = 0;
        int drawNum = 0;
        Tree tree = this;
        synchronized (tree) {
            selectedIndex = this.selectedIndex;
            lineNum = this.viewItems.size();
            viewNum = (size.height - 4) / this.rowHeight;
            if (lineNum <= viewNum) {
                this.viewStart = 0;
            } else if (this.visibleReq != -1 && this.visibleReq < this.viewStart) {
                this.viewStart = this.visibleReq;
            } else if (this.visibleReq != -1 && this.visibleReq > this.viewEnd) {
                this.viewStart = Math.max(0, this.visibleReq - viewNum + 1);
            } else if (this.viewStart + viewNum > lineNum) {
                this.viewStart = Math.max(0, lineNum - viewNum);
            }
            drawNum = this.viewEnd = Math.min(this.viewStart + viewNum - 1, lineNum - 1);
            if (drawNum + 1 < lineNum && (size.height - 4) % this.rowHeight > 0) {
                ++drawNum;
            }
            this.visibleReq = -1;
        }
        this.scrollbar.setVisible(this.viewStart > 0 || this.viewEnd < lineNum - 1);
        g.setColor(bg);
        g.fillRect(0, 0, size.width, size.height);
        Color color = fg;
        if (state == 4) {
            color = new Color(new GrayFilter(bg).filterRGB(0, 0, color.getRGB()));
        }
        g.setFont(this.getFont());
        int x = 2;
        int y = 2;
        int w = size.width - 4;
        int h = this.rowHeight;
        if (this.scrollbar.isVisible()) {
            w -= 16;
        }
        int descent = this.fm.getDescent();
        int half = this.boxSize.width / 2 + 2;
        int imageWidth = 0;
        int imageHeight = 0;
        for (int i = this.viewStart; i <= drawNum; ++i) {
            Image image;
            Item item = (Item)this.viewItems.elementAt(i);
            int indent = item.level * (4 + this.boxSize.width);
            boolean selected = this.isIndexSelected(i);
            if (this.isIndexSelected(i)) {
                g.setColor(SystemColor.textHighlight);
                g.fillRect(x, y, w, h);
            }
            g.setColor(selected ? SystemColor.textHighlightText : SystemColor.textInactiveText);
            GraphicsUtils.drawDashed(g, x + indent + half + 1, y + this.rowHeight / 2, half, 1, 1, 1, 1);
            GraphicsUtils.drawDashed(g, x + indent + half, y, 1, item.isLast ? h / 2 : h, 1, 1, 2);
            if (item.hasChild()) {
                this.drawImage(g, selected ? (item.isOpen ? this.openSelectedImage : this.closeSelectedImage) : (item.isOpen ? this.openImage : this.closeImage), x + indent + 2, y + (this.rowHeight - this.boxSize.height) / 2, this.boxSize.width, this.boxSize.height);
            }
            if (item.level > 0) {
                this.drawItemTree(g, item.parent, x, y, h, half);
            }
            if ((image = item.data.getTreeIcon(item.isOpen)) != null && ImageUtils.load(image, this)) {
                imageWidth = image.getWidth(this);
                imageHeight = image.getHeight(this);
                this.drawImage(g, image, x + indent + this.boxSize.width + 6, y, imageWidth, imageHeight);
            } else {
                imageHeight = 0;
                imageWidth = 0;
            }
            g.setColor(this.isIndexSelected(i) ? SystemColor.textHighlightText : color);
            String label = item.data.getTreeLabel();
            if (label != null) {
                g.drawString(label, x + indent + this.boxSize.width + 8 + imageWidth, y + h - 2 - descent);
            } else {
                g.drawLine(x + indent + this.boxSize.width + 8 + imageWidth, y + this.rowHeight / 2, size.width - 2 - 16 - 2 - 1, y + this.rowHeight / 2);
            }
            if (focus && i == selectedIndex) {
                GraphicsUtils.drawDashed(g, x, y, w, 1, 1, 1, 1);
                GraphicsUtils.drawDashed(g, x, y, 1, h, 1, 1, 2);
                GraphicsUtils.drawDashed(g, x, y + h - 1, w, 1, 1, 1, 1);
                GraphicsUtils.drawDashed(g, x + w - 1, y, 1, h, 1, 1, 2);
            }
            y += this.rowHeight;
        }
        Border border = this.getBorder();
        if (border != null) {
            border.draw(g, 0, 0, size.width - 1, size.height - 1, fg);
        } else {
            g.setColor(SystemColor.controlShadow);
            g.drawLine(0, 0, size.width - 1, 0);
            g.drawLine(0, 0, 0, size.height - 1);
            g.setColor(SystemColor.controlDkShadow);
            g.drawLine(1, 1, size.width - 2, 1);
            g.drawLine(1, 1, 1, size.height - 2);
            g.setColor(SystemColor.controlHighlight);
            g.drawLine(size.width - 2, 2, size.width - 2, size.height - 2);
            g.drawLine(2, size.height - 2, size.width - 2, size.height - 2);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(size.width - 1, 1, size.width - 1, size.height - 1);
            g.drawLine(1, size.height - 1, size.width - 1, size.height - 1);
        }
        if (this.scrollbar.isVisible()) {
            this.scrollbar.setBounds(size.width - 2 - 16, 2, 16, size.height - 4);
            this.scrollbar.setValues(this.viewStart, viewNum, 0, lineNum);
            this.scrollbar.setBlockIncrement(Math.max(1, viewNum - 1));
            this.scrollbar.paint(g, true);
        }
    }

    private void drawItemTree(Graphics g, Item item, int x, int y, int h, int half) {
        if (!item.isLast) {
            int indent = item.level * (4 + this.boxSize.width);
            GraphicsUtils.drawDashed(g, x + indent + half, y, 1, h, 1, 1, 2);
        }
        if (item.level > 0) {
            this.drawItemTree(g, item.parent, x, y, h, half);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setViewState(int state) {
        Object object = this.stateLock;
        synchronized (object) {
            if (state != 4) {
                this.stateEnable = state;
            }
            if (!this.isEnabled()) {
                state = 4;
            }
            if (this.stateRequest != state) {
                this.stateRequest = state;
                if (this.isVisible()) {
                    Graphics g = this.getGraphics();
                    if (g != null) {
                        try {
                            this.update(g);
                        }
                        finally {
                            g.dispose();
                        }
                    } else {
                        this.repaint();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveCurrentFromPoint(int x, int y) {
        Tree tree = this;
        synchronized (tree) {
            int index = this.getIndexFromPosition(x, y);
            if (index < 0) {
                return;
            }
            if (this.isBoxFromPosition(index, x, y)) {
                if (!this.openItem(index, 1)) {
                    return;
                }
            } else if (!this.moveCurrent(index, true, true)) {
                return;
            }
        }
        this.repaintForce();
    }

    private boolean moveCurrent(int index, boolean check, boolean move) {
        int size = this.viewItems.size();
        if (check && (index >= size || index == this.selectedIndex)) {
            return false;
        }
        if (this.selectedIndex >= 0 && this.selectedIndex < size) {
            this.postItemEvent(this.selectedIndex, 2);
        }
        if (move) {
            this.visibleReq = index;
        }
        this.selectedIndex = index;
        if (index >= 0) {
            this.postItemEvent(index, 1);
        }
        return true;
    }

    private int getIndexFromPosition(int x, int y) {
        Dimension size = this.getSize();
        if (x <= 2 || size.width - 2 <= x || y <= 2 || size.height - 2 <= y) {
            return -1;
        }
        int index = this.viewStart + (y - 2) / this.rowHeight;
        if (index >= this.viewItems.size()) {
            return -1;
        }
        return index;
    }

    private boolean isBoxFromPosition(int index, int x, int y) {
        int size = this.viewItems.size();
        if (index >= size) {
            return false;
        }
        Item item = (Item)this.viewItems.elementAt(index);
        if (!item.hasChild()) {
            return false;
        }
        int left = 2 + item.level * (4 + this.boxSize.width) + 2;
        int itemY = (y - 2) % this.rowHeight;
        return left <= x && x <= left + this.boxSize.width && 2 <= itemY && itemY <= this.rowHeight - 2;
    }

    private void loadItems() {
        this.viewItems.removeAllElements();
        if (!this.rootItem.hasChild()) {
            return;
        }
        Vector child = this.rootItem.child;
        int size = child.size();
        for (int i = 0; i < size; ++i) {
            this.scanOpenItem((Item)child.elementAt(i), this.viewItems);
        }
    }

    private boolean openItem(int index, int mode) {
        int i;
        int size;
        Item item = (Item)this.viewItems.elementAt(index);
        if (item.child == null) {
            return false;
        }
        if (mode == 2 && item.isOpen || mode == 3 && !item.isOpen) {
            return false;
        }
        int newSelectedIndex = this.selectedIndex;
        int newSize = size = this.viewItems.size();
        if (item.isOpen = !item.isOpen) {
            newSize += item.child.size() * 2;
        }
        Vector v = new Vector(newSize);
        for (i = 0; i < index; ++i) {
            v.addElement(this.viewItems.elementAt(i));
        }
        if (item.isOpen) {
            int start = v.size();
            this.scanOpenItem(item, v);
            if (this.selectedIndex > index) {
                newSelectedIndex += v.size() - start - 1;
            }
        } else {
            v.addElement(item);
            int level = item.level;
            int del = 0;
            while (++del + index < size && ((Item)this.viewItems.elementAt(del + index)).level > level) {
            }
            --del;
            if (this.selectedIndex > index) {
                newSelectedIndex = index + del < this.selectedIndex ? (newSelectedIndex -= del) : index;
            }
            index += del;
        }
        for (i = index + 1; i < size; ++i) {
            v.addElement(this.viewItems.elementAt(i));
        }
        this.viewItems = v;
        if (newSelectedIndex != this.selectedIndex) {
            this.moveCurrent(newSelectedIndex, false, false);
        }
        return true;
    }

    private void scanOpenItem(Item item, Vector v) {
        v.addElement(item);
        if (item.isOpen && item.hasChild()) {
            int size = item.child.size();
            for (int i = 0; i < size; ++i) {
                this.scanOpenItem((Item)item.child.elementAt(i), v);
            }
        }
    }

    private void repaintForce() {
        this.repaintForce = true;
        this.repaint();
    }

    private void initDefaultImage() {
        SystemColor color1 = SystemColor.textInactiveText;
        SystemColor color2 = SystemColor.textText;
        Color color3 = this.getBackground();
        this.boxSize = new Dimension(13, 13);
        this.openImage = this.createImage(BOX_OPEN, this.boxSize.width, this.boxSize.height, color1, color2, color3);
        this.closeImage = this.createImage(BOX_CLOSE, this.boxSize.width, this.boxSize.height, color1, color2, color3);
        color1 = SystemColor.textHighlightText;
        color2 = SystemColor.textHighlightText;
        color3 = SystemColor.textHighlight;
        this.openSelectedImage = this.createImage(BOX_OPEN, this.boxSize.width, this.boxSize.height, color1, color2, color3);
        this.closeSelectedImage = this.createImage(BOX_CLOSE, this.boxSize.width, this.boxSize.height, color1, color2, color3);
        this.resetSize();
    }

    private Image createImage(int[] base, int width, int height, Color color1, Color color2, Color color3) {
        int fg1 = color1.getRGB() | 0xFF000000;
        int fg2 = color2.getRGB() | 0xFF000000;
        int bg = color3.getRGB() | 0xFF000000;
        int[] buffer = new int[base.length];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = base[i] == 1 ? fg1 : (base[i] == 2 ? fg2 : bg);
        }
        MemoryImageSource mis = new MemoryImageSource(width, height, buffer, 0, width);
        mis.setAnimated(false);
        return this.getToolkit().createImage(mis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawImage(Graphics g, Image image, int x, int y, int width, int height) {
        SyncObserver so;
        SyncObserver syncObserver = so = new SyncObserver();
        synchronized (syncObserver) {
            so.init(g, x, y, width, height);
            if (!g.drawImage(image, x, y, width, height, so)) {
                try {
                    so.wait(10000L);
                }
                catch (InterruptedException e) {
                    System.out.println("wait to draw a box");
                }
            }
        }
    }

    private void resetSize() {
        this.rowHeight = this.fm.getHeight() + 4;
        this.setPreferredSize(this.fm.charWidth('0') * this.columns + 4 + (this.boxSize != null ? this.boxSize.width : 0) + 8, this.rowHeight * this.rows + 4);
    }

    public synchronized void addItemListener(ItemListener l) {
        this.enableEvents(512L);
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public synchronized void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(e);
        }
    }

    private void postItemEvent(int index, int stateChange) {
        ItemEvent e = new ItemEvent(this, 3030, ((Item)this.viewItems.elementAt(index)).data, stateChange);
        try {
            this.getToolkit().getSystemEventQueue().postEvent(e);
        }
        catch (SecurityException ex) {
            this.processItemEvent(e);
        }
    }

    private class ListenerWrapper
    implements MouseListener,
    MouseMotionListener {
        private MouseListener mouseListener;
        private MouseMotionListener mouseMotionListener;

        private ListenerWrapper(MouseListener l) {
            this.mouseListener = l;
        }

        private ListenerWrapper(MouseMotionListener l) {
            this.mouseMotionListener = l;
        }

        public void mouseClicked(MouseEvent e) {
            if (!Tree.this.scrollbar.contains(e.getX(), e.getY(), false)) {
                this.mouseListener.mouseClicked(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (!Tree.this.scrollbar.contains(e.getX(), e.getY(), false)) {
                this.mouseListener.mousePressed(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!Tree.this.scrollbar.contains(e.getX(), e.getY(), false)) {
                this.mouseListener.mouseReleased(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (!Tree.this.scrollbar.contains(e.getX(), e.getY(), false)) {
                this.mouseListener.mouseEntered(e);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!Tree.this.scrollbar.contains(e.getX(), e.getY(), false)) {
                this.mouseListener.mouseExited(e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (!Tree.this.scrollbar.contains(e.getX(), e.getY(), true)) {
                this.mouseMotionListener.mouseDragged(e);
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (!Tree.this.scrollbar.contains(e.getX(), e.getY(), false)) {
                this.mouseMotionListener.mouseMoved(e);
            }
        }
    }

    private class Scrollbar
    extends InnerScrollbar {
        private Scrollbar() {
            super(1, Tree.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repaint() {
            if (Tree.this.repaintForce) {
                return;
            }
            Object object = Tree.this.stateLock;
            synchronized (object) {
                Graphics g = Tree.this.getGraphics();
                if (g != null) {
                    try {
                        Rectangle rect = Tree.this.scrollbar.getBounds();
                        Tree.this.scrollbar.paint(Tree.this.offScreenGraphics, true);
                        int x2 = rect.x + rect.width;
                        int y2 = rect.y + rect.height;
                        g.drawImage(Tree.this.offScreenImage, rect.x, rect.y, x2, y2, rect.x, rect.y, x2, y2, Tree.this);
                    }
                    finally {
                        g.dispose();
                    }
                    return;
                }
            }
            Tree.this.repaintForce();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changedValue() {
            Tree tree = Tree.this;
            synchronized (tree) {
                int v = this.getValue();
                if (v == Tree.this.viewStart) {
                    return;
                }
                Tree.this.viewStart = v;
            }
            Tree.this.repaintForce();
        }
    }

    private class Item {
        private int level;
        private Item parent;
        private TreeItem data;
        private Vector child;
        private boolean checkChild;
        private boolean isOpen;
        private boolean isLast;

        private Item(Item parent, TreeItem treeItem, boolean isLast) {
            this.level = parent == null ? -1 : parent.level + 1;
            this.parent = parent;
            this.data = treeItem;
            this.isLast = isLast;
        }

        private boolean hasChild() {
            if (!this.checkChild) {
                Vector v = this.data.getTreeItems();
                if (v != null) {
                    int size = v.size();
                    Vector old = this.child;
                    this.child = new Vector(size);
                    if (old == null) {
                        for (int i = 0; i < size; ++i) {
                            this.child.addElement(new Item(this, (TreeItem)v.elementAt(i), i + 1 == size));
                        }
                    } else {
                        int oldSize = old.size();
                        for (int i = 0; i < size; ++i) {
                            TreeItem treeItem = (TreeItem)v.elementAt(i);
                            Item newItem = new Item(this, treeItem, i + 1 == size);
                            this.child.addElement(newItem);
                            for (int j = 0; j < oldSize; ++j) {
                                Item oldItem = (Item)old.elementAt(j);
                                if (oldItem.data != treeItem) continue;
                                newItem.child = oldItem.child;
                                newItem.isOpen = oldItem.isOpen;
                            }
                        }
                    }
                }
                this.checkChild = true;
            }
            return this.child != null && this.child.size() > 0;
        }

        private void reset() {
            this.checkChild = false;
            if (this.child == null) {
                return;
            }
            for (int i = this.child.size() - 1; i >= 0; --i) {
                ((Item)this.child.elementAt(i)).reset();
            }
        }
    }
}

