/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import java.util.Vector;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.TextManager;
import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.util.CharList;

public class Text {
    private static final char TYPE_MASK = '\u00ff';
    private static final char TYPE_NONE = '1';
    private static final char TYPE_RIGHT = '2';
    private static final char TYPE_LTRB = '3';
    private static final char TYPE_BR = '5';
    private static final char KK_MASK = '\u0f00';
    private static final char KK_OK = '\u0000';
    private static final char KK_NG = '\u0100';
    private static final int MT_WAIT = 10000;
    private ImageCreator imageCreator;
    private Toolkit toolkit;
    private CharList charsSpinRight;
    private CharList charsSpinLtrb;
    private CharList charsKinsokuHead;
    private CharList charsKinsokuTail;
    private FontData fd;
    private Dimension fs;
    private FontMetrics fm;
    private int ff;
    private int fh;
    private int fx;
    private int fz;
    private StringBuffer values = new StringBuffer();
    private StringBuffer types = new StringBuffer();
    private StringBuffer widths = new StringBuffer();
    private StringBuffer heights = new StringBuffer();
    private int nowLength = 0;
    private int nowWidth = 0;
    private int nowHeight = 0;
    private boolean lastPending = false;
    private boolean lastHankakuEisu = false;
    private int p = -1;
    private boolean mastHeight = true;
    private SyncObserver syncObserver = new SyncObserver();
    private Hashtable cacheSize = new Hashtable();
    private Detail cacheZero = new Detail();
    private char c;
    private char s;
    private int i;
    private int w;
    private int h;
    private Detail detail;
    private char[] tateCs = new char[1];

    Text(TextManager manager, FontData fd, String text) {
        this.imageCreator = manager.imageCreator;
        this.toolkit = this.imageCreator.getToolkit();
        this.charsSpinRight = manager.charsSpinRight;
        this.charsSpinLtrb = manager.charsSpinLtrb;
        this.charsKinsokuHead = manager.charsKinsokuHead;
        this.charsKinsokuTail = manager.charsKinsokuTail;
        this.fd = fd;
        this.fs = fd.getFullSize();
        this.fm = fd.getFontMetrics();
        this.ff = fd.getFullBase();
        this.fh = fd.getHalfBase();
        this.fx = fd.getHalfHeight();
        this.fz = fd.getMaxHeight();
        this.append(text, 0, text.length());
        if (this.nowLength > 0) {
            this.newLine();
        }
    }

    private void append(String text, int begin, int end) {
        this.i = begin;
        while (this.i < end) {
            this.c = text.charAt(this.i);
            if (this.c == '\n') {
                this.commit();
                this.append(this.c, '5', false);
                this.newLine();
            } else if ('0' <= this.c && this.c <= '9' || 'A' <= this.c && this.c <= 'Z' || 'a' <= this.c && this.c <= 'z') {
                if (!this.lastHankakuEisu) {
                    this.commit();
                }
                this.append(this.c, '2', true);
                this.lastHankakuEisu = true;
            } else {
                this.lastHankakuEisu = false;
                this.s = (char)49;
                if (this.c <= '\u00ff' || '\uff61' <= this.c && this.c <= '\uff9f' || this.charsSpinRight.contains(this.c)) {
                    this.s = (char)50;
                } else if (this.charsSpinLtrb.contains(this.c)) {
                    this.s = (char)51;
                }
                if (this.charsKinsokuHead.contains(this.c)) {
                    this.append(this.c, this.s, true);
                } else if (this.charsKinsokuTail.contains(this.c)) {
                    this.commit();
                    this.append(this.c, this.s, false);
                } else {
                    this.commit();
                    this.append(this.c, this.s, true);
                }
            }
            ++this.i;
        }
    }

    private void append(char c, char s, boolean pending) {
        if (pending) {
            if (this.lastPending) {
                this.types.setCharAt(this.p, (char)(this.types.charAt(this.p) | 0x100));
            } else {
                this.lastPending = true;
            }
        }
        this.w = this.calculateWidth(c, s);
        this.h = this.calculateHeight(c, s);
        this.values.append(c);
        this.types.append(s);
        this.widths.append((char)this.w);
        this.heights.append((char)this.h);
        ++this.p;
        ++this.nowLength;
        this.nowWidth = Math.max(this.nowWidth, this.w);
        this.nowHeight += this.h;
    }

    private void commit() {
        if (this.lastPending) {
            this.lastPending = false;
        }
    }

    private int calculateWidth(char c, char s) {
        switch (s) {
            case '2': 
            case '3': {
                return c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? this.fx : this.fs.width;
            }
        }
        return this.fm.charWidth(c);
    }

    private int calculateHeight(char c, char s) {
        switch (s) {
            case '2': 
            case '3': {
                return this.fm.charWidth(c);
            }
        }
        return this.fs.height;
    }

    private void newLine() {
        this.cacheZero.addLine(this.nowLength, this.nowWidth, this.nowHeight);
        this.nowLength = 0;
        this.nowWidth = 0;
        this.nowHeight = 0;
    }

    public Dimension getSize(int maxHeight) {
        return new Dimension(this.getDatail(maxHeight).size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Detail getDatail(int maxHeight) {
        if (maxHeight <= 0) {
            return this.cacheZero;
        }
        Hashtable hashtable = this.cacheSize;
        synchronized (hashtable) {
            Integer key = new Integer(maxHeight);
            this.detail = (Detail)this.cacheSize.get(key);
            if (this.detail != null) {
                return this.detail;
            }
            this.detail = new Detail();
            this.cacheSize.put(key, this.detail);
            char w = '\u0000';
            char h = '\u0000';
            int pl = 0;
            int pw = 0;
            int ph = 0;
            int cl = 0;
            int cw = 0;
            int ch = 0;
            this.i = 0;
            while (this.i <= this.p) {
                this.s = this.types.charAt(this.i);
                w = this.widths.charAt(this.i);
                h = this.heights.charAt(this.i);
                if (this.mastHeight && ch + ph + h > maxHeight) {
                    if (cl > 0) {
                        this.detail.addLine(cl, cw, ch);
                        ch = 0;
                        cw = 0;
                        cl = 0;
                    }
                    if (ph + h > maxHeight) {
                        this.detail.addLine(pl, pw, ph);
                        ph = 0;
                        pw = 0;
                        pl = 0;
                    }
                }
                if ((this.s & 0xF00) == 256) {
                    ++pl;
                    pw = Math.max(pw, w);
                    ph += h;
                } else {
                    if (pl > 0) {
                        ++pl;
                        pw = Math.max(pw, w);
                        if (!this.mastHeight && ch + (ph += h) > maxHeight) {
                            if (cl > 0) {
                                this.detail.addLine(cl, cw, ch);
                            }
                            cl = pl;
                            cw = pw;
                            ch = ph;
                        } else {
                            cl += pl;
                            cw = Math.max(cw, pw);
                            ch += ph;
                        }
                        ph = 0;
                        pw = 0;
                        pl = 0;
                    } else if (!this.mastHeight && ch + h > maxHeight) {
                        if (cl > 0) {
                            this.detail.addLine(cl, cw, ch);
                        }
                        cl = 1;
                        cw = w;
                        ch = h;
                    } else {
                        ++cl;
                        cw = Math.max(cw, w);
                        ch += h;
                    }
                    if (this.s == '5') {
                        this.detail.addLine(cl, cw, ch);
                        ch = 0;
                        cw = 0;
                        cl = 0;
                    }
                }
                ++this.i;
            }
            if (cl > 0) {
                this.detail.addLine(cl, cw, ch);
            }
            return this.detail;
        }
    }

    public void draw(Graphics g, int x, int y, int height) {
        this.detail = this.getDatail(height);
        int bx = x;
        int by = y;
        int begin = 0;
        Line line = null;
        int ln = -1;
        int lc = 0;
        this.i = 0;
        while (this.i <= this.p) {
            if (lc == 0) {
                if (x <= 0) break;
                line = (Line)this.detail.lines.elementAt(++ln);
                lc = line.length;
                x -= line.width;
                y = by;
            }
            this.s = (char)(this.types.charAt(this.i) & 0xFF);
            this.w = this.widths.charAt(this.i);
            this.h = this.heights.charAt(this.i);
            switch (this.s) {
                case '1': {
                    this.tateCs[0] = this.values.charAt(this.i);
                    g.drawChars(this.tateCs, 0, 1, this.fs.width > this.w ? x + (this.fs.width - this.w) / 2 : x, y + this.ff);
                    y += this.h;
                    --lc;
                    ++this.i;
                    break;
                }
                case '2': 
                case '3': {
                    begin = this.i;
                    while (true) {
                        ++this.i;
                        if (--lc == 0 || (this.types.charAt(this.i) & 0xFF) != this.s) break;
                        this.w = Math.max(this.w, this.widths.charAt(this.i));
                        this.h += this.heights.charAt(this.i);
                    }
                    this.drawTextWithSpin(g, begin, this.i, x, y, this.w, this.h, this.s);
                    y += this.h;
                    break;
                }
                case '5': {
                    --lc;
                    ++this.i;
                }
            }
        }
    }

    private void drawTextWithSpin(Graphics g, int begin, int end, int x, int y, int width, int height, char type) {
        if (height == 0) {
            return;
        }
        Color backColor = Color.white;
        Color foreColor = Color.black;
        Image scrap = null;
        Graphics sg = null;
        try {
            scrap = this.imageCreator.createImage(height, width);
            sg = scrap.getGraphics();
        }
        catch (IllegalArgumentException e) {
            System.out.println("e=[" + this.values + "],[" + begin + "],[" + end + "],[" + height + "],[" + width + "]");
            return;
        }
        catch (NegativeArraySizeException e) {
            System.out.println("e=[" + this.values + "],[" + begin + "],[" + end + "],[" + height + "],[" + width + "]");
            return;
        }
        sg.setColor(backColor);
        sg.fillRect(0, 0, height, width);
        sg.setColor(foreColor);
        sg.setFont(this.fd.getFont());
        int base = 0;
        if (type == '3') {
            base = this.ff + (this.fs.height - this.ff) / 2;
        }
        int scrapX = 0;
        for (int i = begin; i < end; ++i) {
            char c;
            this.tateCs[0] = c = this.values.charAt(i);
            if (type == '2') {
                base = c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? this.fh : this.ff;
            }
            sg.drawChars(this.tateCs, 0, 1, scrapX, base);
            scrapX += this.heights.charAt(i);
        }
        sg.dispose();
        int[] bitmap1 = new int[width * height];
        int[] bitmap2 = new int[width * height];
        PixelGrabber pg = new PixelGrabber(scrap, 0, 0, height, width, bitmap1, 0, height);
        try {
            pg.grabPixels(10000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        switch (type) {
            case '2': {
                int scrapY;
                for (scrapX = 0; scrapX < height; ++scrapX) {
                    for (scrapY = 0; scrapY < width; ++scrapY) {
                        bitmap2[scrapX * width + scrapY] = bitmap1[scrapX + (width - scrapY - 1) * height];
                    }
                }
                break;
            }
            case '3': {
                int scrapY;
                for (scrapX = 0; scrapX < height; ++scrapX) {
                    for (scrapY = 0; scrapY < width; ++scrapY) {
                        bitmap2[scrapX * width + scrapY] = bitmap1[scrapX + scrapY * height];
                    }
                }
                break;
            }
        }
        int bcc = backColor.getRGB();
        int fcc = g.getColor().getRGB() | 0xFF000000;
        for (int i = 0; i < bitmap2.length; ++i) {
            if (bitmap2[i] == bcc) {
                int n = i;
                bitmap2[n] = bitmap2[n] & 0xFFFFFF;
                continue;
            }
            bitmap2[i] = fcc;
        }
        MemoryImageSource mis = new MemoryImageSource(width, height, bitmap2, 0, width);
        mis.setAnimated(false);
        Image image = this.toolkit.createImage(mis);
        this.drawImageSync(g, image, x, y, width, height);
        scrap.flush();
        image.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawImageSync(Graphics g, Image image, int x, int y, int width, int height) {
        SyncObserver syncObserver = this.syncObserver;
        synchronized (syncObserver) {
            this.syncObserver.init(g, x, y, width, height);
            if (!g.drawImage(image, x, y, width, height, this.syncObserver)) {
                try {
                    this.syncObserver.wait(10000L);
                }
                catch (InterruptedException e) {
                    System.out.println("wait to draw a text");
                }
            }
        }
    }

    public void dispose() {
    }

    private class Line {
        private int length;
        private int width;
        private int height;

        private Line(int length, int width, int height) {
            this.length = length;
            this.width = width;
            this.height = height;
        }
    }

    private class Detail {
        private Dimension size = new Dimension();
        private Vector lines = new Vector();

        private Detail() {
        }

        private void addLine(int length, int width, int height) {
            width = Math.max(width, Text.this.fz);
            this.lines.addElement(new Line(length, width, height));
            this.size.width += width;
            this.size.height = Math.max(this.size.height, height);
        }
    }
}

