/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import java.util.Vector;
import net.hizlab.kagetaka.awt.SizedComponent;

public class SizedLabel
extends SizedComponent {
    private String text;
    private Vector lines = new Vector();
    private int height;
    private int descent;

    public SizedLabel(String text) {
        this.setText(text);
    }

    public SizedLabel() {
    }

    public synchronized void setText(String text) {
        this.text = text;
        this.calculateHeight();
        this.repaint();
    }

    public synchronized String getText() {
        return this.text;
    }

    public synchronized void setFont(Font f) {
        super.setFont(f);
        this.calculateHeight();
    }

    public void addNotify() {
        super.addNotify();
        this.calculateHeight();
    }

    public synchronized void paint(Graphics g) {
        if (this.lines.size() == 0) {
            return;
        }
        Dimension size = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        int y = this.height - this.descent;
        int i = 0;
        while (i < this.lines.size()) {
            g.drawString((String)this.lines.elementAt(i), 0, y);
            ++i;
            y += this.height;
        }
    }

    private void calculateHeight() {
        this.lines.removeAllElements();
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(font);
        this.height = fm.getHeight();
        this.descent = fm.getDescent();
        Dimension size = new Dimension(0, 0);
        if (this.text == null) {
            return;
        }
        boolean lastCr = false;
        boolean lastText = false;
        String line = null;
        StringTokenizer st = new StringTokenizer(this.text, "\n\r", true);
        while (st.hasMoreTokens()) {
            line = st.nextToken();
            if (line.compareTo("\n") == 0) {
                lastCr = true;
                if (lastText) {
                    lastText = false;
                    continue;
                }
                line = "";
            } else if (line.compareTo("\r") == 0) {
                if (lastCr) {
                    lastCr = false;
                    continue;
                }
                if (lastText) {
                    lastText = false;
                    continue;
                }
                line = "";
            } else {
                lastCr = false;
                lastText = true;
            }
            size.width = Math.max(size.width, fm.stringWidth(line));
            size.height += this.height;
            this.lines.addElement(line);
        }
        this.size = size;
        this.invalidate();
    }
}

