/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.Icon;
import net.hizlab.kagetaka.awt.SizedLabel;

public class MessageBox
extends DialogBox {
    private static final String RESOURCE = "net.hizlab.kagetaka.awt.Resource";
    private static final int MARGIN = 10;
    public static final int BUTTON_OK = 0;
    public static final int BUTTON_OKCANCEL = 1;
    public static final int BUTTON_YESNO = 3;
    public static final int BUTTON_YESNOCANCEL = 4;
    public static final int DEFAULT_BUTTON1 = 0;
    public static final int DEFAULT_BUTTON2 = 16;
    public static final int DEFAULT_BUTTON3 = 32;
    public static final int ICON_EXCLAMATION = 65536;
    public static final int ICON_QUESTION = 131072;
    public static final int ICON_INFORMATION = 196608;
    public static final int ICON_STOP = 262144;
    protected static final int MASK_ICON = 983040;
    private GridBagLayout gbl;
    private SizedLabel message;
    private Icon icon;

    public static int show(Frame owner, String message, String title, int mode) {
        MessageBox messageBox = new MessageBox(owner);
        messageBox.setMessage(message);
        messageBox.setTitle(title);
        messageBox.setMode(mode);
        messageBox.show();
        return messageBox.getResult();
    }

    public MessageBox(Frame owner) {
        super(owner, 0);
        this.setResizable(false);
        this.setModal(true);
        this.gbl = new GridBagLayout();
        this.mainPanel.setLayout(this.gbl);
        this.message = new SizedLabel();
        this.addToPanel(this.message, this.gbl, 1, 0, 1, 1, 1.0, 1.0, 1, 17, new Insets(10, 10, 10, 10));
        KeyAdapter keyListener = null;
        keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 67) {
                    Clipboard clipboard = MessageBox.this.getToolkit().getSystemClipboard();
                    StringSelection data = new StringSelection(MessageBox.this.message.getText());
                    clipboard.setContents(data, data);
                    e.consume();
                }
            }
        };
        this.addButtonKeyListener(keyListener);
        this.addKeyListener(keyListener);
        this.message.setFont(this.getFont());
        this.pack();
    }

    public String getMessage() {
        return this.message.getText();
    }

    public void setMessage(String value) {
        this.message.setText(value);
        this.pack();
    }

    public void setMode(int value) {
        super.setMode(value);
        if (this.icon != null) {
            this.remove(this.icon);
        }
        if ((value & 0xF0000) != 0) {
            switch (value & 0xF0000) {
                case 65536: {
                    this.icon = new Icon(1);
                    break;
                }
                case 131072: {
                    this.icon = new Icon(2);
                    break;
                }
                case 196608: {
                    this.icon = new Icon(3);
                    break;
                }
                case 262144: {
                    this.icon = new Icon(4);
                }
            }
            this.addToPanel(this.icon, this.gbl, 0, 0, 1, 1, 0.0, 1.0, 3, 10, new Insets(10, 10, 10, 10));
        } else {
            this.icon = null;
        }
        this.pack();
    }
}

