/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.Icon;
import net.hizlab.kagetaka.awt.SizedLabel;

public class InputBox
extends DialogBox {
    private static final int MARGIN = 10;
    private SizedLabel message;
    private Icon icon;
    private TextField text;
    private boolean fixedSize;

    public static String show(Frame owner, String message, String title, String text) {
        InputBox dialog = new InputBox(owner);
        dialog.setMessage(message);
        dialog.setTitle(title);
        dialog.setText(text);
        dialog.show();
        if (dialog.getResult() != 0) {
            return null;
        }
        return dialog.getText();
    }

    public InputBox(Frame owner) {
        super(owner, 1);
        this.setResizable(false);
        this.setModal(true);
        GridBagLayout gbl = new GridBagLayout();
        Insets insets = new Insets(10, 10, 10, 10);
        this.mainPanel.setLayout(gbl);
        this.icon = new Icon(2);
        this.addToPanel(this.icon, gbl, 0, 0, 1, 2, 0.0, 1.0, 3, 10, insets);
        this.message = new SizedLabel();
        this.addToPanel(this.message, gbl, 1, 0, 1, 1, 1.0, 1.0, 1, 17, insets);
        this.text = new TextField(40);
        this.addToPanel(this.text, gbl, 1, 1, 1, 1, 1.0, 0.0, 2, 10, insets);
        KeyAdapter keyListener = null;
        keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getSource() instanceof TextField) {
                    return;
                }
                if (e.isControlDown() && e.getKeyCode() == 67) {
                    Clipboard clipboard = InputBox.this.getToolkit().getSystemClipboard();
                    StringSelection data = new StringSelection(InputBox.this.message.getText());
                    clipboard.setContents(data, data);
                    e.consume();
                }
            }
        };
        this.addButtonKeyListener(keyListener);
        this.addKeyListener(keyListener);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                if (InputBox.this.fixedSize) {
                    return;
                }
                Dimension preferredSize = InputBox.this.message.getPreferredSize();
                Dimension messageSize = InputBox.this.message.getSize();
                if (preferredSize.height <= messageSize.height) {
                    return;
                }
                InputBox.this.fixedSize = true;
                InputBox.this.pack();
            }
        });
        this.message.setFont(this.getFont());
        this.pack();
    }

    public String getMessage() {
        return this.message.getText();
    }

    public void setMessage(String value) {
        this.message.setText(value);
        this.pack();
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String value) {
        ((TextComponent)this.text).setText(value);
    }
}

