/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ImageUtils;
import net.hizlab.kagetaka.awt.SizedComponent;

public class Icon
extends SizedComponent {
    private static final String RESOURCE = "net.hizlab.kagetaka.awt.Resource";
    public static final int EXCLAMATION = 1;
    public static final int QUESTION = 2;
    public static final int INFORMATION = 3;
    public static final int STOP = 4;
    private Image image;

    public Icon(int type) {
        this.image = this.getImage(type);
        if (this.image == null) {
            return;
        }
        this.size = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public void paint(Graphics g) {
        if (this.image == null) {
            return;
        }
        Dimension nowSize = this.getSize();
        g.drawImage(this.image, (nowSize.width - this.size.width) / 2, (nowSize.height - this.size.height) / 2, this);
    }

    private Image getImage(int type) {
        String name = "icon.";
        switch (type) {
            case 1: {
                name = name + "warn";
                break;
            }
            case 2: {
                name = name + "question";
                break;
            }
            case 3: {
                name = name + "inform";
                break;
            }
            case 4: {
                name = name + "error";
            }
        }
        Image image = Resource.getImageResource(RESOURCE, name, this.getToolkit());
        if (image == null || !ImageUtils.load(image, this)) {
            return null;
        }
        return image;
    }
}

