/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.SystemColor;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.Tree;
import net.hizlab.kagetaka.awt.TreeItem;
import net.hizlab.kagetaka.java2.IOWrapper;
import net.hizlab.kagetaka.util.Environment;

public class DirectoryDialog
extends DialogBox {
    private static final int MARGIN = 3;
    private Label message;
    private Tree tree;
    private Item root;

    public static String show(Frame owner, String title, String message, String path) {
        DirectoryDialog dialog = new DirectoryDialog(owner, title, message);
        dialog.setPath(path);
        dialog.show();
        if (dialog.getResult() != 0) {
            return null;
        }
        return dialog.getPath();
    }

    public DirectoryDialog(Frame parent) {
        this(parent, null, null);
    }

    public DirectoryDialog(Frame parent, String title, String message) {
        super(parent, 257);
        this.setTitle(title);
        this.setResizable(false);
        this.setModal(true);
        GridBagLayout gbl = new GridBagLayout();
        Insets insets = new Insets(0, 0, 0, 0);
        this.mainPanel.setLayout(gbl);
        this.message = new Label(message);
        this.addToPanel(this.message, gbl, 0, 0, 1, 1, 1.0, 0.0, 2, 17, insets);
        insets.top = 3;
        this.tree = new Tree(10, 35);
        this.addToPanel(this.tree, gbl, 0, 1, 1, 1, 1.0, 1.0, 1, 17, insets);
        this.root = new Item(null, false);
        this.tree.setRootTreeItem(this.root);
        this.tree.setBackground(SystemColor.window);
        this.pack();
    }

    public String getMessage() {
        return this.message.getText();
    }

    public void setMessage(String message) {
        this.message.setText(message);
    }

    public String getPath() {
        Item item = (Item)this.tree.getSelectedTreeItem();
        if (item != null) {
            return item.path.getPath();
        }
        return null;
    }

    public void setPath(String path) {
        int i;
        if (path == null) {
            this.tree.selecteIndex(-1);
            return;
        }
        try {
            path = new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (path.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(path, File.separator);
        Vector<Integer> list = new Vector<Integer>();
        Item item = this.root;
        if (path.charAt(0) == File.separatorChar) {
            item = (Item)item.getTreeItems().elementAt(0);
            list.addElement(new Integer(0));
        }
        block2: while (st.hasMoreTokens()) {
            String s = st.nextToken();
            Vector v = item.getTreeItems();
            for (i = v.size() - 1; i >= 0; --i) {
                Item in = (Item)v.elementAt(i);
                if (s.compareTo(in.getTreeLabel()) != 0) continue;
                list.addElement(new Integer(i));
                item = in;
                continue block2;
            }
        }
        if (list.size() > 0) {
            int[] indices = new int[list.size()];
            for (i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)list.elementAt(i);
            }
            this.tree.selectTreeItem(indices);
        }
    }

    private class Item
    implements TreeItem {
        private File path;
        private boolean root;
        private Vector items;

        private Item(File path, boolean root) {
            this.path = path;
            this.root = root;
        }

        public Image getTreeIcon(boolean opened) {
            return null;
        }

        public String getTreeLabel() {
            if (this.root) {
                if (Environment.isWindows) {
                    return this.path.getPath().substring(0, 2);
                }
                return this.path.getPath();
            }
            if (this.path != null) {
                return this.path.getName();
            }
            return "root";
        }

        public Vector getTreeItems() {
            if (this.items != null) {
                return this.items;
            }
            this.items = new Vector();
            if (this.path != null) {
                String[] lists = this.path.list();
                if (lists != null) {
                    int length = lists.length;
                    for (int i = 0; i < length; ++i) {
                        File file = new File(this.path, lists[i]);
                        if (!file.isDirectory()) continue;
                        this.items.addElement(new Item(file, false));
                    }
                }
            } else {
                IOWrapper wrapper = IOWrapper.getInstance();
                if (wrapper != null) {
                    File[] lists = wrapper.listRoots();
                    if (lists != null) {
                        for (int i = 0; i < lists.length; ++i) {
                            this.items.addElement(new Item(lists[i], true));
                        }
                    }
                } else if (Environment.isWindows) {
                    for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                        File file = new File(c + ":\\");
                        if (!file.exists()) continue;
                        this.items.addElement(new Item(file, true));
                    }
                } else {
                    this.items.addElement(new Item(new File("/"), true));
                }
            }
            return this.items;
        }
    }
}

