/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Button;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DirectoryDialog;
import net.hizlab.kagetaka.io.PathAbsoluter;

public class BrowseButton
extends Button {
    private static final String RESOURCE = "net.hizlab.kagetaka.awt.Resource";
    public static final int DIRECTORY = 1;
    public static final int FILE = 2;
    private static String label = Resource.getMessage("net.hizlab.kagetaka.awt.Resource", "browsebutton.label", null);
    private int type;
    private TextField text;
    private String title;
    private String message;
    private FilenameFilter filter;
    private PathAbsoluter absoluter;
    protected Dimension size;

    public BrowseButton(int type, TextField text) {
        super(label);
        this.type = type;
        this.text = text;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Container parent = BrowseButton.this.getParent();
                if (parent == null) {
                    return;
                }
                while (!(parent instanceof Frame)) {
                    if ((parent = parent.getParent()) != null) continue;
                    return;
                }
                String title = BrowseButton.this.title;
                String fileName = BrowseButton.this.text.getText();
                File file = null;
                if (fileName.length() > 0) {
                    file = new File(fileName);
                    if (BrowseButton.this.absoluter != null) {
                        file = BrowseButton.this.absoluter.convertRelativeToCanonical(file);
                    }
                }
                switch (BrowseButton.this.type) {
                    case 1: {
                        String message;
                        if (title == null) {
                            title = Resource.getMessage(BrowseButton.RESOURCE, "browsebutton.directory.title", null);
                        }
                        if ((message = BrowseButton.this.message) == null) {
                            message = Resource.getMessage(BrowseButton.RESOURCE, "browsebutton.directory.message", null);
                        }
                        fileName = DirectoryDialog.show((Frame)parent, title, message, file != null ? file.getPath() : null);
                        break;
                    }
                    case 2: {
                        if (title == null) {
                            title = Resource.getMessage(BrowseButton.RESOURCE, "browsebutton.file.title", null);
                        }
                        FileDialog fd = new FileDialog((Frame)parent, title);
                        if (file != null) {
                            fd.setDirectory(file.getParent());
                            fd.setFile(file.getName());
                        }
                        if (BrowseButton.this.filter != null) {
                            fd.setFilenameFilter(BrowseButton.this.filter);
                        }
                        fd.show();
                        fileName = fd.getFile();
                        if (fileName == null) break;
                        fileName = fd.getDirectory() + fileName;
                    }
                }
                if (fileName != null) {
                    file = new File(fileName);
                    if (BrowseButton.this.absoluter != null) {
                        file = BrowseButton.this.absoluter.convertCanonicalToRelative(file);
                    }
                    ((TextComponent)BrowseButton.this.text).setText(file.getPath());
                }
            }
        });
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public void setFilenameFilter(FilenameFilter filter) {
        this.filter = filter;
    }

    public PathAbsoluter getPathAbsoluter() {
        return this.absoluter;
    }

    public void setPathAbsoluter(PathAbsoluter absoluter) {
        this.absoluter = absoluter;
    }
}

