/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.SystemColor;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import net.hizlab.kagetaka.awt.CustomContainer;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.QuietPanel;

public class BorderContainer
extends CustomContainer {
    private static final int BORDER = 5;
    private static final int MARGIN = 8;
    private Component component;
    private Label label;
    private Checkbox checkbox;
    private Container mainPanel;

    public BorderContainer(String label) {
        this.label = new Label(label);
        this.component = this.label;
        this.initialize();
    }

    public BorderContainer(Checkbox checkbox) {
        this.checkbox = checkbox;
        this.component = this.checkbox;
        checkbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                BorderContainer.this.mainPanel.setEnabled(BorderContainer.this.checkbox.getState());
            }
        });
        this.initialize();
        this.mainPanel.setEnabled(checkbox.getState());
    }

    private void initialize() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.mainPanel = new MainPanel();
        Insets insets = new Insets(0, 13, 2, 5);
        LayoutUtils.addGridBag(this, this.component, gbl, 0, 0, 1, 1, 0.0, 0.0, 0, 17, insets);
        insets.bottom = 5;
        LayoutUtils.addGridBag(this, this.mainPanel, gbl, 0, 1, 1, 1, 1.0, 1.0, 1, 10, insets);
        this.setBaseContainer(this.mainPanel);
        this.addListenerComponent(this.component);
        this.addListenerComponent(this.mainPanel);
        this.addListenerContainer(this.mainPanel);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        Dimension cSize = this.component.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        int height = cSize.height / 2;
        int right = 13 + cSize.width;
        g.setColor(SystemColor.controlShadow);
        g.drawLine(1, height, 1, size.height - 3);
        g.drawLine(1, height, 5, height);
        g.drawLine(right, height, size.width - 3, height);
        g.drawLine(1, size.height - 3, size.width - 3, size.height - 3);
        g.drawLine(size.width - 3, height, size.width - 3, size.height - 3);
        g.setColor(SystemColor.controlLtHighlight);
        g.drawLine(2, height + 1, 2, size.height - 4);
        g.drawLine(2, height + 1, 5, height + 1);
        g.drawLine(right, height + 1, size.width - 4, height + 1);
        g.drawLine(2, size.height - 2, size.width - 2, size.height - 2);
        g.drawLine(size.width - 2, height + 1, size.width - 2, size.height - 2);
        this.paintComponents(g);
    }

    private class MainPanel
    extends QuietPanel
    implements ContainerListener {
        private Hashtable components = new Hashtable();

        private MainPanel() {
            this.addContainerListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEnabled(boolean b) {
            Component[] cs = this.getComponents();
            boolean enabled = this.isEnabled();
            if (b == enabled) {
                return;
            }
            Hashtable hashtable = this.components;
            synchronized (hashtable) {
                if (b) {
                    for (int i = 0; i < cs.length; ++i) {
                        Boolean bool = (Boolean)this.components.get(cs[i]);
                        if (bool == null) continue;
                        cs[i].setEnabled(bool);
                    }
                    this.components.clear();
                } else {
                    for (int i = 0; i < cs.length; ++i) {
                        this.components.put(cs[i], cs[i].isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                        cs[i].setEnabled(false);
                    }
                }
            }
            super.setEnabled(b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentAdded(ContainerEvent e) {
            Hashtable hashtable = this.components;
            synchronized (hashtable) {
                if (!this.isEnabled()) {
                    Component c;
                    this.components.put(c, (c = e.getChild()).isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                    c.setEnabled(false);
                }
            }
        }

        public void componentRemoved(ContainerEvent e) {
            this.components.remove(e.getChild());
        }
    }
}

