/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import net.hizlab.kagetaka.util.Environment;

public class Resource {
    private static final int BUFFER_SIZE = 16384;
    private static final String BUILD_RESOURCE = "net.hizlab.kagetaka.Build";
    private static String[] localeList;
    private static Entry base;
    private static Hashtable entryCache;
    private static Hashtable bytesCache;
    static /* synthetic */ Class class$net$hizlab$kagetaka$Resource;

    private Resource() {
    }

    public static String getMessage(String key, Object[] args) {
        return Resource.base.getMessage(key, args, false, null);
    }

    public static String getMessage(String key, Object[] args, String def) {
        return Resource.base.getMessage(key, args, true, def);
    }

    public static String getMessage(String path, String key, Object[] args) {
        return Resource.getEntry(path).getMessage(key, args, false, null);
    }

    public static String getMessage(String path, String key, Object[] args, String def) {
        return Resource.getEntry(path).getMessage(key, args, true, def);
    }

    public static byte[] getBinaryResource(String key) {
        return Resource.base.getBinaryResource(key);
    }

    public static byte[] getBinaryResource(String path, String key) {
        return Resource.getEntry(path).getBinaryResource(key);
    }

    public static Image getImageResource(String key, Toolkit tk) {
        return Resource.base.getImageResource(key, tk);
    }

    public static Image getImageResource(String path, String key, Toolkit tk) {
        return Resource.getEntry(path).getImageResource(key, tk);
    }

    private static Entry getEntry(String path) {
        Entry entry = (Entry)entryCache.get(path);
        if (entry == null) {
            entry = new Entry(path);
            entryCache.put(path, entry);
        }
        return entry;
    }

    private static InputStream getInputStream(String path) {
        try {
            ClassLoader cl = (class$net$hizlab$kagetaka$Resource == null ? (class$net$hizlab$kagetaka$Resource = Resource.class$("net.hizlab.kagetaka.Resource")) : class$net$hizlab$kagetaka$Resource).getClassLoader();
            if (cl != null) {
                return cl.getResourceAsStream(path);
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            return ClassLoader.getSystemResourceAsStream(path);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private static String convertMessage(String key, Object[] args, boolean assign, String def) {
        if (assign) {
            if (def == null || args == null) {
                return def;
            }
            return MessageFormat.format(def, args);
        }
        if (args == null) {
            return key;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(key);
        for (int i = 0; i < args.length; ++i) {
            sb.append(", ");
            sb.append(args[i]);
        }
        return sb.toString();
    }

    private static String convertPathToClass(String path, char last, String prefix) {
        int p = path.lastIndexOf(last) + 1;
        return path.substring(0, p) + prefix + path.substring(p);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (Environment.isApplet) {
            Vector<String> v = new Vector<String>();
            Locale locale = Locale.getDefault();
            String variant = locale.getVariant();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            if (variant != null && variant.length() > 0) {
                v.addElement("_" + language + "_" + country + "_" + variant);
            }
            if (country != null && country.length() > 0) {
                v.addElement("_" + language + "_" + country);
            }
            if (language != null && language.length() > 0 && language.compareTo("ja") != 0) {
                v.addElement("_" + language);
            }
            v.addElement("");
            localeList = new String[v.size()];
            v.copyInto(localeList);
        } else {
            localeList = null;
        }
        entryCache = new Hashtable();
        bytesCache = new Hashtable();
        String path = (class$net$hizlab$kagetaka$Resource == null ? (class$net$hizlab$kagetaka$Resource = Resource.class$("net.hizlab.kagetaka.Resource")) : class$net$hizlab$kagetaka$Resource).getName();
        base = new Entry(path);
        entryCache.put(path, base);
    }

    private static class Bytes {
        private static final String CLASS_PREFIX = "_I";
        private byte[] data;

        private Bytes(String path) {
            if (Environment.isApplet) {
                ResourceBundle r = null;
                String fixedPath = path;
                int p = path.lastIndexOf(46);
                if (p != -1) {
                    fixedPath = path.substring(0, p);
                }
                String className = fixedPath = Resource.convertPathToClass(fixedPath, '/', CLASS_PREFIX);
                try {
                    r = (ResourceBundle)Class.forName(className).newInstance();
                    this.data = (byte[])r.getObject("data");
                    return;
                }
                catch (MissingResourceException e) {
                    System.out.println("Can not get binary resource from class `" + className + "' (" + e + ")");
                }
                catch (Throwable e) {
                    System.out.println("Can not create binary resource class `" + className + "' (" + e + ")");
                }
            }
            try {
                InputStream is = Resource.getInputStream(path);
                if (is == null) {
                    return;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
                byte[] buffer = new byte[16384];
                int length = 0;
                while ((length = is.read(buffer, 0, 16384)) != -1) {
                    baos.write(buffer, 0, length);
                }
                baos.flush();
                this.data = baos.toByteArray();
                is.close();
                ((OutputStream)baos).close();
            }
            catch (IOException e) {
                System.out.println("Can not load binary resource file `" + path + "' (" + e + ")");
            }
        }
    }

    private static class Entry {
        private static final String CLASS_PREFIX = "_R";
        private ResourceBundle messageResource;
        private Hashtable messageFormat = new Hashtable();
        private Entry parent;

        private Entry(String path) {
            ResourceBundle r = null;
            if (Environment.isApplet) {
                int i = 0;
                if (path.startsWith("net.hizlab.kagetaka.util.") || path.startsWith("net.hizlab.kagetaka.java2.") || path.compareTo(Resource.BUILD_RESOURCE) == 0) {
                    i = localeList.length - 1;
                }
                while (i < localeList.length) {
                    String className = Resource.convertPathToClass(path, '.', CLASS_PREFIX) + localeList[i];
                    try {
                        if (r == null) {
                            r = (ResourceBundle)Class.forName(className).newInstance();
                        } else {
                            this.addEntry(className, localeList[i]);
                        }
                    }
                    catch (Throwable e) {
                        System.out.println("Can not create message resource class `" + className + "' (" + e + ")");
                    }
                    ++i;
                }
            }
            if (r == null) {
                try {
                    r = ResourceBundle.getBundle(path);
                }
                catch (MissingResourceException e) {
                    System.out.println("Can not load message resource file `" + path + "' (" + e + ")");
                }
            }
            this.messageResource = r;
        }

        private Entry(String className, String locale) throws Exception, ClassFormatError {
            this.messageResource = (ResourceBundle)Class.forName(className).newInstance();
        }

        private void addEntry(String className, String locale) throws Exception, ClassFormatError {
            if (this.parent == null) {
                this.parent = new Entry(className, locale);
            } else {
                this.parent.addEntry(className, locale);
            }
        }

        private String getMessage(String key, Object[] args, boolean assign, String def) {
            try {
                if (this.messageResource != null) {
                    if (args == null) {
                        return this.messageResource.getString(key);
                    }
                    MessageFormat mf = (MessageFormat)this.messageFormat.get(key);
                    if (mf == null) {
                        mf = new MessageFormat(this.messageResource.getString(key));
                        this.messageFormat.put(key, mf);
                    }
                    return mf.format(args);
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (this.parent != null) {
                return this.parent.getMessage(key, args, assign, def);
            }
            return Resource.convertMessage(key, args, assign, def);
        }

        private byte[] getBinaryResource(String key) {
            String path = this.getMessage(key, null, true, null);
            if (path == null) {
                return null;
            }
            Bytes bytes = (Bytes)bytesCache.get(path);
            if (bytes == null) {
                bytes = new Bytes(path);
                bytesCache.put(path, bytes);
            }
            return bytes.data;
        }

        private Image getImageResource(String key, Toolkit tk) {
            byte[] data = this.getBinaryResource(key);
            if (data == null) {
                return null;
            }
            return tk.createImage(data);
        }
    }
}

