/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.cookie;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.Writer;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.hizlab.kagetaka.Resource;

public class Cookie {
    private static final String RESOURCE = "net.hizlab.kagetaka.cookie.Resource";
    private static final String EXPIRE = "E, dd MMM yyyy HH:mm:ss z";
    private static final SimpleDateFormat[] EXPIRES = new SimpleDateFormat[]{new SimpleDateFormat("E, dd MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("E, dd MMM yy HH:mm z", Locale.US), new SimpleDateFormat("dd MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("dd MMM yy HH:mm z", Locale.US), new SimpleDateFormat("E, dd-MM-yy HH:mm:ss z", Locale.US), new SimpleDateFormat("E, dd-MMM-yy HH:mm:ss z", Locale.US), new SimpleDateFormat("E MMM dd HH:mm:ss yy", Locale.US)};
    private String name;
    private String value;
    private long expires = -1L;
    private String path;
    private String domain;
    private boolean secure;
    private String pathDirectory;
    private boolean isDomain;
    Cookie next;
    Cookie prev;

    public Cookie(String string, URL uRL, boolean bl) throws ParseException {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        if (n3 == 0) {
            throw new ParseException(Resource.getMessage((String)RESOURCE, (String)"cookie.parse.none", null), 0);
        }
        n2 = string.indexOf(59);
        String string2 = n2 == -1 ? string : string.substring(n, n2);
        int n4 = string2.indexOf(61);
        if (n4 != -1) {
            this.name = string2.substring(0, n4).trim();
            this.value = string2.substring(n4 + 1).trim();
        } else {
            this.name = string2.trim();
        }
        block2: while ((n = n2) != -1) {
            while (++n != n3) {
                String string3;
                char c = string.charAt(n);
                if (c == ' ' || c == ';') continue;
                n2 = string.indexOf(59, n);
                string2 = n2 == -1 ? string.substring(n) : string.substring(n, n2);
                boolean bl2 = false;
                n4 = string2.indexOf(61);
                if (n4 == -1) {
                    string3 = string2;
                    if (string3.trim().toLowerCase().compareTo("secure") == 0) {
                        if (!this.secure) {
                            this.secure = true;
                            continue block2;
                        }
                    } else {
                        bl2 = true;
                    }
                } else {
                    int n5;
                    string3 = string2.substring(0, n4).trim().toLowerCase();
                    String string4 = string2.substring(n4 + 1).trim();
                    if (string3.compareTo("expires") == 0) {
                        if (this.expires == -1L) {
                            Date date = null;
                            for (n5 = 0; n5 < EXPIRES.length; ++n5) {
                                try {
                                    date = EXPIRES[n5].parse(string4);
                                    break;
                                }
                                catch (ParseException parseException) {
                                    continue;
                                }
                            }
                            if (date == null) {
                                throw new ParseException(Resource.getMessage((String)RESOURCE, (String)"cookie.parse.invalidexpires", (Object[])new String[]{string4}), n);
                            }
                            this.expires = date.getTime();
                            continue block2;
                        }
                    } else if (string3.compareTo("path") == 0) {
                        if (this.path == null) {
                            this.path = string4;
                            if (this.path.length() > 0 && this.path.charAt(this.path.length() - 1) == '/') {
                                this.pathDirectory = this.path;
                                continue block2;
                            }
                            this.pathDirectory = this.path + "/";
                            continue block2;
                        }
                    } else if (string3.compareTo("domain") == 0) {
                        if (this.domain == null) {
                            n4 = string4.lastIndexOf(46);
                            if (n4 != -1) {
                                int n6 = 2;
                                n5 = 0;
                                for (int i = string4.length() - 1; i >= 0; --i) {
                                    if (string4.charAt(i) != '.') continue;
                                    ++n5;
                                }
                                if (n5 >= n6) {
                                    this.domain = string4;
                                    this.isDomain = this.domain.charAt(0) == '.';
                                    continue block2;
                                }
                            }
                            if (!bl) continue block2;
                            throw new ParseException(Resource.getMessage((String)RESOURCE, (String)"cookie.parse.invaliddomain", (Object[])new String[]{string4}), n);
                        }
                    } else {
                        bl2 = true;
                    }
                }
                if (!bl) continue block2;
                throw new ParseException(Resource.getMessage((String)RESOURCE, (String)(bl2 ? "cookie.parse.unknownoption" : "cookie.parse.duplicate"), (Object[])new String[]{string3}), 0);
            }
            break block2;
        }
        if (this.domain != null && !this.isTargetHost(uRL.getHost())) {
            throw new ParseException(Resource.getMessage((String)RESOURCE, (String)"cookie.parse.outofdomain", (Object[])new String[]{uRL.getHost(), this.domain}), n);
        }
        if (this.path == null || this.path.length() == 0) {
            this.path = "/";
            this.pathDirectory = "/";
        }
        if (this.domain == null || this.domain.length() == 0) {
            this.domain = uRL.getHost();
        }
    }

    Cookie(String string) throws InvalidObjectException {
        int n = 0;
        int n2 = string.length();
        String[] stringArray = new String[7];
        for (int i = 0; i < 7; ++i) {
            int n3 = string.indexOf(9, n);
            if (n3 == -1) {
                n3 = n2;
            }
            stringArray[i] = string.substring(n, n3);
            n = n3 + 1;
            if (n >= n2) break;
        }
        if (stringArray[5] == null) {
            throw new InvalidObjectException("invalid format");
        }
        try {
            this.name = stringArray[5];
            this.value = stringArray[6] != null && stringArray[6].length() > 0 ? stringArray[6] : null;
            this.expires = Long.parseLong(stringArray[4]) * 1000L;
            this.path = stringArray[2];
            this.domain = stringArray[0];
            this.secure = Boolean.valueOf(stringArray[3]);
            this.pathDirectory = this.path.length() > 0 && this.path.charAt(this.path.length() - 1) == '/' ? this.path : this.path + "/";
            this.isDomain = Boolean.valueOf(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidObjectException("invalid format");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getFullValue() {
        if (this.value == null) {
            return this.name;
        }
        return this.name + "=" + this.value;
    }

    public long getExpires() {
        return this.expires;
    }

    public String getPath() {
        return this.path;
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isTargetHost(String string) {
        if (this.isDomain) {
            return string.endsWith(this.domain);
        }
        return string.compareTo(this.domain) == 0;
    }

    public boolean isTargetPath(String string) {
        if (this.path.compareTo(string) == 0) {
            return true;
        }
        return string.startsWith(this.pathDirectory);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append(this.name);
        if (this.value != null) {
            stringBuffer.append('=');
            stringBuffer.append(this.value);
        }
        if (this.expires != -1L) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(EXPIRE, Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            stringBuffer.append("; expires=");
            stringBuffer.append(simpleDateFormat.format(new Date(this.expires)));
        }
        stringBuffer.append("; path=");
        stringBuffer.append(this.path);
        stringBuffer.append("; domain=");
        stringBuffer.append(this.domain);
        if (this.secure) {
            stringBuffer.append("; secure");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    void write(Writer writer) throws IOException {
        writer.write(this.domain);
        writer.write("\t");
        writer.write(this.isDomain ? "TRUE" : "FALSE");
        writer.write("\t");
        writer.write(this.path);
        writer.write("\t");
        writer.write(this.secure ? "TRUE" : "FALSE");
        writer.write("\t");
        writer.write(String.valueOf(this.expires / 1000L));
        writer.write("\t");
        writer.write(this.name);
        writer.write("\t");
        if (this.value != null) {
            writer.write(this.value);
        }
    }
}

