/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.util;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import net.hizlab.kagetaka.Resource;

public class Charset {
    private static final String RESOURCE = "net.hizlab.kagetaka.util.Charset";
    private static final String DEFAULT_ENCODING_KEY = "DEFAULT";
    private static final byte[] TEST_BYTES = new byte[]{0, 0, 0, 0};
    private static String defaultEncoding;
    private static Hashtable supportedEncoding;

    private Charset() {
    }

    public static String toEncoding(String string) {
        if (Charset.isSupported(string)) {
            return string;
        }
        String string2 = Resource.getMessage(RESOURCE, string.toLowerCase(), null, null);
        if (string2 != null && Charset.isSupported(string2)) {
            return string2;
        }
        return null;
    }

    private static boolean isSupported(String string) {
        Boolean bl = (Boolean)supportedEncoding.get(string);
        if (bl != null) {
            return bl;
        }
        try {
            String string2 = new String(TEST_BYTES, string);
            supportedEncoding.put(string, Boolean.TRUE);
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        supportedEncoding.put(string, Boolean.FALSE);
        return false;
    }

    public static String getDefaultEncoding() {
        return defaultEncoding;
    }

    static {
        supportedEncoding = new Hashtable();
        String string = Resource.getMessage(RESOURCE, DEFAULT_ENCODING_KEY, null, null);
        if (string != null && !Charset.isSupported(string)) {
            string = null;
        }
        defaultEncoding = string;
    }
}

