/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.EndToken;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TokenCreater;
import net.hizlab.kagetaka.token.TokenTypes;

public class TokenManager {
    private static TokenCreater rubyCreater;
    private static TokenCreater tableCreater;
    private static TokenCreater styleCreater;
    private static TokenCreater formCreater;

    private TokenManager() {
    }

    public static StartToken createStartToken(Document document, Reporter reporter, int n, int n2, int n3, boolean bl) {
        if (TokenTypes.isRuby(n3)) {
            return rubyCreater.createStartToken(document, reporter, n, n2, n3, bl);
        }
        if (TokenTypes.isTable(n3)) {
            return tableCreater.createStartToken(document, reporter, n, n2, n3, bl);
        }
        if (n3 == 2017 || n3 == 2018) {
            return styleCreater.createStartToken(document, reporter, n, n2, n3, bl);
        }
        if (TokenTypes.isForm(n3)) {
            return formCreater.createStartToken(document, reporter, n, n2, n3, bl);
        }
        return new StartToken(document, reporter, n, n2, n3, bl);
    }

    public static EndToken createEndToken(Document document, Reporter reporter, int n, int n2, int n3, boolean bl) {
        if (TokenTypes.isRuby(n3)) {
            return rubyCreater.createEndToken(document, reporter, n, n2, n3, bl);
        }
        if (TokenTypes.isTable(n3)) {
            return tableCreater.createEndToken(document, reporter, n, n2, n3, bl);
        }
        if (n3 == 2018 || n3 == 2017) {
            return styleCreater.createEndToken(document, reporter, n, n2, n3, bl);
        }
        if (TokenTypes.isForm(n3)) {
            return formCreater.createEndToken(document, reporter, n, n2, n3, bl);
        }
        return new EndToken(document, reporter, n, n2, n3, bl);
    }

    public static boolean canUseRuby() {
        return rubyCreater != null;
    }

    public static boolean canUseTable() {
        return tableCreater != null;
    }

    public static boolean canUseStyle() {
        return styleCreater != null;
    }

    public static boolean canUseForm() {
        return formCreater != null;
    }

    static {
        Creater creater = new Creater();
        rubyCreater = creater;
        tableCreater = creater;
        styleCreater = creater;
        formCreater = creater;
        try {
            rubyCreater = (TokenCreater)Class.forName(Resource.getMessage("tokencreater.ruby", null)).newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            tableCreater = (TokenCreater)Class.forName(Resource.getMessage("tokencreater.table", null)).newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            styleCreater = (TokenCreater)Class.forName(Resource.getMessage("tokencreater.style", null)).newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            formCreater = (TokenCreater)Class.forName(Resource.getMessage("tokencreater.form", null)).newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class Creater
    implements TokenCreater {
        private Creater() {
        }

        public StartToken createStartToken(Document document, Reporter reporter, int n, int n2, int n3, boolean bl) {
            this.reportMessage(reporter, n, n2, n3);
            return null;
        }

        public EndToken createEndToken(Document document, Reporter reporter, int n, int n2, int n3, boolean bl) {
            this.reportMessage(reporter, n, n2, n3);
            return null;
        }

        private void reportMessage(Reporter reporter, int n, int n2, int n3) {
            reporter.report(7, Resource.getMessage("tokenmanager.warning.notsupport", new String[]{TokenTypes.getName(n3)}), n, n2);
        }
    }
}

