/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import net.fclabs.util.Queue;
import net.hizlab.kagetaka.rendering.Apply;
import net.hizlab.kagetaka.rendering.Box;
import net.hizlab.kagetaka.rendering.Caddy;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.ImageHolder;
import net.hizlab.kagetaka.rendering.Paragraph;
import net.hizlab.kagetaka.rendering.Position;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.CharList;

class Wadge {
    static final int NORMAL = 0;
    static final int BASE = 1;
    static final int RUBY = 2;
    private Caddy caddy;
    private int type;
    private Wadge baseWadge;
    private Drawkit drawkit;
    private Paragraph paragraph;
    private int preferredHeight;
    private CharList charsSpinRight;
    private CharList charsSpinLtrb;
    private CharList charsKinsokuHead;
    private CharList charsKinsokuTail;
    private int TD_UNDERLINE;
    private int TD_OVERLINE;
    private Apply topApply;
    private Apply lastApply;
    private Status status;
    private int offsetRight;
    private int offsetLeft;
    private int linePitch;
    private int letterSpacing;
    private boolean lastHankakuEisu = false;
    private StringBuffer committedBuffer = new StringBuffer();
    private StringBuffer committedSpin = new StringBuffer();
    private int committedWidth = 0;
    private int committedHeight = 0;
    private int committedOffset = 0;
    private int committedPitch = 0;
    private StringBuffer pendingBuffer = new StringBuffer();
    private StringBuffer pendingSpin = new StringBuffer();
    private int pendingWidth = 0;
    private int pendingHeight = 0;
    private int pendingOffset = 0;
    private int pendingPitch = 0;

    Wadge(Caddy caddy, int n, Wadge wadge) {
        this.caddy = caddy;
        this.type = n;
        this.baseWadge = wadge;
        this.paragraph = caddy.paragraph;
        this.drawkit = this.paragraph.box.drawkit;
        this.preferredHeight = this.paragraph.preferredHeight;
        this.charsSpinRight = this.drawkit.charsSpinRight;
        this.charsSpinLtrb = this.drawkit.charsSpinLtrb;
        this.charsKinsokuHead = this.drawkit.charsKinsokuHead;
        this.charsKinsokuTail = this.drawkit.charsKinsokuTail;
        if (this.drawkit.swapDecoration) {
            this.TD_UNDERLINE = 8192;
            this.TD_OVERLINE = 4096;
        } else {
            this.TD_UNDERLINE = 4096;
            this.TD_OVERLINE = 8192;
        }
        this.status = this.drawkit.status;
        this.topApply = this.lastApply = new Apply(this.status);
        this.cacheStatus();
    }

    void append(String string, int n, int n2) {
        if (!this.drawkit.idQueue.isEmpty()) {
            this.appendId();
        }
        this.lastApply.length += n2 - n;
        this.appendInner(string, n, n2);
    }

    private void appendInner(String string, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                this.commitPending();
                this.committedBuffer.append(c);
                this.committedSpin.append('5');
                if (this.committedWidth == 0) {
                    this.committedWidth = this.status.fdFontSize.width;
                    this.committedPitch = this.linePitch;
                }
                this.newLine(true, 0);
                continue;
            }
            if ('0' <= c && c <= '9' || 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                if (!this.lastHankakuEisu) {
                    this.commitPending();
                }
                this.appendPending(c, '2');
                this.lastHankakuEisu = true;
                continue;
            }
            this.lastHankakuEisu = false;
            char c2 = '1';
            if (c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' || this.charsSpinRight.contains(c)) {
                c2 = '2';
            } else if (this.charsSpinLtrb.contains(c)) {
                c2 = '3';
            }
            if (this.charsKinsokuHead.contains(c)) {
                this.appendPending(c, c2);
                continue;
            }
            if (this.charsKinsokuTail.contains(c)) {
                this.commitPending();
                this.appendCommit(c, c2);
                continue;
            }
            this.commitPending();
            this.appendPending(c, c2);
        }
    }

    private boolean canAppend(int n) {
        if (this.status.whiteSpace != 3) {
            return true;
        }
        return this.paragraph.lineHeight + this.paragraph.floatHeight + this.committedHeight + this.pendingHeight + n <= this.preferredHeight;
    }

    private void newLine(boolean bl, int n) {
        if (this.type == 0) {
            if (this.committedWidth == 0) {
                this.paragraph.appendLastLine(bl, n);
                return;
            }
            this.paragraph.lineWidth = Math.max(this.paragraph.lineWidth, this.committedWidth);
            this.paragraph.lineHeight += this.committedHeight;
            this.paragraph.lineOffset = Math.max(this.paragraph.lineOffset, this.committedOffset);
            this.paragraph.linePitch = Math.max(this.paragraph.linePitch, this.committedPitch);
            this.paragraph.appendLastLine(bl, n);
            this.committedWidth = 0;
            this.committedHeight = 0;
            this.committedOffset = 0;
            this.committedPitch = 0;
        } else if (this.paragraph.lineHeight != 0) {
            this.paragraph.appendLastLine(bl, n);
        }
    }

    private void appendCommit(char c, char c2) {
        int n = this.calculateHeight(c, c2);
        if (!this.canAppend(n)) {
            this.newLine(false, n);
        }
        this.committedBuffer.append(c);
        this.committedSpin.append(c2);
        this.committedWidth = this.calculateWidth(c, c2, this.committedWidth);
        this.committedHeight += n;
        this.committedOffset = Math.max(this.committedOffset, this.offsetLeft);
        this.committedPitch = Math.max(this.committedPitch, this.linePitch);
    }

    private void appendPending(char c, char c2) {
        int n = this.calculateHeight(c, c2);
        if (!this.canAppend(n)) {
            this.newLine(false, this.pendingHeight + n);
        }
        this.pendingBuffer.append(c);
        this.pendingSpin.append(c2);
        this.pendingWidth = this.calculateWidth(c, c2, this.pendingWidth);
        this.pendingHeight += n;
        this.pendingOffset = Math.max(this.pendingOffset, this.offsetLeft);
        this.pendingPitch = Math.max(this.pendingPitch, this.linePitch);
    }

    private int calculateWidth(char c, char c2, int n) {
        switch (c2) {
            case '2': 
            case '3': {
                return Math.max(n, (c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? this.status.fontHeightHalf : this.status.fdFontSize.width) + this.offsetRight);
            }
        }
        return Math.max(n, this.status.fdFontSize.width + this.offsetRight);
    }

    private int calculateHeight(char c, char c2) {
        switch (c2) {
            case '2': 
            case '3': {
                return this.status.fm.charWidth(c) + this.letterSpacing;
            }
        }
        return this.status.fdFontSize.height + this.letterSpacing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(String string, String string2, Value value, Value value2, int n, int n2) {
        if (!this.drawkit.idQueue.isEmpty()) {
            this.appendId();
        }
        ImageHolder imageHolder = new ImageHolder(this.drawkit, this.status, string, string2, value, value2, n, n2);
        char c = '\u0000';
        Vector vector = this.drawkit.images;
        synchronized (vector) {
            c = (char)this.drawkit.images.size();
            this.drawkit.images.addElement(imageHolder);
        }
        ++this.lastApply.length;
        this.appendInner(imageHolder, c);
    }

    private void appendInner(ImageHolder imageHolder, char c) {
        this.commitPending();
        if (imageHolder.floatType != 3) {
            this.paragraph.appendFloatBlock(imageHolder.position.width + imageHolder.border * 2, imageHolder.position.height + imageHolder.border * 2, imageHolder.floatType, imageHolder.floatOffset, this.committedHeight);
            this.committedBuffer.append(c);
            this.committedSpin.append('4');
            return;
        }
        int n = imageHolder.position.height + imageHolder.border * 2 + this.letterSpacing;
        if (!this.canAppend(n)) {
            this.newLine(false, n);
        }
        this.committedBuffer.append(c);
        this.committedSpin.append('4');
        this.committedWidth = Math.max(this.committedWidth, imageHolder.position.width + imageHolder.border * 2 + this.offsetRight);
        this.committedHeight += n;
        this.committedOffset = Math.max(this.committedOffset, this.offsetLeft - ((this.status.decoration & this.TD_UNDERLINE) != 0 ? 1 : 0));
        this.committedPitch = Math.max(this.committedPitch, this.linePitch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(Box box) {
        char c = '\u0000';
        Vector vector = this.drawkit.floats;
        synchronized (vector) {
            c = (char)this.drawkit.floats.size();
            this.drawkit.floats.addElement(box);
        }
        ++this.lastApply.length;
        this.appendInner(box, c);
    }

    void appendInner(Box box, char c) {
        this.commitPending();
        this.paragraph.appendFloatBlock(box.drawWidth, box.drawHeight, box.status.floatType, box.floatOffset, this.committedHeight);
        this.committedBuffer.append(c);
        this.committedSpin.append('7');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(FormItem formItem) {
        char c = '\u0000';
        Vector vector = this.drawkit.formItems;
        synchronized (vector) {
            c = (char)this.drawkit.formItems.size();
            this.drawkit.formItems.addElement(formItem);
        }
        ++this.lastApply.length;
        this.appendInner(formItem, c);
    }

    void appendInner(FormItem formItem, char c) {
        this.commitPending();
        Dimension dimension = formItem.getSize();
        if (!this.canAppend(dimension.height)) {
            this.newLine(false, dimension.height);
        }
        this.committedBuffer.append(c);
        this.committedSpin.append('8');
        this.committedWidth = Math.max(this.committedWidth, dimension.width + this.offsetRight);
        this.committedHeight += dimension.height;
        this.committedOffset = Math.max(this.committedOffset, this.offsetLeft);
        this.committedPitch = Math.max(this.committedPitch, this.linePitch);
    }

    private void appendId() {
        String string;
        while ((string = (String)this.drawkit.idQueue.get()) != null) {
            this.appendInner((char)this.drawkit.ids.size());
            this.drawkit.ids.addElement(string);
            ++this.lastApply.length;
        }
    }

    private void appendInner(char c) {
        this.pendingBuffer.append(c);
        this.pendingSpin.append('6');
    }

    void statusChanged() {
        this.status = this.drawkit.status;
        this.lastApply = this.lastApply.next = new Apply(this.status);
        this.cacheStatus();
    }

    private void cacheStatus() {
        this.offsetRight = Math.max(this.status.offsetX, 0);
        if ((this.status.decoration & this.TD_OVERLINE) != 0) {
            ++this.offsetRight;
        }
        this.offsetLeft = Math.max(-this.status.offsetX, 0);
        if ((this.status.decoration & this.TD_UNDERLINE) != 0) {
            ++this.offsetLeft;
        }
        this.linePitch = 0;
        if (this.type != 2 && this.status.lineHeight != null) {
            this.linePitch = this.status.lineHeight.getValue(this.status.fd, this.status.fdFontSize.width, 1) - this.status.fdFontSize.width;
        }
        this.letterSpacing = 0;
        if (this.type != 2 && this.status.letterSpacing != null) {
            this.letterSpacing = this.status.letterSpacing.getValue(this.status.fd, this.status.fdFontSize.width, 2);
        }
        this.lastApply.offsetRight = this.offsetRight;
        this.lastApply.offsetLeft = this.offsetLeft;
        this.lastApply.linePitch = this.linePitch;
        this.lastApply.letterSpacing = this.letterSpacing;
    }

    void commitPending() {
        if (this.pendingBuffer.length() == 0) {
            return;
        }
        this.committedBuffer.append(this.pendingBuffer.toString());
        this.committedSpin.append(this.pendingSpin.toString());
        this.committedWidth = Math.max(this.committedWidth, this.pendingWidth);
        this.committedHeight += this.pendingHeight;
        this.committedOffset = Math.max(this.committedOffset, this.pendingOffset);
        this.committedPitch = Math.max(this.committedPitch, this.pendingPitch);
        this.pendingBuffer.setLength(0);
        this.pendingSpin.setLength(0);
        this.pendingWidth = 0;
        this.pendingHeight = 0;
        this.pendingOffset = 0;
        this.pendingPitch = 0;
    }

    void commit() {
        this.commitPending();
        switch (this.type) {
            case 0: 
            case 1: {
                this.caddy.width = this.committedWidth;
                this.caddy.height = this.committedHeight;
                this.caddy.offset = this.committedOffset;
                this.caddy.pitch = this.committedPitch;
                break;
            }
            case 2: {
                this.caddy.width += this.committedWidth;
                this.caddy.width += (int)((double)this.baseWadge.committedWidth * 0.1);
                this.caddy.width += this.committedOffset;
                this.caddy.height = Math.max(this.caddy.height, this.committedHeight);
            }
        }
    }

    void rearrange(int n) {
        this.preferredHeight = n;
        int n2 = this.committedBuffer.length();
        if (n2 == 0) {
            return;
        }
        String string = this.committedBuffer.toString();
        String string2 = this.committedSpin.toString();
        this.committedBuffer.setLength(0);
        this.committedSpin.setLength(0);
        this.committedWidth = 0;
        this.committedHeight = 0;
        this.committedOffset = 0;
        this.committedPitch = 0;
        this.pendingBuffer.setLength(0);
        this.pendingSpin.setLength(0);
        this.pendingWidth = 0;
        this.pendingHeight = 0;
        this.pendingOffset = 0;
        this.pendingPitch = 0;
        Apply apply = this.topApply;
        int n3 = apply.length;
        int n4 = 0;
        for (int i = 0; i < n2; i += n3) {
            while ((n3 = apply.length) == 0) {
                apply = apply.next;
            }
            this.status = apply.status;
            this.offsetRight = apply.offsetRight;
            this.offsetLeft = apply.offsetLeft;
            this.linePitch = apply.linePitch;
            this.letterSpacing = apply.letterSpacing;
            int n5 = i + n3;
            char c = string2.charAt(n5 - 1);
            switch (c) {
                case '4': 
                case '7': 
                case '8': {
                    --n5;
                    break;
                }
                case '6': {
                    do {
                        ++n4;
                    } while ((c = string2.charAt(--n5 - 1)) == '6');
                }
            }
            if (i < n5) {
                this.appendInner(string, i, n5);
            }
            switch (c) {
                case '4': {
                    char c2 = string.charAt(n5);
                    this.appendInner((ImageHolder)this.drawkit.images.elementAt(c2), c2);
                    break;
                }
                case '6': {
                    do {
                        this.appendInner(string.charAt(n5));
                        ++n5;
                    } while (--n4 > 0);
                    break;
                }
                case '7': {
                    char c2 = string.charAt(n5);
                    Box box = (Box)this.drawkit.floats.elementAt(c2);
                    box.rearrange(box.resolvePercent(n), n);
                    this.appendInner(box, c2);
                    break;
                }
                case '8': {
                    char c2 = string.charAt(n5);
                    this.appendInner((FormItem)this.drawkit.formItems.elementAt(c2), c2);
                }
            }
            n3 = 0;
            apply = apply.next;
        }
        this.commit();
    }

    void draw(Position position, int n) {
        int n2 = this.committedBuffer.length();
        if (n2 == 0) {
            return;
        }
        Graphics graphics = this.drawkit.g;
        this.status = null;
        int n3 = position.x;
        double d = 0.0;
        if (this.committedHeight < n) {
            d = (double)(n - this.committedHeight) / (double)n2 / 2.0;
        }
        if (this.type == 2) {
            position.x += this.baseWadge.committedWidth;
            position.x += (int)((double)this.baseWadge.committedWidth * 0.1);
            position.y -= n;
        }
        ImageHolder imageHolder = null;
        int n4 = 0;
        block8: while (n4 < n2) {
            int n5;
            if (position.y > position.height) {
                System.out.println("### Wadge.draw.newLine??? [" + position.y + "," + position.height + "]");
                System.out.println("### [" + (n4 - Math.max(n4 - 10, 0)) + "],[" + this.committedBuffer.toString().substring(Math.max(n4 - 10, 0), Math.min(n4 + 10, n2)) + "]");
            }
            while (this.topApply.length == 0) {
                this.topApply = this.topApply.next;
            }
            if (this.status != this.topApply.status) {
                this.status = this.topApply.status;
                this.letterSpacing = this.topApply.letterSpacing;
                graphics.setColor(this.status.foreColor);
                graphics.setFont(this.status.font);
            }
            int n6 = n4;
            char c = this.committedBuffer.charAt(n4);
            char c2 = this.committedSpin.charAt(n4);
            if (c2 == '4') {
                imageHolder = (ImageHolder)this.drawkit.images.elementAt(c);
            }
            if (position.y >= position.height && c2 != '6' && c2 != '7' && (c2 != '4' || imageHolder.floatType == 3)) {
                position.newLine();
            }
            int n7 = position.y;
            int n8 = position.x + this.status.offsetX;
            switch (c2) {
                case '2': 
                case '3': {
                    int n9 = 0;
                    n5 = this.status.fontHeightMax;
                    do {
                        n9 += this.status.fm.charWidth(this.committedBuffer.charAt(n4));
                        n9 += (int)((double)(n4 * 2 + 2) * d) - (int)((double)(n4 * 2) * d);
                        --this.topApply.length;
                    } while (position.y + (n9 += this.letterSpacing) < position.height && ++n4 < n2 && this.topApply.length > 0 && this.committedSpin.charAt(n4) == c2);
                    this.drawkit.drawTextWithSpin(this.committedBuffer, n6, n4, n8, position.y, n9, n5, this.status, d, this.letterSpacing, c2);
                    position.y += n9;
                    break;
                }
                case '4': {
                    if (imageHolder.floatType == 3) {
                        position.y += (int)((double)(n4 * 2 + 1) * d) - (int)((double)(n4 * 2) * d);
                        imageHolder.draw(n8, position.y);
                        position.y += imageHolder.position.height + imageHolder.border * 2;
                        position.y += (int)((double)(n4 * 2 + 2) * d) - (int)((double)(n4 * 2 + 1) * d);
                        position.y += this.letterSpacing;
                    } else {
                        imageHolder.floatDelayX = position.startX - imageHolder.floatOffset.x - imageHolder.position.width - imageHolder.border * 2;
                        imageHolder.floatDelayY = position.startY + imageHolder.floatOffset.y;
                        if (this.drawkit.floatQueue == null) {
                            this.drawkit.floatQueue = new Queue();
                        }
                        this.drawkit.floatQueue.put(imageHolder);
                    }
                    --this.topApply.length;
                    ++n4;
                    continue block8;
                }
                case '5': {
                    --this.topApply.length;
                    ++n4;
                    continue block8;
                }
                case '6': {
                    this.drawkit.itemMap.addId((String)this.drawkit.ids.elementAt(c), this.drawkit.size.width - (n8 + position.width + 4), 0);
                    --this.topApply.length;
                    ++n4;
                    continue block8;
                }
                case '7': {
                    Box box = (Box)this.drawkit.floats.elementAt(c);
                    box.floatDelayX = position.startX - box.floatOffset.x;
                    box.floatDelayY = position.startY + box.floatOffset.y;
                    if (this.drawkit.floatQueue == null) {
                        this.drawkit.floatQueue = new Queue();
                    }
                    this.drawkit.floatQueue.put(box);
                    --this.topApply.length;
                    ++n4;
                    continue block8;
                }
                case '8': {
                    FormItem formItem = (FormItem)this.drawkit.formItems.elementAt(c);
                    Dimension dimension = formItem.getSize();
                    if (formItem.isNeedBackImage()) {
                        Image image = this.drawkit.context.createImage(dimension.width, dimension.height);
                        Graphics graphics2 = image.getGraphics();
                        this.drawkit.drawImageSync(graphics2, this.drawkit.panel, 0, 0, dimension.width, dimension.height, position.x, position.y, dimension.width + position.x, dimension.height + position.y);
                        graphics2.dispose();
                        formItem.setBackImage(image);
                    }
                    formItem.show(this.drawkit.size.width - (n8 + formItem.getSize().width + 1), n7);
                    position.y += dimension.height;
                    --this.topApply.length;
                    ++n4;
                    continue block8;
                }
                default: {
                    int n9 = 0;
                    n5 = this.status.fdFontSize.width;
                    do {
                        n9 += this.status.fdFontSize.height;
                        n9 += (int)((double)(n4 * 2 + 2) * d) - (int)((double)(n4 * 2) * d);
                        --this.topApply.length;
                    } while (position.y + (n9 += this.letterSpacing) < position.height && ++n4 < n2 && this.topApply.length > 0 && this.committedSpin.charAt(n4) == c2);
                    this.drawkit.drawTextTate(this.committedBuffer, n6, n4, n8, position.y, this.status, d, this.letterSpacing);
                    position.y += n9;
                }
            }
            int n10 = position.y;
            if (this.status.href != null) {
                this.drawkit.itemMap.addHref(this.drawkit.size.width - (n8 + n5 + 1), n7, this.drawkit.size.width - n8, n10, this.status.href);
            }
            if (this.status.tip != null) {
                this.drawkit.itemMap.addTip(this.drawkit.size.width - (n8 + n5 + 1), n7, this.drawkit.size.width - n8, n10, this.status.tip);
            }
            if (this.status.decoration == 0 || this.type == 2) continue;
            int n11 = n8;
            if ((this.status.decoration & this.TD_UNDERLINE) != 0) {
                n11 = n8 - 1;
                graphics.drawLine(n11, n7, n11, n10);
            }
            if ((this.status.decoration & this.TD_OVERLINE) != 0) {
                n11 = n8 + this.status.fdFontSize.width + 1 - 1;
                graphics.drawLine(n11, n7, n11, n10);
            }
            if ((this.status.decoration & 0x4000) == 0) continue;
            n11 = n8 + (int)((double)this.status.fdFontSize.width * 0.4);
            graphics.drawLine(n11, n7, n11, n10);
        }
        if (this.type == 2) {
            position.x = n3;
        }
    }

    public String toString() {
        return this.committedBuffer.toString();
    }
}

