/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import java.util.Vector;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Canvas;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.ItemMap;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.PanelListener;
import net.hizlab.kagetaka.rendering.PanelScrollbar;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.token.FormItem;

public class HawkPanel
extends Container {
    private static final long RESIZE_WAIT = 10000L;
    private static final long TIP_DELAY = 700L;
    private static final long TIP_TERM = 5000L;
    private static final long EVENT_DELAY = 30L;
    private static final int MENU_MENU = 0;
    private static final int MENU_ITEM = 1;
    private static final int MENU_CHECK = 2;
    private static final int MENU_SEPARATOR = -1;
    public static final String MENU_MAIN_BACK = "canvas.menu.main.back";
    private static final int MENU_MAIN_BACK_INDEX = 2;
    public static final String MENU_MAIN_FORWARD = "canvas.menu.main.forward";
    private static final int MENU_MAIN_FORWARD_INDEX = 3;
    public static final String MENU_MAIN_STOP = "canvas.menu.main.stop";
    private static final int MENU_MAIN_STOP_INDEX = 4;
    public static final String MENU_MAIN_RELOAD = "canvas.menu.main.reload";
    private static final int MENU_MAIN_RELOAD_INDEX = 5;
    public static final String MENU_MAIN_OPTION = "canvas.menu.main.option";
    private static final int MENU_MAIN_OPTION_INDEX = 7;
    public static final String MENU_MAIN_OPTION_IMAGE = "canvas.menu.main.option.image";
    private static final int MENU_MAIN_OPTION_IMAGE_INDEX = 8;
    public static final String MENU_MAIN_OPTION_BAR = "canvas.menu.main.option.bar";
    private static final int MENU_MAIN_OPTION_BAR_INDEX = 9;
    public static final String MENU_MAIN_OPTION_SPINGIF = "canvas.menu.main.option.spingif";
    private static final int MENU_MAIN_OPTION_SPINGIF_INDEX = 10;
    public static final String MENU_MAIN_OPTION_SPINJPEG = "canvas.menu.main.option.spinjpeg";
    private static final int MENU_MAIN_OPTION_SPINJPEG_INDEX = 11;
    public static final String MENU_MAIN_INFO = "canvas.menu.main.info";
    private static final int MENU_MAIN_INFO_INDEX = 12;
    public static final String MENU_LINK_COPY = "canvas.menu.link.copy";
    private static final int MENU_LINK_COPY_INDEX = 24;
    public static final String MENU_IMAGE_OPEN = "canvas.menu.image.open";
    private static final int MENU_IMAGE_OPEN_INDEX = 32;
    public static final String MENU_IMAGE_COPY = "canvas.menu.image.copy";
    private static final int MENU_IMAGE_COPY_INDEX = 33;
    private static final int MENU_SIZE = 34;
    public static final int SCROLL_HORIZONTAL = 1;
    public static final int SCROLL_VERTICAL = 2;
    public static final int SCROLL_UNIT = 0;
    public static final int SCROLL_BLOCK = 1;
    private HawkContext hawkContext;
    private Option option;
    private GridBagLayout gbl;
    private Canvas canvas;
    private PanelScrollbar horizontal;
    private PanelScrollbar vertical;
    private boolean horizontalAdded;
    private boolean verticalAdded;
    private boolean toolTipUse = true;
    private long toolTipDelay = 700L;
    private long toolTipTerm = 5000L;
    private Dimension canvasSize;
    private Dimension viewportSize;
    private Point position;
    private PopupMenu popupMenu;
    private MenuItem[] menuItems;
    private Vector mainMenuItems = new Vector();
    private Vector linkMenuItems = new Vector();
    private Vector imageMenuItems = new Vector();
    private Dimension charScale;
    private PanelListener listener;
    private Object cursorLock = new Object();
    private int defaultCursorType = 0;
    private int temporaryCursorType = 0;
    private int cursorType = 0;
    private Request request;
    private URL currentLink;
    private URL currentImage;
    private ItemMap itemMap;
    private boolean callRequestFocus;

    public HawkPanel(HawkContext hawkContext, PanelScrollbar panelScrollbar, PanelScrollbar panelScrollbar2) {
        this.hawkContext = hawkContext;
        this.option = hawkContext.getOption();
        this.gbl = new GridBagLayout();
        this.canvas = new Canvas(hawkContext);
        this.horizontal = panelScrollbar;
        this.vertical = panelScrollbar2;
        this.canvasSize = new Dimension(0, 0);
        this.viewportSize = new Dimension(0, 0);
        this.position = new Point(0, 0);
        this.charScale = new Dimension(0, 0);
        panelScrollbar.addAdjustmentListener(new ScrollbarListener(0, panelScrollbar));
        panelScrollbar2.addAdjustmentListener(new ScrollbarListener(1, panelScrollbar2));
        this.setLayout(this.gbl);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.addComponent(this.canvas, this.gbl, gridBagConstraints, 1.0, 0, 0, 1);
        if (this.option.getShowScrollbar()) {
            this.fixScrollbar(true, false);
        }
        super.setBackground(SystemColor.control);
        this.initMenu();
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                HawkPanel.this.canvas.requestFocus();
            }
        });
        this.canvas.addKeyListener(new HawkCanvasKeyListener());
        this.canvas.addMouseListener(new HawkCanvasMouseListener());
        this.canvas.addMouseMotionListener(new HawkCanvasMouseMotionListener());
        this.canvas.addComponentListener(new HawkCanvasComponentListener());
    }

    private void addComponent(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, double d, int n, int n2, int n3) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d;
        gridBagConstraints.fill = n3;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void initMenu() {
        Menu menu = null;
        this.menuItems = new MenuItem[34];
        this.popupMenu = new PopupMenu(Resource.getMessage("canvas.menu", null));
        this.canvas.add(this.popupMenu);
        this.createMenuItem(2, 1, null, this.mainMenuItems);
        this.createMenuItem(3, 1, null, this.mainMenuItems);
        this.createMenuItem(-1, 1, null, this.mainMenuItems);
        this.createMenuItem(4, 1, null, this.mainMenuItems);
        this.createMenuItem(5, 1, null, this.mainMenuItems);
        this.createMenuItem(-1, 1, null, this.mainMenuItems);
        menu = (Menu)this.createMenuItem(7, 0, null, this.mainMenuItems);
        this.createMenuItem(8, 2, menu, null);
        this.createMenuItem(9, 2, menu, null);
        this.createMenuItem(10, 2, menu, null);
        this.createMenuItem(11, 2, menu, null);
        this.createMenuItem(24, 1, null, this.linkMenuItems);
        this.createMenuItem(32, 1, null, this.imageMenuItems);
        this.createMenuItem(33, 1, null, this.imageMenuItems);
    }

    private MenuItem createMenuItem(int n, int n2, Menu menu, Vector vector) {
        String string = null;
        switch (n) {
            case -1: {
                break;
            }
            case 2: {
                string = MENU_MAIN_BACK;
                break;
            }
            case 3: {
                string = MENU_MAIN_FORWARD;
                break;
            }
            case 4: {
                string = MENU_MAIN_STOP;
                break;
            }
            case 5: {
                string = MENU_MAIN_RELOAD;
                break;
            }
            case 7: {
                string = MENU_MAIN_OPTION;
                break;
            }
            case 8: {
                string = MENU_MAIN_OPTION_IMAGE;
                break;
            }
            case 9: {
                string = MENU_MAIN_OPTION_BAR;
                break;
            }
            case 10: {
                string = MENU_MAIN_OPTION_SPINGIF;
                break;
            }
            case 11: {
                string = MENU_MAIN_OPTION_SPINJPEG;
                break;
            }
            case 12: {
                string = MENU_MAIN_INFO;
                break;
            }
            case 24: {
                string = MENU_LINK_COPY;
                break;
            }
            case 32: {
                string = MENU_IMAGE_OPEN;
                break;
            }
            case 33: {
                string = MENU_IMAGE_COPY;
                break;
            }
            default: {
                Reporter reporter = this.hawkContext.getReporter();
                if (reporter != null) {
                    reporter.report(10, Resource.getMessage("internal.error", new String[]{"HawkPanel.createMenuItem", "panel menu", ""}), 0, 0);
                }
                return null;
            }
        }
        String string2 = string == null ? "-" : Resource.getMessage(string, null);
        MenuItem menuItem = null;
        switch (n2) {
            case 0: {
                menuItem = new Menu(string2);
                break;
            }
            case 1: {
                menuItem = new MenuItem(string2);
                if (n == -1) break;
                menuItem.addActionListener(new MenuActionListner(n));
                break;
            }
            case 2: {
                menuItem = new CheckboxMenuItem(string2);
                ((CheckboxMenuItem)menuItem).addItemListener(new MenuActionListner(n));
            }
        }
        menuItem.setActionCommand(string != null ? string : "-");
        if (n != -1) {
            this.menuItems[n] = menuItem;
        }
        if (menu != null) {
            menu.add(menuItem);
        }
        if (vector != null) {
            vector.addElement(menuItem);
        }
        return menuItem;
    }

    public Point getScrollPosition() {
        return new Point(this.position.x, this.position.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScrollPosition(int n, int n2, boolean bl) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            if (!bl && (n > 0 && n + this.viewportSize.width > this.canvasSize.width || n2 > 0 && n2 + this.viewportSize.height > this.canvasSize.height)) {
                return false;
            }
            this.setScrollPosition(n, n2);
        }
        return true;
    }

    public boolean setScrollPosition(String string, boolean bl) {
        if (string == null || this.itemMap == null) {
            return bl;
        }
        Point point = this.itemMap.getIdPoint(string);
        if (point == null) {
            return bl;
        }
        return this.setScrollPosition(point.x, point.y, bl);
    }

    public Vector getMainMenuItems() {
        return this.mainMenuItems;
    }

    public Vector getLinkMenuItems() {
        return this.linkMenuItems;
    }

    public Vector getImageMenuItems() {
        return this.imageMenuItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisibleScrollbar() {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            return this.horizontalAdded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibleScrollbar(boolean bl) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            this.fixScrollbar(bl, bl ? this.verticalAdded : false);
            this.option.setShowScrollbar(bl);
        }
    }

    public void setPanelListener(PanelListener panelListener) {
        this.listener = panelListener;
    }

    public MediaTracker getMediaTracker() {
        return new MediaTracker(this.canvas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(Image image, int n, int n2) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            this.canvasSize.width += n;
            this.canvasSize.height = Math.max(n2, this.canvasSize.height);
            this.horizontal.setMaximum(Math.max(this.canvasSize.width, this.viewportSize.width));
            this.vertical.setMaximum(Math.max(this.canvasSize.height, this.viewportSize.height));
            this.canvas.addImage(image, n, n2);
            if (this.horizontalAdded && this.canvasSize.height > this.viewportSize.height && !this.verticalAdded) {
                this.fixScrollbar(true, true);
            }
        }
    }

    public void addFormItem(FormItem formItem) {
        this.canvas.addFormItem(formItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupCanvas(Request request) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            this.request = request;
            Document document = request.getDocument();
            this.canvas.setupScreen(document.getBackColor(), document.getBackImage());
            this.itemMap = request.getDocument().itemMap;
            this.canvasSize.width = 0;
            this.canvasSize.height = 0;
            this.position.x = 0;
            this.position.y = 0;
            this.horizontal.setMaximum(this.viewportSize.width);
            this.vertical.setMaximum(this.viewportSize.height);
            this.charScale = document.getCharScale();
            this.horizontal.setUnitIncrement(this.charScale.width);
            this.vertical.setUnitIncrement(this.charScale.height);
            this.horizontal.setBlockIncrement(this.viewportSize.width - this.charScale.width);
            this.vertical.setBlockIncrement(this.viewportSize.height - this.charScale.height);
        }
        if (this.horizontalAdded != this.option.getShowScrollbar() || this.verticalAdded) {
            dimension = this.viewportSize;
            synchronized (dimension) {
                this.fixScrollbar(this.option.getShowScrollbar(), false);
                try {
                    this.viewportSize.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.resetStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintCanvas(int n, int n2, int n3, int n4) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            if (this.canvasSize.width < n || this.canvasSize.height < n2) {
                return;
            }
            this.canvas.repaintImage(n, n2, n3, n4);
        }
    }

    public void setCursor(int n) {
        this.setCursor(Cursor.getPredefinedCursor(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getViewportSize() {
        Dimension dimension = this.viewportSize;
        synchronized (dimension) {
            if (this.viewportSize.width == 0 && this.viewportSize.height == 0 && this.getParent() != null) {
                try {
                    this.viewportSize.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return new Dimension(this.viewportSize.width, this.viewportSize.height);
        }
    }

    public URL getSelectedLink() {
        return this.currentLink;
    }

    public Component getCanvas() {
        return this.canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scroll(int n, int n2, int n3) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            int n4 = this.position.x;
            int n5 = this.position.y;
            if (n2 == 0) {
                if (n == 1) {
                    n4 += this.charScale.width * n3;
                } else {
                    n5 += this.charScale.height * n3;
                }
            } else if (n == 1) {
                n4 += (this.viewportSize.width - this.charScale.width) * n3;
            } else {
                n5 += (this.viewportSize.height - this.charScale.height) * n3;
            }
            this.setScrollPosition(n4, n5);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.viewportSize;
        synchronized (dimension) {
            this.paintCorner(graphics);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.canvas.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursor(Cursor cursor) {
        Object object = this.cursorLock;
        synchronized (object) {
            this.defaultCursorType = cursor.getType();
            if (this.temporaryCursorType == 0 && this.cursorType != this.defaultCursorType) {
                this.cursorType = this.defaultCursorType;
                super.setCursor(cursor);
                this.canvas.setCursor(cursor);
            }
        }
    }

    public void setToolTipOption(boolean bl, long l, long l2) {
        this.toolTipUse = bl;
        this.toolTipDelay = l;
        this.toolTipTerm = l2;
    }

    public void requestFocus() {
        if (this.callRequestFocus) {
            return;
        }
        this.callRequestFocus = true;
        super.requestFocus();
        this.canvas.requestFocus();
        this.callRequestFocus = false;
    }

    public String paramString() {
        String string = super.paramString();
        return string;
    }

    private void setScrollPosition(int n, int n2) {
        n = Math.max(Math.min(n, this.canvasSize.width - this.viewportSize.width), 0);
        n2 = Math.max(Math.min(n2, this.canvasSize.height - this.viewportSize.height), 0);
        if (this.position.x == n && this.position.y == n2) {
            return;
        }
        this.resetStatus();
        this.position.x = n;
        this.position.y = n2;
        this.horizontal.setValue(this.horizontal.getMaximum() - this.horizontal.getVisibleAmount() - n);
        this.vertical.setValue(n2);
        this.canvas.movePosition(n, n2);
    }

    private void appendPopupMenuItem(Vector vector) {
        if (vector.size() == 0) {
            return;
        }
        if (this.popupMenu.getItemCount() > 0) {
            this.popupMenu.addSeparator();
        }
        for (int i = 0; i < vector.size(); ++i) {
            MenuItem menuItem = (MenuItem)vector.elementAt(i);
            if (menuItem.getLabel() != null && menuItem.getLabel().compareTo("-") != 0) {
                this.popupMenu.remove(menuItem);
            }
            this.popupMenu.add(menuItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getLinkURL(int n, int n2) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            if (this.itemMap == null) {
                return null;
            }
            n = this.position.x + this.viewportSize.width - n;
            return this.itemMap.getLinkURL(n, n2 += this.position.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getImageURL(int n, int n2) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            if (this.itemMap == null) {
                return null;
            }
            n = this.position.x + this.viewportSize.width - n;
            return this.itemMap.getImageURL(n, n2 += this.position.y);
        }
    }

    private void setTemporaryCursor(int n) {
        this.temporaryCursorType = n;
        if (n == 0) {
            n = this.defaultCursorType;
        }
        if (this.cursorType != n) {
            this.cursorType = n;
            Cursor cursor = Cursor.getPredefinedCursor(this.cursorType);
            super.setCursor(cursor);
            this.canvas.setCursor(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixScrollbar(boolean bl, boolean bl2) {
        if (this.horizontalAdded == bl && this.verticalAdded == bl2) {
            return;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.horizontalAdded != bl) {
            if (bl) {
                this.addComponent(this.horizontal.getComponent(), this.gbl, gridBagConstraints, 0.0, 0, 1, 2);
            } else {
                this.remove(this.horizontal.getComponent());
            }
            this.horizontalAdded = bl;
        }
        if (this.verticalAdded != bl2) {
            if (bl2) {
                this.addComponent(this.vertical.getComponent(), this.gbl, gridBagConstraints, 0.0, 1, 0, 3);
            } else {
                this.remove(this.vertical.getComponent());
            }
            this.verticalAdded = bl2;
        }
        this.validate();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                this.paintCorner(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    private void paintCorner(Graphics graphics) {
        if (this.verticalAdded) {
            Dimension dimension = this.getSize();
            Point point = this.horizontal.getComponent().getLocation();
            Point point2 = this.vertical.getComponent().getLocation();
            graphics.setColor(this.getBackground());
            graphics.fillRect(point2.x, point.y, dimension.width - point.x, dimension.height - point2.y);
        }
    }

    private int setupToolTip(int n, int n2, int n3) {
        if (this.toolTipUse) {
            int n4 = this.position.x + this.viewportSize.width - n2;
            int n5 = this.position.y + n3;
            String string = null;
            string = this.itemMap.getInfo(n4, n5);
            if (string == null && (string = this.itemMap.getTip(n4, n5)) != null) {
                n = 1;
            }
            if (string != null && string.length() > 0) {
                this.canvas.showToolTip(string, n2, n3, this.toolTipDelay, this.toolTipTerm);
                return n;
            }
        }
        this.canvas.clearToolTip();
        return n;
    }

    private void resetStatus() {
        this.setTemporaryCursor(0);
        this.hawkContext.setTemporaryStatus(null);
        this.canvas.clearToolTip();
    }

    private void copyClipboard(String string) {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, stringSelection);
    }

    private class ScrollbarListener
    implements AdjustmentListener {
        private static final int HORIZONTAL = 0;
        private static final int VERTICAL = 1;
        private boolean isHorizontal;
        private PanelScrollbar scrollbar;

        private ScrollbarListener(int n, PanelScrollbar panelScrollbar) {
            this.isHorizontal = n == 0;
            this.scrollbar = panelScrollbar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Dimension dimension = HawkPanel.this.canvasSize;
            synchronized (dimension) {
                if (this.isHorizontal) {
                    ((HawkPanel)HawkPanel.this).position.x = this.scrollbar.getMaximum() - this.scrollbar.getVisibleAmount() - this.scrollbar.getValue();
                } else {
                    ((HawkPanel)HawkPanel.this).position.y = this.scrollbar.getValue();
                }
                HawkPanel.this.canvas.movePosition(((HawkPanel)HawkPanel.this).position.x, ((HawkPanel)HawkPanel.this).position.y);
            }
        }
    }

    private class MenuActionListner
    implements ActionListener,
    ItemListener {
        private int index = 0;

        private MenuActionListner(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (HawkPanel.this.listener != null) {
                boolean bl = (actionEvent.getModifiers() & 1) != 0;
                boolean bl2 = (actionEvent.getModifiers() & 2) != 0;
                switch (this.index) {
                    case 2: {
                        HawkPanel.this.listener.back();
                        break;
                    }
                    case 3: {
                        HawkPanel.this.listener.forward();
                        break;
                    }
                    case 4: {
                        HawkPanel.this.listener.stop();
                        break;
                    }
                    case 5: {
                        HawkPanel.this.listener.reload(bl2);
                        break;
                    }
                    case 12: {
                        break;
                    }
                    case 24: {
                        HawkPanel.this.copyClipboard(HawkPanel.this.currentLink.toString());
                        break;
                    }
                    case 32: {
                        HawkPanel.this.listener.openHawk(new Request(HawkPanel.this.currentImage, null, ((HawkPanel)HawkPanel.this).request.getDocument().url, null, bl, false, 2));
                        break;
                    }
                    case 33: {
                        HawkPanel.this.copyClipboard(HawkPanel.this.currentImage.toString());
                    }
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = itemEvent.getStateChange() == 1;
            switch (this.index) {
                case 8: {
                    HawkPanel.this.option.setLoadImage(!bl);
                    break;
                }
                case 9: {
                    HawkPanel.this.setVisibleScrollbar(!bl);
                    break;
                }
                case 10: {
                    HawkPanel.this.option.setSpinGifImage(bl);
                    break;
                }
                case 11: {
                    HawkPanel.this.option.setSpinJpegImage(bl);
                }
            }
        }
    }

    private class HawkCanvasMouseMotionListener
    extends MouseMotionAdapter {
        private HawkCanvasMouseMotionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = 0;
            String string = null;
            Dimension dimension = HawkPanel.this.canvasSize;
            synchronized (dimension) {
                if (HawkPanel.this.itemMap == null) {
                    return;
                }
                n = HawkPanel.this.setupToolTip(n, mouseEvent.getX(), mouseEvent.getY());
                URL uRL = HawkPanel.this.getLinkURL(mouseEvent.getX(), mouseEvent.getY());
                if (uRL != null) {
                    n = 12;
                    string = uRL.toString();
                }
            }
            mouseEvent.consume();
            HawkPanel.this.setTemporaryCursor(n);
            HawkPanel.this.hawkContext.setTemporaryStatus(string);
        }
    }

    private class HawkCanvasMouseListener
    extends MouseAdapter {
        private HawkCanvasMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            mouseEvent.getComponent().requestFocus();
            if (HawkPanel.this.itemMap != null) {
                HawkPanel.this.setupToolTip(0, mouseEvent.getX(), mouseEvent.getY());
            }
            if (HawkPanel.this.listener == null) {
                return;
            }
            HawkPanel.this.currentLink = HawkPanel.this.getLinkURL(mouseEvent.getX(), mouseEvent.getY());
            HawkPanel.this.currentImage = HawkPanel.this.getImageURL(mouseEvent.getX(), mouseEvent.getY());
            if (mouseEvent.isPopupTrigger() || (mouseEvent.getModifiers() & 4) == 4) {
                HawkPanel.this.popupMenu.removeAll();
                if (HawkPanel.this.currentLink == null && HawkPanel.this.currentImage == null) {
                    HawkPanel.this.menuItems[2].setEnabled(HawkPanel.this.listener.canBack());
                    HawkPanel.this.menuItems[3].setEnabled(HawkPanel.this.listener.canForward());
                    HawkPanel.this.menuItems[4].setEnabled(HawkPanel.this.listener.canStop());
                    HawkPanel.this.menuItems[5].setEnabled(HawkPanel.this.listener.canReload());
                    ((CheckboxMenuItem)HawkPanel.this.menuItems[8]).setState(!HawkPanel.this.option.getLoadImage());
                    ((CheckboxMenuItem)HawkPanel.this.menuItems[9]).setState(!HawkPanel.this.option.getShowScrollbar());
                    ((CheckboxMenuItem)HawkPanel.this.menuItems[10]).setState(HawkPanel.this.option.getSpinGifImage());
                    ((CheckboxMenuItem)HawkPanel.this.menuItems[11]).setState(HawkPanel.this.option.getSpinJpegImage());
                    HawkPanel.this.appendPopupMenuItem(HawkPanel.this.mainMenuItems);
                }
                if (HawkPanel.this.currentLink != null) {
                    HawkPanel.this.appendPopupMenuItem(HawkPanel.this.linkMenuItems);
                }
                if (HawkPanel.this.currentImage != null) {
                    HawkPanel.this.appendPopupMenuItem(HawkPanel.this.imageMenuItems);
                }
                HawkPanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
                return;
            }
            if (HawkPanel.this.currentLink != null) {
                if ((mouseEvent.getModifiers() & 0x10) == 16 || (mouseEvent.getModifiers() & 8) == 8) {
                    HawkPanel.this.resetStatus();
                    HawkPanel.this.listener.openHawk(new Request(HawkPanel.this.currentLink, null, ((HawkPanel)HawkPanel.this).request.getDocument().url, null, mouseEvent.isShiftDown(), (mouseEvent.getModifiers() & 8) == 8, 2));
                }
                mouseEvent.consume();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            HawkPanel.this.resetStatus();
        }
    }

    private class HawkCanvasComponentListener
    extends ComponentAdapter {
        private HawkCanvasComponentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentResized(ComponentEvent componentEvent) {
            boolean bl = false;
            Dimension dimension = HawkPanel.this.canvasSize;
            synchronized (dimension) {
                Dimension dimension2 = HawkPanel.this.viewportSize;
                synchronized (dimension2) {
                    Dimension dimension3 = HawkPanel.this.canvas.getSize();
                    bl = ((HawkPanel)HawkPanel.this).canvasSize.width > 0 && ((HawkPanel)HawkPanel.this).viewportSize.height != dimension3.height;
                    ((HawkPanel)HawkPanel.this).viewportSize.width = dimension3.width;
                    ((HawkPanel)HawkPanel.this).viewportSize.height = dimension3.height;
                    HawkPanel.this.viewportSize.notifyAll();
                }
                HawkPanel.this.horizontal.setMaximum(Math.max(((HawkPanel)HawkPanel.this).canvasSize.width, ((HawkPanel)HawkPanel.this).viewportSize.width));
                HawkPanel.this.vertical.setMaximum(Math.max(((HawkPanel)HawkPanel.this).canvasSize.height, ((HawkPanel)HawkPanel.this).viewportSize.height));
                HawkPanel.this.horizontal.setVisibleAmount(((HawkPanel)HawkPanel.this).viewportSize.width);
                HawkPanel.this.vertical.setVisibleAmount(((HawkPanel)HawkPanel.this).viewportSize.height);
                HawkPanel.this.horizontal.setBlockIncrement(((HawkPanel)HawkPanel.this).viewportSize.width - ((HawkPanel)HawkPanel.this).charScale.width);
                HawkPanel.this.vertical.setBlockIncrement(((HawkPanel)HawkPanel.this).viewportSize.height - ((HawkPanel)HawkPanel.this).charScale.height);
                if (HawkPanel.this.horizontalAdded) {
                    HawkPanel.this.fixScrollbar(HawkPanel.this.horizontalAdded, ((HawkPanel)HawkPanel.this).canvasSize.height > ((HawkPanel)HawkPanel.this).viewportSize.height);
                }
            }
            if (bl && HawkPanel.this.listener != null && HawkPanel.this.listener.canReload()) {
                HawkPanel.this.listener.reload(false);
            }
        }
    }

    private class HawkCanvasKeyListener
    extends KeyAdapter {
        private KeyEvent oldEvent;

        private HawkCanvasKeyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent keyEvent) {
            boolean bl;
            boolean bl2 = bl = (keyEvent.getModifiers() & 8) != 0;
            if (keyEvent.getWhen() + 30L < System.currentTimeMillis() && this.oldEvent != null && this.oldEvent.getKeyCode() == keyEvent.getKeyCode() && this.oldEvent.getModifiers() == keyEvent.getModifiers()) {
                return;
            }
            this.oldEvent = keyEvent;
            if (bl) {
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        keyEvent.consume();
                        HawkPanel.this.listener.back();
                        break;
                    }
                    case 39: {
                        keyEvent.consume();
                        HawkPanel.this.listener.forward();
                    }
                }
            } else {
                switch (keyEvent.getKeyCode()) {
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        keyEvent.consume();
                        Dimension dimension = HawkPanel.this.canvasSize;
                        synchronized (dimension) {
                            int n = ((HawkPanel)HawkPanel.this).position.x;
                            int n2 = ((HawkPanel)HawkPanel.this).position.y;
                            switch (keyEvent.getKeyCode()) {
                                case 37: {
                                    n += ((HawkPanel)HawkPanel.this).charScale.width;
                                    break;
                                }
                                case 39: {
                                    n -= ((HawkPanel)HawkPanel.this).charScale.width;
                                    break;
                                }
                                case 38: {
                                    n2 -= ((HawkPanel)HawkPanel.this).charScale.height;
                                    break;
                                }
                                case 40: {
                                    n2 += ((HawkPanel)HawkPanel.this).charScale.height;
                                    break;
                                }
                                case 34: {
                                    n += ((HawkPanel)HawkPanel.this).viewportSize.width - ((HawkPanel)HawkPanel.this).charScale.width;
                                    break;
                                }
                                case 33: {
                                    n -= ((HawkPanel)HawkPanel.this).viewportSize.width - ((HawkPanel)HawkPanel.this).charScale.width;
                                    break;
                                }
                                case 36: {
                                    n = 0;
                                    n2 = 0;
                                    break;
                                }
                                case 35: {
                                    n = ((HawkPanel)HawkPanel.this).canvasSize.width - ((HawkPanel)HawkPanel.this).viewportSize.width;
                                    n2 = 0;
                                    break;
                                }
                                case 32: {
                                    n += (((HawkPanel)HawkPanel.this).viewportSize.width - ((HawkPanel)HawkPanel.this).charScale.width) * (!keyEvent.isShiftDown() ? 1 : -1);
                                }
                            }
                            HawkPanel.this.setScrollPosition(n, n2);
                            break;
                        }
                    }
                    case 27: {
                        keyEvent.consume();
                        if (HawkPanel.this.listener == null) break;
                        HawkPanel.this.listener.stop();
                    }
                }
            }
        }
    }
}

