/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import net.hizlab.kagetaka.rendering.ItemMap;
import net.hizlab.kagetaka.util.ContentType;

public class Document {
    public static final int ZONE_INTERNET = 0;
    public static final int ZONE_LOCAL = 1;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.white;
    public final URL url;
    public final ContentType contentType;
    public final int contentLength;
    public final int media;
    public final ItemMap itemMap;
    public final int zone;
    private URL baseUrl;
    private String encoding;
    private String title;
    private Color backColor;
    private Image backImage;
    private Dimension charScale;

    Document(URL uRL, ContentType contentType, int n, int n2, ItemMap itemMap) {
        this.url = uRL;
        this.contentType = contentType;
        this.contentLength = n;
        this.media = n2;
        this.itemMap = itemMap;
        this.baseUrl = uRL;
        this.zone = uRL.getProtocol().compareTo("file") == 0 ? 1 : 0;
    }

    Document(URL uRL, Document document) {
        this.url = uRL;
        this.contentType = document.contentType;
        this.contentLength = document.contentLength;
        this.media = document.media;
        this.itemMap = document.itemMap;
        this.zone = document.zone;
        this.baseUrl = document.baseUrl;
        this.encoding = document.encoding;
        this.title = document.title;
        this.backColor = document.backColor;
        this.backImage = document.backImage;
        this.charScale = document.charScale;
    }

    public URL getBaseURL() {
        return this.baseUrl;
    }

    public void setBaseURL(URL uRL) {
        this.baseUrl = uRL;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public Color getBackColor() {
        return this.backColor != null ? this.backColor : DEFAULT_BACKGROUND_COLOR;
    }

    public void setBackColor(Color color) {
        this.backColor = color;
    }

    public Image getBackImage() {
        return this.backImage;
    }

    public void setBackImage(Image image) {
        this.backImage = image;
    }

    public Dimension getCharScale() {
        return this.charScale;
    }

    public void setCharScale(Dimension dimension) {
        this.charScale = dimension;
    }

    public URL createURL(String string) throws MalformedURLException, SecurityException {
        URL uRL = new URL(this.baseUrl, string);
        if (this.zone != 1 && uRL.getProtocol().compareTo("file") == 0) {
            throw new SecurityException("Can not access to local file");
        }
        return uRL;
    }
}

