/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.rendering.Box;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.Paragraph;
import net.hizlab.kagetaka.rendering.Position;
import net.hizlab.kagetaka.rendering.Wadge;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.Value;

class Caddy {
    Paragraph paragraph;
    boolean ruby;
    private Drawkit drawkit;
    private Wadge wadge = null;
    private Wadge baseWadge;
    private int rubyMode = 0;
    private Wadge rubyWadge = null;
    int width = 0;
    int height = 0;
    int offset = 0;
    int pitch = 0;
    Caddy next = null;

    Caddy(Paragraph paragraph, boolean bl) {
        this.paragraph = paragraph;
        this.ruby = bl;
        this.drawkit = paragraph.box.drawkit;
        this.wadge = this.baseWadge = new Wadge(this, bl ? 1 : 0, null);
    }

    void append(String string, int n, int n2) {
        if (this.wadge != null) {
            this.wadge.append(string, n, n2);
        }
    }

    void append(String string, String string2, Value value, Value value2, int n, int n2) {
        if (this.wadge != null) {
            this.wadge.append(string, string2, value, value2, n, n2);
        }
    }

    void append(Box box) {
        if (this.wadge != null) {
            this.wadge.append(box);
        }
    }

    void append(FormItem formItem) {
        if (this.wadge != null) {
            this.wadge.append(formItem);
        }
    }

    void setRuby(int n) {
        if (this.rubyMode == n) {
            return;
        }
        switch (n) {
            case 2: {
                this.wadge = this.baseWadge;
                break;
            }
            case 3: {
                this.wadge = null;
                break;
            }
            case 4: {
                if (this.rubyWadge == null) {
                    this.rubyWadge = new Wadge(this, 2, this.baseWadge);
                }
                this.wadge = this.rubyWadge;
                break;
            }
        }
        this.rubyMode = n;
    }

    void statusChanged() {
        if (this.wadge == null) {
            return;
        }
        this.wadge.statusChanged();
    }

    void commit() {
        if (this.ruby) {
            if (this.rubyMode < 7) {
                return;
            }
            this.baseWadge.commit();
            if (this.rubyWadge != null) {
                this.rubyWadge.commit();
            }
            this.rubyMode = 8;
        } else {
            this.baseWadge.commit();
        }
        this.paragraph.lineWidth = Math.max(this.paragraph.lineWidth, this.width);
        this.paragraph.lineHeight += this.height;
        this.paragraph.lineOffset = Math.max(this.paragraph.lineOffset, this.offset);
        this.paragraph.linePitch = Math.max(this.paragraph.linePitch, this.pitch);
    }

    void rearrange(int n) {
        if (this.baseWadge != null) {
            this.baseWadge.rearrange(n);
        }
        if (this.rubyWadge != null) {
            this.rubyWadge.rearrange(n);
        }
        this.paragraph.lineWidth = Math.max(this.paragraph.lineWidth, this.width);
        this.paragraph.lineHeight += this.height;
        this.paragraph.lineOffset = Math.max(this.paragraph.lineOffset, this.offset);
        this.paragraph.linePitch = Math.max(this.paragraph.linePitch, this.pitch);
    }

    void draw(Position position) {
        if (this.ruby) {
            if (this.rubyMode != 8) {
                return;
            }
            this.baseWadge.draw(position, this.height);
            if (this.rubyWadge != null) {
                this.rubyWadge.draw(position, this.height);
            }
            this.rubyMode = 9;
        } else {
            this.baseWadge.draw(position, 0);
        }
    }

    public String toString() {
        return this.baseWadge.toString();
    }
}

