/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.Vector;
import net.hizlab.kagetaka.rendering.DelayRectangle;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.FloatChain;
import net.hizlab.kagetaka.rendering.Paragraph;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.Value;

class Box
implements DelayRectangle {
    private static final int CUR = 0;
    private static final int MIN = 1;
    private static final int MAX = 2;
    private static final int FIX = 3;
    private static final int PER = 4;
    Drawkit drawkit;
    Status status;
    private Box origin;
    private Box parent;
    private boolean fixedBlock;
    private int level = -1;
    private Insets frame;
    private Dimension preferredSize;
    private Insets border = null;
    private Insets padding = new Insets(0, 0, 0, 0);
    private Insets margin = new Insets(0, 0, 0, 0);
    private int width = 0;
    private int height = 0;
    private int innerWidth = 0;
    private int maxHeight = 0;
    private boolean heightPercent = false;
    private boolean heightFixed = false;
    private int frameWidth = 0;
    private int frameHeight = 0;
    private int topOffset = 0;
    private Vector delayPanels = null;
    private boolean dummyBox = false;
    private FloatChain floatChain = null;
    Point floatOffset;
    int floatDelayX;
    int floatDelayY;
    int drawWidth;
    int drawHeight;
    private Cell[][] cells = null;
    private int colNum = 0;
    private int rowNum = 0;
    private int verticalSpacing = 0;
    private int horizontalSpacing = 0;
    private int totalMinHeight = 0;
    private int totalMaxHeight = 0;
    private int[] curHeights;
    private int[] minHeights;
    private int[] maxHeights;
    private int[] fixHeights;
    private int[] perHeights;
    private boolean tableHasFixed;
    private boolean tableHasPercent;
    private Point drawOffset = new Point(0, 0);
    private Insets originOffset = new Insets(0, 0, 0, 0);
    private Vector contents = null;
    private Box lastBox = null;
    private Paragraph paragraph = null;
    private Status listStatus = null;

    Box(Drawkit drawkit) {
        this(drawkit, null, null);
        if (this.level == 0 && this.frame.right > 0) {
            drawkit.createPanel(this.frame.right, 1, this.status);
            drawkit.commitPanel();
        }
    }

    private Box(Drawkit drawkit, Box box, Box box2) {
        if (box == null) {
            this.origin = box = this;
        }
        this.drawkit = drawkit;
        this.status = drawkit.status;
        this.origin = box.status.isTable ? this : box.origin;
        this.parent = box;
        this.level = box.level + 1;
        boolean bl = this.fixedBlock = this.level <= 1 || box.status.isTable;
        if (this.status.floatType != 3) {
            this.origin = this;
            this.floatOffset = new Point(0, 0);
        }
        this.frame = new Insets(0, 0, 0, 0);
        if (!box.status.isTable && this.status.margin != null) {
            int n;
            int n2 = this.level == 0 ? drawkit.viewSize.width : 0;
            int n3 = n = this.level == 0 ? drawkit.viewSize.height : 0;
            if (this.status.margin.top != null) {
                this.margin.top = this.status.margin.top.getValue(this.status.fd, n, 2);
                this.frame.top += this.margin.top;
            }
            if (this.status.margin.right != null) {
                this.margin.right = Math.max(this.status.margin.right.getValue(this.status.fd, n2, 1) - (box2 != null ? box2.margin.left : 0), 0);
                this.frame.right = this.frame.right + this.margin.right;
            }
            if (this.status.margin.bottom != null) {
                this.margin.bottom = this.status.margin.bottom.getValue(this.status.fd, n, 2);
                this.frame.bottom += this.margin.bottom;
            }
            if (this.status.margin.left != null) {
                this.margin.left = this.status.margin.left.getValue(this.status.fd, n2, 1);
                this.frame.left += this.margin.left;
            }
        }
        if (this.status.border != null) {
            this.status.border.setBaseSize(this.status.fd);
            this.border = this.status.border.getWidths();
            this.frame.top += this.border.top;
            this.frame.right += this.border.right;
            this.frame.bottom += this.border.bottom;
            this.frame.left += this.border.left;
        }
        if (this.status.padding != null) {
            if (this.status.padding.top != null) {
                this.padding.top = this.status.padding.top.getValue(this.status.fd, 0, 2);
                this.frame.top += this.padding.top;
            }
            if (this.status.padding.right != null) {
                this.padding.right = this.status.padding.right.getValue(this.status.fd, 0, 1);
                this.frame.right += this.padding.right;
            }
            if (this.status.padding.bottom != null) {
                this.padding.bottom = this.status.padding.bottom.getValue(this.status.fd, 0, 2);
                this.frame.bottom += this.padding.bottom;
            }
            if (this.status.padding.left != null) {
                this.padding.left = this.status.padding.left.getValue(this.status.fd, 0, 1);
                this.frame.left += this.padding.left;
            }
        }
        this.heightPercent = this.status.height != null && this.status.height.getUnit() == 9;
        this.heightFixed = this.status.height != null && this.status.height.getUnit() != 9;
        this.frameWidth = this.frame.left + this.frame.right;
        this.frameHeight = this.frame.top + this.frame.bottom;
        this.preferredSize = this.level == 0 ? new Dimension(0, drawkit.viewSize.height - this.frameHeight) : new Dimension(this.status.width != null ? this.status.width.getValue(this.status.fd, 0, 1) : 0, box.status.isTable ? (this.status.height != null && this.status.height.getUnit() != 9 ? this.status.height.getValue(this.status.fd, 0, 2) : 1) : (this.status.height != null ? this.status.height.getValue(this.status.fd, box.preferredSize.height - (this.status.isTable ? 0 : this.frameHeight), 2) : box.preferredSize.height - (this.status.isTable ? 0 : this.frameHeight)));
        if (this.status.isTable) {
            this.verticalSpacing = this.status.borderVerticalSpacing != null ? this.status.borderVerticalSpacing.getValue(this.status.fd, 0, 2) : 2;
            int n = this.horizontalSpacing = this.status.borderHorizontalSpacing != null ? this.status.borderHorizontalSpacing.getValue(this.status.fd, 0, 1) : 2;
            if (this.heightFixed && this.border != null) {
                this.preferredSize.width = Math.max(this.preferredSize.width - (this.border.left + this.border.right), 0);
                this.preferredSize.height = Math.max(this.preferredSize.height - (this.border.top + this.border.bottom), 0);
            }
        }
    }

    void dispose() {
        if (this.level == 0) {
            if (this.delayPanels != null) {
                this.drawWithQueue(false, Math.max(this.floatChain.getWidth() - this.topOffset, 0));
            }
            if (this.frame.left > 0) {
                this.drawkit.createPanel(this.frame.left, 1, this.status);
                this.drawkit.commitPanel();
            }
        }
    }

    Box createBox() {
        boolean bl;
        boolean bl2 = bl = this.drawkit.status.floatType == 3;
        if (bl) {
            this.commitParagraph();
            this.lastBox = new Box(this.drawkit, this, this.lastBox);
            if (bl && this.listStatus != null) {
                this.lastBox.listStatus = this.listStatus;
                this.listStatus = null;
            }
            if (this.contents == null) {
                this.contents = new Vector();
            }
            this.contents.addElement(this.lastBox);
            return this.lastBox;
        }
        Box box = null;
        if (this.level == 0) {
            this.drawkit.insertStatus(3191);
            this.drawkit.status.checkStatus();
            this.statusChanged();
            box = this.createBox();
            box.dummyBox = true;
            this.drawkit.saveStatus(-1);
            this.drawkit.status.checkStatus();
            box.statusChanged();
            return box.createBox();
        }
        box = this.lastBox = new Box(this.drawkit, this, this.lastBox);
        this.checkParagraph();
        this.paragraph.appendFloat(box);
        return box;
    }

    Box commitBox() {
        this.commitParagraph();
        if (this.status.isTable && this.lastBox != null) {
            this.lastBox.status.isVertical = false;
        }
        if (this.contents != null) {
            if (this.status.isTable) {
                this.doCountSizeTable();
            } else {
                this.doCountSizeNormal();
            }
        } else if (this.status.isHorizontalRule) {
            this.doCountSizeHR();
        }
        if (this.level == 1) {
            int n;
            this.originOffset.right = this.parent.topOffset;
            this.originOffset.top = this.parent.frame.top;
            this.originOffset.bottom = this.parent.frame.bottom;
            this.rearrange(this.preferredSize.height + (this.status.isTable ? 0 : this.frameHeight), this.parent.preferredSize.height);
            if (!this.status.isTable && this.status.height == null) {
                n = Math.max(this.preferredSize.width - this.width, 0);
                if (n > 0) {
                    this.width += n;
                    this.drawWidth += n;
                }
                if ((n = Math.max(this.preferredSize.height - this.height, 0)) > 0) {
                    this.height += n;
                    this.drawHeight += n;
                }
            }
            if ((this.status.align == 33 || this.status.align == 32) && (n = this.parent.preferredSize.height - this.frameHeight) < this.drawkit.viewSize.height && n > this.height) {
                int n2 = 0;
                switch (this.parent.status.align) {
                    case 33: {
                        n2 = (n - this.height) / 2;
                        break;
                    }
                    case 32: {
                        n2 = n - this.height;
                    }
                }
                this.drawOffset.y += n2;
                this.height += n2;
                this.drawHeight += n2;
            }
            this.parent.topOffset += this.drawWidth;
            if (this.drawWidth > 0 && this.drawHeight > 0 || this.origin.floatChain != null) {
                if (this.origin.floatChain != null && this.origin.floatChain.getHeight(35, this.originOffset.right + this.drawWidth, this.originOffset.top, this.originOffset.bottom) > 0) {
                    if (this.parent.delayPanels == null) {
                        this.parent.delayPanels = new Vector();
                    }
                    this.parent.delayPanels.addElement(this);
                } else {
                    this.drawWithQueue(true, 0);
                }
            }
        }
        if (this.parent.dummyBox) {
            this.drawkit.resetStatus();
            this.drawkit.status.checkStatus();
            this.parent.statusChanged();
            return this.parent.commitBox();
        }
        return this.parent;
    }

    void statusChanged() {
        if (this.paragraph != null) {
            this.paragraph.statusChanged();
        }
    }

    void rearrange(int n, int n2) {
        int n3;
        if (this.contents == null && !this.status.isHorizontalRule) {
            return;
        }
        n -= this.frameHeight;
        n2 -= this.frameHeight;
        if (this.origin == this) {
            this.originOffset.bottom = 0;
            this.originOffset.top = 0;
            this.originOffset.right = 0;
            this.floatChain = null;
        }
        if (!this.parent.status.isTable && this.heightFixed) {
            n = this.preferredSize.height;
        }
        if (this.status.clearType != 3 && this.origin.floatChain != null && (n3 = this.origin.floatChain.getClearPosition(this.status.clearType, this.originOffset.right) - this.originOffset.right) > this.margin.right) {
            this.margin.right += (n3 -= this.margin.right);
            this.frame.right += n3;
            this.frameWidth += n3;
        }
        n3 = 0;
        if (this.status.isTable && this.status.floatType == 3 && this.origin.floatChain != null) {
            if ((n3 = this.getFloatGap(n3 - this.frame.right, this.heightFixed ? n : this.height, n2) + this.frame.right) > 0) {
                this.drawOffset.x += n3;
            }
            this.drawOffset.y = this.origin.floatChain.getHeight(31, this.originOffset.right + n3, this.originOffset.top, this.originOffset.bottom);
            if (!this.heightFixed) {
                n -= Math.max(this.origin.floatChain.getHeight(35, this.originOffset.right + n3, this.originOffset.top, this.originOffset.bottom) - (n2 - n), 0);
            }
        }
        if (this.status.floatType != 3) {
            n = Math.min(n, this.maxHeight);
        }
        this.width = 0;
        this.height = 0;
        if (this.status.isTable) {
            this.rearrangeTable(n);
        } else if (this.status.isHorizontalRule) {
            this.rearrangeHR(n);
        } else {
            this.rearrangeNormal(n);
        }
        this.drawWidth = this.width + this.frameWidth + n3;
        this.drawHeight = this.height + this.frameHeight;
        this.innerWidth = this.width;
    }

    private void draw(int n, int n2) {
        int n3;
        int n4;
        if ((this.frame.right + this.width + this.frame.left == 0 || this.frameHeight + this.height == 0) && this.origin.floatChain == null) {
            return;
        }
        n -= this.drawOffset.x;
        n2 += this.drawOffset.y;
        if (this.level > 0 && this.status.backColor != null) {
            n4 = this.width + this.padding.left + this.padding.right;
            n3 = this.height + this.padding.top + this.padding.bottom;
            if (n4 > 0 && n3 > 0) {
                this.drawkit.g.setColor(this.status.backColor);
                this.drawkit.g.fillRect(n - this.frame.right - this.width - this.padding.left, n2 + (this.frame.top - this.padding.top), n4, n3);
            }
        }
        if (this.border != null) {
            if (!this.status.isHorizontalRule) {
                this.status.border.draw(this.drawkit.g, n - this.frame.right - this.width - this.padding.left - this.border.left, n2 + this.margin.top, n - this.margin.right, n2 + this.frame.top + this.height + this.padding.bottom + this.border.bottom, this.status.foreColor);
            } else {
                n4 = this.status.hrHeight.getValue(this.status.fd, this.height, 2);
                n3 = 0;
                if ((this.status.align == 33 || this.status.align == 32) && this.height < this.drawkit.viewSize.height) {
                    switch (this.status.align) {
                        case 33: {
                            n3 = (this.height - n4) / 2;
                            break;
                        }
                        case 32: {
                            n3 = this.height - n4;
                        }
                    }
                }
                this.status.border.draw(this.drawkit.g, n - this.frame.right - this.width - this.padding.left - this.border.left, n2 + n3 + this.margin.top, n - this.margin.right, n2 + n3 + this.frame.top + n4 + this.padding.bottom + this.border.bottom, this.status.foreColor);
            }
        }
        if (this.contents == null) {
            return;
        }
        n -= this.frame.right;
        n2 += this.frame.top;
        switch (this.status.valign) {
            case 47: {
                n -= this.width - this.innerWidth;
                break;
            }
            case 44: {
                break;
            }
            default: {
                n -= (this.width - this.innerWidth) / 2;
            }
        }
        for (int i = 0; i < this.contents.size(); ++i) {
            Object e = this.contents.elementAt(i);
            if (e instanceof Box) {
                Box box = (Box)e;
                n3 = 0;
                if (!(this.status.align != 33 && this.status.align != 32 || this.level <= 1 && this.drawkit.viewSize.height <= box.height + box.frameHeight)) {
                    int n5 = this.level == 1 ? Math.min(this.height, this.drawkit.viewSize.height) : this.height;
                    n5 -= this.getFloatHeight(box.drawOffset.x, 35);
                    switch (this.status.align) {
                        case 33: {
                            n3 = (n5 - (box.height + box.frameHeight)) / 2;
                            break;
                        }
                        case 32: {
                            n3 = n5 - (box.height + box.frameHeight);
                        }
                    }
                }
                box.draw(n, n2 + n3);
                continue;
            }
            ((Paragraph)e).draw(n, n2);
        }
    }

    private void drawWithQueue(boolean bl, int n) {
        DelayRectangle delayRectangle;
        int n2;
        int n3 = n;
        int n4 = 0;
        if (bl) {
            n3 += this.drawWidth;
            n4 += this.drawHeight;
        }
        if (this.parent.delayPanels != null) {
            for (n2 = 0; n2 < this.parent.delayPanels.size(); ++n2) {
                delayRectangle = (Box)this.parent.delayPanels.elementAt(n2);
                n3 += ((Box)delayRectangle).width + ((Box)delayRectangle).frameWidth;
                n4 = Math.max(n4, ((Box)delayRectangle).height + ((Box)delayRectangle).frameHeight);
            }
        }
        this.drawkit.createPanel(n3, n4 + this.parent.frameHeight, this.status);
        if (this.parent.delayPanels != null) {
            for (n2 = 0; n2 < this.parent.delayPanels.size(); ++n2) {
                delayRectangle = (Box)this.parent.delayPanels.elementAt(n2);
                super.draw(n3, this.parent.frame.top);
                n3 -= ((Box)delayRectangle).drawWidth;
            }
            this.parent.delayPanels = null;
        }
        if (bl) {
            this.draw(n3, this.parent.frame.top);
        }
        if (this.drawkit.floatQueue != null) {
            while ((delayRectangle = (DelayRectangle)this.drawkit.floatQueue.get()) != null) {
                delayRectangle.drawDelay();
            }
            this.drawkit.floatQueue = null;
        }
        this.drawkit.commitPanel();
    }

    public void drawDelay() {
        this.draw(this.floatDelayX, this.floatDelayY);
    }

    int resolvePercent(int n) {
        if (!this.heightPercent) {
            return n;
        }
        return n * this.status.height.getNumber().intValue() / 100;
    }

    Point addFloat(int n, int n2, int n3, int n4, int n5) {
        if (this.origin.floatChain == null) {
            this.origin.floatChain = new FloatChain();
        }
        Point point = this.origin.floatChain.allocate(n4, n += this.originOffset.right + this.frame.right, n2, n3, this.originOffset.top + this.frame.top, this.originOffset.bottom + this.frame.bottom, n5);
        point.x -= this.originOffset.right + this.frame.right;
        return point;
    }

    int getFloatHeight(int n, int n2) {
        if (this.origin.floatChain == null) {
            return 0;
        }
        return this.origin.floatChain.getHeight(n2, this.originOffset.right + this.frame.right + n, this.originOffset.top + this.frame.top, this.originOffset.bottom + this.frame.bottom);
    }

    int getFloatGap(int n, int n2, int n3) {
        if (this.origin.floatChain == null) {
            return n;
        }
        n += this.originOffset.right + this.frame.right;
        n = this.origin.floatChain.getGapPosition(n, n2, this.originOffset.top + this.frame.top, this.originOffset.bottom + this.frame.bottom, n3);
        return n -= this.originOffset.right + this.frame.right;
    }

    void appendString(String string) {
        this.checkParagraph();
        this.paragraph.appendString(string);
    }

    void appendNewLine() {
        this.checkParagraph();
        this.paragraph.newLine();
    }

    void createNewRow() {
        if (this.lastBox != null) {
            this.lastBox.status.isVertical = false;
        }
    }

    void appendImage(String string, String string2, Value value, Value value2, int n, int n2) {
        this.checkParagraph();
        this.paragraph.appendImage(string, string2, value, value2, n, n2);
    }

    void appendForm(FormItem formItem) {
        this.checkParagraph();
        this.paragraph.appendForm(formItem);
    }

    void setRuby(int n) {
        this.checkParagraph();
        this.paragraph.setRuby(n);
    }

    void setListItem() {
        this.listStatus = this.drawkit.status;
    }

    private void checkParagraph() {
        if (this.paragraph != null) {
            return;
        }
        this.paragraph = new Paragraph(this, this.listStatus, this.preferredSize.height);
        if (!this.status.isTable) {
            if (this.contents == null) {
                this.contents = new Vector();
            }
            this.contents.addElement(this.paragraph);
            this.lastBox = null;
            this.listStatus = null;
        }
    }

    private void commitParagraph() {
        if (this.paragraph == null) {
            return;
        }
        this.paragraph.commit();
        this.paragraph = null;
    }

    private void doCountSizeNormal() {
        for (int i = 0; i < this.contents.size(); ++i) {
            Object e = this.contents.elementAt(i);
            if (e instanceof Box) {
                Box box = (Box)e;
                this.width = Math.max(this.width, box.drawOffset.x + box.width + box.frameWidth);
                this.height = Math.max(this.height, box.drawOffset.y + box.height + box.frameHeight);
                this.maxHeight = Math.max(this.maxHeight, box.maxHeight + box.frameHeight);
                continue;
            }
            Paragraph paragraph = (Paragraph)e;
            this.width = Math.max(this.width, paragraph.width + paragraph.drawOffsetX);
            this.height = Math.max(this.height, paragraph.height);
            this.maxHeight = Math.max(this.maxHeight, paragraph.maxHeight);
        }
        if (this.floatChain != null) {
            this.width = Math.max(this.width, this.floatChain.getWidth());
        }
    }

    private void doCountSizeHR() {
        this.width = this.preferredSize.width;
        this.maxHeight = this.height = this.status.hrHeight.getValue(this.status.fd, 0, 2);
    }

    private void doCountSizeTable() {
        int n;
        int n2;
        Box box;
        int n3;
        int n4 = this.contents.size();
        Cell cell = null;
        this.rowNum = 0;
        this.colNum = 0;
        Row row = new Row();
        for (n3 = 0; n3 < n4; ++n3) {
            box = (Box)this.contents.elementAt(n3);
            row.add(box.status.colSpan, box.status.rowSpan);
            if (box.status.isVertical) continue;
            this.colNum = Math.max(this.colNum, row.col);
            ++this.rowNum;
            row = row.next();
        }
        while (row.col > 0) {
            this.colNum = Math.max(this.colNum, row.col);
            ++this.rowNum;
            if ((row = row.next) != null) continue;
        }
        this.cells = new Cell[this.rowNum][this.colNum];
        int n5 = 0;
        int n6 = 0;
        block2: for (n3 = 0; n3 < n4; ++n3) {
            box = (Box)this.contents.elementAt(n3);
            cell = new Cell(cell, box, n6, n5);
            for (int i = 0; i < cell.rowSpan; ++i) {
                for (int j = 0; j < cell.colSpan; ++j) {
                    this.cells[n5 + i][n6 + j] = cell;
                }
            }
            n6 += cell.colSpan;
            if (!box.status.isVertical) {
                n6 = this.colNum;
            }
            while (true) {
                if (n6 == this.colNum) {
                    n6 = 0;
                    if (++n5 != this.rowNum) continue;
                    break block2;
                }
                if (this.cells[n5][n6] == null) continue block2;
                ++n6;
            }
        }
        this.curHeights = new int[this.colNum];
        this.minHeights = new int[this.colNum];
        this.maxHeights = new int[this.colNum];
        this.perHeights = new int[this.colNum];
        this.fixHeights = new int[this.colNum];
        for (n6 = this.colNum - 1; n6 >= 0; --n6) {
            int n7 = 1;
            n2 = 1;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            n = 0;
            int n12 = 0;
            for (n5 = 0; n5 < this.rowNum; ++n5) {
                cell = this.cells[n5][n6];
                if (cell == null || cell.row != n5 || cell.colSpan != 1) continue;
                n2 = Math.max(n2, cell.min);
                n7 = Math.max(n7, cell.max);
                n12 = Math.max(n12, cell.fix);
                n = Math.max(n, cell.per);
            }
            if (n7 < n2) {
                n7 = n2;
            }
            if (n12 > 0 && n12 < n2) {
                n12 = n2;
            }
            for (n5 = 0; n5 < this.rowNum; ++n5) {
                cell = this.cells[n5][n6];
                if (cell == null || cell.row != n5 || cell.colSpan == 1) continue;
                cell.min -= n2;
                cell.max -= n7;
                cell.fix -= n12;
                cell.per -= n;
                if (cell.col == n6) {
                    n11 = Math.max(n11, cell.min);
                    n10 = Math.max(n10, cell.max);
                    n9 = Math.max(n9, cell.fix);
                    n8 = Math.max(n8, cell.per);
                    continue;
                }
                cell.min -= this.verticalSpacing;
                cell.max -= this.verticalSpacing;
                cell.fix -= this.verticalSpacing;
                cell.per -= this.verticalSpacing;
            }
            this.minHeights[n6] = n2;
            this.maxHeights[n6] = n12 > 0 ? n12 : n7;
            this.fixHeights[n6] = n12;
            this.perHeights[n6] = n;
            if (n9 > 0) {
                this.correctOddHeights(3, n6);
            }
            if (n10 > 0) {
                this.correctOddHeights(2, n6);
            }
            if (n11 > 0) {
                this.correctOddHeights(1, n6);
            }
            if (n8 > 0) {
                this.correctOddHeights(4, n6);
            }
            if (!(this.tableHasFixed || n12 <= 0 && n9 <= 0)) {
                this.tableHasFixed = true;
            }
            if (this.tableHasPercent || n <= 0 && n8 <= 0) continue;
            this.tableHasPercent = true;
        }
        for (n6 = 0; n6 < this.colNum; ++n6) {
            this.totalMinHeight += this.minHeights[n6];
            this.totalMaxHeight += this.maxHeights[n6];
        }
        if (this.tableHasPercent) {
            n = 0;
            for (n6 = 0; n6 < this.colNum; ++n6) {
                if (this.perHeights[n6] <= 0) continue;
                n = Math.max(this.maxHeights[n6] * 100 / this.perHeights[n6], n);
            }
            this.totalMaxHeight = Math.max(this.totalMaxHeight, n);
        }
        int n13 = this.verticalSpacing * (this.colNum + 1);
        n2 = this.totalMinHeight + n13;
        this.width = 1;
        this.height = this.heightFixed ? Math.max(n2, this.preferredSize.height) : n2;
        this.maxHeight = this.totalMaxHeight + n13;
    }

    private void rearrangeNormal(int n) {
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < this.contents.size(); ++i) {
            Object e = this.contents.elementAt(i);
            if (e instanceof Box) {
                Box box = (Box)e;
                int n3 = box.resolvePercent(n);
                if (this.level > 1 && n3 > n) {
                    n3 = n;
                }
                box.drawOffset.x = n2;
                box.originOffset.right = this.originOffset.right + this.frame.right + n2;
                box.originOffset.top = this.originOffset.top + this.frame.top;
                box.originOffset.bottom = this.originOffset.bottom + this.frame.bottom;
                box.rearrange(n3, n);
                n2 = box.drawOffset.x + box.width + box.frameWidth;
                continue;
            }
            Paragraph paragraph = (Paragraph)e;
            paragraph.drawOffsetX = n2;
            paragraph.rearrange(n, this.origin.floatChain != null);
            n2 += paragraph.width;
        }
        this.doCountSizeNormal();
        this.height = Math.max(this.height, n);
    }

    private void rearrangeHR(int n) {
        this.width = this.preferredSize.width;
        this.height = n;
    }

    private void rearrangeTable(int n) {
        Cell cell;
        int n2;
        int n3;
        boolean bl;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = bl = (n -= this.verticalSpacing * (this.colNum + 1)) >= this.totalMaxHeight;
        if (this.tableHasPercent) {
            int n6 = !this.heightPercent && !this.heightFixed && this.totalMaxHeight < n ? this.totalMaxHeight : n;
            for (n3 = 0; n3 < this.colNum; ++n3) {
                if (this.perHeights[n3] <= 0) continue;
                this.maxHeights[n3] = Math.max(n6 * this.perHeights[n3] / 100, this.minHeights[n3]);
            }
        }
        if (!this.heightPercent && !this.heightFixed && this.totalMaxHeight <= n) {
            for (n3 = 0; n3 < this.colNum; ++n3) {
                this.curHeights[n3] = this.maxHeights[n3];
                n5 += this.maxHeights[n3];
            }
            n = this.totalMaxHeight;
        } else {
            int n7;
            for (n3 = 0; n3 < this.colNum; ++n3) {
                this.curHeights[n3] = this.minHeights[n3];
                n5 += this.minHeights[n3];
            }
            if (this.tableHasPercent && n5 < n) {
                for (n3 = 0; n3 < this.colNum && n5 < n; ++n3) {
                    if (this.perHeights[n3] == 0 || this.maxHeights[n3] <= this.curHeights[n3]) continue;
                    n7 = this.maxHeights[n3] - this.curHeights[n3];
                    if (n7 + n5 > n) {
                        n7 = n - n5;
                    }
                    int n8 = n3;
                    this.curHeights[n8] = this.curHeights[n8] + n7;
                    n5 += n7;
                }
            }
            if (this.tableHasFixed && n5 < n) {
                for (n3 = 0; n3 < this.colNum; ++n3) {
                    if (this.fixHeights[n3] == 0 || this.perHeights[n3] > 0 || this.maxHeights[n3] <= this.curHeights[n3]) continue;
                    n7 = this.maxHeights[n3] - this.curHeights[n3];
                    int n9 = n3;
                    this.curHeights[n9] = this.curHeights[n9] + n7;
                    n5 += n7;
                }
            }
        }
        if (n5 < n || n5 > n && n5 > this.totalMinHeight) {
            n5 = this.correctColHeights(0, n5, n - n5, 0, this.colNum);
        }
        if (n5 < n) {
            System.out.println("### table height = req=[" + n + "],fix=[" + n5 + "]");
        }
        for (n3 = 0; n3 < this.colNum; ++n3) {
            for (n2 = 0; n2 < this.rowNum; ++n2) {
                cell = this.cells[n2][n3];
                if (cell == null || cell.row != n2) continue;
                cell.height += this.curHeights[n3];
            }
        }
        int n10 = this.verticalSpacing;
        for (n3 = 0; n3 < this.colNum; ++n3) {
            for (n2 = 0; n2 < this.rowNum; ++n2) {
                cell = this.cells[n2][n3];
                if (cell == null || cell.col != n3 || cell.row != n2) continue;
                cell.initializeWidth(n10);
            }
            n10 += this.curHeights[n3] + this.verticalSpacing;
        }
        int[] nArray = new int[this.rowNum];
        for (n2 = 0; n2 < this.rowNum; ++n2) {
            int n11 = 1;
            int n12 = 0;
            for (n3 = 0; n3 < this.colNum; ++n3) {
                cell = this.cells[n2][n3];
                if (cell == null || cell.col != n3 || cell.rowSpan != 1) continue;
                n11 = Math.max(n11, cell.width);
            }
            for (n3 = 0; n3 < this.colNum; ++n3) {
                cell = this.cells[n2][n3];
                if (cell == null || cell.col != n3 || cell.rowSpan == 1) continue;
                cell.width -= n11;
                if (cell.row + cell.rowSpan - 1 == n2) {
                    n12 = Math.max(n12, cell.width);
                    continue;
                }
                cell.width -= this.horizontalSpacing;
            }
            nArray[n2] = n11;
            if (n12 <= 0) continue;
            this.correctOddWidths(n2, nArray);
        }
        n10 = this.horizontalSpacing;
        for (n2 = 0; n2 < this.rowNum; ++n2) {
            for (n3 = 0; n3 < this.colNum; ++n3) {
                cell = this.cells[n2][n3];
                if (cell == null || cell.col != n3) continue;
                if (cell.row == n2) {
                    ((Cell)cell).box.drawOffset.x = n10;
                } else {
                    ((Cell)cell).box.width += this.horizontalSpacing;
                }
                ((Cell)cell).box.width += nArray[n2];
            }
            n4 += nArray[n2];
            n10 += nArray[n2] + this.horizontalSpacing;
        }
        this.width = n4 + this.horizontalSpacing * (this.rowNum + 1);
        this.height = n5 + this.verticalSpacing * (this.colNum + 1);
        this.curHeights = null;
        this.minHeights = null;
        this.maxHeights = null;
        this.fixHeights = null;
        this.perHeights = null;
    }

    private void correctOddHeights(int n, int n2) {
        int n3 = 0;
        while (true) {
            Cell cell;
            int n4;
            int n5 = 0;
            for (n4 = 0; n4 < this.rowNum; ++n4) {
                cell = this.cells[n4][n2];
                if (cell == null || cell.row != n4 || cell.col != n2 || cell.colSpan == 1) continue;
                switch (n) {
                    case 1: {
                        n3 = cell.min;
                        break;
                    }
                    case 2: {
                        n3 = cell.max;
                        break;
                    }
                    case 3: {
                        n3 = cell.fix;
                        break;
                    }
                    case 4: {
                        n3 = cell.per;
                    }
                }
                n5 = Math.max(n5, n3);
            }
            if (n5 == 0) break;
            int n6 = this.colNum;
            for (n4 = 0; n4 < this.rowNum; ++n4) {
                cell = this.cells[n4][n2];
                if (cell == null || cell.row != n4 || cell.col != n2 || cell.colSpan == 1) continue;
                switch (n) {
                    case 1: {
                        n3 = cell.min;
                        break;
                    }
                    case 2: {
                        n3 = cell.max;
                        break;
                    }
                    case 3: {
                        n3 = cell.fix;
                        break;
                    }
                    case 4: {
                        n3 = cell.per;
                    }
                }
                if (n3 != n5) continue;
                n6 = Math.min(n6, cell.colSpan);
            }
            this.correctColHeights(n, 0, n5, n2, n2 + n6);
        }
    }

    private int correctColHeights(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        int n6;
        int n7;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        if (n == 2) {
            for (n7 = n4; n7 < n5; ++n7) {
                n11 += this.maxHeights[n7];
                if (this.perHeights[n7] == 0) continue;
                ++n10;
                n12 += this.perHeights[n7];
            }
            if (n10 > 0) {
                if (n12 < 100) {
                    n12 = 100;
                }
                n11 += n3;
                for (n7 = n4; n7 < n5; ++n7) {
                    if (this.perHeights[n7] == 0) continue;
                    n6 = n11 * this.perHeights[n7] / n12;
                    n8 = n6 > this.minHeights[n7] ? n6 - this.maxHeights[n7] : this.minHeights[n7] - this.maxHeights[n7];
                    n3 -= n8;
                    n11 -= n6;
                    n12 -= this.perHeights[n7];
                    if (n8 == 0) continue;
                    n2 = this.correctWork(n, n7, n2, n8);
                }
            }
        }
        boolean bl2 = bl = n == 4;
        while (n3 != 0) {
            if (++n9 > 1000) {
                throw new RuntimeException("internal error (table col correct)");
            }
            n12 = 0;
            n11 = 0;
            n10 = 0;
            for (n7 = n4; n7 < n5; ++n7) {
                if (!bl && n != 1 && (this.fixHeights[n7] > 0 || this.perHeights[n7] > 0) || !bl && n == 1 && this.minHeights[n7] == this.maxHeights[n7] || n3 < 0 && (n == 2 ? this.maxHeights[n7] : this.curHeights[n7]) == this.minHeights[n7]) continue;
                ++n10;
                switch (n) {
                    case 0: {
                        n11 += this.curHeights[n7];
                        break;
                    }
                    case 1: {
                        n11 += this.minHeights[n7];
                        break;
                    }
                    case 2: {
                        n11 += this.maxHeights[n7];
                        break;
                    }
                    case 3: {
                        n11 += this.fixHeights[n7];
                        break;
                    }
                    case 4: {
                        n11 += this.perHeights[n7];
                    }
                }
                n12 += this.maxHeights[n7];
            }
            if (n10 == 0) {
                if (bl) break;
                bl = true;
                continue;
            }
            n11 += n3;
            for (n7 = n4; n7 < n5 && n3 != 0; ++n7) {
                if (!bl && n != 1 && (this.fixHeights[n7] > 0 || this.perHeights[n7] > 0) || !bl && n == 1 && this.minHeights[n7] == this.maxHeights[n7] || n3 < 0 && (n == 2 ? this.maxHeights[n7] : this.curHeights[n7]) == this.minHeights[n7]) continue;
                n6 = n11 * this.maxHeights[n7] / n12;
                switch (n) {
                    case 0: {
                        if (n6 >= this.minHeights[n7]) {
                            n8 = n6 - this.curHeights[n7];
                            break;
                        }
                        n8 = this.minHeights[n7] - this.curHeights[n7];
                        break;
                    }
                    case 1: {
                        if (bl || n6 <= this.maxHeights[n7]) {
                            n8 = n6 - this.minHeights[n7];
                            break;
                        }
                        n8 = this.maxHeights[n7] - this.minHeights[n7];
                        break;
                    }
                    case 2: {
                        if (n6 >= this.minHeights[n7]) {
                            n8 = n6 - this.maxHeights[n7];
                            break;
                        }
                        n8 = this.minHeights[n7] - this.maxHeights[n7];
                        break;
                    }
                    case 3: {
                        n8 = n6 - this.fixHeights[n7];
                        break;
                    }
                    case 4: {
                        n8 = n6 - this.perHeights[n7];
                    }
                }
                n3 -= n8;
                n11 -= n6;
                n12 -= this.maxHeights[n7];
                if (n8 == 0) continue;
                n2 = this.correctWork(n, n7, n2, n8);
            }
        }
        return n2;
    }

    private int correctWork(int n, int n2, int n3, int n4) {
        switch (n) {
            case 0: {
                int n5 = n2;
                this.curHeights[n5] = this.curHeights[n5] + n4;
                return n3 += n4;
            }
            case 1: {
                int n6 = n2;
                this.minHeights[n6] = this.minHeights[n6] + n4;
                if (this.maxHeights[n2] >= this.minHeights[n2]) break;
                this.maxHeights[n2] = this.minHeights[n2];
                break;
            }
            case 2: {
                if (this.fixHeights[n2] != 0) break;
                int n7 = n2;
                this.maxHeights[n7] = this.maxHeights[n7] + n4;
                break;
            }
            case 3: {
                int n8 = n2;
                this.fixHeights[n8] = this.fixHeights[n8] + n4;
                this.maxHeights[n2] = Math.max(this.fixHeights[n2], this.minHeights[n2]);
                break;
            }
            case 4: {
                int n9 = n2;
                this.perHeights[n9] = this.perHeights[n9] + n4;
            }
        }
        block13: for (int i = 0; i < this.rowNum; ++i) {
            Cell cell = this.cells[i][n2];
            if (cell == null || cell.row != i || cell.colSpan == 1) continue;
            switch (n) {
                case 1: {
                    cell.min -= n4;
                    continue block13;
                }
                case 2: {
                    cell.max -= n4;
                    continue block13;
                }
                case 3: {
                    cell.fix -= n4;
                    continue block13;
                }
                case 4: {
                    cell.per -= n4;
                }
            }
        }
        return n3;
    }

    private void correctOddWidths(int n, int[] nArray) {
        block0: while (true) {
            int n2;
            Cell cell;
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < this.colNum; ++n3) {
                cell = this.cells[n][n3];
                if (cell == null || cell.col != n3 || cell.rowSpan == 1 || cell.row + cell.rowSpan - 1 != n) continue;
                n4 = Math.max(n4, cell.width);
            }
            if (n4 == 0) break;
            int n5 = this.rowNum;
            for (n3 = 0; n3 < this.colNum; ++n3) {
                cell = this.cells[n][n3];
                if (cell == null || cell.col != n3 || cell.rowSpan == 1 || cell.row + cell.rowSpan - 1 != n || cell.width != n4) continue;
                n5 = Math.min(n5, cell.rowSpan);
            }
            int n6 = 0;
            for (n2 = n - n5 + 1; n2 <= n; ++n2) {
                n6 += nArray[n2];
            }
            int n7 = n6 + n4;
            n2 = n - n5 + 1;
            while (true) {
                if (n2 > n) continue block0;
                int n8 = n7 * nArray[n2] / n6;
                int n9 = n8 - nArray[n2];
                n7 -= n8;
                n6 -= nArray[n2];
                nArray[n2] = n8;
                for (n3 = 0; n3 < this.colNum; ++n3) {
                    cell = this.cells[n2][n3];
                    if (cell == null || cell.col != n3 || cell.rowSpan == 1) continue;
                    cell.width -= n9;
                }
                ++n2;
            }
            break;
        }
    }

    private class Cell {
        private Cell next;
        private Box box;
        private int col;
        private int row;
        private int colSpan;
        private int rowSpan;
        private int workRowSpan;
        private int min;
        private int max;
        private int fix;
        private int per;
        private int width;
        private int height;

        private Cell(Cell cell, Box box2, int n, int n2) {
            if (cell != null) {
                cell.next = this;
            }
            this.box = box2;
            this.col = n;
            this.row = n2;
            this.colSpan = box2.status.colSpan;
            this.rowSpan = box2.status.rowSpan;
            this.min = Math.max(box2.height + box2.frameHeight, 1);
            this.max = Math.max(box2.maxHeight + box2.frameHeight, this.min);
            if (box2.heightFixed) {
                this.fix = Math.max(((Box)box2).preferredSize.height, 1);
            }
            if (box2.heightPercent) {
                this.per = Math.max(box2.status.height.getNumber().intValue(), 1);
            }
            this.workRowSpan = this.rowSpan;
            this.height = Box.this.verticalSpacing * (this.colSpan - 1);
        }

        private void initializeWidth(int n) {
            this.box.height = this.height - this.box.frameHeight;
            ((Box)this.box).drawOffset.y = n;
            this.box.rearrange(this.height, this.height);
            this.width = this.box.width + this.box.frameWidth;
            this.box.width = -this.box.frameWidth;
        }
    }

    private class Row {
        private int col;
        private Row next;

        private Row() {
        }

        private void add(int n, int n2) {
            this.col += n;
            if (n2 > 1) {
                Row row = this;
                while (n2-- > 1) {
                    row = row.next();
                    row.add(n, 1);
                }
            }
        }

        private Row next() {
            if (this.next != null) {
                return this.next;
            }
            this.next = new Row();
            return this.next;
        }
    }
}

