/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.build;

import java.io.IOException;
import java.util.Stack;
import net.fclabs.util.Queue;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.build.FilterParser;
import net.hizlab.kagetaka.build.ParseException;
import net.hizlab.kagetaka.build.Parser;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.EndToken;
import net.hizlab.kagetaka.token.MiscToken;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TextToken;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenManager;
import net.hizlab.kagetaka.token.TokenTypes;

public class TokenCoordinator {
    private Document document = null;
    private Parser parser = null;
    private Reporter reporter = null;

    public TokenCoordinator(Document document, Parser parser, Reporter reporter) {
        Abbreviation abbreviation = null;
        abbreviation = new Abbreviation();
        abbreviation.setParser(document, parser, reporter);
        parser = abbreviation;
        this.document = document;
        this.parser = parser;
        this.reporter = reporter;
    }

    public synchronized Token next() {
        return this.nextToken(this.parser);
    }

    private Token nextToken(Parser parser) {
        try {
            return parser.next();
        }
        catch (IOException iOException) {
            this.reportMessage(10, "tc.error.ioerror", new String[]{iOException.toString()}, null);
        }
        catch (ParseException parseException) {
            this.reportMessage(10, "tc.error.parseerror", new String[]{parseException.toString()}, null);
        }
        catch (Exception exception) {
            this.reportMessage(10, "tc.error.unknownerror", new String[]{exception.toString()}, null);
            exception.printStackTrace();
        }
        return null;
    }

    private void reportMessage(int n, String string, String[] stringArray, Token token) {
        if (this.reporter == null) {
            return;
        }
        this.reporter.report(n, Resource.getMessage(string, stringArray), token == null ? 0 : token.getLineNumber(), token == null ? 0 : token.getColumnNumber());
    }

    private class Abbreviation
    extends FilterParser {
        private Queue fixedTokenQueue = new Queue();
        private Queue unfixedTokenQueue = new Queue();
        private boolean alreadyEnd = false;
        private boolean isFrameset = false;
        private StartToken bottomToken = null;
        private Stack createToken = new Stack();

        private Abbreviation() {
        }

        public String getParserName() {
            return "AbbreviationCoordinator";
        }

        public String getParserDescription() {
            return "\u7701\u7565\u3055\u308c\u305f\u30c8\u30fc\u30af\u30f3\u3092\u88dc\u3044\u307e\u3059";
        }

        public Token next() throws ParseException, IOException {
            if (this.alreadyEnd) {
                return null;
            }
            Token token = null;
            block3: while ((token = (Token)this.fixedTokenQueue.get()) == null) {
                token = this.readNextToken();
                if (token == null) {
                    return null;
                }
                switch (token.getType()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        continue block3;
                    }
                }
                if (this.bottomToken == null) {
                    TextToken textToken;
                    if (token instanceof TextToken && !(textToken = (TextToken)token).hasCharacters()) continue;
                    if (token.getType() == 1001) {
                        this.bottomToken = (StartToken)token;
                        return token;
                    }
                    this.unfixedTokenQueue.put(token);
                    this.bottomToken = TokenManager.createStartToken(TokenCoordinator.this.document, TokenCoordinator.this.reporter, 0, 0, 1001, true);
                    TokenCoordinator.this.reportMessage(7, "tc.warning.nohtml", new String[]{this.bottomToken.getName()}, this.bottomToken);
                    return this.bottomToken;
                }
                if (token.getType() == 2045) {
                    this.skipToken(2045, 2046);
                    continue;
                }
                if (token instanceof TextToken) {
                    token = this.fixedTextToken((TextToken)token);
                } else if (token instanceof StartToken) {
                    token = this.fixedStartToken((StartToken)token);
                } else if (token instanceof EndToken) {
                    token = this.fixedEndToken((EndToken)token);
                } else {
                    if (token instanceof MiscToken) continue;
                    TokenCoordinator.this.reportMessage(7, "tc.warning.unknowntoken", new String[]{token.toString()}, token);
                    continue;
                }
                if (token == null) continue;
            }
            if (token instanceof EndToken) {
                this.bottomToken = this.bottomToken.getParent();
                if (this.bottomToken == null) {
                    this.alreadyEnd = true;
                    return token;
                }
            }
            this.bottomToken.includeToken(token);
            if (token instanceof StartToken && !TokenTypes.isEmpty(token.getType())) {
                this.bottomToken = (StartToken)token;
            }
            return token;
        }

        private Token readNextToken() throws ParseException, IOException {
            Token token = (Token)this.unfixedTokenQueue.get();
            if (token != null) {
                return token;
            }
            return TokenCoordinator.this.nextToken(this.parser);
        }

        private Token fixedTextToken(TextToken textToken) {
            StartToken startToken = null;
            StartToken startToken2 = this.bottomToken;
            if (TokenTypes.canHaveText(startToken2.getType())) {
                return textToken;
            }
            if (!textToken.hasCharacters()) {
                return null;
            }
            int n = 3191;
            int n2 = startToken2.getType();
            if (n2 == 3301) {
                n = 3303;
            } else if (n2 == 3115 || n2 == 3117) {
                n = 3123;
            }
            startToken = TokenManager.createStartToken(TokenCoordinator.this.document, TokenCoordinator.this.reporter, textToken.getLineNumber(), textToken.getColumnNumber(), n, true);
            if (startToken != null && startToken2.isContents(startToken)) {
                TokenCoordinator.this.reportMessage(7, "tc.warning.completestart", new String[]{startToken.getName()}, startToken);
                this.fixedTokenQueue.put(textToken);
                return startToken;
            }
            TokenCoordinator.this.reportMessage(7, "tc.warning.invalidposition", new String[]{textToken.getName()}, textToken);
            return null;
        }

        private Token fixedStartToken(StartToken startToken) {
            Token token;
            StartToken startToken2 = startToken;
            StartToken startToken3 = null;
            int n = 0;
            StartToken startToken4 = null;
            block3: while (true) {
                startToken3 = this.bottomToken;
                n = -1;
                block4: while (true) {
                    ++n;
                    if (startToken3.isContents(startToken2)) break block3;
                    if (startToken3.getType() == 3115 || startToken3.getType() == 3117) {
                        if (startToken4 == null) {
                            startToken4 = TokenManager.createStartToken(TokenCoordinator.this.document, TokenCoordinator.this.reporter, startToken.getLineNumber(), startToken.getColumnNumber(), 3123, true);
                        }
                        if (startToken4.isContents(startToken2)) {
                            this.createToken.push(startToken4);
                            break block3;
                        }
                    }
                    if (startToken2 != startToken) continue;
                    switch (startToken2.getType()) {
                        case 3431: 
                        case 3433: {
                            token = startToken2.getDefaultParentToken();
                            if (startToken3.isContents((StartToken)token)) {
                                this.createToken.push(token);
                                break block3;
                            }
                        }
                        default: {
                            if ((startToken3 = startToken3.getParent()) != null) continue block4;
                            if ((startToken2 = startToken2.getDefaultParentToken()) == null) {
                                TokenCoordinator.this.reportMessage(7, "tc.warning.invalidposition", new String[]{startToken.getName()}, startToken);
                                if (!this.createToken.empty()) {
                                    this.createToken.removeAllElements();
                                }
                                return null;
                            }
                            this.createToken.push(startToken2);
                            continue block3;
                        }
                    }
                    break;
                }
                break;
            }
            token = null;
            if (n > 0) {
                token = this.complementEndToken(n, startToken);
            }
            if (!this.createToken.empty()) {
                while (!this.createToken.empty()) {
                    startToken2 = (StartToken)this.createToken.pop();
                    TokenCoordinator.this.reportMessage(7, "tc.warning.completestart", new String[]{startToken2.getName()}, startToken2);
                    if (token == null) {
                        token = startToken2;
                        continue;
                    }
                    this.fixedTokenQueue.put(startToken2);
                }
                this.createToken.removeAllElements();
            }
            if (token == null) {
                token = startToken;
            } else {
                this.fixedTokenQueue.put(startToken);
            }
            return token;
        }

        private Token fixedEndToken(EndToken endToken) {
            StartToken startToken = this.bottomToken;
            int n = endToken.getType();
            int n2 = 0;
            while (startToken.getEndTokenType() != n) {
                if (this.isTopContainer(startToken.getType(), n) || (startToken = startToken.getParent()) == null) {
                    TokenCoordinator.this.reportMessage(7, "tc.warning.nostart", new String[]{endToken.getName()}, endToken);
                    return null;
                }
                ++n2;
            }
            if (n2 > 0) {
                Token token = this.complementEndToken(n2, endToken);
                this.fixedTokenQueue.put(endToken);
                return token;
            }
            return endToken;
        }

        private Token complementEndToken(int n, Token token) {
            EndToken endToken = null;
            StartToken startToken = this.bottomToken;
            EndToken endToken2 = null;
            while (n-- > 0) {
                endToken2 = startToken.getEndToken(token);
                TokenCoordinator.this.reportMessage(7, "tc.warning.completeend", new String[]{endToken2.getName()}, endToken2);
                if (endToken == null) {
                    endToken = endToken2;
                } else {
                    this.fixedTokenQueue.put(endToken2);
                }
                if ((startToken = startToken.getParent()) != null) continue;
                break;
            }
            return endToken;
        }

        private boolean isTopContainer(int n, int n2) {
            if (n == 3301 && TokenTypes.isRubyItem(n2)) {
                return true;
            }
            if (n == 3401 && TokenTypes.isTableItem(n2)) {
                return true;
            }
            return n == 3501 && TokenTypes.isFormItem(n2);
        }

        private void skipToken(int n, int n2) throws ParseException, IOException {
            Token token;
            int n3 = 1;
            while ((token = (Token)this.fixedTokenQueue.get()) != null || (token = this.readNextToken()) != null) {
                int n4 = token.getType();
                if (n4 == n) {
                    ++n3;
                    continue;
                }
                if (n4 != n2 || --n3 != 0) continue;
                return;
            }
        }
    }
}

