/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.build;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.build.FilterParser;
import net.hizlab.kagetaka.build.InputStreamParser;
import net.hizlab.kagetaka.build.Parser;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.util.Environment;

public class ParserManager {
    private static Hashtable parsers;

    private ParserManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParserInfo[] getParserList() {
        Hashtable hashtable = parsers;
        synchronized (hashtable) {
            ParserInfo[] parserInfoArray = new ParserInfo[parsers.size()];
            int n = 0;
            Enumeration enumeration = parsers.elements();
            while (enumeration.hasMoreElements()) {
                parserInfoArray[n++] = (ParserInfo)enumeration.nextElement();
            }
            return parserInfoArray;
        }
    }

    public static ParserInfo getParser(String string) {
        ParserInfo parserInfo = (ParserInfo)parsers.get(string);
        if (parserInfo != null) {
            return parserInfo;
        }
        if (ParserManager.addParser(string)) {
            return (ParserInfo)parsers.get(string);
        }
        return null;
    }

    public static boolean addParser(String string) {
        try {
            if (parsers.containsKey(string)) {
                return true;
            }
            Parser parser = (Parser)Class.forName(string).newInstance();
            if (!(parser instanceof InputStreamParser) && !(parser instanceof FilterParser)) {
                return false;
            }
            ParserInfo parserInfo = new ParserInfo(string, parser.getParserName(), parser.getParserDescription(), parser instanceof FilterParser);
            parsers.put(string, parserInfo);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (ClassFormatError classFormatError) {
            // empty catch block
        }
        return false;
    }

    public static InputStreamParser createInstance(String string, Document document, InputStream inputStream, Reporter reporter) {
        try {
            InputStreamParser inputStreamParser = (InputStreamParser)Class.forName(string).newInstance();
            inputStreamParser.setInputStream(document, inputStream, reporter);
            return inputStreamParser;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (ClassFormatError classFormatError) {
            // empty catch block
        }
        return null;
    }

    public static FilterParser createInstance(String string, Document document, Parser parser, Reporter reporter) {
        try {
            FilterParser filterParser = (FilterParser)Class.forName(string).newInstance();
            filterParser.setParser(document, parser, reporter);
            return filterParser;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (ClassFormatError classFormatError) {
            // empty catch block
        }
        return null;
    }

    static {
        StringTokenizer stringTokenizer;
        parsers = new Hashtable();
        String string = null;
        string = Resource.getMessage("parser.list", null);
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, ",; ");
            while (stringTokenizer.hasMoreTokens()) {
                ParserManager.addParser(stringTokenizer.nextToken());
            }
        }
        if (!Environment.isApplet) {
            try {
                string = System.getProperty("net.hizlab.kagetaka.parsers", null);
                if (string != null) {
                    stringTokenizer = new StringTokenizer(string, ",; ");
                    while (stringTokenizer.hasMoreTokens()) {
                        ParserManager.addParser(stringTokenizer.nextToken());
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static class ParserInfo {
        private String className = null;
        private String name = null;
        private String description = null;
        private boolean filter = false;

        private ParserInfo(String string, String string2, String string3, boolean bl) {
            this.className = string;
            this.name = string2;
            this.description = string3;
            this.filter = bl;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isFilter() {
            return this.filter;
        }
    }
}

