/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.event.ActionEvent;
import net.hizlab.kagetaka.awt.tate.TextComponent;
import net.hizlab.kagetaka.rendering.Option;

public class TextField
extends TextComponent {
    private static final String RESOURCE = "net.hizlab.kagetaka.awt.tate.Resource";
    private static final String BASE = "textfield";
    private static int nameCounter = 0;
    private String command;
    private char echoChar;
    private int maxlength;
    private transient ActionListener actionListener;

    public TextField(Option option, ImageCreator imageCreator) {
        this(option, imageCreator, null, 20);
    }

    public TextField(Option option, ImageCreator imageCreator, String string) {
        this(option, imageCreator, string, string != null ? string.length() : 20);
    }

    public TextField(Option option, ImageCreator imageCreator, int n) {
        this(option, imageCreator, null, n);
    }

    public TextField(Option option, ImageCreator imageCreator, String string, int n) {
        super(option, imageCreator, string, 1, n, false);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!TextField.this.isEnabled()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        keyEvent.consume();
                        TextField.this.postActionEvent(keyEvent.getModifiers());
                    }
                }
            }
        });
    }

    protected String paramString() {
        String string = super.paramString();
        if (this.echoChar != '\u0000') {
            string = string + ",echo=" + this.echoChar;
        }
        return string;
    }

    String constructComponentName() {
        return BASE + nameCounter++;
    }

    void resetText() {
        this.text = null;
        if (this.value.length() > 0) {
            try {
                String string = this.value;
                if (this.echoChar != '\u0000') {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = string.length() - 1; i >= 0; --i) {
                        stringBuffer.append(this.echoChar);
                    }
                    string = stringBuffer.toString();
                }
                this.text = super.getText(string);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            this.setPreferredSize(0, 0);
        }
    }

    public int getColumns() {
        return super.getColumns();
    }

    public void setColumns(int n) {
        super.setColumns(n);
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char c) {
        this.echoChar = c;
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    public int getMaxLength() {
        return this.maxlength;
    }

    public void setMaxLength(int n) {
        this.maxlength = n;
    }

    public String getActionCommand() {
        return this.command != null ? this.command : this.getText();
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.enableEvents(128L);
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    private void postActionEvent(int n) {
        ActionEvent actionEvent = new ActionEvent(this, 3020, this.getActionCommand(), n);
        try {
            this.getToolkit().getSystemEventQueue().postEvent(actionEvent);
        }
        catch (SecurityException securityException) {
            this.processActionEvent(actionEvent);
        }
    }

    Window showInputBox(Frame frame, int n, int n2) {
        Point point = this.getLocationOnScreen();
        Input input = new Input(frame);
        Insets insets = input.getInsets();
        ((Component)input).setLocation(point.x + n - insets.left, point.y + n2 - insets.top);
        input.show();
        input.text.requestFocus();
        input.toFront();
        return input;
    }

    private class Input
    extends Dialog {
        private java.awt.TextField text;
        private boolean isClosed;

        private Input(Frame frame) {
            super(frame, Resource.getMessage((String)TextField.RESOURCE, (String)"input.title", null), false);
            this.text = new java.awt.TextField(TextField.this.value, TextField.this.getColumns());
            this.text.setForeground(TextField.this.getForeground());
            ((Component)this.text).setBackground(TextField.this.getBackground());
            this.text.setFont(TextField.this.getFont());
            if (TextField.this.echoChar != '\u0000') {
                this.text.setEchoChar(TextField.this.echoChar);
            }
            this.add(this.text);
            this.pack();
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ Input this$1;
                {
                    this.this$1 = input;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    Input.access$400(this.this$1, false);
                }

                public void windowDeactivated(WindowEvent windowEvent) {
                    Input.access$400(this.this$1, true);
                }
            });
            this.text.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ Input this$1;
                {
                    this.this$1 = input;
                }

                public void keyTyped(KeyEvent keyEvent) {
                    char c;
                    if (!(TextField.access$600(Input.access$500(this.this$1)) == 0 || Input.access$200(this.this$1).getText().length() < TextField.access$600(Input.access$500(this.this$1)) || Character.isISOControl(c = keyEvent.getKeyChar()) && c != '\u0016')) {
                        keyEvent.consume();
                    }
                }

                public void keyPressed(KeyEvent keyEvent) {
                    switch (keyEvent.getKeyCode()) {
                        case 27: {
                            keyEvent.consume();
                            Input.access$400(this.this$1, false);
                            break;
                        }
                        case 10: {
                            keyEvent.consume();
                            Input.access$400(this.this$1, true);
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(boolean bl) {
            Object object = this;
            synchronized (object) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            if (bl) {
                object = this.text.getText();
                if (TextField.this.maxlength != 0 && ((String)object).length() >= TextField.this.maxlength) {
                    object = ((String)object).substring(0, TextField.this.maxlength);
                }
                TextField.this.setText((String)object);
            }
            this.dispose();
        }

        public void update(Graphics graphics) {
            ((Container)this).paint(graphics);
        }

        static /* synthetic */ void access$400(Input input, boolean bl) {
            input.close(bl);
        }

        static /* synthetic */ TextField access$500(Input input) {
            return input.TextField.this;
        }
    }
}

